#include "setup.h"
#ifndef HAVE_LIBZ
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Aug 22 10:00:28 2008
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
void hugehelp(void)
{
   fputs(
"                                  _   _ ____  _     \n"
"  Project                     ___| | | |  _ \\| |    \n"
"                             / __| | | | |_) | |    \n"
"                            | (__| |_| |  _ <| |___ \n"
"                             \\___|\\___/|_| \\_\\_____|\n"
"\n"
"NAME\n"
"       curl - transfer a URL\n"
"\n"
"SYNOPSIS\n"
"       curl [options] [URL...]\n"
"\n"
"DESCRIPTION\n"
"       curl  is  a tool to transfer data from or to a server, using one of the\n"
, stdout);
 fputs(
"       supported protocols (HTTP, HTTPS, FTP, FTPS,  SCP,  SFTP,  TFTP,  DICT,\n"
"       TELNET,  LDAP  or  FILE).  The command is designed to work without user\n"
"       interaction.\n"
"\n"
"       curl offers a busload of useful tricks like proxy support, user authen-\n"
"       tication,  ftp upload, HTTP post, SSL connections, cookies, file trans-\n"
"       fer resume and more. As you will see below, the number of features will\n"
"       make your head spin!\n"
"\n"
, stdout);
 fputs(
"       curl  is  powered  by  libcurl  for  all transfer-related features. See\n"
"       libcurl(3) for details.\n"
"\n"
"URL\n"
"       The URL syntax is protocol dependent. You'll find a  detailed  descrip-\n"
"       tion in RFC 3986.\n"
"\n"
"       You  can  specify  multiple  URLs or parts of URLs by writing part sets\n"
"       within braces as in:\n"
"\n"
"        http://site.{one,two,three}.com\n"
"\n"
"       or you can get sequences of alphanumeric series by using [] as in:\n"
"\n"
"        ftp://ftp.numericals.com/file[1-100].txt\n"
, stdout);
 fputs(
"        ftp://ftp.numericals.com/file[001-100].txt    (with leading zeros)\n"
"        ftp://ftp.letters.com/file[a-z].txt\n"
"\n"
"       No nesting of the sequences is supported at the moment, but you can use\n"
"       several ones next to each other:\n"
"\n"
"        http://any.org/archive[1996-1999]/vol[1-4]/part{a,b,c}.html\n"
"\n"
"       You  can  specify  any amount of URLs on the command line. They will be\n"
"       fetched in a sequential manner in the specified order.\n"
"\n"
, stdout);
 fputs(
"       Since curl 7.15.1 you can also specify step counter for the ranges,  so\n"
"       that you can get every Nth number or letter:\n"
"        http://www.numericals.com/file[1-100:10].txt\n"
"        http://www.letters.com/file[a-z:2].txt\n"
"\n"
"       If  you  specify  URL  without protocol:// prefix, curl will attempt to\n"
"       guess what protocol you might want. It will then default  to  HTTP  but\n"
"       try  other  protocols based on often-used host name prefixes. For exam-\n"
, stdout);
 fputs(
"       ple, for host names starting with \"ftp.\" curl will assume you  want  to\n"
"       speak FTP.\n"
"\n"
"       Curl will attempt to re-use connections for multiple file transfers, so\n"
"       that getting many files from the same server will not do multiple  con-\n"
"       nects / handshakes. This improves speed. Of course this is only done on\n"
"       files specified on a single command line and  cannot  be  used  between\n"
"       separate curl invokes.\n"
"\n"
"PROGRESS METER\n"
, stdout);
 fputs(
"       curl  normally  displays a progress meter during operations, indicating\n"
"       amount of transferred data, transfer speeds  and  estimated  time  left\n"
"       etc.\n"
"\n"
"       However,  since  curl  displays data to the terminal by default, if you\n"
"       invoke curl to do an operation and it is about to  write  data  to  the\n"
"       terminal,  it disables the progress meter as otherwise it would mess up\n"
"       the output mixing progress meter and response data.\n"
"\n"
, stdout);
 fputs(
"       If you want a progress meter for HTTP POST or PUT requests, you need to\n"
"       redirect  the  response  output to a file, using shell redirect (>), -o\n"
"       [file] or similar.\n"
"\n"
"       It is not the same case for FTP upload as that operation is  not  spit-\n"
"       ting out any response data to the terminal.\n"
"\n"
"       If you prefer a progress \"bar\" instead of the regular meter, -# is your\n"
"       friend.\n"
"OPTIONS\n"
"       In general, all boolean options are enabled with --option and yet again\n"
, stdout);
 fputs(
"       disabled  with --no-option. That is, you use the exact same option name\n"
"       but prefix it with \"no-\". However, in this list we mostly only list and\n"
"       show  the --option version of them. (This concept with --no options was\n"
"       added in  7.19.0.  Previously  most  options  were  toggled  on/off  on\n"
"       repeated use of the same command line option.)\n"
"\n"
"       -a/--append\n"
"              (FTP/SFTP) When used in an upload, this will tell curl to append\n"
, stdout);
 fputs(
"              to the target file  instead  of  overwriting  it.  If  the  file\n"
"              doesn't  exist,  it  will  be  created.   Note that this flag is\n"
"              ignored by some SSH servers (including OpenSSH).\n"
"\n"
"       -A/--user-agent <agent string>\n"
"              (HTTP) Specify the User-Agent string to send to the HTTP server.\n"
"              Some   badly   done  CGIs  fail  if  this  field  isn't  set  to\n"
"              \"Mozilla/4.0\". To encode blanks  in  the  string,  surround  the\n"
, stdout);
 fputs(
"              string  with  single  quote marks. This can also be set with the\n"
"              -H/--header option of course.\n"
"\n"
"              If this option is set more than once, the last one will  be  the\n"
"              one that's used.\n"
"\n"
"       --anyauth\n"
"              (HTTP) Tells curl to figure out authentication method by itself,\n"
"              and use the most secure one the remote site claims it  supports.\n"
"              This is done by first doing a request and checking the response-\n"
, stdout);
 fputs(
"              headers, thus possibly inducing  an  extra  network  round-trip.\n"
"              This  is  used  instead  of  setting  a  specific authentication\n"
"              method, which you can do with  --basic,  --digest,  --ntlm,  and\n"
"              --negotiate.\n"
"\n"
"              Note  that  using --anyauth is not recommended if you do uploads\n"
"              from stdin, since it may require data to be sent twice and  then\n"
, stdout);
 fputs(
"              the client must be able to rewind. If the need should arise when\n"
"              uploading from stdin, the upload operation will fail.\n"
"\n"
"       -b/--cookie <name=data>\n"
"              (HTTP) Pass the data to the HTTP server as a cookie. It is  sup-\n"
"              posedly  the data previously received from the server in a \"Set-\n"
"              Cookie:\" line.  The data should be in the format  \"NAME1=VALUE1;\n"
"              NAME2=VALUE2\".\n"
"\n"
, stdout);
 fputs(
"              If  no  '=' letter is used in the line, it is treated as a file-\n"
"              name to use to read previously stored cookie lines  from,  which\n"
"              should  be used in this session if they match. Using this method\n"
"              also activates the \"cookie parser\" which will make  curl  record\n"
"              incoming cookies too, which may be handy if you're using this in\n"
"              combination with the -L/--location option. The  file  format  of\n"
, stdout);
 fputs(
"              the  file  to  read cookies from should be plain HTTP headers or\n"
"              the Netscape/Mozilla cookie file format.\n"
"\n"
"              NOTE that the file specified with -b/--cookie is  only  used  as\n"
"              input.  No cookies will be stored in the file. To store cookies,\n"
"              use the -c/--cookie-jar option or you could even save  the  HTTP\n"
"              headers to a file using -D/--dump-header!\n"
"\n"
, stdout);
 fputs(
"              If  this  option is set more than once, the last one will be the\n"
"              one that's used.\n"
"\n"
"       -B/--use-ascii\n"
"              Enable ASCII transfer when using FTP or LDAP. For FTP, this  can\n"
"              also  be enforced by using an URL that ends with \";type=A\". This\n"
"              option causes data sent to stdout to be in text mode  for  win32\n"
"              systems.\n"
"\n"
"       --basic\n"
"              (HTTP)  Tells curl to use HTTP Basic authentication. This is the\n"
, stdout);
 fputs(
"              default and this option is usually pointless, unless you use  it\n"
"              to  override  a  previously  set  option  that  sets a different\n"
"              authentication method (such as --ntlm,  --digest  and  --negoti-\n"
"              ate).\n"
"\n"
"       --ciphers <list of ciphers>\n"
"              (SSL) Specifies which ciphers to use in the connection. The list\n"
"              of ciphers must be using valid ciphers. Read up  on  SSL  cipher\n"
, stdout);
 fputs(
"              list           details           on           this          URL:\n"
"              http://www.openssl.org/docs/apps/ciphers.html\n"
"\n"
"              NSS ciphers are done differently than OpenSSL  and  GnuTLS.  The\n"
"              full  list of NSS ciphers is in the NSSCipherSuite entry at this\n"
"              URL: http://directory.fedora.redhat.com/docs/mod_nss.html#Direc-\n"
"              tives\n"
"\n"
"              If this option is used several times, the last one will override\n"
, stdout);
 fputs(
"              the others.\n"
"\n"
"       --compressed\n"
"              (HTTP) Request a compressed response using one of the algorithms\n"
"              libcurl supports, and return the uncompressed document.  If this\n"
"              option is used and the server  sends  an  unsupported  encoding,\n"
"              curl will report an error.\n"
"\n"
"       --connect-timeout <seconds>\n"
"              Maximum  time  in  seconds  that you allow the connection to the\n"
, stdout);
 fputs(
"              server to take.  This only limits  the  connection  phase,  once\n"
"              curl  has  connected this option is of no more use. See also the\n"
"              -m/--max-time option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -c/--cookie-jar <file name>\n"
"              Specify to which file you want curl to write all cookies after a\n"
"              completed operation. Curl writes  all  cookies  previously  read\n"
, stdout);
 fputs(
"              from  a  specified  file  as  well  as all cookies received from\n"
"              remote server(s). If no cookies are known, no file will be writ-\n"
"              ten.  The  file  will  be written using the Netscape cookie file\n"
"              format. If you set the file name to  a  single  dash,  \"-\",  the\n"
"              cookies will be written to stdout.\n"
"\n"
"              NOTE If the cookie jar can't be created or written to, the whole\n"
, stdout);
 fputs(
"              curl operation won't fail or even report an error clearly. Using\n"
"              -v  will  get  a warning displayed, but that is the only visible\n"
"              feedback you get about this possibly lethal situation.\n"
"\n"
"              If this option is used several times, the  last  specified  file\n"
"              name will be used.\n"
"\n"
"       -C/--continue-at <offset>\n"
"              Continue/Resume  a  previous  file transfer at the given offset.\n"
, stdout);
 fputs(
"              The given offset is the exact  number  of  bytes  that  will  be\n"
"              skipped  counted from the beginning of the source file before it\n"
"              is transferred to the destination.  If used  with  uploads,  the\n"
"              ftp server command SIZE will not be used by curl.\n"
"\n"
"              Use  \"-C  -\" to tell curl to automatically find out where/how to\n"
"              resume the transfer. It then uses the given  output/input  files\n"
"              to figure that out.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --create-dirs\n"
"              When used in conjunction with the -o option,  curl  will  create\n"
"              the  necessary  local directory hierarchy as needed. This option\n"
"              creates the dirs mentioned with the -o option, nothing else.  If\n"
"              the  -o file name uses no dir or if the dirs it mentions already\n"
"              exist, no dir will be created.\n"
"\n"
, stdout);
 fputs(
"              To create remote directories when using FTP or SFTP, try  --ftp-\n"
"              create-dirs.\n"
"\n"
"       --crlf (FTP) Convert LF to CRLF in upload. Useful for MVS (OS/390).\n"
"\n"
"       -d/--data <data>\n"
"              (HTTP)  Sends  the  specified data in a POST request to the HTTP\n"
"              server, in the same way that a browser  does  when  a  user  has\n"
"              filled  in an HTML form and presses the submit button. This will\n"
, stdout);
 fputs(
"              cause curl to pass the data to the server using the content-type\n"
"              application/x-www-form-urlencoded.  Compare to -F/--form.\n"
"\n"
"              -d/--data  is  the  same  as  --data-ascii.  To post data purely\n"
"              binary, you should instead use the --data-binary option. To  URL\n"
"              encode the value of a form field you may use --data-urlencode.\n"
"\n"
"              If  any of these options is used more than once on the same com-\n"
, stdout);
 fputs(
"              mand line, the data pieces specified  will  be  merged  together\n"
"              with  a  separating  &-letter.  Thus,  using  '-d name=daniel -d\n"
"              skill=lousy'  would  generate  a  post  chunk  that  looks  like\n"
"              'name=daniel&skill=lousy'.\n"
"\n"
"              If  you  start  the data with the letter @, the rest should be a\n"
"              file name to read the data from, or - if you want curl  to  read\n"
, stdout);
 fputs(
"              the  data  from stdin.  The contents of the file must already be\n"
"              url-encoded. Multiple files can also be specified. Posting  data\n"
"              from  a file named 'foobar' would thus be done with --data @foo-\n"
"              bar.\n"
"\n"
"       --data-binary <data>\n"
"              (HTTP) This posts data exactly as specified with no  extra  pro-\n"
"              cessing whatsoever.\n"
"\n"
"              If  you  start  the data with the letter @, the rest should be a\n"
, stdout);
 fputs(
"              filename.  Data is posted in a similar  manner  as  --data-ascii\n"
"              does,  except  that  newlines  are preserved and conversions are\n"
"              never done.\n"
"\n"
"              If this option is used several times,  the  ones  following  the\n"
"              first will append data. As described in -d/--data.\n"
"\n"
"       --data-urlencode <data>\n"
"              (HTTP) This posts data, similar to the other --data options with\n"
, stdout);
 fputs(
"              the exception that this performs URL encoding. (Added in 7.18.0)\n"
"              To  be  CGI  compliant, the <data> part should begin with a name\n"
"              followed by a separator and a content specification. The  <data>\n"
"              part can be passed to curl using one of the following syntaxes:\n"
"\n"
"              content\n"
"                     This  will make curl URL encode the content and pass that\n"
"                     on. Just be careful so that the content  doesn't  contain\n"
, stdout);
 fputs(
"                     any  =  or  @  letters, as that will then make the syntax\n"
"                     match one of the other cases below!\n"
"\n"
"              =content\n"
"                     This will make curl URL encode the content and pass  that\n"
"                     on. The preceding = letter is not included in the data.\n"
"\n"
"              name=content\n"
"                     This  will make curl URL encode the content part and pass\n"
, stdout);
 fputs(
"                     that on. Note that the name part is expected  to  be  URL\n"
"                     encoded already.\n"
"\n"
"              @filename\n"
"                     This  will  make  curl  load  data  from  the  given file\n"
"                     (including any newlines), URL encode that data  and  pass\n"
"                     it on in the POST.\n"
"\n"
"              name@filename\n"
"                     This  will  make  curl  load  data  from  the  given file\n"
, stdout);
 fputs(
"                     (including any newlines), URL encode that data  and  pass\n"
"                     it  on  in  the  POST.  The  name part gets an equal sign\n"
"                     appended, resulting in name=urlencoded-file-content. Note\n"
"                     that the name is expected to be URL encoded already.\n"
"\n"
"       --digest\n"
"              (HTTP) Enables HTTP Digest authentication. This is a authentica-\n"
"              tion that prevents the password from being sent over the wire in\n"
, stdout);
 fputs(
"              clear  text.  Use  this in combination with the normal -u/--user\n"
"              option to set user name and password. See also --ntlm, --negoti-\n"
"              ate and --anyauth for related options.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       --disable-eprt\n"
"              (FTP) Tell curl to disable the use of the EPRT and LPRT commands\n"
, stdout);
 fputs(
"              when doing active FTP transfers. Curl will normally always first\n"
"              attempt to use EPRT, then LPRT before using PORT, but with  this\n"
"              option,  it  will  use PORT right away. EPRT and LPRT are exten-\n"
"              sions to the original FTP protocol, may not work on all  servers\n"
"              but  enable  more  functionality in a better way than the tradi-\n"
"              tional PORT command.\n"
"\n"
, stdout);
 fputs(
"              Since curl 7.19.0, --eprt can be used to explicitly enable  EPRT\n"
"              again and --no-eprt is an alias for --disable-eprt.\n"
"\n"
"       --disable-epsv\n"
"              (FTP)  Tell  curl  to  disable  the use of the EPSV command when\n"
"              doing passive FTP transfers. Curl  will  normally  always  first\n"
"              attempt  to  use EPSV before PASV, but with this option, it will\n"
"              not try using EPSV.\n"
"\n"
, stdout);
 fputs(
"              Since curl 7.19.0, --epsv can be used to explicitly enable  EPRT\n"
"              again and --no-epsv is an alias for --disable-epsv.\n"
"\n"
"       -D/--dump-header <file>\n"
"              Write the protocol headers to the specified file.\n"
"\n"
"              This  option  is handy to use when you want to store the headers\n"
"              that a HTTP site sends to you. Cookies from  the  headers  could\n"
"              then  be  read  in a second curl invoke by using the -b/--cookie\n"
, stdout);
 fputs(
"              option! The -c/--cookie-jar option is however a  better  way  to\n"
"              store cookies.\n"
"\n"
"              When  used  on FTP, the ftp server response lines are considered\n"
"              being \"headers\" and thus are saved there.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -e/--referer <URL>\n"
"              (HTTP)  Sends the \"Referer Page\" information to the HTTP server.\n"
, stdout);
 fputs(
"              This can also be set with the -H/--header flag of course.   When\n"
"              used  with -L/--location you can append \";auto\" to the --referer\n"
"              URL to make curl automatically set the previous URL when it fol-\n"
"              lows  a  Location: header. The \";auto\" string can be used alone,\n"
"              even if you don't set an initial --referer.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --engine <name>\n"
, stdout);
 fputs(
"              Select  the  OpenSSL crypto engine to use for cipher operations.\n"
"              Use --engine list  to  print  a  list  of  build-time  supported\n"
"              engines.  Note  that  not  all  (or  none) of the engines may be\n"
"              available at run-time.\n"
"\n"
"       --environment\n"
"              (RISC OS ONLY) Sets a range of environment variables, using  the\n"
"              names the -w option supports, to easier allow extraction of use-\n"
, stdout);
 fputs(
"              ful information after having run curl.\n"
"\n"
"       --egd-file <file>\n"
"              (SSL) Specify the path name  to  the  Entropy  Gathering  Daemon\n"
"              socket.  The  socket  is  used to seed the random engine for SSL\n"
"              connections. See also the --random-file option.\n"
"\n"
"       -E/--cert <certificate[:password]>\n"
"              (SSL) Tells curl to use the specified certificate file when get-\n"
"              ting  a  file with HTTPS or FTPS. The certificate must be in PEM\n"
, stdout);
 fputs(
"              format.  If the optional password isn't specified,  it  will  be\n"
"              queried  for  on  the  terminal. Note that this option assumes a\n"
"              \"certificate\" file that is the private key and the private  cer-\n"
"              tificate  concatenated!  See  --cert  and  --key to specify them\n"
"              independently.\n"
"\n"
"              If curl is built against the NSS SSL library  then  this  option\n"
, stdout);
 fputs(
"              tells curl the nickname of the certificate to use within the NSS\n"
"              database defined by the  environment  variable  SSL_DIR  (or  by\n"
"              default  /etc/pki/nssdb).  If  the  NSS PEM PKCS#11 module (lib-\n"
"              nsspem.so) is available then PEM files may be loaded.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --cert-type <type>\n"
"              (SSL)  Tells curl what certificate type the provided certificate\n"
, stdout);
 fputs(
"              is in. PEM, DER and ENG are recognized types.  If not specified,\n"
"              PEM is assumed.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --cacert <CA certificate>\n"
"              (SSL) Tells curl to use the specified certificate file to verify\n"
"              the  peer.  The  file  may contain multiple CA certificates. The\n"
"              certificate(s) must be in PEM format. Normally curl is built  to\n"
, stdout);
 fputs(
"              use a default file for this, so this option is typically used to\n"
"              alter that default file.\n"
"\n"
"              curl recognizes the environment variable named  'CURL_CA_BUNDLE'\n"
"              if  that  is set, and uses the given path as a path to a CA cert\n"
"              bundle. This option overrides that variable.\n"
"\n"
"              The windows version of curl will automatically  look  for  a  CA\n"
"              certs  file  named  'curl-ca-bundle.crt',  either  in  the  same\n"
, stdout);
 fputs(
"              directory as curl.exe, or in the Current Working  Directory,  or\n"
"              in any folder along your PATH.\n"
"\n"
"              If  curl  is  built against the NSS SSL library then this option\n"
"              tells curl the nickname of the CA certificate to use within  the\n"
"              NSS  database defined by the environment variable SSL_DIR (or by\n"
"              default /etc/pki/nssdb).  If the NSS PEM  PKCS#11  module  (lib-\n"
, stdout);
 fputs(
"              nsspem.so) is available then PEM files may be loaded.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --capath <CA certificate directory>\n"
"              (SSL) Tells curl to use the specified certificate  directory  to\n"
"              verify the peer. The certificates must be in PEM format, and the\n"
"              directory must have been processed using  the  c_rehash  utility\n"
, stdout);
 fputs(
"              supplied  with  openssl.  Using  --capath can allow curl to make\n"
"              SSL-connections much more efficiently than using --cacert if the\n"
"              --cacert file contains many CA certificates.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -f/--fail\n"
"              (HTTP) Fail silently (no output at all) on server  errors.  This\n"
"              is  mostly done like this to better enable scripts etc to better\n"
, stdout);
 fputs(
"              deal with failed attempts. In normal cases when  a  HTTP  server\n"
"              fails to deliver a document, it returns an HTML document stating\n"
"              so (which often also describes why and  more).  This  flag  will\n"
"              prevent curl from outputting that and return error 22.\n"
"\n"
"              This  method is not fail-safe and there are occasions where non-\n"
"              successful response codes will  slip  through,  especially  when\n"
, stdout);
 fputs(
"              authentication is involved (response codes 401 and 407).\n"
"\n"
"       --ftp-account [data]\n"
"              (FTP) When an FTP server asks for \"account data\" after user name\n"
"              and password has been provided, this data is sent off using  the\n"
"              ACCT command. (Added in 7.13.0)\n"
"\n"
"              If  this option is used twice, the second will override the pre-\n"
"              vious use.\n"
"\n"
"       --ftp-create-dirs\n"
, stdout);
 fputs(
"              (FTP/SFTP) When an FTP or SFTP URL/operation uses  a  path  that\n"
"              doesn't  currently exist on the server, the standard behavior of\n"
"              curl is to fail. Using this option, curl will instead attempt to\n"
"              create missing directories.\n"
"\n"
"       --ftp-method [method]\n"
"              (FTP)  Control  what method curl should use to reach a file on a\n"
"              FTP(S) server. The method argument should be one of the  follow-\n"
"              ing alternatives:\n"
"\n"
, stdout);
 fputs(
"              multicwd\n"
"                     curl  does  a  single CWD operation for each path part in\n"
"                     the given URL. For deep hierarchies this means very  many\n"
"                     commands.  This  is  how  RFC1738 says it should be done.\n"
"                     This is the default but the slowest behavior.\n"
"\n"
"              nocwd  curl does no CWD at all. curl will do  SIZE,  RETR,  STOR\n"
"                     etc and give a full path to the server for all these com-\n"
, stdout);
 fputs(
"                     mands. This is the fastest behavior.\n"
"\n"
"              singlecwd\n"
"                     curl does one CWD with the full target directory and then\n"
"                     operates  on  the  file  \"normally\" (like in the multicwd\n"
"                     case). This is somewhat  more  standards  compliant  than\n"
"                     'nocwd' but without the full penalty of 'multicwd'.\n"
"\n"
"       --ftp-pasv\n"
"              (FTP)  Use  PASV when transferring. PASV is the internal default\n"
, stdout);
 fputs(
"              behavior, but using this option can be used to override a previ-\n"
"              ous --ftp-port option. (Added in 7.11.0)\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference. Undoing an enforced PASV really isn't doable\n"
"              but you must then instead enforce the correct EPRT again.\n"
"\n"
"       --ftp-alternative-to-user <command>\n"
"              (FTP)  If  authenticating with the USER and PASS commands fails,\n"
, stdout);
 fputs(
"              send this  command.   When  connecting  to  Tumbleweed's  Secure\n"
"              Transport  server  over  FTPS  using a client certificate, using\n"
"              \"SITE AUTH\" will tell the server to retrieve the  username  from\n"
"              the certificate. (Added in 7.15.5)\n"
"\n"
"       --ftp-skip-pasv-ip\n"
"              (FTP) Tell curl to not use the IP address the server suggests in\n"
"              its response to curl's PASV command when curl connects the  data\n"
, stdout);
 fputs(
"              connection.  Instead  curl  will  re-use  the same IP address it\n"
"              already uses for the control connection. (Added in 7.14.2)\n"
"\n"
"              This option has no effect if PORT, EPRT or EPSV is used  instead\n"
"              of PASV.\n"
"\n"
"       --ftp-ssl\n"
"              (FTP)  Try  to use SSL/TLS for the FTP connection.  Reverts to a\n"
"              non-secure connection if the  server  doesn't  support  SSL/TLS.\n"
, stdout);
 fputs(
"              See also --ftp-ssl-control and --ftp-ssl-reqd for different lev-\n"
"              els of encryption required. (Added in 7.11.0)\n"
"\n"
"       --ftp-ssl-control\n"
"              (FTP) Require SSL/TLS for the ftp  login,  clear  for  transfer.\n"
"              Allows  secure  authentication, but non-encrypted data transfers\n"
"              for efficiency.  Fails the transfer if the server  doesn't  sup-\n"
"              port SSL/TLS.  (Added in 7.16.0)\n"
"\n"
"       --ftp-ssl-reqd\n"
, stdout);
 fputs(
"              (FTP)  Require  SSL/TLS  for the FTP connection.  Terminates the\n"
"              connection if the server doesn't  support  SSL/TLS.   (Added  in\n"
"              7.15.5)\n"
"\n"
"       --ftp-ssl-ccc\n"
"              (FTP)  Use  CCC  (Clear  Command Channel) Shuts down the SSL/TLS\n"
"              layer after authenticating. The rest of the control channel com-\n"
"              munication  will be unencrypted. This allows NAT routers to fol-\n"
, stdout);
 fputs(
"              low the FTP transaction. The default mode is passive. See --ftp-\n"
"              ssl-ccc-mode for other modes.  (Added in 7.16.1)\n"
"\n"
"       --ftp-ssl-ccc-mode [active/passive]\n"
"              (FTP)  Use  CCC  (Clear  Command Channel) Sets the CCC mode. The\n"
"              passive mode will not initiate the shutdown,  but  instead  wait\n"
"              for the server to do it, and will not reply to the shutdown from\n"
, stdout);
 fputs(
"              the server. The active mode initiates the shutdown and waits for\n"
"              a reply from the server.  (Added in 7.16.2)\n"
"\n"
"       -F/--form <name=content>\n"
"              (HTTP)  This  lets curl emulate a filled in form in which a user\n"
"              has pressed the submit button. This causes  curl  to  POST  data\n"
"              using the Content-Type multipart/form-data according to RFC1867.\n"
"              This enables uploading of binary files etc. To force  the  'con-\n"
, stdout);
 fputs(
"              tent' part to be a file, prefix the file name with an @ sign. To\n"
"              just get the content part from a file, prefix the file name with\n"
"              the  letter  <.  The  difference  between @ and < is then that @\n"
"              makes a file get attached in the post as a  file  upload,  while\n"
"              the < makes a text field and just get the contents for that text\n"
"              field from a file.\n"
"\n"
, stdout);
 fputs(
"              Example, to send your password file to the server, where  'pass-\n"
"              word' is the name of the form-field to which /etc/passwd will be\n"
"              the input:\n"
"\n"
"              curl -F password=@/etc/passwd www.mypasswords.com\n"
"\n"
"              To read the file's content from stdin instead of a file,  use  -\n"
"              where  the  file name should've been. This goes for both @ and <\n"
"              constructs.\n"
"\n"
, stdout);
 fputs(
"              You can also  tell  curl  what  Content-Type  to  use  by  using\n"
"              'type=', in a manner similar to:\n"
"\n"
"              curl -F \"web=@index.html;type=text/html\" url.com\n"
"\n"
"              or\n"
"\n"
"              curl -F \"name=daniel;type=text/foo\" url.com\n"
"\n"
"              You  can also explicitly change the name field of an file upload\n"
"              part by setting filename=, like this:\n"
"\n"
"              curl -F \"file=@localfile;filename=nameinpost\" url.com\n"
"\n"
, stdout);
 fputs(
"              See further examples and details in the MANUAL.\n"
"\n"
"              This option can be used multiple times.\n"
"\n"
"       --form-string <name=string>\n"
"              (HTTP) Similar to --form except that the value  string  for  the\n"
"              named  parameter  is used literally. Leading '@' and '<' charac-\n"
"              ters, and the ';type=' string in the value have no special mean-\n"
"              ing. Use this in preference to --form if there's any possibility\n"
, stdout);
 fputs(
"              that the string value may accidentally trigger the  '@'  or  '<'\n"
"              features of --form.\n"
"\n"
"       -g/--globoff\n"
"              This option switches off the \"URL globbing parser\". When you set\n"
"              this option, you can specify URLs that contain the letters  {}[]\n"
"              without  having them being interpreted by curl itself. Note that\n"
"              these letters are not normal legal URL contents but they  should\n"
, stdout);
 fputs(
"              be encoded according to the URI standard.\n"
"\n"
"       -G/--get\n"
"              When  used,  this  option  will  make  all  data  specified with\n"
"              -d/--data or --data-binary to be used  in  a  HTTP  GET  request\n"
"              instead  of  the  POST request that otherwise would be used. The\n"
"              data will be appended to the URL with a '?'  separator.\n"
"\n"
"              If used in combination with -I, the POST data  will  instead  be\n"
, stdout);
 fputs(
"              appended to the URL with a HEAD request.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference. This is because undoing a GET  doesn't  make\n"
"              sense,  but  you  should  then  instead  enforce the alternative\n"
"              method you prefer.\n"
"\n"
"       -h/--help\n"
"              Usage help.\n"
"\n"
"       -H/--header <header>\n"
"              (HTTP) Extra header to use when getting  a  web  page.  You  may\n"
, stdout);
 fputs(
"              specify any number of extra headers. Note that if you should add\n"
"              a custom header that has the same name as one  of  the  internal\n"
"              ones  curl  would  use,  your externally set header will be used\n"
"              instead of the internal one. This allows you to make even trick-\n"
"              ier  stuff  than  curl would normally do. You should not replace\n"
"              internally set  headers  without  knowing  perfectly  well  what\n"
, stdout);
 fputs(
"              you're  doing. Remove an internal header by giving a replacement\n"
"              without content on the right  side  of  the  colon,  as  in:  -H\n"
"              \"Host:\".\n"
"\n"
"              curl  will  make  sure that each header you add/replace get sent\n"
"              with the proper end of line marker, you should thus not add that\n"
"              as a part of the header content: do not add newlines or carriage\n"
"              returns they will only mess things up for you.\n"
"\n"
, stdout);
 fputs(
"              See also the -A/--user-agent and -e/--referer options.\n"
"\n"
"              This option can be used  multiple  times  to  add/replace/remove\n"
"              multiple headers.\n"
"\n"
"       --hostpubmd5 <md5>\n"
"              Pass  a  string  containing  32  hexadecimal  digits. The string\n"
"              should be the 128 bit MD5 checksum of the remote  host's  public\n"
"              key,  curl  will  refuse the connection with the host unless the\n"
, stdout);
 fputs(
"              md5sums match. This option is only for SCP and  SFTP  transfers.\n"
"              (Added in 7.17.1)\n"
"\n"
"       --ignore-content-length\n"
"              (HTTP)  Ignore  the  Content-Length header. This is particularly\n"
"              useful for servers running Apache 1.x, which will report  incor-\n"
"              rect Content-Length for files larger than 2 gigabytes.\n"
"\n"
"       -i/--include\n"
"              (HTTP)  Include  the  HTTP-header in the output. The HTTP-header\n"
, stdout);
 fputs(
"              includes things like server-name, date of  the  document,  HTTP-\n"
"              version and more...\n"
"\n"
"       --interface <name>\n"
"              Perform  an operation using a specified interface. You can enter\n"
"              interface name, IP address or host name. An example  could  look\n"
"              like:\n"
"\n"
"               curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -I/--head\n"
, stdout);
 fputs(
"              (HTTP/FTP/FILE) Fetch the HTTP-header only! HTTP-servers feature\n"
"              the  command  HEAD which this uses to get nothing but the header\n"
"              of a document. When used on a FTP or FILE  file,  curl  displays\n"
"              the file size and last modification time only.\n"
"\n"
"       -j/--junk-session-cookies\n"
"              (HTTP) When curl is told to read cookies from a given file, this\n"
"              option will make it discard all  \"session  cookies\".  This  will\n"
, stdout);
 fputs(
"              basically  have  the same effect as if a new session is started.\n"
"              Typical browsers always discard  session  cookies  when  they're\n"
"              closed down.\n"
"\n"
"       -k/--insecure\n"
"              (SSL)  This  option explicitly allows curl to perform \"insecure\"\n"
"              SSL connections and transfers. All SSL connections are attempted\n"
"              to  be  made secure by using the CA certificate bundle installed\n"
, stdout);
 fputs(
"              by default. This makes all connections considered \"insecure\"  to\n"
"              fail unless -k/--insecure is used.\n"
"\n"
"              See     this    online    resource    for    further    details:\n"
"              http://curl.haxx.se/docs/sslcerts.html\n"
"\n"
"       --keepalive-time <seconds>\n"
"              This option sets the time a  connection  needs  to  remain  idle\n"
"              before  sending keepalive probes and the time between individual\n"
, stdout);
 fputs(
"              keepalive probes. It is currently effective on operating systems\n"
"              offering  the  TCP_KEEPIDLE  and  TCP_KEEPINTVL  socket  options\n"
"              (meaning Linux, recent AIX, HP-UX and more). This option has  no\n"
"              effect if --no-keepalive is used. (Added in 7.18.0)\n"
"\n"
"              If  this option is used multiple times, the last occurrence sets\n"
"              the amount.\n"
"       --key <key>\n"
, stdout);
 fputs(
"              (SSL/SSH) Private key file name. Allows you to provide your pri-\n"
"              vate key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --key-type <type>\n"
"              (SSL) Private key file type. Specify which type your --key  pro-\n"
"              vided  private  key  is.  DER, PEM and ENG are supported. If not\n"
"              specified, PEM is assumed.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --krb <level>\n"
"              (FTP)  Enable Kerberos authentication and use. The level must be\n"
"              entered and should be one of 'clear', 'safe', 'confidential'  or\n"
"              'private'.  Should  you  use  a  level that is not one of these,\n"
"              'private' will instead be used.\n"
"\n"
"              This option requires that the library was built  with  kerberos4\n"
, stdout);
 fputs(
"              or  GSSAPI (GSS-Negotiate) support. This is not very common. Use\n"
"              -V/--version to see if your curl supports it.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -K/--config <config file>\n"
"              Specify  which config file to read curl arguments from. The con-\n"
"              fig file is a text file in which command line arguments  can  be\n"
"              written  which  then will be used as if they were written on the\n"
, stdout);
 fputs(
"              actual command line. Options and their parameters must be speci-\n"
"              fied  on  the  same  config file line, separated by white space,\n"
"              colon, the equals sign or any combination thereof (however,  the\n"
"              preferred  separator is the equals sign). If the parameter is to\n"
"              contain white spaces, the  parameter  must  be  enclosed  within\n"
"              quotes. Within double quotes, the following escape sequences are\n"
, stdout);
 fputs(
"              available: \\\\, \\\", \\t, \\n, \\r and \\v. A backlash  preceding  any\n"
"              other  letter  is  ignored. If the first column of a config line\n"
"              is a '#' character, the rest of the line will be  treated  as  a\n"
"              comment.  Only  write one option per physical line in the config\n"
"              file.\n"
"\n"
"              Specify the filename to -K/--config as '-' to make curl read the\n"
"              file from stdin.\n"
"\n"
, stdout);
 fputs(
"              Note  that  to  be able to specify a URL in the config file, you\n"
"              need to specify it using the --url option,  and  not  by  simply\n"
"              writing  the  URL  on its own line. So, it could look similar to\n"
"              this:\n"
"\n"
"              url = \"http://curl.haxx.se/docs/\"\n"
"\n"
"              Long option names can optionally be given  in  the  config  file\n"
"              without the initial double dashes.\n"
"\n"
, stdout);
 fputs(
"              When curl is invoked, it always (unless -q is used) checks for a\n"
"              default config file and uses it if  found.  The  default  config\n"
"              file is checked for in the following places in this order:\n"
"\n"
"              1)  curl  tries  to find the \"home dir\": It first checks for the\n"
"              CURL_HOME and then the HOME environment variables. Failing that,\n"
"              it  uses getpwuid() on unix-like systems (which returns the home\n"
, stdout);
 fputs(
"              dir given the current user in your system). On Windows, it  then\n"
"              checks for the APPDATA variable, or as a last resort the '%USER-\n"
"              PROFILE%0lication Data'.\n"
"\n"
"              2) On windows, if there is no _curlrc file in the home  dir,  it\n"
"              checks for one in the same dir the executable curl is placed. On\n"
"              unix-like systems, it will simply try to load .curlrc  from  the\n"
"              determined home dir.\n"
"\n"
, stdout);
 fputs(
"              # --- Example file ---\n"
"              # this is a comment\n"
"              url = \"curl.haxx.se\"\n"
"              output = \"curlhere.html\"\n"
"              user-agent = \"superagent/1.0\"\n"
"\n"
"              # and fetch another URL too\n"
"              url = \"curl.haxx.se/docs/manpage.html\"\n"
"              -O\n"
"              referer = \"http://nowhereatall.com/\"\n"
"              # --- End of example file ---\n"
"\n"
"              This  option  can be used multiple times to load multiple config\n"
"              files.\n"
"\n"
, stdout);
 fputs(
"       --libcurl <file>\n"
"              Append this option to any ordinary curl command  line,  and  you\n"
"              will  get  a  libcurl-using source code written to the file that\n"
"              does the equivalent operation of what your command  line  opera-\n"
"              tion does!\n"
"\n"
"              NOTE:  this does not properly support -F and the sending of mul-\n"
"              tipart formposts, so in those cases the output program  will  be\n"
, stdout);
 fputs(
"              missing necessary calls to curl_formadd(3), and possibly more.\n"
"\n"
"              If  this  option is used several times, the last given file name\n"
"              will be used. (Added in 7.16.1)\n"
"\n"
"       --limit-rate <speed>\n"
"              Specify the maximum transfer rate you want  curl  to  use.  This\n"
"              feature is useful if you have a limited pipe and you'd like your\n"
"              transfer not use your entire bandwidth.\n"
"\n"
, stdout);
 fputs(
"              The given speed is measured in bytes/second, unless a suffix  is\n"
"              appended.   Appending  'k' or 'K' will count the number as kilo-\n"
"              bytes, 'm' or M' makes it megabytes while 'g' or  'G'  makes  it\n"
"              gigabytes. Examples: 200K, 3m and 1G.\n"
"\n"
"              The  given  rate is the average speed, counted during the entire\n"
"              transfer. It means that curl might use higher transfer speeds in\n"
, stdout);
 fputs(
"              short bursts, but over time it uses no more than the given rate.\n"
"              If you are also using the -Y/--speed-limit option,  that  option\n"
"              will   take  precedence  and  might  cripple  the  rate-limiting\n"
"              slightly, to help keeping the speed-limit logic working.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -l/--list-only\n"
"              (FTP)  When listing an FTP directory, this switch forces a name-\n"
, stdout);
 fputs(
"              only view.  Especially useful if you want to  machine-parse  the\n"
"              contents  of  an  FTP  directory since the normal directory view\n"
"              doesn't use a standard look or format.\n"
"\n"
"              This option causes an FTP NLST command to  be  sent.   Some  FTP\n"
"              servers  list  only files in their response to NLST; they do not\n"
"              include subdirectories and symbolic links.\n"
"\n"
"       --local-port <num>[-num]\n"
, stdout);
 fputs(
"              Set a preferred number or range of local port numbers to use for\n"
"              the connection(s).  Note that port numbers by nature is a scarce\n"
"              resource that will be busy at times so  setting  this  range  to\n"
"              something  too  narrow  might cause unnecessary connection setup\n"
"              failures. (Added in 7.15.2)\n"
"\n"
"       -L/--location\n"
"              (HTTP/HTTPS) If the server reports that the requested  page  has\n"
, stdout);
 fputs(
"              moved to a different location (indicated with a Location: header\n"
"              and a 3XX response code) this option will  make  curl  redo  the\n"
"              request  on the new place. If used together with -i/--include or\n"
"              -I/--head, headers from all requested pages will be shown.  When\n"
"              authentication  is  used, curl only sends its credentials to the\n"
"              initial host. If a redirect takes curl to a different  host,  it\n"
, stdout);
 fputs(
"              won't  be  able to intercept the user+password. See also --loca-\n"
"              tion-trusted on how to change this. You can limit the amount  of\n"
"              redirects to follow by using the --max-redirs option.\n"
"\n"
"              When  curl follows a redirect and the request is not a plain GET\n"
"              (for example POST or PUT), it will do the following request with\n"
"              a GET if the HTTP response was 301, 302, or 303. If the response\n"
, stdout);
 fputs(
"              code was any other 3xx code, curl  will  re-send  the  following\n"
"              request using the same unmodified method.\n"
"\n"
"       --location-trusted\n"
"              (HTTP/HTTPS) Like -L/--location, but will allow sending the name\n"
"              + password to all hosts that the site may redirect to. This  may\n"
"              or may not introduce a security breach if the site redirects you\n"
"              do a site to which you'll send your authentication  info  (which\n"
, stdout);
 fputs(
"              is plaintext in the case of HTTP Basic authentication).\n"
"\n"
"       --max-filesize <bytes>\n"
"              Specify  the  maximum  size (in bytes) of a file to download. If\n"
"              the file requested is larger than this value, the transfer  will\n"
"              not start and curl will return with exit code 63.\n"
"\n"
"              NOTE:  The  file size is not always known prior to download, and\n"
"              for such files this option has no effect even if the file trans-\n"
, stdout);
 fputs(
"              fer  ends  up  being larger than this given limit. This concerns\n"
"              both FTP and HTTP transfers.\n"
"\n"
"       -m/--max-time <seconds>\n"
"              Maximum time in seconds that you allow the  whole  operation  to\n"
"              take.   This is useful for preventing your batch jobs from hang-\n"
"              ing for hours due to slow networks or  links  going  down.   See\n"
"              also the --connect-timeout option.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -M/--manual\n"
"              Manual. Display the huge help text.\n"
"\n"
"       -n/--netrc\n"
"              Makes curl scan the .netrc  (_netrc  on  Windows)  file  in  the\n"
"              user's home directory for login name and password. This is typi-\n"
"              cally used for ftp on unix. If used with http, curl will  enable\n"
"              user  authentication.  See netrc(4) or ftp(1) for details on the\n"
, stdout);
 fputs(
"              file format. Curl will not complain  if  that  file  hasn't  the\n"
"              right  permissions  (it should not be world nor group readable).\n"
"              The environment variable \"HOME\" is used to find the home  direc-\n"
"              tory.\n"
"\n"
"              A  quick  and  very  simple  example of how to setup a .netrc to\n"
"              allow curl to ftp to the machine host.domain.com with user  name\n"
"              'myself' and password 'secret' should look similar to:\n"
"\n"
, stdout);
 fputs(
"              machine host.domain.com login myself password secret\n"
"\n"
"       --netrc-optional\n"
"              Very  similar to --netrc, but this option makes the .netrc usage\n"
"              optional and not mandatory as the --netrc does.\n"
"\n"
"       --negotiate\n"
"              (HTTP) Enables GSS-Negotiate authentication.  The  GSS-Negotiate\n"
"              method was designed by Microsoft and is used in their web appli-\n"
"              cations. It is  primarily  meant  as  a  support  for  Kerberos5\n"
, stdout);
 fputs(
"              authentication but may be also used along with another authenti-\n"
"              cation methods. For  more  information  see  IETF  draft  draft-\n"
"              brezak-spnego-http-04.txt.\n"
"\n"
"              If  you  want to enable Negotiate for your proxy authentication,\n"
"              then use --proxy-negotiate.\n"
"\n"
"              This option requires that the library was built with GSSAPI sup-\n"
"              port.  This  is not very common. Use -V/--version to see if your\n"
, stdout);
 fputs(
"              version supports GSS-Negotiate.\n"
"\n"
"              When using this option, you must also provide a  fake  -u/--user\n"
"              option  to  activate the authentication code properly. Sending a\n"
"              '-u :' is enough as the user  name  and  password  from  the  -u\n"
"              option aren't actually used.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -N/--no-buffer\n"
, stdout);
 fputs(
"              Disables the buffering of the output stream. In normal work sit-\n"
"              uations,  curl  will  use a standard buffered output stream that\n"
"              will have the effect that it will output the data in chunks, not\n"
"              necessarily  exactly  when  the data arrives.  Using this option\n"
"              will disable that buffering.\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --buffer to enforce the buffering.\n"
"\n"
, stdout);
 fputs(
"       --no-keepalive\n"
"              Disables the use of keepalive messages on the TCP connection, as\n"
"              by default curl enables them.\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --keepalive to enforce keepalive.\n"
"\n"
"       --no-sessionid\n"
"              (SSL)  Disable curl's use of SSL session-ID caching.  By default\n"
"              all transfers are done using the cache. Note that while  nothing\n"
, stdout);
 fputs(
"              ever  should  get  hurt  by attempting to reuse SSL session-IDs,\n"
"              there seem to be broken SSL implementations in the wild that may\n"
"              require  you to disable this in order for you to succeed. (Added\n"
"              in 7.16.0)\n"
"\n"
"              Note that this is the negated option name  documented.  You  can\n"
"              thus use --sessionid to enforce session-ID caching.\n"
"\n"
"       --ntlm (HTTP)  Enables  NTLM  authentication.  The  NTLM authentication\n"
, stdout);
 fputs(
"              method was designed by Microsoft and is used by IIS web servers.\n"
"              It is a proprietary protocol, reversed engineered by clever peo-\n"
"              ple and implemented in curl based on their efforts. This kind of\n"
"              behavior  should  not be endorsed, you should encourage everyone\n"
"              who uses NTLM to switch to a public and  documented  authentica-\n"
"              tion method instead. Such as Digest.\n"
"\n"
, stdout);
 fputs(
"              If  you  want to enable NTLM for your proxy authentication, then\n"
"              use --proxy-ntlm.\n"
"\n"
"              This option requires that the library was built  with  SSL  sup-\n"
"              port. Use -V/--version to see if your curl supports NTLM.\n"
"\n"
"              If  this option is used several times, the following occurrences\n"
"              make no difference.\n"
"\n"
"       -o/--output <file>\n"
"              Write output to <file> instead of stdout. If you are using {} or\n"
, stdout);
 fputs(
"              []  to  fetch  multiple documents, you can use '#' followed by a\n"
"              number in the <file> specifier. That variable will  be  replaced\n"
"              with the current string for the URL being fetched. Like in:\n"
"\n"
"                curl http://{one,two}.site.com -o \"file_#1.txt\"\n"
"\n"
"              or use several variables like:\n"
"\n"
"                curl http://{site,host}.host[1-5].com -o \"#1_#2\"\n"
"\n"
"              You  may  use  this  option  as many times as you have number of\n"
, stdout);
 fputs(
"              URLs.\n"
"\n"
"              See also the --create-dirs option to create the  local  directo-\n"
"              ries dynamically.\n"
"\n"
"       -O/--remote-name\n"
"              Write  output to a local file named like the remote file we get.\n"
"              (Only the file part of the remote file is used, the path is  cut\n"
"              off.)\n"
"\n"
"              The  remote  file  name  to use for saving is extracted from the\n"
"              given URL, nothing else.\n"
"\n"
, stdout);
 fputs(
"              You may use this option as many times  as  you  have  number  of\n"
"              URLs.\n"
"\n"
"       --remote-name-all\n"
"              This  option changes the default action for all given URLs to be\n"
"              dealt with as if -O/--remote-name were used for each one. So  if\n"
"              you want to disable that for a specific URL after --remote-name-\n"
"              all has been used, you must  use  \"-o  -\"  or  --no-remote-name.\n"
"              (Added in 7.19.0)\n"
"\n"
"       --pass <phrase>\n"
, stdout);
 fputs(
"              (SSL/SSH) Pass phrase for the private key\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --post301\n"
"              Tells curl to respect  RFC  2616/10.3.2  and  not  convert  POST\n"
"              requests into GET requests when following a 301 redirection. The\n"
"              non-RFC behaviour is ubiquitous in web browsers,  so  curl  does\n"
"              the  conversion  by  default to maintain consistency. However, a\n"
, stdout);
 fputs(
"              server may requires a POST to remain a POST after such  a  redi-\n"
"              rection. This option is meaningful only when using -L/--location\n"
"              (Added in 7.17.1)\n"
"\n"
"       --proxy-anyauth\n"
"              Tells curl to pick a suitable authentication method when  commu-\n"
"              nicating  with  the  given  proxy.  This  might  cause  an extra\n"
"              request/response round-trip. (Added in 7.13.2)\n"
"\n"
"       --proxy-basic\n"
, stdout);
 fputs(
"              Tells curl to use HTTP Basic authentication  when  communicating\n"
"              with the given proxy. Use --basic for enabling HTTP Basic with a\n"
"              remote host. Basic is the  default  authentication  method  curl\n"
"              uses with proxies.\n"
"\n"
"       --proxy-digest\n"
"              Tells  curl to use HTTP Digest authentication when communicating\n"
"              with the given proxy. Use --digest for enabling HTTP Digest with\n"
"              a remote host.\n"
"\n"
, stdout);
 fputs(
"       --proxy-negotiate\n"
"              Tells curl to use HTTP Negotiate authentication when communicat-\n"
"              ing with the given proxy.  Use  --negotiate  for  enabling  HTTP\n"
"              Negotiate with a remote host. (Added in 7.17.1)\n"
"\n"
"       --proxy-ntlm\n"
"              Tells  curl  to  use HTTP NTLM authentication when communicating\n"
"              with the given proxy. Use --ntlm for enabling NTLM with a remote\n"
"              host.\n"
"\n"
"       -p/--proxytunnel\n"
, stdout);
 fputs(
"              When  an HTTP proxy is used (-x/--proxy), this option will cause\n"
"              non-HTTP protocols  to  attempt  to  tunnel  through  the  proxy\n"
"              instead  of merely using it to do HTTP-like operations. The tun-\n"
"              nel approach is made with the HTTP  proxy  CONNECT  request  and\n"
"              requires that the proxy allows direct connect to the remote port\n"
"              number curl wants to tunnel through to.\n"
"\n"
"       --pubkey <key>\n"
, stdout);
 fputs(
"              (SSH) Public key file name. Allows you to  provide  your  public\n"
"              key in this separate file.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -P/--ftp-port <address>\n"
"              (FTP) Reverses the initiator/listener roles when connecting with\n"
"              ftp.  This  switch  makes  Curl  use the PORT command instead of\n"
"              PASV. In practise, PORT tells  the  server  to  connect  to  the\n"
, stdout);
 fputs(
"              client's  specified address and port, while PASV asks the server\n"
"              for an ip address and port to connect to.  <address>  should  be\n"
"              one of:\n"
"\n"
"              interface\n"
"                     i.e  \"eth0\"  to  specify which interface's IP address you\n"
"                     want to use  (Unix only)\n"
"\n"
"              IP address\n"
"                     i.e \"192.168.10.1\" to specify exact IP number\n"
"\n"
"              host name\n"
, stdout);
 fputs(
"                     i.e \"my.host.domain\" to specify machine\n"
"\n"
"              -      make curl pick the same IP address that is  already  used\n"
"                     for the control connection\n"
"\n"
"       If  this  option is used several times, the last one will be used. Dis-\n"
"       able the use of PORT with --ftp-pasv. Disable the attempt  to  use  the\n"
"       EPRT  command  instead  of PORT by using --disable-eprt. EPRT is really\n"
"       PORT++.\n"
"\n"
, stdout);
 fputs(
"       -q     If used as the first parameter on the command line,  the  curlrc\n"
"              config  file  will not be read and used. See the -K/--config for\n"
"              details on the default config file search path.\n"
"\n"
"       -Q/--quote <command>\n"
"              (FTP/SFTP) Send an arbitrary command to the remote FTP  or  SFTP\n"
"              server.  Quote  commands  are sent BEFORE the transfer is taking\n"
"              place (just after the initial PWD command in an FTP transfer, to\n"
, stdout);
 fputs(
"              be exact). To make commands take place after a successful trans-\n"
"              fer, prefix them with a dash '-'.  To  make  commands  get  sent\n"
"              after  libcurl  has  changed  working directory, just before the\n"
"              transfer command(s), prefix the command with '+' (this  is  only\n"
"              supported  for  FTP). You may specify any number of commands. If\n"
"              the server returns failure for one of the commands,  the  entire\n"
, stdout);
 fputs(
"              operation  will  be aborted. You must send syntactically correct\n"
"              FTP commands as RFC959 defines to FTP servers,  or  one  of  the\n"
"              commands  listed below to SFTP servers.  This option can be used\n"
"              multiple times.\n"
"\n"
"              SFTP is a binary protocol. Unlike for  FTP,  libcurl  interprets\n"
"              SFTP  quote commands before sending them to the server.  Follow-\n"
"              ing is the list of all supported SFTP quote commands:\n"
"\n"
, stdout);
 fputs(
"              chgrp group file\n"
"                     The chgrp command sets the group ID of the file named  by\n"
"                     the  file  operand to the group ID specified by the group\n"
"                     operand. The group operand is a decimal integer group ID.\n"
"\n"
"              chmod mode file\n"
"                     The  chmod  command  modifies  the  file mode bits of the\n"
"                     specified file. The mode operand is an octal integer mode\n"
"                     number.\n"
"\n"
, stdout);
 fputs(
"              chown user file\n"
"                     The chown command sets the owner of the file named by the\n"
"                     file operand  to  the  user  ID  specified  by  the  user\n"
"                     operand. The user operand is a decimal integer user ID.\n"
"\n"
"              ln source_file target_file\n"
"                     The ln and symlink commands create a symbolic link at the\n"
"                     target_file location pointing to  the  source_file  loca-\n"
"                     tion.\n"
"\n"
, stdout);
 fputs(
"              mkdir directory_name\n"
"                     The  mkdir  command  creates  the  directory named by the\n"
"                     directory_name operand.\n"
"\n"
"              pwd    The pwd command returns the absolute pathname of the cur-\n"
"                     rent working directory.\n"
"\n"
"              rename source target\n"
"                     The rename command renames the file or directory named by\n"
"                     the source operand to the destination path named  by  the\n"
, stdout);
 fputs(
"                     target operand.\n"
"\n"
"              rm file\n"
"                     The  rm  command  removes  the file specified by the file\n"
"                     operand.\n"
"\n"
"              rmdir directory\n"
"                     The rmdir command removes the directory  entry  specified\n"
"                     by the directory operand, provided it is empty.\n"
"\n"
"              symlink source_file target_file\n"
"                     See ln.\n"
"\n"
"       --random-file <file>\n"
, stdout);
 fputs(
"              (SSL) Specify the path name to file containing what will be con-\n"
"              sidered as random data. The data is  used  to  seed  the  random\n"
"              engine for SSL connections.  See also the --egd-file option.\n"
"\n"
"       -r/--range <range>\n"
"              (HTTP/FTP/FILE)  Retrieve  a byte range (i.e a partial document)\n"
"              from a HTTP/1.1, FTP server or a local FILE. Ranges can be spec-\n"
"              ified in a number of ways.\n"
"\n"
, stdout);
 fputs(
"              0-499     specifies the first 500 bytes\n"
"\n"
"              500-999   specifies the second 500 bytes\n"
"\n"
"              -500      specifies the last 500 bytes\n"
"\n"
"              9500-     specifies the bytes from offset 9500 and forward\n"
"\n"
"              0-0,-1    specifies the first and last byte only(*)(H)\n"
"\n"
"              500-700,600-799\n"
"                        specifies 300 bytes from offset 500(H)\n"
"\n"
"              100-199,500-599\n"
, stdout);
 fputs(
"                        specifies two separate 100 bytes ranges(*)(H)\n"
"\n"
"       (*)  =  NOTE  that this will cause the server to reply with a multipart\n"
"       response!\n"
"\n"
"       Only digit characters (0-9) are valid in 'start' and  'stop'  of  range\n"
"       syntax  'start-stop'.  If  a non-digit character is given in the range,\n"
"       the server's response will be indeterminable,  depending  on  different\n"
"       server's configuration.\n"
"\n"
, stdout);
 fputs(
"       You  should  also  be aware that many HTTP/1.1 servers do not have this\n"
"       feature enabled, so that when  you  attempt  to  get  a  range,  you'll\n"
"       instead get the whole document.\n"
"\n"
"       FTP  range  downloads  only  support  the  simple  syntax  'start-stop'\n"
"       (optionally with one of the numbers omitted). It depends on the non-RFC\n"
"       command SIZE.\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       --raw  When  used, it disables all internal HTTP decoding of content or\n"
"              transfer encodings and instead makes them passed  on  unaltered,\n"
"              raw. (Added in 7.16.2)\n"
"\n"
"       -R/--remote-time\n"
"              When  used,  this  will  make  libcurl attempt to figure out the\n"
"              timestamp of the remote file, and if that is available make  the\n"
"              local file get that same timestamp.\n"
"\n"
"       --retry <num>\n"
, stdout);
 fputs(
"              If  a  transient  error is returned when curl tries to perform a\n"
"              transfer, it will retry this number of times before  giving  up.\n"
"              Setting  the  number to 0 makes curl do no retries (which is the\n"
"              default). Transient error means either: a timeout,  an  FTP  5xx\n"
"              response code or an HTTP 5xx response code.\n"
"\n"
"              When  curl  is about to retry a transfer, it will first wait one\n"
, stdout);
 fputs(
"              second and then for all forthcoming retries it will  double  the\n"
"              waiting  time until it reaches 10 minutes which then will be the\n"
"              delay between the rest of the retries.  By  using  --retry-delay\n"
"              you   disable  this  exponential  backoff  algorithm.  See  also\n"
"              --retry-max-time to limit the total time  allowed  for  retries.\n"
"              (Added in 7.12.3)\n"
"\n"
, stdout);
 fputs(
"              If  this  option  is  used  multiple  times, the last occurrence\n"
"              decide the amount.\n"
"\n"
"       --retry-delay <seconds>\n"
"              Make curl sleep this amount of time between each  retry  when  a\n"
"              transfer  has  failed  with  a  transient  error (it changes the\n"
"              default backoff time algorithm between retries). This option  is\n"
"              only  interesting if --retry is also used. Setting this delay to\n"
, stdout);
 fputs(
"              zero will make curl use the default  backoff  time.   (Added  in\n"
"              7.12.3)\n"
"\n"
"              If  this  option  is  used  multiple  times, the last occurrence\n"
"              decide the amount.\n"
"\n"
"       --retry-max-time <seconds>\n"
"              The retry timer is reset  before  the  first  transfer  attempt.\n"
"              Retries will be done as usual (see --retry) as long as the timer\n"
"              hasn't reached this given limit. Notice that if the timer hasn't\n"
, stdout);
 fputs(
"              reached  the  limit, the request will be made and while perform-\n"
"              ing, it may take longer than this given time period. To limit  a\n"
"              single  request's  maximum  time,  use  -m/--max-time.  Set this\n"
"              option to zero to not timeout retries. (Added in 7.12.3)\n"
"\n"
"              If this option is  used  multiple  times,  the  last  occurrence\n"
"              decide the amount.\n"
"\n"
"       -s/--silent\n"
, stdout);
 fputs(
"              Silent mode. Don't show progress meter or error messages.  Makes\n"
"              Curl mute.\n"
"\n"
"       -S/--show-error\n"
"              When used with -s it makes curl show error message if it  fails.\n"
"\n"
"       --socks4 <host[:port]>\n"
"              Use the specified SOCKS4 proxy. If the port number is not speci-\n"
"              fied, it is assumed at port 1080. (Added in 7.15.2)\n"
"\n"
"              This option overrides any previous use of  -x/--proxy,  as  they\n"
, stdout);
 fputs(
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --socks4a <host[:port]>\n"
"              Use the specified SOCKS4a proxy. If the port number is not spec-\n"
"              ified, it is assumed at port 1080. (Added in 7.18.0)\n"
"\n"
"              This  option  overrides  any previous use of -x/--proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       --socks5-hostname <host[:port]>\n"
"              Use  the  specified  SOCKS5 proxy (and let the proxy resolve the\n"
"              host name). If the port number is not specified, it  is  assumed\n"
"              at port 1080. (Added in 7.18.0)\n"
"\n"
"              This  option  overrides  any previous use of -x/--proxy, as they\n"
"              are mutually exclusive.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
, stdout);
 fputs(
"              (This  option  was  previously  wrongly  documented  and used as\n"
"              --socks without the number appended.)\n"
"\n"
"       --socks5 <host[:port]>\n"
"              Use the specified SOCKS5 proxy  -  but  resolve  the  host  name\n"
"              locally.  If  the port number is not specified, it is assumed at\n"
"              port 1080.\n"
"\n"
"              This option overrides any previous use of  -x/--proxy,  as  they\n"
"              are mutually exclusive.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"              (This option was  previously  wrongly  documented  and  used  as\n"
"              --socks without the number appended.)\n"
"\n"
"       --stderr <file>\n"
"              Redirect  all writes to stderr to the specified file instead. If\n"
"              the file name is a plain '-', it is instead written  to  stdout.\n"
"              This  option  has no point when you're using a shell with decent\n"
, stdout);
 fputs(
"              redirecting capabilities.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --tcp-nodelay\n"
"              Turn  on the TCP_NODELAY option. See the curl_easy_setopt(3) man\n"
"              page for details about this option. (Added in 7.11.2)\n"
"\n"
"       -t/--telnet-option <OPT=val>\n"
"              Pass options to the telnet protocol. Supported options are:\n"
"\n"
"              TTYPE=<term> Sets the terminal type.\n"
"\n"
, stdout);
 fputs(
"              XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"              NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"       -T/--upload-file <file>\n"
"              This transfers the specified local file to the  remote  URL.  If\n"
"              there is no file part in the specified URL, Curl will append the\n"
"              local file name. NOTE that you must use a trailing / on the last\n"
"              directory  to really prove to Curl that there is no file name or\n"
, stdout);
 fputs(
"              curl will think that your last directory name is the remote file\n"
"              name to use. That will most likely cause the upload operation to\n"
"              fail. If this is used on a http(s) server, the PUT command  will\n"
"              be used.\n"
"\n"
"              Use  the file name \"-\" (a single dash) to use stdin instead of a\n"
"              given file.\n"
"\n"
"              You can specify one -T for each URL on the command line. Each -T\n"
, stdout);
 fputs(
"              + URL pair specifies what to upload and to where. curl also sup-\n"
"              ports \"globbing\" of the -T argument, meaning that you can upload\n"
"              multiple  files  to  a single URL by using the same URL globbing\n"
"              style supported in the URL, like this:\n"
"\n"
"              curl -T \"{file1,file2}\" http://www.uploadtothissite.com\n"
"\n"
"              or even\n"
"\n"
"              curl -T \"img[1-1000].png\" ftp://ftp.picturemania.com/upload/\n"
"\n"
"       --trace <file>\n"
, stdout);
 fputs(
"              Enables a full trace dump of all  incoming  and  outgoing  data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This option overrides previous uses of -v/--verbose or  --trace-\n"
"              ascii.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --trace-ascii <file>\n"
, stdout);
 fputs(
"              Enables a full trace dump of all  incoming  and  outgoing  data,\n"
"              including descriptive information, to the given output file. Use\n"
"              \"-\" as filename to have the output sent to stdout.\n"
"\n"
"              This is very similar to --trace, but leaves out the hex part and\n"
"              only  shows  the ASCII part of the dump. It makes smaller output\n"
"              that might be easier to read for untrained humans.\n"
"\n"
, stdout);
 fputs(
"              This option overrides previous uses of -v/--verbose or  --trace.\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --trace-time\n"
"              Prepends a time stamp to each trace or verbose  line  that  curl\n"
"              displays.  (Added in 7.14.0)\n"
"\n"
"       -u/--user <user:password>\n"
"              Specify  user  and  password  to  use for server authentication.\n"
"              Overrides -n/--netrc and --netrc-optional.\n"
"\n"
, stdout);
 fputs(
"              If you just give the user name (without entering a  colon)  curl\n"
"              will prompt for a password.\n"
"\n"
"              If  you  use an SSPI-enabled curl binary and do NTLM authentica-\n"
"              tion, you can force curl to pick up the user name  and  password\n"
"              from  your  environment by simply specifying a single colon with\n"
"              this option: \"-u :\".\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       -U/--proxy-user <user:password>\n"
"              Specify user and password to use for proxy authentication.\n"
"\n"
"              If  you  use an SSPI-enabled curl binary and do NTLM authentica-\n"
"              tion, you can force curl to pick up the user name  and  password\n"
"              from  your  environment by simply specifying a single colon with\n"
"              this option: \"-U :\".\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --url <URL>\n"
, stdout);
 fputs(
"              Specify  a  URL  to  fetch. This option is mostly handy when you\n"
"              want to specify URL(s) in a config file.\n"
"\n"
"              This option may be used any number of times.  To  control  where\n"
"              this URL is written, use the -o/--output or the -O/--remote-name\n"
"              options.\n"
"\n"
"       -v/--verbose\n"
"              Makes the fetching more  verbose/talkative.  Mostly  usable  for\n"
"              debugging.  Lines  starting with '>' means \"header data\" sent by\n"
, stdout);
 fputs(
"              curl, '<' means \"header data\" received by curl that is hidden in\n"
"              normal  cases  and lines starting with '*' means additional info\n"
"              provided by curl.\n"
"\n"
"              Note  that  if  you  only  want  HTTP  headers  in  the  output,\n"
"              -i/--include might be option you're looking for.\n"
"\n"
"              If  you think this option still doesn't give you enough details,\n"
"              consider using --trace or --trace-ascii instead.\n"
"\n"
, stdout);
 fputs(
"              This option overrides previous uses of --trace-ascii or --trace.\n"
"\n"
"       -V/--version\n"
"              Displays information about curl and the libcurl version it uses.\n"
"              The first line includes the full version of  curl,  libcurl  and\n"
"              other 3rd party libraries linked with the executable.\n"
"\n"
"              The  second  line (starts with \"Protocols:\") shows all protocols\n"
"              that libcurl reports to support.\n"
"\n"
, stdout);
 fputs(
"              The third line (starts with \"Features:\") shows specific features\n"
"              libcurl reports to offer. Available features include:\n"
"\n"
"              IPv6   You can use IPv6 with this.\n"
"\n"
"              krb4   Krb4 for ftp is supported.\n"
"\n"
"              SSL    HTTPS and FTPS are supported.\n"
"\n"
"              libz   Automatic  decompression of compressed files over HTTP is\n"
"                     supported.\n"
"\n"
"              NTLM   NTLM authentication is supported.\n"
"\n"
"              GSS-Negotiate\n"
, stdout);
 fputs(
"                     Negotiate authentication and krb5 for ftp is supported.\n"
"\n"
"              Debug  This curl uses a libcurl built with Debug.  This  enables\n"
"                     more  error-tracking  and memory debugging etc. For curl-\n"
"                     developers only!\n"
"\n"
"              AsynchDNS\n"
"                     This curl uses asynchronous name resolves.\n"
"\n"
"              SPNEGO SPNEGO Negotiate authentication is supported.\n"
"\n"
"              Largefile\n"
, stdout);
 fputs(
"                     This curl supports transfers of large files, files larger\n"
"                     than 2GB.\n"
"\n"
"              IDN    This curl supports IDN - international domain names.\n"
"\n"
"              SSPI   SSPI  is  supported. If you use NTLM and set a blank user\n"
"                     name, curl will authenticate with your current  user  and\n"
"                     password.\n"
"\n"
"       -w/--write-out <format>\n"
"              Defines what to display on stdout after a completed and success-\n"
, stdout);
 fputs(
"              ful operation. The format is a string  that  may  contain  plain\n"
"              text mixed with any number of variables. The string can be spec-\n"
"              ified as \"string\", to get read from a particular file you  spec-\n"
"              ify  it  \"@filename\"  and  to  tell curl to read the format from\n"
"              stdin you write \"@-\".\n"
"\n"
"              The variables present in the output format will  be  substituted\n"
, stdout);
 fputs(
"              by  the  value or text that curl thinks fit, as described below.\n"
"              All variables are specified like %{variable_name} and to  output\n"
"              a normal % you just write them like %%. You can output a newline\n"
"              by using \\n, a carriage return with \\r and a tab space with  \\t.\n"
"              NOTE: The %-letter is a special letter in the win32-environment,\n"
"              where all occurrences of %  must  be  doubled  when  using  this\n"
"              option.\n"
"\n"
, stdout);
 fputs(
"              Available variables are at this point:\n"
"\n"
"              url_effective  The  URL  that  was  fetched last. This is mostly\n"
"                             meaningful if you've told curl  to  follow  loca-\n"
"                             tion: headers.\n"
"\n"
"              http_code      The numerical response code that was found in the\n"
"                             last retrieved HTTP(S)  or  FTP(s)  transfer.  In\n"
"                             7.18.2  the alias response_code was added to show\n"
, stdout);
 fputs(
"                             the same info.\n"
"\n"
"              http_connect   The numerical code that was  found  in  the  last\n"
"                             response   (from  a  proxy)  to  a  curl  CONNECT\n"
"                             request. (Added in 7.12.4)\n"
"\n"
"              time_total     The total time, in seconds, that the full  opera-\n"
"                             tion lasted. The time will be displayed with mil-\n"
"                             lisecond resolution.\n"
"\n"
"              time_namelookup\n"
, stdout);
 fputs(
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until the name resolving was completed.\n"
"\n"
"              time_connect   The  time,  in  seconds,  it  took from the start\n"
"                             until the TCP connect  to  the  remote  host  (or\n"
"                             proxy) was completed.\n"
"\n"
"              time_appconnect\n"
"                             The  time,  in  seconds,  it  took from the start\n"
, stdout);
 fputs(
"                             until the SSL/SSH/etc  connect/handshake  to  the\n"
"                             remote host was completed. (Added in 7.19.0)\n"
"\n"
"              time_pretransfer\n"
"                             The  time,  in  seconds,  it  took from the start\n"
"                             until the file transfer is just about  to  begin.\n"
"                             This includes all pre-transfer commands and nego-\n"
, stdout);
 fputs(
"                             tiations that are specific to the particular pro-\n"
"                             tocol(s) involved.\n"
"\n"
"              time_redirect  The time, in seconds, it took for all redirection\n"
"                             steps include name lookup,  connect,  pretransfer\n"
"                             and   transfer   before   final  transaction  was\n"
"                             started. time_redirect shows the complete  execu-\n"
, stdout);
 fputs(
"                             tion  time  for  multiple redirections. (Added in\n"
"                             7.12.3)\n"
"\n"
"              time_starttransfer\n"
"                             The time, in seconds,  it  took  from  the  start\n"
"                             until  the  first byte is just about to be trans-\n"
"                             ferred. This includes time_pretransfer  and  also\n"
"                             the  time  the  server  needs  to  calculate  the\n"
, stdout);
 fputs(
"                             result.\n"
"\n"
"              size_download  The total amount of bytes that were downloaded.\n"
"\n"
"              size_upload    The total amount of bytes that were uploaded.\n"
"\n"
"              size_header    The total amount of bytes of the downloaded head-\n"
"                             ers.\n"
"\n"
"              size_request   The  total  amount of bytes that were sent in the\n"
"                             HTTP request.\n"
"\n"
, stdout);
 fputs(
"              speed_download The average download speed that curl measured for\n"
"                             the complete download.\n"
"\n"
"              speed_upload   The  average  upload speed that curl measured for\n"
"                             the complete upload.\n"
"\n"
"              content_type   The Content-Type of the  requested  document,  if\n"
"                             there was any.\n"
"\n"
"              num_connects   Number  of new connects made in the recent trans-\n"
, stdout);
 fputs(
"                             fer. (Added in 7.12.3)\n"
"\n"
"              num_redirects  Number of redirects that  were  followed  in  the\n"
"                             request. (Added in 7.12.3)\n"
"\n"
"              redirect_url   When a HTTP request was made without -L to follow\n"
"                             redirects, this variable will show the actual URL\n"
"                             a redirect would take you to. (Added in 7.18.2)\n"
"\n"
, stdout);
 fputs(
"              ftp_entry_path The initial path libcurl ended up in when logging\n"
"                             on to the remote FTP server. (Added in 7.15.4)\n"
"\n"
"              ssl_verify_result\n"
"                             The result of the SSL peer certificate  verifica-\n"
"                             tion that was requested. 0 means the verification\n"
"                             was successful. (Added in 7.19.0)\n"
"\n"
"       If this option is used several times, the last one will be used.\n"
"\n"
, stdout);
 fputs(
"       -x/--proxy <proxyhost[:port]>\n"
"              Use specified HTTP proxy. If the port number is  not  specified,\n"
"              it is assumed at port 1080.\n"
"\n"
"              This  option  overrides existing environment variables that sets\n"
"              proxy to use. If  there's  an  environment  variable  setting  a\n"
"              proxy, you can set proxy to \"\" to override it.\n"
"\n"
"              Note  that  all  operations that are performed over a HTTP proxy\n"
, stdout);
 fputs(
"              will transparently be converted to HTTP. It means  that  certain\n"
"              protocol specific operations might not be available. This is not\n"
"              the case if you can tunnel through the proxy, as done  with  the\n"
"              -p/--proxytunnel option.\n"
"\n"
"              Starting  with 7.14.1, the proxy host can be specified the exact\n"
"              same way as the proxy environment  variables,  include  protocol\n"
"              prefix (http://) and embedded user + password.\n"
"\n"
, stdout);
 fputs(
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -X/--request <command>\n"
"              (HTTP) Specifies a custom request method to use when communicat-\n"
"              ing  with  the  HTTP server.  The specified request will be used\n"
"              instead of the method otherwise used (which  defaults  to  GET).\n"
"              Read the HTTP 1.1 specification for details and explanations.\n"
"\n"
, stdout);
 fputs(
"              (FTP) Specifies a custom FTP command to use instead of LIST when\n"
"              doing file lists with ftp.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -y/--speed-time <time>\n"
"              If a download is slower than speed-limit bytes per second during\n"
"              a speed-time period, the download gets aborted. If speed-time is\n"
"              used, the default speed-limit will be 1 unless set with -y.\n"
"\n"
, stdout);
 fputs(
"              This  option  controls  transfers  and thus will not affect slow\n"
"              connects etc. If this is a concern for you, try  the  --connect-\n"
"              timeout option.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -Y/--speed-limit <speed>\n"
"              If a download is slower than this given speed, in bytes per sec-\n"
"              ond,  for  speed-time seconds it gets aborted. speed-time is set\n"
, stdout);
 fputs(
"              with -Y and is 30 if not set.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -z/--time-cond <date expression>\n"
"              (HTTP/FTP)  Request a file that has been modified later than the\n"
"              given time and date, or one that has been modified  before  that\n"
"              time. The date expression can be all sorts of date strings or if\n"
"              it doesn't match any internal ones, it tries  to  get  the  time\n"
, stdout);
 fputs(
"              from  a  given  file  name  instead! See the curl_getdate(3) man\n"
"              pages for date expression details.\n"
"\n"
"              Start the date expression with a dash (-) to make it request for\n"
"              a  document that is older than the given date/time, default is a\n"
"              document that is newer than the specified date/time.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       --max-redirs <num>\n"
, stdout);
 fputs(
"              Set   maximum   number  of  redirection-followings  allowed.  If\n"
"              -L/--location is used, this option can be used to  prevent  curl\n"
"              from following redirections \"in absurdum\". By default, the limit\n"
"              is set to 50 redirections. Set this option to -1 to make it lim-\n"
"              itless.\n"
"\n"
"              If this option is used several times, the last one will be used.\n"
"\n"
"       -0/--http1.0\n"
, stdout);
 fputs(
"              (HTTP) Forces curl to issue its requests using HTTP 1.0  instead\n"
"              of using its internally preferred: HTTP 1.1.\n"
"\n"
"       -1/--tlsv1\n"
"              (SSL)  Forces  curl to use TSL version 1 when negotiating with a\n"
"              remote TLS server.\n"
"\n"
"       -2/--sslv2\n"
"              (SSL) Forces curl to use SSL version 2 when negotiating  with  a\n"
"              remote SSL server.\n"
"\n"
"       -3/--sslv3\n"
"              (SSL)  Forces  curl to use SSL version 3 when negotiating with a\n"
, stdout);
 fputs(
"              remote SSL server.\n"
"\n"
"       -4/--ipv4\n"
"              If libcurl is capable of resolving an  address  to  multiple  IP\n"
"              versions  (which it is if it is ipv6-capable), this option tells\n"
"              libcurl to resolve names to IPv4 addresses only.\n"
"\n"
"       -6/--ipv6\n"
"              If libcurl is capable of resolving an  address  to  multiple  IP\n"
"              versions  (which it is if it is ipv6-capable), this option tells\n"
, stdout);
 fputs(
"              libcurl to resolve names to IPv6 addresses only.\n"
"\n"
"       -#/--progress-bar\n"
"              Make curl display progress information as a progress bar instead\n"
"              of the default statistics.\n"
"\n"
"FILES\n"
"       ~/.curlrc\n"
"              Default config file, see -K/--config for details.\n"
"\n"
"ENVIRONMENT\n"
"       http_proxy [protocol://]<host>[:port]\n"
"              Sets proxy server to use for HTTP.\n"
"\n"
"       HTTPS_PROXY [protocol://]<host>[:port]\n"
, stdout);
 fputs(
"              Sets proxy server to use for HTTPS.\n"
"\n"
"       FTP_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use for FTP.\n"
"\n"
"       ALL_PROXY [protocol://]<host>[:port]\n"
"              Sets proxy server to use if no protocol-specific proxy is set.\n"
"\n"
"       NO_PROXY <comma-separated list of hosts>\n"
"              list  of  host names that shouldn't go through any proxy. If set\n"
"              to a asterisk '*' only, it matches all hosts.\n"
"\n"
"EXIT CODES\n"
, stdout);
 fputs(
"       There exists a bunch of different error codes and  their  corresponding\n"
"       error  messages  that  may appear during bad conditions. At the time of\n"
"       this writing, the exit codes are:\n"
"\n"
"       1      Unsupported protocol. This build of curl has no support for this\n"
"              protocol.\n"
"\n"
"       2      Failed to initialize.\n"
"\n"
"       3      URL malformat. The syntax was not correct.\n"
"\n"
"       5      Couldn't  resolve  proxy.  The  given  proxy  host  could not be\n"
, stdout);
 fputs(
"              resolved.\n"
"\n"
"       6      Couldn't resolve host. The given remote host was not resolved.\n"
"\n"
"       7      Failed to connect to host.\n"
"\n"
"       8      FTP weird server reply.  The  server  sent  data  curl  couldn't\n"
"              parse.\n"
"\n"
"       9      FTP  access  denied. The server denied login or denied access to\n"
"              the particular resource or directory you wanted to  reach.  Most\n"
"              often  you  tried to change to a directory that doesn't exist on\n"
, stdout);
 fputs(
"              the server.\n"
"\n"
"       11     FTP weird PASS reply. Curl couldn't parse the reply sent to  the\n"
"              PASS request.\n"
"\n"
"       13     FTP  weird PASV reply, Curl couldn't parse the reply sent to the\n"
"              PASV request.\n"
"\n"
"       14     FTP weird 227 format.  Curl  couldn't  parse  the  227-line  the\n"
"              server sent.\n"
"\n"
"       15     FTP  can't  get host. Couldn't resolve the host IP we got in the\n"
"              227-line.\n"
"\n"
, stdout);
 fputs(
"       17     FTP couldn't set binary.  Couldn't  change  transfer  method  to\n"
"              binary.\n"
"\n"
"       18     Partial file. Only a part of the file was transferred.\n"
"\n"
"       19     FTP  couldn't download/access the given file, the RETR (or simi-\n"
"              lar) command failed.\n"
"\n"
"       21     FTP quote error. A quote command returned error from the server.\n"
"       22     HTTP  page  not  retrieved.  The  requested url was not found or\n"
, stdout);
 fputs(
"              returned another error with the HTTP error  code  being  400  or\n"
"              above. This return code only appears if -f/--fail is used.\n"
"\n"
"       23     Write  error.  Curl couldn't write data to a local filesystem or\n"
"              similar.\n"
"\n"
"       25     FTP couldn't STOR file. The server denied  the  STOR  operation,\n"
"              used for FTP uploading.\n"
"\n"
"       26     Read error. Various reading problems.\n"
"\n"
"       27     Out of memory. A memory allocation request failed.\n"
"\n"
, stdout);
 fputs(
"       28     Operation  timeout.  The  specified  time-out period was reached\n"
"              according to the conditions.\n"
"\n"
"       30     FTP PORT failed. The PORT command failed. Not  all  FTP  servers\n"
"              support  the  PORT  command,  try  doing  a  transfer using PASV\n"
"              instead!\n"
"\n"
"       31     FTP couldn't use REST. The REST command failed. This command  is\n"
"              used for resumed FTP transfers.\n"
"\n"
"       33     HTTP range error. The range \"command\" didn't work.\n"
"\n"
, stdout);
 fputs(
"       34     HTTP post error. Internal post-request generation error.\n"
"\n"
"       35     SSL connect error. The SSL handshaking failed.\n"
"\n"
"       36     FTP  bad  download  resume. Couldn't continue an earlier aborted\n"
"              download.\n"
"\n"
"       37     FILE couldn't read file. Failed to open the file. Permissions?\n"
"\n"
"       38     LDAP cannot bind. LDAP bind operation failed.\n"
"\n"
"       39     LDAP search failed.\n"
"\n"
"       41     Function not found. A required LDAP function was not found.\n"
"\n"
, stdout);
 fputs(
"       42     Aborted by callback. An application told curl to abort the oper-\n"
"              ation.\n"
"\n"
"       43     Internal error. A function was called with a bad parameter.\n"
"\n"
"       45     Interface  error.  A  specified  outgoing interface could not be\n"
"              used.\n"
"\n"
"       47     Too many redirects. When following redirects, curl hit the maxi-\n"
"              mum amount.\n"
"\n"
"       48     Unknown TELNET option specified.\n"
"\n"
"       49     Malformed telnet option.\n"
"\n"
, stdout);
 fputs(
"       51     The peer's SSL certificate or SSH MD5 fingerprint was not ok\n"
"\n"
"       52     The  server  didn't  reply anything, which here is considered an\n"
"              error.\n"
"\n"
"       53     SSL crypto engine not found\n"
"\n"
"       54     Cannot set SSL crypto engine as default\n"
"\n"
"       55     Failed sending network data\n"
"\n"
"       56     Failure in receiving network data\n"
"\n"
"       58     Problem with the local certificate\n"
"\n"
"       59     Couldn't use specified SSL cipher\n"
"\n"
, stdout);
 fputs(
"       60     Peer certificate cannot be authenticated with known CA  certifi-\n"
"              cates\n"
"\n"
"       61     Unrecognized transfer encoding\n"
"\n"
"       62     Invalid LDAP URL\n"
"\n"
"       63     Maximum file size exceeded\n"
"\n"
"       64     Requested FTP SSL level failed\n"
"\n"
"       65     Sending the data requires a rewind that failed\n"
"\n"
"       66     Failed to initialise SSL Engine\n"
"\n"
"       67     User,  password  or  similar was not accepted and curl failed to\n"
"              login\n"
"\n"
, stdout);
 fputs(
"       68     File not found on TFTP server\n"
"\n"
"       69     Permission problem on TFTP server\n"
"\n"
"       70     Out of disk space on TFTP server\n"
"\n"
"       71     Illegal TFTP operation\n"
"\n"
"       72     Unknown TFTP transfer ID\n"
"\n"
"       73     File already exists (TFTP)\n"
"\n"
"       74     No such user (TFTP)\n"
"\n"
"       75     Character conversion failed\n"
"\n"
"       76     Character conversion functions required\n"
"\n"
"       77     Problem with reading the SSL CA cert (path? access rights?)\n"
"\n"
, stdout);
 fputs(
"       78     The resource referenced in the URL does not exist\n"
"\n"
"       79     An unspecified error occurred during the SSH session\n"
"\n"
"       80     Failed to shut down the SSL connection\n"
"\n"
"       82     Could not load CRL file,  missing  or  wrong  format  (added  in\n"
"              7.19.0)\n"
"\n"
"       83     Issuer check failed (added in 7.19.0)\n"
"\n"
"       XX     There  will appear more error codes here in future releases. The\n"
"              existing ones are meant to never change.\n"
"\n"
"AUTHORS / CONTRIBUTORS\n"
, stdout);
 fputs(
"       Daniel Stenberg is the main author, but the whole list of  contributors\n"
"       is found in the separate THANKS file.\n"
"\n"
"WWW\n"
"       http://curl.haxx.se\n"
"\n"
"FTP\n"
"       ftp://ftp.sunet.se/pub/www/utilities/curl/\n"
"\n"
"SEE ALSO\n"
"       ftp(1), wget(1)\n"
"\n"
"LATEST VERSION\n"
"\n"
"  You always find news about what's going on as well as the latest versions\n"
"  from the curl web pages, located at:\n"
"\n"
"        http://curl.haxx.se\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from Netscape's web-server:\n"
"\n"
, stdout);
 fputs(
"        curl http://www.netscape.com/\n"
"\n"
"  Get the README file the user's home directory at funet's ftp-server:\n"
"\n"
"        curl ftp://ftp.funet.fi/README\n"
"\n"
"  Get a web page from a server using port 8000:\n"
"\n"
"        curl http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of a directory of an FTP site:\n"
"\n"
"        curl ftp://cool.haxx.se/\n"
"\n"
"  Get the definition of curl from a dictionary:\n"
"\n"
"        curl dict://dict.org/m:curl\n"
"\n"
"  Fetch two documents at once:\n"
"\n"
, stdout);
 fputs(
"        curl ftp://cool.haxx.se/ http://www.weirdserver.com:8000/\n"
"\n"
"  Get a file off an FTPS server:\n"
"\n"
"        curl ftps://files.are.secure.com/secrets.txt\n"
"\n"
"  or use the more appropriate FTPS way to get the same file:\n"
"\n"
"        curl --ftp-ssl ftp://files.are.secure.com/secrets.txt\n"
"\n"
"  Get a file from an SSH server using SFTP:\n"
"\n"
"        curl -u username sftp://shell.example.com/etc/issue\n"
"\n"
"  Get a file from an SSH server using SCP using a private key to authenticate:\n"
"\n"
, stdout);
 fputs(
"        curl -u username: --key ~/.ssh/id_dsa --pubkey ~/.ssh/id_dsa.pub \\\n"
"        	scp://shell.example.com/~/personal.txt\n"
"\n"
"  Get the main page from an IPv6 web server:\n"
"\n"
"        curl -g \"http://[2001:1890:1112:1::20]/\"\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
"  Get a web page and store in a local file:\n"
"\n"
"        curl -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
, stdout);
 fputs(
"  will fail):\n"
"\n"
"        curl -O http://www.netscape.com/index.html\n"
"\n"
"  Fetch two files and store them with their remote names:\n"
"\n"
"        curl -O www.haxx.se/index.html -O curl.haxx.se/download.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        curl ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        curl -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" FTPS\n"
"\n"
, stdout);
 fputs(
"   It is just like for FTP, but you may also want to specify and use\n"
"   SSL-specific options for certificates etc.\n"
"\n"
"   Note that using FTPS:// as prefix is the \"implicit\" way as described in the\n"
"   standards while the recommended \"explicit\" way is done by using FTP:// and\n"
"   the --ftp-ssl option.\n"
"\n"
" SFTP / SCP\n"
"\n"
"   This is similar to FTP, but you can specify a private key to use instead of\n"
"   a password. Note that the private key may itself be protected by a password\n"
, stdout);
 fputs(
"   that is unrelated to the login password of the remote system.  If you\n"
"   provide a private key file you must also provide a public key file.\n"
"\n"
" HTTP\n"
"\n"
"   Curl also supports user and password in HTTP URLs, thus you can pick a file\n"
"   like:\n"
"\n"
"        curl http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        curl -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
, stdout);
 fputs(
"   HTTP offers many different methods of authentication and curl supports\n"
"   several: Basic, Digest, NTLM and Negotiate. Without telling which method to\n"
"   use, curl defaults to Basic. You can also ask curl to pick the most secure\n"
"   ones out of the ones that the server accepts for the given URL, by using\n"
"   --anyauth.\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Curl via a proxy. You _must_ use the -u style fetch\n"
, stdout);
 fputs(
"   during such circumstances.\n"
"\n"
" HTTPS\n"
"\n"
"   Probably most commonly used with private certificates, as explained below.\n"
"\n"
"PROXY\n"
"\n"
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        curl -x my-proxy:888 ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from a HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        curl -u user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" Some proxies require special authentication. Specify by using -U as above:\n"
"\n"
, stdout);
 fputs(
"        curl -U user:passwd -x my-proxy:888 http://www.get.this/\n"
"\n"
" curl also supports SOCKS4 and SOCKS5 proxies with --socks4 and --socks5.\n"
"\n"
" See also the environment variables Curl support that offer further proxy\n"
" control.\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
"  to get only one or more subparts of a specified document. Curl supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        curl -r 0-99 http://www.get.this/\n"
"\n"
, stdout);
 fputs(
"  Get the last 500 bytes of a document:\n"
"\n"
"        curl -r -500 http://www.get.this/\n"
"\n"
"  Curl also supports simple ranges for FTP files as well. Then you can only\n"
"  specify start and stop position.\n"
"\n"
"  Get the first 100 bytes of a document using FTP:\n"
"\n"
"        curl -r 0-99 ftp://www.get.this/README  \n"
"\n"
"UPLOADING\n"
"\n"
" FTP / FTPS / SFTP / SCP\n"
"\n"
"  Upload all data on stdin to a specified server:\n"
"\n"
"        curl -T - ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload data from a specified file, login with user and password:\n"
, stdout);
 fputs(
"\n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
"  Upload a local file to the remote site, and use the local file name remote\n"
"  too:\n"
" \n"
"        curl -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
"  Upload a local file to get appended to the remote file:\n"
"\n"
"        curl -T localfile -a ftp://ftp.upload.com/remotefile\n"
"\n"
"  Curl also supports ftp upload through a proxy, but only if the proxy is\n"
"  configured to allow that kind of tunneling. If it does, you can run curl in\n"
, stdout);
 fputs(
"  a fashion similar to:\n"
"\n"
"        curl --proxytunnel -x proxy:port -T localfile ftp.upload.com\n"
"\n"
" HTTP\n"
"\n"
"  Upload all data on stdin to a specified http site:\n"
"\n"
"        curl -T - http://www.upload.com/myfile\n"
"\n"
"  Note that the http server must have been configured to accept PUT before\n"
"  this can be done successfully.\n"
"\n"
"  For other ways to do http data upload, see the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If curl fails where it isn't supposed to, if the servers don't let you in,\n"
, stdout);
 fputs(
"  if you can't understand the responses: use the -v flag to get verbose\n"
"  fetching. Curl will output lots of info and what it sends and receives in\n"
"  order to let the user see all client-server interaction (but it won't show\n"
"  you the actual data).\n"
"\n"
"        curl -v ftp://ftp.upload.com/\n"
"\n"
"  To get even more details and information on what curl does, try using the\n"
"  --trace or --trace-ascii options with a given file name to log to, like\n"
"  this:\n"
"\n"
"        curl --trace trace.txt www.haxx.se\n"
" \n"
"\n"
, stdout);
 fputs(
"DETAILED INFORMATION\n"
"\n"
"  Different protocols provide different ways of getting detailed information\n"
"  about specific files/documents. To get curl to show detailed information\n"
"  about a single file, you should use -I/--head option. It displays all\n"
"  available info on a single file for HTTP and FTP. The HTTP information is a\n"
"  lot more extensive.\n"
"\n"
"  For HTTP, you can get the header information (the same as -I would show)\n"
"  shown before the data by using -i/--include. Curl understands the\n"
, stdout);
 fputs(
"  -D/--dump-header option when getting files from both FTP and HTTP, and it\n"
"  will then store the headers in the specified file.\n"
"\n"
"  Store the HTTP headers in a separate file (headers.txt in the example):\n"
"\n"
"        curl --dump-header headers.txt curl.haxx.se\n"
"\n"
"  Note that headers stored in a separate file can be very useful at a later\n"
"  time if you want curl to use cookies sent by the server. More about that in\n"
"  the cookies section.\n"
"\n"
"POST (HTTP)\n"
"\n"
, stdout);
 fputs(
"  It's easy to post data using curl. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"        curl -d \"name=Rafael%20Sagula&phone=3320780\" \\\n"
"                http://www.where.com/guest.cgi\n"
"\n"
"  How to post a form with curl, lesson #1:\n"
"\n"
"  Dig out all the <input> tags in the form that you want to fill in. (There's\n"
"  a perl program called formfind.pl on the curl site that helps with this).\n"
"\n"
, stdout);
 fputs(
"  If there's a \"normal\" post, you use -d to post. -d takes a full \"post\n"
"  string\", which is in the format\n"
"\n"
"        <variable1>=<data1>&<variable2>=<data2>&...\n"
"\n"
"  The 'variable' names are the names set with \"name=\" in the <input> tags, and\n"
"  the data is the contents you want to fill in for the inputs. The data *must*\n"
"  be properly URL encoded. That means you replace space with + and that you\n"
"  write weird letters with %XX where XX is the hexadecimal representation of\n"
, stdout);
 fputs(
"  the letter's ASCII code.\n"
"\n"
"  Example:\n"
"\n"
"  (page located at http://www.formpost.com/getthis/\n"
"\n"
"        <form action=\"post.cgi\" method=\"post\">\n"
"        <input name=user size=10>\n"
"        <input name=pass type=password size=10>\n"
"        <input name=id type=hidden value=\"blablabla\">\n"
"        <input name=ding value=\"submit\">\n"
"        </form>\n"
"\n"
"  We want to enter user 'foobar' with password '12345'.\n"
"\n"
"  To post to this, you enter a curl command line like:\n"
"\n"
, stdout);
 fputs(
"        curl -d \"user=foobar&pass=12345&id=blablabla&ding=submit\"  (continues)\n"
"          http://www.formpost.com/getthis/post.cgi\n"
"\n"
"\n"
"  While -d uses the application/x-www-form-urlencoded mime-type, generally\n"
"  understood by CGI's and similar, curl also supports the more capable\n"
"  multipart/form-data type. This latter type supports things like file upload.\n"
"\n"
"  -F accepts parameters like -F \"name=contents\". If you want the contents to\n"
, stdout);
 fputs(
"  be read from a file, use <@filename> as contents. When specifying a file,\n"
"  you can also specify the file content type by appending ';type=<mime type>'\n"
"  to the file name. You can also post the contents of several files in one\n"
"  field.  For example, the field name 'coolfiles' is used to send three files,\n"
"  with different content types using the following syntax:\n"
"\n"
"        curl -F \"coolfiles=@fil1.gif;type=image/gif,fil2.txt,fil3.html\" \\\n"
"        http://www.post.com/postit.cgi\n"
"\n"
, stdout);
 fputs(
"  If the content-type is not specified, curl will try to guess from the file\n"
"  extension (it only knows a few), or use the previously specified type (from\n"
"  an earlier file if several files are specified in a list) or else it will\n"
"  using the default type 'text/plain'.\n"
"\n"
"  Emulate a fill-in form with -F. Let's say you fill in three fields in a\n"
"  form. One field is a file name which to post, one field is your name and one\n"
, stdout);
 fputs(
"  field is a file description. We want to post the file we have written named\n"
"  \"cooltext.txt\". To let curl do the posting of this data instead of your\n"
"  favourite browser, you have to read the HTML source of the form page and\n"
"  find the names of the input fields. In our example, the input field names\n"
"  are 'file', 'yourname' and 'filedescription'.\n"
"\n"
"        curl -F \"file=@cooltext.txt\" -F \"yourname=Daniel\" \\\n"
"             -F \"filedescription=Cool text file with cool text inside\" \\\n"
, stdout);
 fputs(
"             http://www.post.com/postit.cgi\n"
"\n"
"  To send two files in one post you can do it in two ways:\n"
"\n"
"  1. Send multiple files in a single \"field\" with a single field name:\n"
" \n"
"        curl -F \"pictures=@dog.gif,cat.gif\" \n"
" \n"
"  2. Send two fields with two field names: \n"
"\n"
"        curl -F \"docpicture=@dog.gif\" -F \"catpicture=@cat.gif\" \n"
"\n"
"  To send a field value literally without interpreting a leading '@'\n"
"  or '<', or an embedded ';type=', use --form-string instead of\n"
, stdout);
 fputs(
"  -F. This is recommended when the value is obtained from a user or\n"
"  some other unpredictable source. Under these circumstances, using\n"
"  -F instead of --form-string would allow a user to trick curl into\n"
"  uploading a file.\n"
"\n"
"REFERRER\n"
"\n"
"  A HTTP request has the option to include information about which address\n"
"  that referred to actual page.  Curl allows you to specify the\n"
"  referrer to be used on the command line. It is especially useful to\n"
, stdout);
 fputs(
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"        curl -e www.coolsite.com http://www.showme.com/\n"
"\n"
"  NOTE: The Referer: [sic] field is defined in the HTTP spec to be a full URL.\n"
"\n"
"USER AGENT\n"
"\n"
"  A HTTP request has the option to include information about the browser\n"
"  that generated the request. Curl allows it to be specified on the command\n"
"  line. It is especially useful to fool or trick stupid servers or CGI\n"
, stdout);
 fputs(
"  scripts that only accept certain browsers.\n"
"\n"
"  Example:\n"
"\n"
"  curl -A 'Mozilla/3.0 (Win95; I)' http://www.nationsbank.com/\n"
"\n"
"  Other common strings:\n"
"    'Mozilla/3.0 (Win95; I)'     Netscape Version 3 for Windows 95\n"
"    'Mozilla/3.04 (Win95; U)'    Netscape Version 3 for Windows 95\n"
"    'Mozilla/2.02 (OS/2; U)'     Netscape Version 2 for OS/2\n"
"    'Mozilla/4.04 [en] (X11; U; AIX 4.2; Nav)'           NS for AIX\n"
"    'Mozilla/4.05 [en] (X11; U; Linux 2.0.32 i586)'      NS for Linux\n"
"\n"
, stdout);
 fputs(
"  Note that Internet Explorer tries hard to be compatible in every way:\n"
"    'Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)'    MSIE for W95\n"
"\n"
"  Mozilla is not the only possible User-Agent name:\n"
"    'Konqueror/1.0'             KDE File Manager desktop client\n"
"    'Lynx/2.7.1 libwww-FM/2.14' Lynx command line browser\n"
"\n"
"COOKIES\n"
"\n"
"  Cookies are generally used by web servers to keep state information at the\n"
"  client's side. The server sets cookies by sending a response line in the\n"
, stdout);
 fputs(
"  headers that looks like 'Set-Cookie: <data>' where the data part then\n"
"  typically contains a set of NAME=VALUE pairs (separated by semicolons ';'\n"
"  like \"NAME1=VALUE1; NAME2=VALUE2;\"). The server can also specify for what\n"
"  path the \"cookie\" should be used for (by specifying \"path=value\"), when the\n"
"  cookie should expire (\"expire=DATE\"), for what domain to use it\n"
"  (\"domain=NAME\") and if it should be used on secure connections only\n"
"  (\"secure\").\n"
"\n"
, stdout);
 fputs(
"  If you've received a page from a server that contains a header like:\n"
"        Set-Cookie: sessionid=boo123; path=\"/foo\";\n"
"\n"
"  it means the server wants that first pair passed on when we get anything in\n"
"  a path beginning with \"/foo\".\n"
"\n"
"  Example, get a page that wants my name passed in a cookie:\n"
"\n"
"        curl -b \"name=Daniel\" www.sillypage.com\n"
"\n"
"  Curl also has the ability to use previously received cookies in following\n"
"  sessions. If you get cookies from a server and store them in a file in a\n"
, stdout);
 fputs(
"  manner similar to:\n"
"\n"
"        curl --dump-header headers www.example.com\n"
"\n"
"  ... you can then in a second connect to that (or another) site, use the\n"
"  cookies from the 'headers' file like:\n"
"\n"
"        curl -b headers www.example.com\n"
"\n"
"  While saving headers to a file is a working way to store cookies, it is\n"
"  however error-prone and not the preferred way to do this. Instead, make curl\n"
"  save the incoming cookies using the well-known netscape cookie format like\n"
"  this:\n"
"\n"
, stdout);
 fputs(
"        curl -c cookies.txt www.example.com\n"
"\n"
"  Note that by specifying -b you enable the \"cookie awareness\" and with -L\n"
"  you can make curl follow a location: (which often is used in combination\n"
"  with cookies). So that if a site sends cookies and a location, you can\n"
"  use a non-existing file to trigger the cookie awareness like:\n"
"\n"
"        curl -L -b empty.txt www.example.com\n"
"\n"
"  The file to read cookies from must be formatted using plain HTTP headers OR\n"
, stdout);
 fputs(
"  as netscape's cookie file. Curl will determine what kind it is based on the\n"
"  file contents.  In the above command, curl will parse the header and store\n"
"  the cookies received from www.example.com.  curl will send to the server the\n"
"  stored cookies which match the request as it follows the location.  The\n"
"  file \"empty.txt\" may be a nonexistent file.\n"
"\n"
"  Alas, to both read and write cookies from a netscape cookie file, you can\n"
"  set both -b and -c to use the same file:\n"
"\n"
, stdout);
 fputs(
"        curl -b cookies.txt -c cookies.txt www.example.com\n"
"\n"
"PROGRESS METER\n"
"\n"
"  The progress meter exists to show a user that something actually is\n"
"  happening. The different fields in the output have the following meaning:\n"
"\n"
"  % Total    % Received % Xferd  Average Speed          Time             Curr.\n"
"                                 Dload  Upload Total    Current  Left    Speed\n"
"  0  151M    0 38608    0     0   9406      0  4:41:43  0:00:04  4:41:39  9287\n"
"\n"
"  From left-to-right:\n"
, stdout);
 fputs(
"   %             - percentage completed of the whole transfer\n"
"   Total         - total size of the whole expected transfer\n"
"   %             - percentage completed of the download\n"
"   Received      - currently downloaded amount of bytes\n"
"   %             - percentage completed of the upload\n"
"   Xferd         - currently uploaded amount of bytes\n"
"   Average Speed\n"
"   Dload         - the average transfer speed of the download\n"
"   Average Speed\n"
"   Upload        - the average transfer speed of the upload\n"
, stdout);
 fputs(
"   Time Total    - expected time to complete the operation\n"
"   Time Current  - time passed since the invoke\n"
"   Time Left     - expected time left to completion\n"
"   Curr.Speed    - the average transfer speed the last 5 seconds (the first\n"
"                   5 seconds of a transfer is based on less time of course.)\n"
"\n"
"  The -# option will display a totally different progress bar that doesn't\n"
"  need much explanation!\n"
"\n"
"SPEED LIMIT\n"
"\n"
, stdout);
 fputs(
"  Curl allows the user to set the transfer speed conditions that must be met\n"
"  to let the transfer keep going. By using the switch -y and -Y you\n"
"  can make curl abort transfers if the transfer speed is below the specified\n"
"  lowest limit for a specified time.\n"
"\n"
"  To have curl abort the download if the speed is slower than 3000 bytes per\n"
"  second for 1 minute, run:\n"
"\n"
"        curl -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  This can very well be used in combination with the overall time limit, so\n"
, stdout);
 fputs(
"  that the above operation must be completed in whole within 30 minutes:\n"
"\n"
"        curl -m 1800 -Y 3000 -y 60 www.far-away-site.com\n"
"\n"
"  Forcing curl not to transfer data faster than a given rate is also possible,\n"
"  which might be useful if you're using a limited bandwidth connection and you\n"
"  don't want your transfer to use all of it (sometimes referred to as\n"
"  \"bandwidth throttle\").\n"
"\n"
"  Make curl transfer data no faster than 10 kilobytes per second:\n"
"\n"
, stdout);
 fputs(
"        curl --limit-rate 10K www.far-away-site.com\n"
"\n"
"    or\n"
"\n"
"        curl --limit-rate 10240 www.far-away-site.com\n"
"\n"
"  Or prevent curl from uploading data faster than 1 megabyte per second:\n"
"\n"
"        curl -T upload --limit-rate 1M ftp://uploadshereplease.com\n"
"\n"
"  When using the --limit-rate option, the transfer rate is regulated on a\n"
"  per-second basis, which will cause the total transfer speed to become lower\n"
"  than the given number. Sometimes of course substantially lower, if your\n"
, stdout);
 fputs(
"  transfer stalls during periods.\n"
"\n"
"CONFIG FILE\n"
"\n"
"  Curl automatically tries to read the .curlrc file (or _curlrc file on win32\n"
"  systems) from the user's home dir on startup.\n"
"\n"
"  The config file could be made up with normal command line switches, but you\n"
"  can also specify the long options without the dashes to make it more\n"
"  readable. You can separate the options and the parameter with spaces, or\n"
"  with = or :. Comments can be used within the file. If the first letter on a\n"
, stdout);
 fputs(
"  line is a '#'-letter the rest of the line is treated as a comment.\n"
"\n"
"  If you want the parameter to contain spaces, you must enclose the entire\n"
"  parameter within double quotes (\"). Within those quotes, you specify a\n"
"  quote as \\\".\n"
"\n"
"  NOTE: You must specify options and their arguments on the same line.\n"
"\n"
"  Example, set default time out and proxy in a config file:\n"
"\n"
"        # We want a 30 minute timeout:\n"
"        -m 1800\n"
"        # ... and we use a proxy for all accesses:\n"
, stdout);
 fputs(
"        proxy = proxy.our.domain.com:8080\n"
"\n"
"  White spaces ARE significant at the end of lines, but all white spaces\n"
"  leading up to the first characters of each line are ignored.\n"
"\n"
"  Prevent curl from reading the default file by using -q as the first command\n"
"  line parameter, like:\n"
"\n"
"        curl -q www.thatsite.com\n"
"\n"
"  Force curl to get and display a local help page in case it is invoked\n"
"  without URL by making a config file similar to:\n"
"\n"
"        # default url to get\n"
, stdout);
 fputs(
"        url = \"http://help.with.curl.com/curlhelp.html\"\n"
"\n"
"  You can specify another config file to be read by using the -K/--config\n"
"  flag. If you set config file name to \"-\" it'll read the config from stdin,\n"
"  which can be handy if you want to hide options from being visible in process\n"
"  tables etc:\n"
"\n"
"        echo \"user = user:passwd\" | curl -K - http://that.secret.site.com\n"
"\n"
"EXTRA HEADERS\n"
"\n"
"  When using curl in your own very special programs, you may end up needing\n"
, stdout);
 fputs(
"  to pass on your own custom headers when getting a web page. You can do\n"
"  this by using the -H flag.\n"
"\n"
"  Example, send the header \"X-you-and-me: yes\" to the server when getting a\n"
"  page:\n"
"\n"
"        curl -H \"X-you-and-me: yes\" www.love.com\n"
"\n"
"  This can also be useful in case you want curl to send a different text in a\n"
"  header than it normally does. The -H header you specify then replaces the\n"
"  header curl would normally send. If you replace an internal header with an\n"
, stdout);
 fputs(
"  empty one, you prevent that header from being sent. To prevent the Host:\n"
"  header from being used:\n"
"\n"
"        curl -H \"Host:\" www.server.com\n"
"\n"
"FTP and PATH NAMES\n"
"\n"
"  Do note that when getting files with the ftp:// URL, the given path is\n"
"  relative the directory you enter. To get the file 'README' from your home\n"
"  directory at your ftp site, do:\n"
"\n"
"        curl ftp://user:passwd@my.site.com/README\n"
"\n"
"  But if you want the README file from the root directory of that very same\n"
, stdout);
 fputs(
"  site, you need to specify the absolute file name:\n"
"\n"
"        curl ftp://user:passwd@my.site.com//README\n"
"\n"
"  (I.e with an extra slash in front of the file name.)\n"
"\n"
"SFTP and SCP and PATH NAMES\n"
"\n"
"  With sftp: and scp: URLs, the path name given is the absolute name on the\n"
"  server. To access a file relative to the remote user's home directory,\n"
"  prefix the file with /~/ , such as:\n"
"\n"
"        curl -u $USER sftp://home.example.com/~/.bashrc\n"
"\n"
"FTP and firewalls\n"
"\n"
, stdout);
 fputs(
"  The FTP protocol requires one of the involved parties to open a second\n"
"  connection as soon as data is about to get transfered. There are two ways to\n"
"  do this.\n"
"\n"
"  The default way for curl is to issue the PASV command which causes the\n"
"  server to open another port and await another connection performed by the\n"
"  client. This is good if the client is behind a firewall that don't allow\n"
"  incoming connections.\n"
"\n"
"        curl ftp.download.com\n"
"\n"
, stdout);
 fputs(
"  If the server for example, is behind a firewall that don't allow connections\n"
"  on other ports than 21 (or if it just doesn't support the PASV command), the\n"
"  other way to do it is to use the PORT command and instruct the server to\n"
"  connect to the client on the given (as parameters to the PORT command) IP\n"
"  number and port.\n"
"\n"
"  The -P flag to curl supports a few different options. Your machine may have\n"
"  several IP-addresses and/or network interfaces and curl allows you to select\n"
, stdout);
 fputs(
"  which of them to use. Default address can also be used:\n"
"\n"
"        curl -P - ftp.download.com\n"
"\n"
"  Download with PORT but use the IP address of our 'le0' interface (this does\n"
"  not work on windows):\n"
"\n"
"        curl -P le0 ftp.download.com\n"
"\n"
"  Download with PORT but use 192.168.0.10 as our IP address to use:\n"
"\n"
"        curl -P 192.168.0.10 ftp.download.com\n"
"\n"
"NETWORK INTERFACE\n"
"\n"
"  Get a web page from a server using a specified port for the interface:\n"
"\n"
, stdout);
 fputs(
"        curl --interface eth0:1 http://www.netscape.com/\n"
"\n"
"  or\n"
"\n"
"        curl --interface 192.168.1.10 http://www.netscape.com/\n"
"\n"
"HTTPS\n"
"\n"
"  Secure HTTP requires SSL libraries to be installed and used when curl is\n"
"  built. If that is done, curl is capable of retrieving and posting documents\n"
"  using the HTTPS protocol.\n"
"\n"
"  Example:\n"
"\n"
"        curl https://www.secure-site.com\n"
"\n"
"  Curl is also capable of using your personal certificates to get/post files\n"
, stdout);
 fputs(
"  from sites that require valid certificates. The only drawback is that the\n"
"  certificate needs to be in PEM-format. PEM is a standard and open format to\n"
"  store certificates with, but it is not used by the most commonly used\n"
"  browsers (Netscape and MSIE both use the so called PKCS#12 format). If you\n"
"  want curl to use the certificates you use with your (favourite) browser, you\n"
"  may need to download/compile a converter that can convert your browser's\n"
, stdout);
 fputs(
"  formatted certificates to PEM formatted ones. This kind of converter is\n"
"  included in recent versions of OpenSSL, and for older versions Dr Stephen\n"
"  N. Henson has written a patch for SSLeay that adds this functionality. You\n"
"  can get his patch (that requires an SSLeay installation) from his site at:\n"
"  http://www.drh-consultancy.demon.co.uk/\n"
"\n"
"  Example on how to automatically retrieve a document using a certificate with\n"
"  a personal password:\n"
"\n"
, stdout);
 fputs(
"        curl -E /path/to/cert.pem:password https://secure.site.com/\n"
"\n"
"  If you neglect to specify the password on the command line, you will be\n"
"  prompted for the correct password before any data can be received.\n"
"\n"
"  Many older SSL-servers have problems with SSLv3 or TLS, that newer versions\n"
"  of OpenSSL etc is using, therefore it is sometimes useful to specify what\n"
"  SSL-version curl should use. Use -3, -2 or -1 to specify that exact SSL\n"
"  version to use (for SSLv3, SSLv2 or TLSv1 respectively):\n"
, stdout);
 fputs(
"\n"
"        curl -2 https://secure.site.com/\n"
"\n"
"  Otherwise, curl will first attempt to use v3 and then v2.\n"
"\n"
"  To use OpenSSL to convert your favourite browser's certificate into a PEM\n"
"  formatted one that curl can use, do something like this (assuming netscape,\n"
"  but IE is likely to work similarly):\n"
"\n"
"    You start with hitting the 'security' menu button in netscape. \n"
"\n"
"    Select 'certificates->yours' and then pick a certificate in the list \n"
"\n"
"    Press the 'export' button \n"
"\n"
, stdout);
 fputs(
"    enter your PIN code for the certs \n"
"\n"
"    select a proper place to save it \n"
"\n"
"    Run the 'openssl' application to convert the certificate. If you cd to the\n"
"    openssl installation, you can do it like:\n"
"\n"
"     # ./apps/openssl pkcs12 -in [file you saved] -clcerts -out [PEMfile]\n"
"\n"
"\n"
"RESUMING FILE TRANSFERS\n"
"\n"
" To continue a file transfer where it was previously aborted, curl supports\n"
" resume on http(s) downloads as well as ftp uploads and downloads.\n"
"\n"
" Continue downloading a document:\n"
"\n"
, stdout);
 fputs(
"        curl -C - -o file ftp://ftp.server.com/path/file\n"
"\n"
" Continue uploading a document(*1):\n"
"\n"
"        curl -C - -T file ftp://ftp.server.com/path/file\n"
"\n"
" Continue downloading a document from a web server(*2):\n"
"\n"
"        curl -C - -o file http://www.server.com/\n"
"\n"
" (*1) = This requires that the ftp server supports the non-standard command\n"
"        SIZE. If it doesn't, curl will say so.\n"
"\n"
" (*2) = This requires that the web server supports at least HTTP/1.1. If it\n"
"        doesn't, curl will say so.\n"
"\n"
, stdout);
 fputs(
"TIME CONDITIONS\n"
"\n"
" HTTP allows a client to specify a time condition for the document it\n"
" requests. It is If-Modified-Since or If-Unmodified-Since. Curl allow you to\n"
" specify them with the -z/--time-cond flag.\n"
"\n"
" For example, you can easily make a download that only gets performed if the\n"
" remote file is newer than a local copy. It would be made like:\n"
"\n"
"        curl -z local.html http://remote.server.com/remote.html\n"
"\n"
" Or you can download a file only if the local file is newer than the remote\n"
, stdout);
 fputs(
" one. Do this by prepending the date string with a '-', as in:\n"
"\n"
"        curl -z -local.html http://remote.server.com/remote.html\n"
"\n"
" You can specify a \"free text\" date as condition. Tell curl to only download\n"
" the file if it was updated since January 12, 2012:\n"
"\n"
"        curl -z \"Jan 12 2012\" http://remote.server.com/remote.html\n"
"\n"
" Curl will then accept a wide range of date formats. You always make the date\n"
" check the other way around by prepending it with a dash '-'.\n"
"\n"
"DICT\n"
"\n"
"  For fun try\n"
"\n"
, stdout);
 fputs(
"        curl dict://dict.org/m:curl\n"
"        curl dict://dict.org/d:heisenbug:jargon\n"
"        curl dict://dict.org/d:daniel:web1913\n"
"\n"
"  Aliases for 'm' are 'match' and 'find', and aliases for 'd' are 'define'\n"
"  and 'lookup'. For example,\n"
"\n"
"        curl dict://dict.org/find:curl\n"
"\n"
"  Commands that break the URL description of the RFC (but not the DICT\n"
"  protocol) are\n"
"\n"
"        curl dict://dict.org/show:db\n"
"        curl dict://dict.org/show:strat\n"
"\n"
, stdout);
 fputs(
"  Authentication is still missing (but this is not required by the RFC)\n"
"\n"
"LDAP\n"
"\n"
"  If you have installed the OpenLDAP library, curl can take advantage of it\n"
"  and offer ldap:// support.\n"
"\n"
"  LDAP is a complex thing and writing an LDAP query is not an easy task. I do\n"
"  advice you to dig up the syntax description for that elsewhere. Two places\n"
"  that might suit you are:\n"
"\n"
"  Netscape's \"Netscape Directory SDK 3.0 for C Programmer's Guide Chapter 10:\n"
"  Working with LDAP URLs\":\n"
, stdout);
 fputs(
"  http://developer.netscape.com/docs/manuals/dirsdk/csdk30/url.htm\n"
"\n"
"  RFC 2255, \"The LDAP URL Format\" http://curl.haxx.se/rfc/rfc2255.txt\n"
"\n"
"  To show you an example, this is now I can get all people from my local LDAP\n"
"  server that has a certain sub-domain in their email address:\n"
"\n"
"        curl -B \"ldap://ldap.frontec.se/o=frontec??sub?mail=*sth.frontec.se\"\n"
"\n"
"  If I want the same info in HTML format, I can get it by not using the -B\n"
"  (enforce ASCII) flag.\n"
"\n"
"ENVIRONMENT VARIABLES\n"
"\n"
, stdout);
 fputs(
"  Curl reads and understands the following environment variables:\n"
"\n"
"        http_proxy, HTTPS_PROXY, FTP_PROXY\n"
"\n"
"  They should be set for protocol-specific proxies. General proxy should be\n"
"  set with\n"
"        \n"
"        ALL_PROXY\n"
"\n"
"  A comma-separated list of host names that shouldn't go through any proxy is\n"
"  set in (only an asterisk, '*' matches all hosts)\n"
"\n"
"        NO_PROXY\n"
"\n"
"  If a tail substring of the domain-path for a host matches one of these\n"
, stdout);
 fputs(
"  strings, transactions with that node will not be proxied.\n"
"\n"
"\n"
"  The usage of the -x/--proxy flag overrides the environment variables.\n"
"\n"
"NETRC\n"
"\n"
"  Unix introduced the .netrc concept a long time ago. It is a way for a user\n"
"  to specify name and password for commonly visited ftp sites in a file so\n"
"  that you don't have to type them in each time you visit those sites. You\n"
"  realize this is a big security risk if someone else gets hold of your\n"
, stdout);
 fputs(
"  passwords, so therefore most unix programs won't read this file unless it is\n"
"  only readable by yourself (curl doesn't care though).\n"
"\n"
"  Curl supports .netrc files if told so (using the -n/--netrc and\n"
"  --netrc-optional options). This is not restricted to only ftp,\n"
"  but curl can use it for all protocols where authentication is used.\n"
"\n"
"  A very simple .netrc file could look something like:\n"
"\n"
"        machine curl.haxx.se login iamdaniel password mysecret\n"
"\n"
"CUSTOM OUTPUT\n"
"\n"
, stdout);
 fputs(
"  To better allow script programmers to get to know about the progress of\n"
"  curl, the -w/--write-out option was introduced. Using this, you can specify\n"
"  what information from the previous transfer you want to extract.\n"
"\n"
"  To display the amount of bytes downloaded together with some text and an\n"
"  ending newline:\n"
"\n"
"        curl -w 'We downloaded %{size_download} bytes\\n' www.download.com\n"
"\n"
"KERBEROS FTP TRANSFER\n"
"\n"
"  Curl supports kerberos4 and kerberos5/GSSAPI for FTP transfers. You need\n"
, stdout);
 fputs(
"  the kerberos package installed and used at curl build time for it to be\n"
"  used.\n"
"\n"
"  First, get the krb-ticket the normal way, like with the kinit/kauth tool.\n"
"  Then use curl in way similar to:\n"
"\n"
"        curl --krb private ftp://krb4site.com -u username:fakepwd\n"
"\n"
"  There's no use for a password on the -u switch, but a blank one will make\n"
"  curl ask for one and you already entered the real password to kinit/kauth.\n"
"\n"
"TELNET\n"
"\n"
, stdout);
 fputs(
"  The curl telnet support is basic and very easy to use. Curl passes all data\n"
"  passed to it on stdin to the remote server. Connect to a remote telnet\n"
"  server using a command line similar to:\n"
"\n"
"        curl telnet://remote.server.com\n"
"\n"
"  And enter the data to pass to the server on stdin. The result will be sent\n"
"  to stdout or to the file you specify with -o.\n"
"\n"
"  You might want the -N/--no-buffer option to switch off the buffered output\n"
"  for slow connections or similar.\n"
"\n"
, stdout);
 fputs(
"  Pass options to the telnet protocol negotiation, by using the -t option. To\n"
"  tell the server we use a vt100 terminal, try something like:\n"
"\n"
"        curl -tTTYPE=vt100 telnet://remote.server.com\n"
"\n"
"  Other interesting options for it -t include:\n"
"\n"
"   - XDISPLOC=<X display> Sets the X display location.\n"
"\n"
"   - NEW_ENV=<var,val> Sets an environment variable.\n"
"\n"
"  NOTE: the telnet protocol does not specify any way to login with a specified\n"
, stdout);
 fputs(
"  user and password so curl can't do that automatically. To do that, you need\n"
"  to track when the login prompt is received and send the username and\n"
"  password accordingly.\n"
"\n"
"PERSISTENT CONNECTIONS\n"
"\n"
"  Specifying multiple files on a single command line will make curl transfer\n"
"  all of them, one after the other in the specified order.\n"
"\n"
"  libcurl will attempt to use persistent connections for the transfers so that\n"
"  the second transfer to the same host can use the same connection that was\n"
, stdout);
 fputs(
"  already initiated and was left open in the previous transfer. This greatly\n"
"  decreases connection time for all but the first transfer and it makes a far\n"
"  better use of the network.\n"
"\n"
"  Note that curl cannot use persistent connections for transfers that are used\n"
"  in subsequence curl invokes. Try to stuff as many URLs as possible on the\n"
"  same command line if they are using the same host, as that'll make the\n"
"  transfers faster. If you use a http proxy for file transfers, practically\n"
, stdout);
 fputs(
"  all transfers will be persistent.\n"
"\n"
"MULTIPLE TRANSFERS WITH A SINGLE COMMAND LINE\n"
"\n"
"  As is mentioned above, you can download multiple files with one command line\n"
"  by simply adding more URLs. If you want those to get saved to a local file\n"
"  instead of just printed to stdout, you need to add one save option for each\n"
"  URL you specify. Note that this also goes for the -O option (but not\n"
"  --remote-name-all).\n"
"\n"
"  For example: get two files and use -O for the first and a custom file\n"
, stdout);
 fputs(
"  name for the second:\n"
"\n"
"    curl -O http://url.com/file.txt ftp://ftp.com/moo.exe -o moo.jpg\n"
"\n"
"  You can also upload multiple files in a similar fashion:\n"
"\n"
"    curl -T local1 ftp://ftp.com/moo.exe -T local2 ftp://ftp.com/moo2.txt\n"
"\n"
"IPv6\n"
"\n"
"  curl will connect to a server with IPv6 when a host lookup returns an IPv6\n"
"  address and fall back to IPv4 if the connection fails. The --ipv4 and --ipv6\n"
"  options can specify which address to use when both are available. IPv6\n"
, stdout);
 fputs(
"  addresses can also be specified directly in URLs using the syntax:\n"
"\n"
"    http://[2001:1890:1112:1::20]/overview.html\n"
"\n"
"  When this style is used, the -g option must be given to stop curl from\n"
"  interpreting the square brackets as special globbing characters.  Link local\n"
"  and site local addresses including a scope identifier, such as fe80::1234%1,\n"
"  may also be used, but the scope portion must be numeric and the percent\n"
"  character must be URL escaped. The previous example in an SFTP URL might\n"
, stdout);
 fputs(
"  look like:\n"
"\n"
"    sftp://[fe80::1234%251]/\n"
"\n"
"  IPv6 addresses provided other than in URLs (e.g. to the --proxy, --interface\n"
"  or --ftp-port options) should not be URL encoded.\n"
"\n"
"\n"
"MAILING LISTS\n"
"\n"
"  For your convenience, we have several open mailing lists to discuss curl,\n"
"  its development and things relevant to this. Get all info at\n"
"  http://curl.haxx.se/mail/. Some of the lists available are:\n"
"\n"
"  curl-users\n"
"\n"
"    Users of the command line tool. How to use it, what doesn't work, new\n"
, stdout);
 fputs(
"    features, related tools, questions, news, installations, compilations,\n"
"    running, porting etc.\n"
"\n"
"  curl-library\n"
"\n"
"    Developers using or developing libcurl. Bugs, extensions, improvements.\n"
"\n"
"  curl-announce\n"
"\n"
"    Low-traffic. Only receives announcements of new public versions. At worst,\n"
"    that makes something like one or two mails per month, but usually only one\n"
"    mail every second month.\n"
"\n"
"  curl-and-php\n"
"\n"
"    Using the curl functions in PHP. Everything curl with a PHP angle. Or PHP\n"
, stdout);
 fputs(
"    with a curl angle.\n"
"\n"
"  curl-and-python\n"
"\n"
"    Python hackers using curl with or without the python binding pycurl.\n"
"\n"
"  Please direct curl questions, feature requests and trouble reports to one of\n"
"  these mailing lists instead of mailing any individual.\n"
, stdout) ;
}
#endif /* USE_MANUAL */
#else
/*
 * NEVER EVER edit this manually, fix the mkhelp.pl script instead!
 * Generation time: Fri Aug 22 10:00:29 2008
 */
#include "setup.h"
#ifdef USE_MANUAL
#include "hugehelp.h"
#include <stdio.h>
#include <stdlib.h>
#include <zlib.h>
static const unsigned char hugehelpgz[] = {
  /* This mumbo-jumbo is the huge help text compressed with gzip.
     Thanks to this operation, the size of this data shrunk from 123812
     to 38358 bytes. You can disable the use of compressed help
     texts by NOT passing -c to the mkhelp.pl tool. */
  0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0xed, 0xbd,
  0x69, 0x5b, 0x23, 0x57, 0xb2, 0x2e, 0xfa, 0xf9, 0xf2, 0x2b, 0xb2, 0xe5,
  0xeb, 0x16, 0x74, 0x4b, 0x62, 0xa8, 0x2a, 0xdb, 0x45, 0x57, 0xb9, 0x8d,
  0x81, 0xb2, 0x39, 0xa6, 0x80, 0x83, 0x28, 0x0f, 0xc7, 0xf6, 0x53, 0x4f,
  0x4a, 0x4a, 0x20, 0x1b, 0x49, 0xa9, 0xce, 0x4c, 0x31, 0xb8, 0x77, 0xef,
  0xdf, 0x7e, 0x23, 0xde, 0x88, 0x58, 0x6b, 0xe5, 0x20, 0x28, 0x77, 0xdb,
  0x67, 0x9f, 0xe1, 0x7a, 0xef, 0x2e, 0x40, 0xca, 0x5c, 0x63, 0xac, 0x58,
  0x31, 0xbe, 0x11, 0x45, 0x4f, 0xfd, 0xf7, 0x1e, 0xff, 0x7b, 0x4f, 0xff,
  0xc9, 0xef, 0x51, 0xb4, 0x16, 0x45, 0x67, 0x79, 0xf6, 0xb7, 0x64, 0x5c,
  0xb6, 0xbf, 0xf0, 0xfe, 0xfd, 0x7f, 0x44, 0xf2, 0x7f, 0xf4, 0xc2, 0x4f,
  0xf8, 0x89, 0x97, 0x1e, 0xf9, 0x6f, 0x33, 0xf2, 0x2f, 0xfd, 0xc7, 0xfb,
  0x8d, 0xe8, 0x43, 0x5e, 0xfa, 0x8f, 0x68, 0x1d, 0x2f, 0xbd, 0xd7, 0x9e,
  0x5e, 0xf1, 0xef, 0x34, 0xca, 0xc7, 0x7b, 0xfa, 0x89, 0x87, 0xc7, 0xff,
  0x6c, 0xf2, 0x8b, 0x3f, 0xbd, 0xe7, 0x5f, 0xe9, 0x93, 0xb5, 0xb5, 0x93,
  0xbd, 0xb7, 0x87, 0xf6, 0xea, 0x78, 0x99, 0x4f, 0xa3, 0x7e, 0x54, 0xe6,
  0xf1, 0xbc, 0xb8, 0x4c, 0xf2, 0x28, 0x8e, 0xde, 0x9d, 0x1f, 0xaf, 0xad,
  0x0d, 0x7f, 0x38, 0x39, 0x3d, 0x1b, 0x1e, 0x0d, 0x2b, 0x8f, 0xfd, 0x98,
  0x2d, 0xca, 0x34, 0x9b, 0x17, 0x3f, 0x47, 0x3f, 0xd2, 0x43, 0x83, 0xc1,
  0xe0, 0xe7, 0xb5, 0xb5, 0x83, 0xc3, 0xe1, 0xfe, 0xf9, 0xd1, 0xd9, 0xc5,
  0xd1, 0xe9, 0x49, 0xe5, 0xd9, 0x28, 0x2d, 0x22, 0x6a, 0xac, 0xcc, 0xb2,
  0x29, 0xfd, 0xe3, 0xdb, 0x9f, 0xc4, 0x65, 0x1c, 0x5d, 0xe6, 0xd9, 0x2c,
  0xca, 0x72, 0xfe, 0x22, 0x8e, 0x8a, 0x24, 0xbf, 0x4d, 0xf2, 0x5e, 0xb4,
  0x2c, 0xd2, 0xf9, 0x55, 0x94, 0xcd, 0x93, 0x28, 0xbb, 0x8c, 0xca, 0xeb,
  0xc4, 0x9a, 0x2b, 0x96, 0x8b, 0x45, 0x96, 0x97, 0xc9, 0x24, 0x5a, 0xe4,
  0x59, 0x99, 0x8d, 0xb3, 0x69, 0x11, 0xad, 0x7f, 0x7d, 0x71, 0x71, 0xd6,
  0x8b, 0xf8, 0xdf, 0x61, 0x2f, 0x7a, 0xc3, 0xbf, 0xbf, 0xc1, 0xaf, 0xd1,
  0x70, 0xff, 0x8c, 0xff, 0xc5, 0x47, 0xd1, 0x85, 0xfc, 0x38, 0x38, 0xda,
  0xbf, 0xe8, 0x59, 0x73, 0x17, 0x87, 0xc7, 0x27, 0x87, 0x17, 0xf4, 0xe9,
  0xf1, 0xc1, 0xde, 0x59, 0xc4, 0xa3, 0x88, 0xde, 0x1c, 0x1d, 0x1f, 0x6e,
  0x0c, 0xe8, 0xab, 0xeb, 0x24, 0x1a, 0x67, 0xb3, 0x59, 0x3c, 0x9f, 0xf0,
  0xf0, 0x27, 0x49, 0x91, 0x5e, 0xcd, 0xa9, 0x5f, 0x1a, 0xe6, 0x5d, 0x96,
  0xdf, 0x44, 0x77, 0x69, 0x79, 0x9d, 0x2d, 0x4b, 0x1a, 0x69, 0x92, 0x5b,
  0x73, 0xe9, 0xbc, 0x4c, 0xf2, 0x78, 0xcc, 0xeb, 0x32, 0x58, 0xab, 0xac,
  0x40, 0x76, 0x49, 0xf3, 0x2d, 0x68, 0x82, 0xa3, 0x65, 0x31, 0xcd, 0xe2,
  0x09, 0x4f, 0x8b, 0xde, 0xbc, 0x5c, 0xd2, 0x82, 0xe4, 0xe9, 0xf8, 0xa6,
  0x88, 0xa6, 0xe9, 0x4d, 0xc2, 0x93, 0xba, 0x7f, 0xb0, 0x49, 0xf6, 0xd0,
  0x76, 0x14, 0x2f, 0x69, 0xfe, 0xf3, 0xbe, 0x35, 0x57, 0xa6, 0xe3, 0x98,
  0x3b, 0xa0, 0x41, 0x5f, 0x96, 0x8b, 0x68, 0xb9, 0xe0, 0xe6, 0x64, 0xf6,
  0xd1, 0x22, 0x2b, 0xe8, 0xad, 0xe1, 0xf0, 0x98, 0x46, 0x3e, 0x9f, 0x27,
  0x18, 0x48, 0xd1, 0xa3, 0x3f, 0xb2, 0x9b, 0x34, 0xa1, 0x5f, 0x2e, 0xd3,
  0x69, 0x22, 0xab, 0xef, 0x9a, 0xe3, 0x6d, 0xc8, 0x93, 0x62, 0x39, 0x4b,
  0x22, 0x9e, 0xe9, 0x2c, 0xcb, 0x93, 0x41, 0xb4, 0x57, 0x44, 0x0f, 0xd9,
  0x92, 0xa6, 0x38, 0x9d, 0xd2, 0x8e, 0x24, 0xd1, 0x28, 0x99, 0x66, 0x77,
  0x3d, 0xde, 0x87, 0x68, 0xbe, 0x9c, 0x8d, 0xe8, 0x15, 0x1a, 0xfe, 0x65,
  0x12, 0x97, 0x4b, 0x7a, 0x15, 0x8f, 0x59, 0x73, 0xb3, 0x98, 0x66, 0x41,
  0xef, 0xe6, 0xd1, 0x75, 0x42, 0xb3, 0x2c, 0x16, 0xe9, 0xfc, 0x0f, 0x6b,
  0x4d, 0x5a, 0x58, 0x64, 0x77, 0x49, 0x4e, 0x8b, 0x19, 0x8d, 0x1e, 0x22,
  0x9a, 0xf9, 0x48, 0xbe, 0xb9, 0xe4, 0xf5, 0x8f, 0xa7, 0x53, 0x47, 0x20,
  0xfd, 0x3c, 0x99, 0xc6, 0xbc, 0xd9, 0xd6, 0xd7, 0x20, 0x1a, 0x26, 0x8e,
  0x16, 0xf4, 0xbd, 0xf5, 0x67, 0x1b, 0x78, 0x73, 0x92, 0x94, 0x71, 0x3a,
  0x2d, 0x68, 0xe1, 0x99, 0x68, 0x6d, 0x83, 0x69, 0xc8, 0xf4, 0x67, 0x54,
  0x3c, 0xcc, 0xcb, 0xf8, 0x9e, 0xfb, 0x36, 0xba, 0xa1, 0xe7, 0x17, 0xc9,
  0x7c, 0x92, 0xcc, 0xcb, 0x41, 0xf4, 0x43, 0xb6, 0xec, 0x52, 0xb7, 0x97,
  0x29, 0xad, 0x40, 0x1c, 0x69, 0x4b, 0x3c, 0x3c, 0xda, 0xf5, 0x71, 0x9e,
  0x2e, 0x82, 0xc5, 0xcf, 0xe6, 0xb4, 0xcb, 0xd1, 0xf9, 0x9b, 0xfd, 0xe8,
  0xd9, 0xcb, 0xcf, 0x3e, 0xf1, 0xbb, 0x4c, 0x4d, 0xd0, 0x04, 0xe3, 0x39,
  0x91, 0xe8, 0x22, 0x19, 0xa7, 0x97, 0x34, 0xaf, 0xd9, 0x72, 0x5a, 0xa6,
  0x0b, 0x5a, 0x71, 0x1e, 0x41, 0xc1, 0xc4, 0xb5, 0x88, 0xf3, 0xb2, 0xe0,
  0xb5, 0xc3, 0x07, 0x34, 0xf7, 0xbb, 0x3c, 0x2d, 0x99, 0xd0, 0xf9, 0x0b,
  0x5a, 0xe9, 0xb2, 0xb0, 0xe6, 0x98, 0xba, 0xa8, 0x9f, 0x11, 0x51, 0x13,
  0xad, 0x70, 0x5c, 0x50, 0xa7, 0xbb, 0xae, 0xaf, 0xe8, 0xba, 0x2c, 0x17,
  0xbb, 0x9b, 0x9b, 0x45, 0x5a, 0x26, 0x83, 0x7f, 0xd0, 0x21, 0xe9, 0x95,
  0x77, 0x59, 0xaf, 0xbc, 0xce, 0x93, 0xe4, 0x9f, 0x03, 0xa2, 0x59, 0xf7,
  0x20, 0x75, 0xc9, 0xfb, 0xc8, 0xc3, 0xba, 0x4a, 0xb8, 0x83, 0xbf, 0x2f,
  0x93, 0x39, 0x37, 0x48, 0x43, 0x88, 0xa7, 0x8b, 0xeb, 0x98, 0x76, 0x33,
  0x21, 0xf2, 0xe3, 0x63, 0x47, 0x04, 0xc2, 0x23, 0x92, 0x83, 0xf7, 0xe3,
  0xcf, 0x8d, 0x3e, 0x2f, 0xd1, 0x25, 0xfd, 0x3b, 0xd0, 0x97, 0x62, 0x5a,
  0x6b, 0xea, 0x6c, 0x93, 0x89, 0xea, 0xc7, 0xed, 0xfe, 0xf6, 0xd6, 0xd6,
  0xcf, 0x83, 0xf2, 0xbe, 0xfc, 0xc0, 0x17, 0xb6, 0xb6, 0xfc, 0x2b, 0xfc,
  0xf4, 0x3a, 0xcf, 0x38, 0x9a, 0x12, 0xd1, 0x70, 0xff, 0xbf, 0x24, 0x79,
  0x56, 0x6c, 0xb4, 0x34, 0x35, 0x4d, 0x4a, 0x3a, 0x62, 0x41, 0x3b, 0x71,
  0xff, 0x17, 0xe9, 0xd6, 0x1e, 0x3e, 0xc9, 0xa2, 0x79, 0x52, 0x60, 0x55,
  0x85, 0x75, 0x04, 0xd3, 0xa6, 0xed, 0xf7, 0x0c, 0x24, 0x2e, 0xf1, 0xed,
  0x2c, 0x9b, 0x11, 0x0d, 0xf4, 0xe8, 0x60, 0x96, 0x6e, 0xb1, 0xe8, 0xdc,
  0x39, 0x86, 0x93, 0x10, 0x3f, 0x8a, 0xa7, 0xcc, 0x8a, 0x0a, 0x6a, 0x98,
  0x06, 0x4b, 0x0c, 0x20, 0x89, 0xc7, 0xd7, 0x51, 0x46, 0x6f, 0xe7, 0xcd,
  0x4d, 0x89, 0xe7, 0x0f, 0x83, 0x2c, 0xbf, 0xda, 0x8c, 0xf3, 0xf1, 0x75,
  0x7a, 0x4b, 0x2b, 0xf3, 0xf2, 0xe5, 0x27, 0x7d, 0xfa, 0xe7, 0xe5, 0xcf,
  0x9b, 0xb7, 0xd9, 0x94, 0x16, 0xea, 0xf9, 0xcf, 0x9b, 0xbc, 0xdd, 0xff,
  0x88, 0x7b, 0xa3, 0xde, 0xf8, 0x9f, 0x83, 0xeb, 0x72, 0x36, 0x7d, 0x8c,
  0x8a, 0xa8, 0xbd, 0x28, 0x9e, 0x65, 0xcb, 0x79, 0xe9, 0x08, 0x87, 0x68,
  0xb0, 0x0c, 0xb8, 0xd3, 0x34, 0x9d, 0xd3, 0x99, 0x25, 0x4a, 0x7f, 0x90,
  0x13, 0x3b, 0x4a, 0xfc, 0xe1, 0x2e, 0xc7, 0xd7, 0x34, 0x55, 0xa2, 0xa4,
  0x58, 0x97, 0xa1, 0x4c, 0x69, 0x32, 0xf4, 0xda, 0x9c, 0x0e, 0x71, 0x2a,
  0xed, 0x48, 0x57, 0x29, 0x3d, 0x97, 0xe5, 0x93, 0x24, 0xf7, 0x34, 0x3d,
  0x4c, 0x69, 0xd5, 0xe4, 0xd4, 0x7e, 0x3a, 0xd8, 0x7e, 0x31, 0xd8, 0x76,
  0x0b, 0x44, 0x5b, 0x99, 0xb9, 0x21, 0x16, 0x65, 0xb2, 0xa0, 0xc1, 0x2c,
  0x99, 0xf9, 0xe1, 0x24, 0x72, 0xa3, 0x74, 0x82, 0xaf, 0x98, 0xe5, 0x44,
  0x45, 0xe6, 0x0e, 0xcf, 0x75, 0x5c, 0x56, 0xe8, 0x91, 0x97, 0xf6, 0x21,
  0x3a, 0xa1, 0x7d, 0x37, 0xae, 0x92, 0x47, 0xb2, 0xc1, 0xbb, 0xf5, 0x55,
  0xbd, 0xbb, 0xbb, 0x5b, 0x4d, 0x77, 0xbb, 0xdb, 0x35, 0xd2, 0x0b, 0x5e,
  0x6a, 0x23, 0x98, 0xdd, 0x9d, 0x2a, 0xc9, 0x1c, 0x5d, 0x46, 0x18, 0x97,
  0x5f, 0x74, 0x66, 0x19, 0x8e, 0xc3, 0x1b, 0xc7, 0xa0, 0x16, 0xe9, 0xf7,
  0xe4, 0x32, 0xbd, 0xef, 0xc9, 0xa2, 0x60, 0xb5, 0x63, 0x6a, 0x7f, 0xb6,
  0x60, 0xb2, 0xb0, 0xe6, 0xae, 0x96, 0x49, 0x41, 0x5c, 0x91, 0x67, 0xeb,
  0x98, 0x0d, 0x37, 0x3f, 0x4b, 0xaf, 0xae, 0xcb, 0xe8, 0x2e, 0x66, 0x8e,
  0x73, 0x54, 0xca, 0xdb, 0xcc, 0xda, 0x89, 0xcb, 0x5c, 0xc6, 0xc4, 0x2b,
  0x22, 0x26, 0x2d, 0x61, 0xe4, 0x4c, 0x8d, 0x6e, 0xd9, 0x68, 0x8d, 0x84,
  0xd8, 0xa2, 0xe0, 0xd2, 0x1b, 0xc5, 0x05, 0x6f, 0xd8, 0x9c, 0x88, 0xa2,
  0xa4, 0xdb, 0x61, 0xc9, 0x7f, 0x5d, 0x13, 0xfb, 0x8f, 0xe6, 0xf1, 0x2c,
  0xd1, 0x61, 0x32, 0xbf, 0x7c, 0x43, 0x6b, 0x9a, 0xdc, 0xc7, 0x33, 0xc7,
  0xc2, 0x88, 0x21, 0xf5, 0xb0, 0x4b, 0xee, 0x69, 0x3a, 0x14, 0x25, 0x11,
  0x24, 0x9f, 0x18, 0x1c, 0xc2, 0x0e, 0x1f, 0xb4, 0x4e, 0x38, 0xc5, 0x02,
  0xf7, 0x03, 0x96, 0x88, 0x87, 0x1f, 0x05, 0x93, 0xa5, 0x25, 0x8b, 0x6f,
  0xf8, 0xbe, 0xf5, 0x64, 0xb3, 0xdf, 0xb2, 0x36, 0x74, 0xc7, 0xf0, 0x18,
  0xc3, 0x7b, 0x09, 0x83, 0x70, 0x3c, 0xd2, 0x5f, 0x4d, 0x7c, 0x51, 0xf6,
  0xea, 0x64, 0x43, 0xe4, 0x82, 0x01, 0xce, 0xf8, 0x38, 0xf0, 0xb3, 0x85,
  0xc8, 0x0d, 0xa0, 0x5f, 0x9e, 0xb1, 0x08, 0x0e, 0xd2, 0xed, 0x3c, 0x2b,
  0xa3, 0x49, 0x16, 0xf0, 0x5f, 0xea, 0xd5, 0xcd, 0x9f, 0xbb, 0x2f, 0x48,
  0xf0, 0x22, 0xe6, 0x37, 0x29, 0xae, 0xe9, 0xba, 0x2a, 0xf8, 0xec, 0x10,
  0x67, 0x48, 0x67, 0xb4, 0xba, 0xb7, 0xbc, 0x1a, 0x8b, 0x24, 0x99, 0x0c,
  0xa2, 0xd3, 0x4b, 0x26, 0xea, 0x9c, 0x06, 0x5d, 0xe2, 0x6b, 0x3e, 0x77,
  0xd3, 0x07, 0x6a, 0x98, 0x85, 0x92, 0xb9, 0x3b, 0x62, 0x18, 0x4b, 0x70,
  0x84, 0x70, 0xd4, 0x68, 0xa8, 0xd3, 0xea, 0x01, 0xc5, 0xed, 0xca, 0x94,
  0xcf, 0x83, 0xa3, 0x23, 0x1a, 0x45, 0xd8, 0x32, 0xfa, 0xad, 0xbc, 0x4b,
  0x92, 0xb9, 0x67, 0x37, 0xc4, 0x1b, 0xe8, 0xca, 0x93, 0xd5, 0x4f, 0xe7,
  0xb7, 0x19, 0x0f, 0x70, 0x6d, 0xed, 0xec, 0xfc, 0xf4, 0xab, 0xf3, 0xc3,
  0xe1, 0x30, 0x7a, 0x7b, 0x78, 0x71, 0x78, 0x5e, 0xbd, 0x50, 0xe7, 0x59,
  0x3e, 0xa3, 0x5b, 0x93, 0xa8, 0x64, 0x92, 0x16, 0x8b, 0x69, 0xfc, 0xc0,
  0x72, 0x06, 0xcd, 0xe5, 0x2a, 0x67, 0x3a, 0x9c, 0x25, 0x7c, 0x2c, 0x27,
  0xcb, 0x1c, 0x1c, 0x71, 0x41, 0xcc, 0x4c, 0xa5, 0x02, 0xba, 0xec, 0x20,
  0x4a, 0xcc, 0xaf, 0xac, 0x39, 0xcf, 0x66, 0x6c, 0x23, 0xf8, 0x8e, 0x66,
  0x21, 0xad, 0xe7, 0x65, 0x36, 0xac, 0x0e, 0x8b, 0x73, 0x3c, 0x1f, 0x66,
  0xb4, 0x33, 0xdc, 0xd0, 0x74, 0x35, 0xd2, 0x2e, 0xd0, 0xf1, 0xbd, 0x74,
  0x84, 0x4b, 0xcc, 0xc7, 0x13, 0xc5, 0xd7, 0x74, 0xe3, 0x43, 0xb2, 0xe3,
  0xc5, 0x19, 0x27, 0x36, 0x76, 0x37, 0x62, 0x88, 0x82, 0x2c, 0x1b, 0xd2,
  0x86, 0xd2, 0x80, 0x67, 0xe9, 0x9c, 0xf8, 0x14, 0xdd, 0x47, 0x7a, 0x36,
  0x68, 0xb8, 0x97, 0x4c, 0x80, 0x5e, 0xd2, 0xe2, 0x95, 0x91, 0x46, 0xe8,
  0x2d, 0xda, 0x6d, 0xe2, 0x29, 0x6e, 0x76, 0x18, 0x5c, 0x5a, 0xf2, 0x9e,
  0xc5, 0x23, 0x3e, 0xc2, 0x7c, 0xb0, 0xf8, 0xae, 0xa5, 0x7e, 0xd1, 0x11,
  0x3e, 0x08, 0xc4, 0x4a, 0xeb, 0x91, 0x86, 0x47, 0xaf, 0xd1, 0xa0, 0xe2,
  0x11, 0x6f, 0x2b, 0x0f, 0xa6, 0xb6, 0x90, 0x74, 0x2d, 0xe2, 0x2c, 0xde,
  0xa5, 0x44, 0x18, 0xf4, 0xec, 0x5d, 0xb6, 0x9c, 0x92, 0xd8, 0xc4, 0x0f,
  0x2c, 0x17, 0x9e, 0x64, 0x89, 0x44, 0x96, 0xe5, 0x82, 0x7a, 0x9e, 0xa5,
  0xf7, 0xb8, 0xe0, 0x6b, 0xad, 0xd0, 0xf8, 0xe8, 0xcf, 0x05, 0x6d, 0x44,
  0x82, 0x11, 0x0d, 0x42, 0x66, 0x04, 0xd9, 0x8b, 0xcf, 0x59, 0x63, 0x1b,
  0xf9, 0xc8, 0x80, 0x41, 0x9c, 0x9d, 0x0e, 0x2f, 0x98, 0x5d, 0x9e, 0xbd,
  0xbb, 0xa0, 0x86, 0x88, 0xb1, 0x17, 0x25, 0x6d, 0x29, 0xbf, 0x38, 0x4f,
  0x20, 0xa4, 0x5a, 0x73, 0xb4, 0x83, 0x69, 0x0e, 0x95, 0x85, 0x07, 0xe5,
  0x3b, 0xb5, 0xf1, 0x41, 0xea, 0x66, 0x22, 0x36, 0x99, 0xbb, 0xb8, 0x4e,
  0xe8, 0x08, 0xb9, 0xd7, 0xd6, 0x3f, 0xdf, 0xe8, 0x45, 0x7d, 0xd7, 0xdc,
  0x8f, 0xfc, 0xe8, 0xcf, 0xdc, 0x73, 0x91, 0xce, 0xd2, 0x69, 0x1c, 0xdc,
  0x16, 0x47, 0x58, 0x6f, 0x26, 0x6f, 0x77, 0x28, 0xc7, 0xc4, 0xa4, 0x30,
  0x66, 0xe2, 0x0f, 0x2a, 0xa9, 0xf2, 0x02, 0xe2, 0x44, 0xfb, 0xcd, 0x62,
  0x81, 0x10, 0xa7, 0x82, 0xa4, 0xc5, 0x32, 0x10, 0xb5, 0x98, 0x5e, 0x69,
  0x84, 0x7c, 0xe2, 0x2b, 0x6b, 0x55, 0x27, 0x93, 0xc6, 0xda, 0x31, 0xf7,
  0x83, 0xf6, 0xe2, 0x56, 0xaf, 0x33, 0x8a, 0xf3, 0x0e, 0x11, 0x0d, 0x5d,
  0x55, 0x22, 0x7b, 0xe3, 0x8a, 0x4a, 0xae, 0x96, 0x34, 0x03, 0x59, 0x5a,
  0x9a, 0xe4, 0x47, 0x3c, 0x12, 0x96, 0x5d, 0xdd, 0xd9, 0x26, 0xa1, 0x68,
  0x3e, 0x19, 0xac, 0x9d, 0x42, 0xa3, 0x71, 0xea, 0xcf, 0x11, 0xdf, 0x5e,
  0x73, 0x96, 0x0a, 0x7a, 0x90, 0x56, 0x47, 0xa4, 0xd6, 0x24, 0x20, 0x3f,
  0xe1, 0x6b, 0x71, 0x9e, 0x44, 0xc9, 0x9c, 0x29, 0x68, 0x22, 0x0c, 0xb5,
  0xdf, 0x97, 0xaf, 0xb0, 0xed, 0x0f, 0x74, 0xf1, 0xc5, 0x57, 0x71, 0xea,
  0x8e, 0xbc, 0x52, 0xdb, 0x24, 0xb2, 0x87, 0xe7, 0x99, 0x3e, 0xcf, 0x8c,
  0x29, 0xe6, 0x55, 0x95, 0x9d, 0x5d, 0x82, 0x15, 0x25, 0xcc, 0xce, 0x69,
  0x63, 0xb0, 0xc0, 0xda, 0x2e, 0x73, 0x71, 0x6b, 0x6e, 0x84, 0x1b, 0x8b,
  0xd9, 0x3f, 0xc8, 0x13, 0x0c, 0x9d, 0x5a, 0xec, 0x0c, 0xfc, 0x11, 0xc4,
  0xbd, 0x9f, 0xb2, 0xca, 0x41, 0x37, 0xc0, 0x1d, 0x8b, 0x40, 0x45, 0x49,
  0xec, 0x03, 0xec, 0x0d, 0x9f, 0xd1, 0x38, 0x1d, 0x43, 0xba, 0xce, 0xee,
  0x84, 0x76, 0xdc, 0x2c, 0xa8, 0x8d, 0x22, 0xc5, 0xcd, 0xc3, 0x9f, 0xcf,
  0x06, 0xd1, 0x3a, 0xf8, 0x27, 0x31, 0xd9, 0x71, 0xb2, 0x28, 0xfd, 0x2c,
  0xdc, 0x82, 0xdc, 0xc5, 0x4e, 0xae, 0x8d, 0x27, 0x13, 0x91, 0x47, 0x58,
  0xa2, 0x78, 0x39, 0xd8, 0x1a, 0xb0, 0x4e, 0x9d, 0xdc, 0xa6, 0x19, 0xa9,
  0x45, 0x2c, 0x32, 0xf3, 0x9d, 0xe4, 0xde, 0x8b, 0x58, 0x49, 0xe0, 0xb3,
  0x7a, 0x75, 0x85, 0xf5, 0xc9, 0xe6, 0x9b, 0xa4, 0x47, 0x45, 0x01, 0xf7,
  0xcd, 0x49, 0x86, 0x07, 0xfb, 0xe1, 0xb5, 0x31, 0x71, 0x0f, 0x94, 0x17,
  0xb2, 0x5e, 0x5d, 0xcd, 0x0d, 0x47, 0x27, 0xfd, 0x78, 0xb3, 0xdf, 0x8f,
  0x17, 0x2c, 0xff, 0xd7, 0xb4, 0xe6, 0x75, 0xa2, 0xd4, 0x4d, 0x56, 0x18,
  0x37, 0xa2, 0xef, 0xf8, 0x6a, 0x06, 0x93, 0x66, 0xf1, 0x69, 0xee, 0x34,
  0x2d, 0x2c, 0x9d, 0x5c, 0xde, 0x7c, 0x52, 0x8c, 0x05, 0xb5, 0x36, 0x67,
  0x94, 0x1a, 0xe7, 0x2c, 0xef, 0xe0, 0x8e, 0x73, 0x54, 0xc8, 0xe3, 0x8d,
  0xe8, 0xc2, 0xc9, 0x4d, 0x09, 0xa0, 0xfd, 0x1a, 0x88, 0x30, 0x82, 0xa3,
  0xca, 0x4f, 0xd7, 0x9a, 0x9b, 0x64, 0x49, 0x31, 0xef, 0xd2, 0x0a, 0x25,
  0xf7, 0x29, 0x6b, 0x7a, 0xbc, 0xc3, 0x32, 0x14, 0xdc, 0x28, 0xe3, 0x1c,
  0x8b, 0x31, 0x80, 0x14, 0x5c, 0x26, 0x72, 0xce, 0x30, 0xdc, 0xcb, 0x69,
  0x7c, 0x45, 0x74, 0x54, 0x6b, 0x8e, 0x14, 0xda, 0x8c, 0x39, 0x3c, 0xb1,
  0xd9, 0x82, 0xa4, 0x60, 0x52, 0x1c, 0xbf, 0xd6, 0x7b, 0x94, 0x94, 0x6a,
  0xe2, 0xd2, 0xd3, 0x25, 0x84, 0xf1, 0x53, 0x9a, 0x18, 0x7d, 0xb5, 0xe1,
  0xcf, 0x59, 0x7f, 0x8f, 0xd6, 0x8f, 0x95, 0xd3, 0x7e, 0x4c, 0x27, 0xa1,
  0x8c, 0x5e, 0xc9, 0x8f, 0xa2, 0xe4, 0x4b, 0xe6, 0xf3, 0xfa, 0x92, 0x32,
  0xc3, 0xda, 0x88, 0x86, 0x2a, 0x5b, 0xf1, 0xdc, 0xde, 0xf1, 0xab, 0x7b,
  0xc1, 0x3b, 0xbc, 0x50, 0x05, 0x2d, 0x9f, 0x2d, 0x18, 0x78, 0x9c, 0x0c,
  0x65, 0x50, 0x6b, 0x6e, 0xc8, 0x23, 0xa5, 0xf9, 0xc6, 0x13, 0x26, 0x18,
  0xb9, 0x8e, 0xa3, 0xfd, 0xaf, 0x8e, 0x88, 0x5c, 0x2e, 0x49, 0x6b, 0x8b,
  0xf8, 0xa2, 0x90, 0x49, 0xd3, 0x0a, 0x26, 0xc4, 0x9b, 0x69, 0xde, 0x58,
  0x33, 0x52, 0xaf, 0x42, 0xc1, 0x45, 0xff, 0xeb, 0xbc, 0xcd, 0x7e, 0xa1,
  0x05, 0x8c, 0x37, 0x9f, 0x0f, 0xb6, 0xe8, 0x8c, 0x5c, 0x90, 0x70, 0x3f,
  0x1f, 0x67, 0x13, 0xd2, 0x79, 0xa7, 0xf1, 0x9c, 0xd4, 0x72, 0xd0, 0x2a,
  0xf6, 0x43, 0x46, 0xca, 0x17, 0xd8, 0x32, 0xcf, 0xe9, 0xa2, 0x9c, 0x54,
  0x6e, 0x10, 0x3b, 0x2e, 0x32, 0x1d, 0x39, 0x04, 0x26, 0x07, 0x44, 0x7f,
  0x5f, 0xf2, 0x76, 0xcc, 0xe2, 0xfc, 0xc6, 0x84, 0x0d, 0x27, 0x44, 0x8f,
  0x12, 0x0c, 0x0c, 0xcf, 0x37, 0x9b, 0xeb, 0x7f, 0x4d, 0x0b, 0xcd, 0x9a,
  0x34, 0x0b, 0xc7, 0x72, 0xfa, 0x32, 0x13, 0x4b, 0xfc, 0x76, 0x78, 0xee,
  0x87, 0x79, 0xeb, 0x83, 0xac, 0xec, 0x50, 0xcb, 0xac, 0xd1, 0x33, 0x25,
  0xd0, 0x9b, 0x74, 0x3e, 0x45, 0x89, 0x9f, 0xc6, 0x74, 0xcc, 0x78, 0xe1,
  0x3c, 0xed, 0x34, 0xfb, 0xe6, 0xef, 0x99, 0x82, 0xba, 0x05, 0x4e, 0x41,
  0xb0, 0xfb, 0x7d, 0x62, 0xc9, 0x6c, 0x95, 0x68, 0xdf, 0xe8, 0x0b, 0x3a,
  0x15, 0x85, 0x3b, 0x16, 0x97, 0xe9, 0x15, 0x29, 0xee, 0xc2, 0xc8, 0x61,
  0xc8, 0x30, 0xfb, 0x05, 0xb3, 0xdd, 0xeb, 0x0c, 0xc4, 0x97, 0x96, 0x45,
  0x32, 0xbd, 0xec, 0xd5, 0x9a, 0xe3, 0xe3, 0x6b, 0x2c, 0x0f, 0x7c, 0xa1,
  0x48, 0xc6, 0x68, 0x6a, 0x9e, 0x28, 0xfb, 0x9e, 0xf1, 0xaa, 0xb2, 0x12,
  0x1c, 0x8d, 0xa7, 0x71, 0x3a, 0x2b, 0x70, 0x1c, 0x54, 0xc1, 0x2b, 0xea,
  0x74, 0x73, 0xa1, 0x42, 0x1c, 0x08, 0x66, 0xc4, 0x42, 0x64, 0x5e, 0xb0,
  0x98, 0xc8, 0xdb, 0x15, 0xdb, 0x1d, 0x8a, 0x4e, 0x49, 0x65, 0x1a, 0xdf,
  0x80, 0x28, 0xd1, 0x8b, 0xdc, 0x3c, 0xfd, 0x5a, 0x73, 0xb2, 0x29, 0x05,
  0xaf, 0xe7, 0xb2, 0x60, 0xc3, 0x4b, 0x91, 0x8e, 0x88, 0x20, 0x49, 0xa8,
  0x5a, 0x8e, 0x41, 0x01, 0xac, 0xc4, 0x91, 0xba, 0x98, 0xc7, 0x2c, 0x72,
  0x96, 0x30, 0x19, 0x45, 0x20, 0x9b, 0x3e, 0x91, 0xc8, 0xa2, 0x75, 0x74,
  0xb8, 0x09, 0x45, 0x2c, 0xac, 0x30, 0x89, 0x42, 0x85, 0x5f, 0xb6, 0x4d,
  0xa8, 0xa4, 0x39, 0xae, 0xad, 0x66, 0xad, 0x39, 0x59, 0xdb, 0x1e, 0x29,
  0x21, 0x29, 0x69, 0xaa, 0xa6, 0x73, 0x91, 0x94, 0x24, 0x74, 0xd9, 0xef,
  0x93, 0xfa, 0x90, 0x8e, 0x7b, 0xfc, 0xdb, 0x24, 0x25, 0x3d, 0xad, 0xc4,
  0xaf, 0xf3, 0x72, 0x3a, 0xeb, 0x45, 0x21, 0xf7, 0x77, 0x3b, 0x3e, 0x4f,
  0xae, 0x32, 0x52, 0x1d, 0xcb, 0x26, 0xd5, 0x81, 0xd3, 0x08, 0xab, 0x51,
  0x09, 0xc2, 0xd1, 0x87, 0xc9, 0x03, 0x24, 0x48, 0x10, 0x3b, 0x66, 0x63,
  0xcb, 0x44, 0xc5, 0x38, 0x1e, 0x8a, 0xf0, 0xd3, 0x3a, 0x4f, 0x82, 0x54,
  0x5f, 0x94, 0xc4, 0x78, 0x7a, 0x2a, 0x29, 0xd2, 0xa6, 0xce, 0xe2, 0x07,
  0xec, 0x10, 0x89, 0x24, 0x4e, 0x02, 0xc0, 0xc1, 0x21, 0x06, 0x52, 0xde,
  0xa5, 0x63, 0x95, 0xae, 0x79, 0x41, 0xea, 0x0c, 0x98, 0xf5, 0xe4, 0x69,
  0xca, 0x0f, 0xce, 0x96, 0xb4, 0xbf, 0xf4, 0x16, 0x5f, 0xb6, 0xa2, 0x91,
  0xdc, 0xd1, 0x6e, 0x0d, 0xe4, 0xd8, 0x24, 0x22, 0x37, 0xd1, 0x6d, 0xc7,
  0xe2, 0x5c, 0x9c, 0xb3, 0x74, 0x77, 0xd7, 0x6c, 0x4e, 0xc6, 0xcc, 0x93,
  0x0c, 0xc7, 0xc9, 0xaf, 0xab, 0x74, 0xe3, 0xa5, 0x1a, 0x1c, 0x2d, 0xe6,
  0x48, 0xc1, 0xc1, 0x19, 0xd1, 0x69, 0x16, 0x63, 0x5c, 0xf4, 0x8a, 0xef,
  0xec, 0xd7, 0x3c, 0x99, 0x15, 0xfc, 0xf2, 0x8c, 0xb4, 0x2e, 0xb4, 0x1c,
  0x8a, 0x3c, 0x01, 0x5f, 0x64, 0x41, 0x2a, 0x56, 0xd3, 0xde, 0x40, 0x85,
  0x2f, 0x26, 0xfe, 0x3a, 0xa1, 0x12, 0x69, 0x26, 0x60, 0x95, 0xae, 0xad,
  0x85, 0xbf, 0x70, 0x69, 0x67, 0x92, 0xf4, 0x96, 0x0d, 0x6c, 0x4e, 0x99,
  0x92, 0xc6, 0x61, 0x31, 0xe8, 0x0c, 0x93, 0xb2, 0xde, 0xdc, 0x3e, 0x3a,
  0xdc, 0xed, 0xa8, 0xd5, 0x01, 0x06, 0x36, 0xb4, 0xaa, 0x4b, 0x47, 0x0b,
  0xac, 0x66, 0x85, 0x4b, 0x56, 0x4b, 0x88, 0x28, 0x3a, 0x6c, 0x61, 0xde,
  0x7e, 0xfd, 0xed, 0xde, 0xf1, 0xbb, 0xc3, 0xed, 0xbf, 0xd4, 0xa9, 0x87,
  0xbe, 0xdb, 0x91, 0xef, 0x76, 0x3a, 0x6d, 0x1c, 0x8d, 0x08, 0x28, 0x8a,
  0xba, 0xaf, 0xbb, 0x6a, 0x18, 0xe0, 0x59, 0xda, 0x9d, 0x0c, 0x4e, 0x46,
  0xa3, 0xe8, 0xa9, 0xa8, 0x5f, 0xca, 0xf5, 0x27, 0x0b, 0xc3, 0xb7, 0x67,
  0x7d, 0xec, 0x50, 0x8d, 0x69, 0x25, 0xc1, 0x55, 0x98, 0x00, 0xe2, 0x49,
  0xb8, 0x18, 0x45, 0x89, 0xdb, 0x50, 0x37, 0x88, 0x5b, 0x2e, 0x84, 0x1e,
  0xe9, 0x4c, 0xe0, 0x20, 0xd5, 0x79, 0xbd, 0xcc, 0x98, 0xa7, 0xec, 0x87,
  0x04, 0xae, 0x5b, 0x40, 0x3e, 0x4a, 0x41, 0x58, 0x0f, 0x44, 0xbd, 0xe5,
  0xf8, 0x7a, 0x40, 0x97, 0x9e, 0xf0, 0x94, 0xb4, 0xd0, 0xe3, 0x59, 0xe7,
  0x77, 0x7c, 0x1d, 0xb0, 0xf1, 0xf8, 0x96, 0x66, 0x21, 0x5b, 0xdf, 0xd1,
  0xb1, 0x90, 0x4e, 0x48, 0xfb, 0xd2, 0xd1, 0xe3, 0x0c, 0xca, 0x82, 0xa1,
  0x55, 0x95, 0x28, 0x3e, 0x5f, 0x79, 0xbd, 0x39, 0x3a, 0x3b, 0xd9, 0x8c,
  0x7b, 0x54, 0xeb, 0x2f, 0x5b, 0xdf, 0x8d, 0x21, 0xf0, 0x79, 0xa2, 0x51,
  0xb3, 0x0a, 0xfc, 0xa0, 0x27, 0xb2, 0x9b, 0x27, 0x7a, 0x7c, 0x45, 0xdb,
  0xad, 0x53, 0x3e, 0x35, 0x36, 0x22, 0x61, 0x5b, 0x49, 0x5b, 0x2e, 0xab,
  0xa8, 0x7f, 0x4c, 0x04, 0x3d, 0xcd, 0x94, 0xa1, 0x7b, 0xa1, 0x55, 0xa5,
  0x97, 0xc8, 0xd1, 0x40, 0x76, 0xd9, 0x72, 0x2e, 0xf5, 0x19, 0x56, 0xc5,
  0xb0, 0x15, 0x36, 0x50, 0x39, 0x5a, 0x8e, 0x9c, 0x48, 0x3f, 0xa4, 0x95,
  0x05, 0xe5, 0x2b, 0xd3, 0x25, 0xf5, 0xa3, 0xa5, 0xb9, 0x93, 0xa4, 0x2c,
  0xc6, 0xf1, 0x22, 0xd9, 0xd4, 0x1b, 0xdd, 0x36, 0x12, 0xbd, 0xc8, 0x40,
  0x9a, 0xcc, 0xeb, 0xf4, 0xe2, 0xd0, 0xc4, 0x24, 0x7d, 0xd2, 0xab, 0xf2,
  0x22, 0xc8, 0x06, 0x67, 0x96, 0x4f, 0x18, 0x84, 0x64, 0x65, 0xd2, 0x71,
  0x43, 0xa0, 0x9a, 0x93, 0x4a, 0x35, 0x80, 0x0d, 0xd2, 0x26, 0xa3, 0x16,
  0x39, 0x23, 0x2e, 0x3b, 0x1b, 0xd4, 0x13, 0x84, 0x0d, 0x7c, 0xec, 0x0c,
  0xf4, 0x75, 0x6e, 0xa3, 0xb7, 0x5f, 0x7f, 0xec, 0xc6, 0xd0, 0xff, 0x5b,
  0xec, 0x25, 0x01, 0xb5, 0xee, 0x62, 0xa1, 0x48, 0xb2, 0x9f, 0x93, 0xe8,
  0x7b, 0x9b, 0xe8, 0xda, 0xf2, 0x7a, 0xb5, 0x5f, 0x59, 0x5e, 0xe5, 0x33,
  0x7e, 0x7d, 0x40, 0xcd, 0x4f, 0x96, 0xb3, 0x85, 0x4a, 0x1a, 0x7f, 0x68,
  0x3b, 0x86, 0x22, 0x51, 0xfd, 0x5a, 0xd1, 0x62, 0x94, 0xfc, 0x2a, 0xc1,
  0xe2, 0x4b, 0x11, 0x2b, 0xfb, 0x71, 0x31, 0x4e, 0xd3, 0xda, 0x5b, 0x87,
  0xd0, 0xa8, 0xa2, 0xbd, 0xe1, 0xfe, 0xd1, 0x91, 0xb7, 0x46, 0xdc, 0x89,
  0x90, 0xce, 0xd3, 0x60, 0x1d, 0x93, 0x96, 0x84, 0x3d, 0x39, 0x62, 0xf6,
  0x82, 0xbf, 0x47, 0xc6, 0x4d, 0xb7, 0x5f, 0xdb, 0x69, 0xe3, 0xf1, 0x25,
  0x73, 0xa2, 0x8d, 0xb1, 0x48, 0xc1, 0xd2, 0x10, 0xcd, 0x87, 0xed, 0x7f,
  0x20, 0x0b, 0xba, 0xb4, 0x0a, 0x55, 0xa2, 0xfe, 0x52, 0x3e, 0x2c, 0x92,
  0xd7, 0x7b, 0x1d, 0x91, 0xe0, 0xea, 0x73, 0x92, 0x85, 0x19, 0xc7, 0x34,
  0x7c, 0x35, 0x66, 0xc8, 0xed, 0xc4, 0x5b, 0x3c, 0x51, 0x13, 0x84, 0xf2,
  0x46, 0x36, 0x22, 0xcf, 0x58, 0xc4, 0x14, 0x87, 0x07, 0xdd, 0x42, 0xcf,
  0x76, 0xea, 0xac, 0xe5, 0x81, 0xae, 0xff, 0x59, 0x11, 0xca, 0x5c, 0xb8,
  0xb1, 0xdb, 0xaf, 0x8a, 0x9a, 0xc8, 0xc5, 0x64, 0x83, 0xe3, 0xf2, 0x25,
  0xbf, 0x52, 0x13, 0x14, 0x06, 0x4e, 0x10, 0x6a, 0x6e, 0x8c, 0xd9, 0x21,
  0xf9, 0x32, 0xad, 0x49, 0x92, 0xcb, 0x62, 0x09, 0x13, 0xd3, 0x82, 0xe4,
  0xa5, 0x72, 0x4a, 0x0c, 0xae, 0x17, 0x2d, 0xe7, 0xfc, 0xd3, 0x69, 0xa6,
  0xc4, 0x84, 0x9b, 0xca, 0x0f, 0xf4, 0x9b, 0x3c, 0xe5, 0xb9, 0xc6, 0x51,
  0xc8, 0x6b, 0x45, 0x1a, 0xd7, 0xf6, 0x55, 0x7a, 0x60, 0xff, 0x07, 0x3d,
  0x36, 0x49, 0xd9, 0x57, 0x46, 0x23, 0xae, 0xef, 0x58, 0xab, 0xf8, 0xb8,
  0x5e, 0x2c, 0x89, 0xa1, 0x11, 0xcb, 0x77, 0xe2, 0x8b, 0x89, 0x34, 0x6a,
  0xa2, 0x32, 0xd9, 0xa5, 0x7e, 0x19, 0x10, 0x93, 0x0d, 0x35, 0x9a, 0xfe,
  0x38, 0x5d, 0x5c, 0xf3, 0xe9, 0x78, 0x05, 0x0d, 0x98, 0xa5, 0x6c, 0xf9,
  0xa0, 0x71, 0x3d, 0x0f, 0x87, 0xc7, 0xa6, 0xcd, 0xe0, 0x80, 0x83, 0xa3,
  0xda, 0xdb, 0xba, 0xfc, 0xa9, 0x59, 0xe8, 0xcd, 0xda, 0x29, 0x5c, 0x91,
  0x9b, 0xae, 0x13, 0x8e, 0xeb, 0xc8, 0x09, 0x28, 0x42, 0x85, 0xb7, 0xf1,
  0x34, 0x9d, 0xd8, 0x77, 0x83, 0xe8, 0x9c, 0x39, 0xe4, 0x72, 0xc1, 0xa7,
  0x27, 0x82, 0x87, 0x4f, 0xbf, 0xaa, 0x35, 0x87, 0xc1, 0x87, 0x3b, 0x0a,
  0x9f, 0x58, 0xe5, 0xf0, 0x55, 0xd8, 0x66, 0x1a, 0x7c, 0x47, 0x44, 0xbf,
  0x5b, 0x67, 0x19, 0xde, 0x90, 0x4e, 0x92, 0xcd, 0xbc, 0x28, 0xa6, 0xf0,
  0x6d, 0x4c, 0xb2, 0x71, 0xb1, 0x49, 0x0a, 0x6f, 0xb1, 0x69, 0xe3, 0xab,
  0x78, 0x31, 0x8c, 0xb9, 0x0e, 0x87, 0x6e, 0x6e, 0x6c, 0x13, 0x81, 0xe4,
  0xed, 0x76, 0x77, 0xfa, 0x20, 0xac, 0x43, 0xb4, 0xcb, 0x63, 0xdd, 0xad,
  0xaf, 0xe6, 0xcb, 0x8b, 0xe3, 0xa1, 0xc8, 0x15, 0x75, 0xc9, 0x70, 0xc9,
  0xba, 0x8a, 0xed, 0x4e, 0xd8, 0x38, 0xee, 0x2b, 0xb9, 0x03, 0x86, 0xc3,
  0x7d, 0x7c, 0x38, 0x5c, 0xb2, 0x5a, 0x40, 0xdd, 0xe4, 0x0f, 0x91, 0x2a,
  0xc1, 0xb5, 0xe6, 0x78, 0xb6, 0x36, 0x3f, 0xb1, 0x75, 0x65, 0xf9, 0xc3,
  0xe0, 0x32, 0x99, 0x64, 0x79, 0x3c, 0x20, 0x56, 0x4d, 0x24, 0x09, 0xa7,
  0x01, 0xe6, 0x4a, 0xc7, 0xf5, 0x3d, 0xcd, 0x1e, 0xd3, 0xfc, 0xe8, 0x80,
  0x9f, 0xae, 0x93, 0x13, 0x5d, 0xdb, 0x49, 0xf1, 0xb4, 0x46, 0x86, 0x8b,
  0xc3, 0x7c, 0x4a, 0x6c, 0x32, 0x2d, 0xda, 0xd8, 0xa6, 0x9d, 0x9a, 0x96,
  0x5b, 0x0e, 0xc6, 0xc7, 0x0a, 0x63, 0xa0, 0x41, 0x2e, 0xd8, 0xc8, 0x95,
  0x4c, 0xda, 0xb9, 0xc3, 0xb9, 0xa9, 0x36, 0x91, 0x7f, 0xd2, 0x1b, 0xd4,
  0xea, 0x8e, 0x76, 0x62, 0x8c, 0x57, 0x59, 0x4e, 0x0c, 0x6f, 0x56, 0x34,
  0x48, 0x4b, 0xdc, 0xb4, 0xa6, 0x60, 0xf5, 0xd4, 0x8a, 0x59, 0x2e, 0x73,
  0x59, 0xfc, 0xe5, 0x3c, 0xe8, 0x80, 0x96, 0x6d, 0x39, 0x83, 0x73, 0xd5,
  0x56, 0xa1, 0x9d, 0x63, 0xda, 0x9a, 0x08, 0xcf, 0x71, 0xf2, 0x27, 0xac,
  0x01, 0x85, 0x68, 0x51, 0xcb, 0xb9, 0x77, 0xda, 0x89, 0x76, 0xce, 0x7a,
  0x78, 0x5d, 0x3e, 0x71, 0x4e, 0x87, 0x3c, 0xe1, 0x67, 0xf9, 0x4d, 0x5a,
  0xc4, 0x2c, 0xaf, 0x2e, 0x15, 0xce, 0x63, 0x9f, 0x17, 0x9e, 0x79, 0xf2,
  0x2b, 0x52, 0x29, 0x33, 0xea, 0xa7, 0x7e, 0xc6, 0xdf, 0xc6, 0xf7, 0xe9,
  0x6c, 0x39, 0x33, 0xa3, 0x36, 0x9b, 0x00, 0xf4, 0xc9, 0xc0, 0x8b, 0x45,
  0xfc, 0x30, 0xbb, 0xab, 0x1d, 0x73, 0x95, 0xd3, 0xeb, 0xdc, 0x5c, 0xe6,
  0xc4, 0xdf, 0x91, 0xd4, 0x36, 0x50, 0x6d, 0x4f, 0xcd, 0x6d, 0x33, 0xd2,
  0x7e, 0xf5, 0xce, 0x0e, 0xda, 0x89, 0x16, 0xd7, 0x71, 0x41, 0x57, 0x2a,
  0x6e, 0xd6, 0xb6, 0xa9, 0x92, 0xf0, 0x56, 0xb8, 0x37, 0x92, 0x06, 0xbf,
  0xa6, 0xcd, 0x24, 0xc1, 0x19, 0x17, 0x34, 0x2d, 0x2f, 0xdc, 0xe6, 0x72,
  0xe5, 0xb5, 0xd8, 0x18, 0x66, 0x74, 0xeb, 0xce, 0xe2, 0x7b, 0xac, 0x8a,
  0x09, 0x71, 0xbf, 0x15, 0x25, 0xab, 0x6c, 0x1c, 0x6c, 0x42, 0x4d, 0x96,
  0x79, 0x05, 0x41, 0x84, 0x25, 0xf3, 0xfa, 0x26, 0x38, 0x83, 0x51, 0xa6,
  0x3c, 0x16, 0x4f, 0x3a, 0xdb, 0xb8, 0xdd, 0x76, 0x62, 0xd6, 0x67, 0x3b,
  0xac, 0x89, 0x5c, 0xf1, 0x25, 0x4c, 0xec, 0x4d, 0x01, 0x76, 0x41, 0x3a,
  0x44, 0x12, 0xe8, 0x68, 0x03, 0x75, 0x55, 0x71, 0x0b, 0x85, 0x44, 0x1e,
  0xb8, 0x46, 0x2a, 0x97, 0x15, 0x8b, 0xa7, 0x6d, 0x7a, 0x6a, 0xa0, 0x90,
  0x33, 0x6d, 0x8a, 0x3c, 0x1b, 0xc3, 0x70, 0xc9, 0x6d, 0xb1, 0x22, 0x12,
  0x8c, 0xab, 0xa2, 0x6c, 0xd5, 0x9a, 0x33, 0x63, 0x06, 0x28, 0x65, 0xbd,
  0xd8, 0x80, 0x5a, 0x3a, 0xf7, 0x62, 0x24, 0xf3, 0xcf, 0x9b, 0x79, 0x76,
  0x47, 0xda, 0xe6, 0x3c, 0x93, 0x8e, 0x6c, 0x7d, 0x79, 0xf8, 0x0d, 0x6e,
  0x94, 0xcc, 0x55, 0x37, 0xd3, 0x41, 0x39, 0x43, 0x0f, 0x3f, 0x5d, 0x3a,
  0x99, 0x29, 0x94, 0x9b, 0x43, 0x79, 0xb9, 0x3e, 0x59, 0x91, 0x9e, 0xcd,
  0xbe, 0xce, 0x77, 0xb7, 0x93, 0x97, 0x4d, 0xa9, 0xc2, 0x5a, 0xa8, 0xbd,
  0x6b, 0x12, 0x17, 0xd7, 0x44, 0xbb, 0x9d, 0x7e, 0xa7, 0xd7, 0x66, 0x59,
  0xaa, 0xcb, 0xc6, 0x36, 0x26, 0x27, 0x2c, 0xb5, 0xcb, 0xe9, 0xaa, 0xa8,
  0xeb, 0x30, 0x99, 0x78, 0x48, 0xac, 0xeb, 0xe2, 0xca, 0x54, 0xcb, 0x27,
  0xcb, 0x7f, 0xbe, 0x31, 0xa1, 0xc7, 0xbb, 0xeb, 0x6c, 0xda, 0x7a, 0x82,
  0x02, 0x55, 0x3d, 0xe3, 0x66, 0x60, 0x3d, 0x64, 0x6f, 0x29, 0x4b, 0xd2,
  0x35, 0x26, 0x12, 0x8d, 0xa7, 0x49, 0x9c, 0x4f, 0x1f, 0x54, 0x8b, 0xab,
  0x9f, 0xa0, 0x5b, 0x5b, 0x60, 0xb6, 0xf2, 0xd2, 0x42, 0xdc, 0xc5, 0xf9,
  0x9c, 0x97, 0x57, 0xbd, 0x5b, 0xc9, 0x44, 0xc2, 0x0b, 0x4a, 0xb1, 0xe6,
  0x0b, 0x1f, 0xe7, 0xd3, 0x7f, 0x9b, 0xb2, 0xd5, 0xa8, 0xb1, 0xda, 0x49,
  0x32, 0x19, 0xc5, 0xe3, 0x1b, 0xac, 0x35, 0xb7, 0xa8, 0x3e, 0x2c, 0x3e,
  0x7f, 0xce, 0xd0, 0x44, 0xa4, 0x7c, 0x4d, 0x07, 0xaf, 0x48, 0xcb, 0x65,
  0xfc, 0x6f, 0x9e, 0x58, 0x39, 0xb2, 0x75, 0x42, 0x6e, 0xd3, 0x9d, 0x57,
  0x1c, 0xe9, 0x7d, 0x1c, 0x69, 0x12, 0xcd, 0xe6, 0x4b, 0x92, 0xdd, 0x89,
  0xad, 0x66, 0x97, 0x97, 0x44, 0x23, 0x9f, 0x37, 0x4c, 0x07, 0xf2, 0xc8,
  0xe6, 0xb9, 0xc4, 0x1b, 0x85, 0x22, 0x61, 0x54, 0x75, 0x00, 0x5b, 0x70,
  0xc6, 0x55, 0xca, 0x9b, 0x21, 0xcd, 0x35, 0x4d, 0x66, 0xd5, 0xef, 0x6d,
  0x65, 0xc5, 0x3d, 0x62, 0x21, 0x05, 0x30, 0xa0, 0x8d, 0x1e, 0x70, 0xc0,
  0x45, 0xcc, 0xb4, 0xa3, 0x50, 0x67, 0xd2, 0x37, 0xe9, 0x62, 0xc1, 0x93,
  0x97, 0x48, 0x86, 0xc0, 0x24, 0x32, 0x4a, 0xae, 0xd2, 0xf9, 0x3c, 0x0c,
  0x28, 0xc9, 0x96, 0xa4, 0x31, 0xc8, 0x88, 0x47, 0xc9, 0x25, 0x33, 0xd9,
  0x86, 0xf0, 0x0b, 0x7b, 0x84, 0x77, 0xa2, 0xaa, 0xfd, 0x66, 0x82, 0xc8,
  0x14, 0x65, 0x3e, 0xbc, 0x45, 0xa2, 0x48, 0x8a, 0x55, 0x4e, 0x0d, 0x62,
  0xad, 0x47, 0x86, 0x43, 0xbd, 0xf4, 0x1a, 0x31, 0xd7, 0xc6, 0xf0, 0xe8,
  0x7f, 0x1c, 0x7a, 0x7f, 0xb7, 0x19, 0x21, 0x48, 0x8b, 0x61, 0xea, 0x6e,
  0x90, 0xc3, 0x3b, 0x16, 0xd1, 0x3b, 0xfd, 0x7d, 0xda, 0xae, 0x0e, 0x46,
  0x53, 0xf1, 0x5d, 0x2c, 0xcb, 0x8c, 0x0e, 0x38, 0xc7, 0x56, 0x4c, 0x1f,
  0x24, 0x0c, 0x8a, 0x29, 0x8e, 0x94, 0xab, 0x3c, 0xd9, 0x64, 0x07, 0x50,
  0xc3, 0x6c, 0xae, 0x21, 0x63, 0x70, 0x6e, 0xe8, 0x34, 0x61, 0x84, 0x2a,
  0xd5, 0x69, 0x52, 0x04, 0xdb, 0xa7, 0xae, 0xc6, 0x4d, 0x68, 0xc7, 0xea,
  0x31, 0x6f, 0xaa, 0x0a, 0x6a, 0x28, 0x16, 0xdf, 0x60, 0x0b, 0x0b, 0xf8,
  0xed, 0x6e, 0xa0, 0xbe, 0x70, 0x0b, 0x52, 0x13, 0xf2, 0xfa, 0x38, 0x2a,
  0x3e, 0x1f, 0x22, 0xe9, 0xbf, 0x91, 0x4c, 0x53, 0x33, 0x79, 0x98, 0x5b,
  0xab, 0x67, 0x17, 0xb1, 0xd0, 0x93, 0xb4, 0xd9, 0x66, 0xe5, 0xa0, 0x0b,
  0x9a, 0x44, 0xa2, 0x98, 0xa3, 0x38, 0xd8, 0x54, 0x32, 0x8d, 0x9c, 0xb4,
  0x19, 0x5d, 0xa7, 0x34, 0xf6, 0x7c, 0x7c, 0xfd, 0xc0, 0x57, 0x05, 0x1b,
  0x20, 0xd9, 0x79, 0x73, 0xe1, 0x67, 0x59, 0x67, 0x5b, 0xe8, 0x43, 0xad,
  0x82, 0x29, 0x6b, 0x0c, 0xac, 0x0f, 0x65, 0x73, 0xb3, 0x55, 0xd4, 0xc6,
  0x47, 0x64, 0x71, 0xcd, 0x54, 0x9b, 0x4c, 0x59, 0x02, 0xa0, 0x05, 0x6c,
  0x1b, 0x5d, 0x3f, 0x0b, 0xd8, 0x38, 0x36, 0x8e, 0xee, 0x17, 0x6a, 0x9c,
  0x39, 0xa1, 0x18, 0xb0, 0xa4, 0x2b, 0xb6, 0xc2, 0x4a, 0x6f, 0x7c, 0xa9,
  0xf1, 0x85, 0xf8, 0x50, 0x6b, 0x4e, 0x7d, 0x52, 0xfa, 0xba, 0xad, 0xbd,
  0xf9, 0xa4, 0xea, 0xdb, 0x79, 0x91, 0xe9, 0x57, 0x76, 0xf5, 0xd9, 0xaa,
  0x88, 0x4e, 0x55, 0xd7, 0xea, 0x25, 0x86, 0x13, 0xa1, 0x30, 0xfd, 0x3e,
  0x1d, 0x86, 0x7e, 0xeb, 0xd2, 0x60, 0x4b, 0xab, 0x3b, 0x3d, 0xbd, 0x84,
  0x4f, 0x6f, 0x83, 0xb9, 0x0f, 0x51, 0x4a, 0x19, 0x1d, 0xbf, 0x61, 0x6a,
  0xdb, 0x3f, 0xa7, 0x9f, 0xa9, 0x39, 0xf5, 0x98, 0xad, 0x23, 0x16, 0x93,
  0x15, 0xf2, 0xb7, 0xdf, 0x0e, 0xa3, 0xf5, 0xd3, 0xe1, 0xe6, 0xb3, 0x97,
  0x5b, 0xa1, 0x82, 0x38, 0x61, 0x23, 0x09, 0xeb, 0xf5, 0xaf, 0x1e, 0x31,
  0xda, 0x92, 0x9c, 0xa5, 0x42, 0x62, 0x12, 0x32, 0x54, 0xbc, 0x07, 0x93,
  0x2a, 0xfc, 0xf6, 0xe6, 0x6c, 0x08, 0x8c, 0xba, 0xad, 0x12, 0x63, 0xcf,
  0x45, 0x68, 0x81, 0xf9, 0xc6, 0x0f, 0x72, 0x3a, 0xe2, 0x68, 0x94, 0x67,
  0x77, 0x1c, 0x1a, 0x0a, 0x87, 0x60, 0x24, 0xcb, 0xc5, 0xdc, 0x14, 0xf1,
  0xa2, 0x2c, 0x19, 0xd6, 0xb9, 0x07, 0x6d, 0x86, 0x78, 0x15, 0xf8, 0x46,
  0xfb, 0xfa, 0xe2, 0xed, 0x31, 0xae, 0x74, 0x08, 0xdd, 0x22, 0xb0, 0x0b,
  0x51, 0x15, 0xcb, 0x11, 0x89, 0xa3, 0x7c, 0x57, 0x95, 0xce, 0x52, 0x10,
  0x46, 0x77, 0xda, 0x62, 0xc7, 0x08, 0xe5, 0x51, 0xe6, 0xb1, 0x68, 0x33,
  0x54, 0x2b, 0xaf, 0xf2, 0x52, 0x06, 0xdf, 0x0f, 0x44, 0x3f, 0x7d, 0x36,
  0xa2, 0xd4, 0x35, 0xf1, 0xc5, 0x62, 0xaa, 0x5a, 0xfd, 0xe6, 0x7d, 0x9f,
  0x74, 0xcd, 0x3e, 0x0f, 0xae, 0x4f, 0xcd, 0x8b, 0x2b, 0x8e, 0x1d, 0x9a,
  0xfb, 0x24, 0xbd, 0xb1, 0x0c, 0x44, 0xcd, 0xf7, 0xdf, 0xd0, 0x4e, 0xf0,
  0x13, 0x0d, 0x9a, 0xf2, 0x7b, 0x04, 0x53, 0x9d, 0x6c, 0x42, 0x3c, 0x53,
  0x99, 0x4c, 0xbe, 0x12, 0xdb, 0xd2, 0x00, 0x04, 0xc8, 0xe1, 0xb2, 0x6a,
  0x12, 0x27, 0xd6, 0x33, 0xad, 0x13, 0x34, 0xdb, 0x3b, 0xf3, 0x07, 0xf1,
  0xbd, 0xab, 0x39, 0xd2, 0xdc, 0x32, 0xce, 0x32, 0x27, 0x6d, 0xca, 0x93,
  0xde, 0x00, 0x9a, 0x41, 0xbd, 0xac, 0x9f, 0x0f, 0xf1, 0x2b, 0xf2, 0x6b,
  0xa4, 0xdb, 0x2f, 0xa1, 0x70, 0xc5, 0xb2, 0x0f, 0xe2, 0xa8, 0x44, 0x8c,
  0x58, 0xfc, 0x80, 0xc6, 0xb5, 0x61, 0xb7, 0x06, 0xad, 0xa6, 0x71, 0x8e,
  0x8c, 0x90, 0x2b, 0xa9, 0x48, 0x9c, 0xd3, 0xdc, 0x18, 0x63, 0xd5, 0x38,
  0x67, 0x31, 0x83, 0xe6, 0x1c, 0xaf, 0x9f, 0x1f, 0xe7, 0x2c, 0xef, 0x05,
  0x7e, 0x82, 0x94, 0x39, 0x57, 0x28, 0x17, 0x78, 0x77, 0xe1, 0x2c, 0xc9,
  0xaf, 0x10, 0xf5, 0x93, 0x91, 0x80, 0xd2, 0x34, 0x43, 0xc8, 0x85, 0x16,
  0xbb, 0x78, 0x26, 0x78, 0xaf, 0xfe, 0xd8, 0x17, 0x1b, 0x3e, 0x24, 0xd3,
  0x25, 0xdf, 0x73, 0x42, 0x1e, 0x51, 0xb7, 0x3f, 0x89, 0xd4, 0x1d, 0x32,
  0xa7, 0x95, 0xa0, 0x7d, 0x6c, 0xde, 0xcd, 0xd3, 0xe9, 0xeb, 0x29, 0xc9,
  0x09, 0x0f, 0xdd, 0x48, 0x43, 0x6e, 0x34, 0x06, 0xa3, 0x54, 0x39, 0x02,
  0x81, 0x03, 0xe3, 0xeb, 0xe5, 0xfc, 0xc6, 0xee, 0xf9, 0x29, 0xc9, 0x89,
  0x45, 0x84, 0xb8, 0xea, 0x5a, 0x73, 0xdd, 0xa0, 0xb3, 0x3f, 0x86, 0x6d,
  0xb7, 0xae, 0xb2, 0x44, 0x06, 0x72, 0x84, 0x5c, 0xe0, 0x43, 0x71, 0xfc,
  0x56, 0xdd, 0x12, 0x5f, 0xf4, 0xcc, 0x5b, 0x58, 0x06, 0xa6, 0xeb, 0xb8,
  0x79, 0x0e, 0xbd, 0xc0, 0x0c, 0x9b, 0xb7, 0x6b, 0x50, 0xfc, 0x0c, 0xc4,
  0x7e, 0xfa, 0xe6, 0x22, 0xf3, 0x5a, 0x8e, 0x33, 0x91, 0xb7, 0x31, 0x70,
  0xa1, 0x77, 0xef, 0x8e, 0x72, 0xa1, 0xeb, 0x38, 0x6f, 0x85, 0xc9, 0x2c,
  0xe8, 0x1a, 0x16, 0x26, 0xe5, 0xde, 0x4d, 0x09, 0x88, 0xba, 0xea, 0xbb,
  0x13, 0xf7, 0x36, 0x0c, 0xcc, 0xab, 0xf9, 0xab, 0x8d, 0x20, 0x06, 0xd1,
  0x59, 0x26, 0x91, 0xb6, 0x18, 0xc5, 0x0a, 0x0d, 0xc9, 0x4d, 0x7a, 0x12,
  0x75, 0x2f, 0xb3, 0x6c, 0x14, 0xe7, 0x5d, 0xdd, 0x42, 0xb8, 0x4e, 0x47,
  0x6a, 0x18, 0xd2, 0xb0, 0x11, 0x4c, 0xe7, 0x0b, 0x7a, 0xae, 0x4e, 0xa1,
  0xa3, 0xb8, 0xa2, 0xca, 0x87, 0xe7, 0xee, 0x31, 0x8e, 0x7c, 0xa1, 0x52,
  0x73, 0xa9, 0x56, 0x59, 0x48, 0x87, 0x53, 0x5c, 0xb8, 0x35, 0x4b, 0x3f,
  0x3b, 0x9a, 0xd4, 0x61, 0xbb, 0xc8, 0x1b, 0xdd, 0xf3, 0x1d, 0x8e, 0x08,
  0x49, 0xa2, 0xad, 0x22, 0x4b, 0x6e, 0xc3, 0x38, 0xd9, 0xdf, 0x8f, 0x58,
  0x78, 0xd9, 0x68, 0x43, 0x0f, 0x70, 0x7f, 0xc8, 0x3c, 0x5c, 0x38, 0xaf,
  0xc4, 0x5f, 0x45, 0x16, 0xcc, 0xdb, 0xe0, 0x71, 0x2d, 0xb1, 0x23, 0x3d,
  0x9e, 0x21, 0x82, 0x74, 0xf4, 0x8c, 0xcc, 0x93, 0x3b, 0xf5, 0x73, 0x31,
  0x73, 0xe5, 0xab, 0x80, 0xf9, 0xb6, 0x58, 0x63, 0xc6, 0xb8, 0x30, 0x0b,
  0x0b, 0x69, 0xaa, 0xeb, 0x03, 0xbc, 0x04, 0xd8, 0xb9, 0x7f, 0x51, 0x52,
  0x13, 0xea, 0xcd, 0xc4, 0xc9, 0x96, 0xb1, 0x2d, 0x05, 0x84, 0xd4, 0x22,
  0xfa, 0xc2, 0x51, 0x2f, 0xf1, 0xa4, 0x88, 0xb1, 0x91, 0x80, 0x39, 0x4e,
  0x52, 0x90, 0xf0, 0xfc, 0x91, 0x2c, 0x89, 0xe3, 0xfe, 0x0d, 0x32, 0x71,
  0x5c, 0xf4, 0xd7, 0x50, 0x4a, 0xcf, 0xad, 0xb0, 0x5e, 0x69, 0x12, 0x82,
  0xab, 0x14, 0xea, 0x42, 0x9b, 0xd2, 0x46, 0x18, 0x84, 0xe8, 0x20, 0xbc,
  0xca, 0x30, 0x08, 0xb9, 0x18, 0x1c, 0x52, 0x37, 0x99, 0xd9, 0x17, 0x70,
  0x2e, 0x98, 0x19, 0x6b, 0x10, 0xad, 0xef, 0x59, 0x48, 0xd4, 0xa7, 0x83,
  0xed, 0xcf, 0x06, 0x5b, 0x1b, 0x4d, 0x41, 0x09, 0x1c, 0x77, 0xff, 0xab,
  0x23, 0x35, 0x62, 0xa4, 0x31, 0xc7, 0xab, 0x73, 0x37, 0x32, 0x1d, 0xcd,
  0x1e, 0x30, 0x42, 0x22, 0x65, 0x45, 0x28, 0x2e, 0xae, 0xc4, 0x85, 0x39,
  0x55, 0x9e, 0x97, 0x5a, 0x14, 0x85, 0xd8, 0xd8, 0x73, 0x26, 0x11, 0x89,
  0xb1, 0x71, 0x0d, 0x17, 0x65, 0x10, 0x07, 0x1e, 0xbd, 0xd6, 0xb5, 0x43,
  0xd7, 0xcc, 0x1c, 0xd8, 0x51, 0x17, 0xc3, 0xf2, 0x47, 0xcb, 0x05, 0xae,
  0xd5, 0xb0, 0x2c, 0xfa, 0x5d, 0x96, 0x6c, 0x8c, 0xa4, 0xd8, 0x5d, 0x6b,
  0x58, 0x06, 0xd0, 0x7f, 0x7b, 0x2a, 0x93, 0xc4, 0x48, 0x78, 0xef, 0x27,
  0x7a, 0x71, 0x8b, 0x99, 0x84, 0x62, 0x86, 0x48, 0x36, 0x22, 0x98, 0xc4,
  0x2b, 0x9a, 0xe3, 0x89, 0xfd, 0x37, 0x35, 0xb9, 0x8f, 0x89, 0xc0, 0x59,
  0xfe, 0x83, 0x81, 0x4c, 0x75, 0x4f, 0x6b, 0xca, 0x47, 0x5d, 0xf1, 0x27,
  0x71, 0xc3, 0x33, 0xea, 0xc2, 0x55, 0x48, 0x36, 0x7d, 0x2d, 0x39, 0x44,
  0x5f, 0x44, 0x7a, 0xd4, 0xd9, 0x48, 0xaa, 0xf1, 0x8e, 0x3e, 0xdc, 0x1b,
  0x83, 0xc7, 0x65, 0x8c, 0x65, 0x68, 0x6f, 0x0e, 0x4e, 0xe3, 0x70, 0xf5,
  0x84, 0xfc, 0x38, 0xa2, 0xb2, 0x90, 0x7c, 0x9c, 0x86, 0x9b, 0xee, 0xf5,
  0xd3, 0xab, 0xf7, 0x2b, 0x17, 0xef, 0x89, 0xd5, 0xbb, 0x40, 0x78, 0x2c,
  0x09, 0x09, 0x88, 0x88, 0x78, 0x1d, 0xb8, 0xe8, 0x59, 0x23, 0x95, 0x00,
  0x32, 0xef, 0xf3, 0xac, 0x1e, 0xcd, 0xc0, 0xac, 0xf0, 0xfa, 0x37, 0xdb,
  0x75, 0x50, 0xa3, 0x8d, 0xbe, 0xbd, 0x39, 0xd1, 0x2f, 0x69, 0xf0, 0x61,
  0x84, 0x9c, 0x5e, 0xca, 0x78, 0x9d, 0x7a, 0x4b, 0xee, 0x17, 0x62, 0x54,
  0xc5, 0xc5, 0x3b, 0x4a, 0xda, 0xa4, 0xb9, 0x8a, 0x50, 0x37, 0xb1, 0x4b,
  0xb5, 0x31, 0xbf, 0x2f, 0x8c, 0x8b, 0x3f, 0x39, 0xb9, 0x8a, 0x47, 0x1f,
  0xb1, 0x24, 0xe1, 0xd5, 0x2e, 0xdc, 0x52, 0xf4, 0xe9, 0x16, 0xeb, 0x8c,
  0x71, 0x32, 0x1f, 0xb4, 0xc7, 0xe4, 0x68, 0xdc, 0x7d, 0xa3, 0x57, 0x5d,
  0xb0, 0x58, 0xa5, 0x5e, 0x71, 0xb9, 0xac, 0x5e, 0xab, 0x94, 0x57, 0xca,
  0xb6, 0x8f, 0x35, 0x97, 0xd6, 0xed, 0xfb, 0xdf, 0x7d, 0x8a, 0x70, 0x89,
  0xb9, 0x28, 0x3f, 0x4c, 0x53, 0x4d, 0xa7, 0x9e, 0x28, 0xae, 0xe0, 0x9a,
  0x9c, 0x47, 0xa4, 0xb8, 0xc1, 0xe8, 0x76, 0xb5, 0x8a, 0x09, 0xe0, 0x82,
  0x62, 0x7b, 0x1f, 0x1b, 0x48, 0xa6, 0x90, 0x8d, 0x52, 0x89, 0xcf, 0x7d,
  0xed, 0xf5, 0x99, 0x3e, 0x82, 0x53, 0x94, 0x68, 0x85, 0x12, 0x1f, 0x21,
  0x56, 0x47, 0x9e, 0x21, 0x65, 0x8a, 0x37, 0xd9, 0x4f, 0xb9, 0x85, 0x02,
  0xcd, 0x0f, 0xda, 0x7e, 0xdb, 0x89, 0x3b, 0xbd, 0x10, 0x47, 0xf1, 0x81,
  0x38, 0x4c, 0x57, 0x79, 0x8a, 0xe3, 0xe0, 0x9b, 0xa6, 0xdf, 0xcb, 0x2e,
  0x39, 0x36, 0xe5, 0x41, 0xe2, 0x44, 0xd4, 0x3c, 0xad, 0xf8, 0x5d, 0x96,
  0xab, 0x15, 0x6d, 0x94, 0x80, 0xeb, 0xf3, 0x11, 0xcd, 0xe0, 0x09, 0x61,
  0xbb, 0x2c, 0x07, 0x73, 0x35, 0xc3, 0x4c, 0xd8, 0xce, 0x1a, 0xc1, 0x47,
  0x3e, 0x50, 0xa3, 0x95, 0xc6, 0xa3, 0xb4, 0x47, 0xa0, 0x48, 0xee, 0x43,
  0xd4, 0x5f, 0x6a, 0x40, 0x6a, 0xbb, 0x93, 0x09, 0xd1, 0xa5, 0x92, 0xaa,
  0x29, 0x4b, 0x69, 0x3c, 0x82, 0x87, 0x18, 0x38, 0x47, 0xcc, 0x87, 0xfc,
  0x88, 0xcf, 0x18, 0xaf, 0xfa, 0x08, 0x37, 0x36, 0x18, 0x58, 0x92, 0xa2,
  0xca, 0x04, 0x83, 0x95, 0xe1, 0x13, 0x4f, 0x9b, 0xae, 0xfc, 0x15, 0x99,
  0x8d, 0xe9, 0x98, 0xe4, 0x48, 0x5b, 0x6b, 0xa8, 0x6a, 0x37, 0x89, 0x58,
  0x59, 0xc4, 0x93, 0x3a, 0x4e, 0xaa, 0x7b, 0x8e, 0x68, 0xf2, 0x7e, 0xb2,
  0xc8, 0xcb, 0x96, 0xd8, 0x66, 0x09, 0xcf, 0xf4, 0x79, 0x13, 0xf2, 0xb4,
  0xb8, 0xef, 0x7c, 0x08, 0xf5, 0xe1, 0xd9, 0xf9, 0x05, 0x26, 0x7a, 0xcc,
  0xbf, 0xa8, 0xc1, 0xb1, 0x3e, 0x0e, 0x58, 0x1d, 0x34, 0x7e, 0x92, 0xa3,
  0x96, 0x12, 0xd8, 0x6a, 0x5c, 0x0a, 0xcf, 0x20, 0xc8, 0x03, 0x72, 0x19,
  0x2a, 0xf1, 0xf4, 0x8e, 0x93, 0x3d, 0x20, 0xd2, 0x35, 0xd6, 0xd6, 0xe5,
  0x0a, 0xf1, 0x48, 0x78, 0x08, 0x3d, 0xb9, 0x2f, 0x31, 0x08, 0xb5, 0xb3,
  0x8a, 0x50, 0x71, 0x76, 0xca, 0x5f, 0xb2, 0x49, 0x5d, 0x14, 0xcd, 0x95,
  0xee, 0xc5, 0x4a, 0x88, 0x34, 0x37, 0xcb, 0x6f, 0x46, 0x39, 0x12, 0xb1,
  0x62, 0x1a, 0xca, 0xa0, 0x36, 0x55, 0x84, 0xee, 0xdf, 0x97, 0x41, 0xba,
  0xad, 0x69, 0xa0, 0x90, 0xf6, 0x4c, 0x12, 0xa4, 0x06, 0x90, 0x9f, 0xc2,
  0x13, 0xb6, 0x94, 0xac, 0x1e, 0x74, 0x77, 0xbe, 0xf8, 0x10, 0xeb, 0xc9,
  0xd1, 0xfe, 0xdc, 0xa9, 0xc6, 0x53, 0xd7, 0x95, 0x19, 0x36, 0x84, 0x4a,
  0x8e, 0x40, 0x24, 0x9a, 0x7a, 0x74, 0xa9, 0xa6, 0xc6, 0x78, 0x9a, 0x96,
  0x0f, 0x22, 0xe2, 0x8f, 0xe4, 0x3e, 0x55, 0xc3, 0xcf, 0xdc, 0xac, 0xad,
  0x93, 0xb4, 0xed, 0x10, 0xd2, 0x70, 0x30, 0x39, 0xdd, 0xad, 0x06, 0x15,
  0x56, 0x93, 0xf9, 0x5e, 0x0e, 0xb6, 0x98, 0xcc, 0x99, 0x4a, 0x4c, 0x7c,
  0x5b, 0xaa, 0xf0, 0x46, 0x3c, 0x66, 0x9a, 0x8e, 0x53, 0x56, 0x92, 0x6c,
  0x84, 0xbc, 0x48, 0xf5, 0xed, 0xe2, 0x14, 0x06, 0x3d, 0x0c, 0xf3, 0x4c,
  0x1a, 0x4a, 0xc1, 0x23, 0x69, 0x02, 0xb1, 0x24, 0x77, 0x55, 0xa9, 0xb1,
  0x9d, 0x4a, 0x8b, 0xdb, 0x56, 0x2a, 0x15, 0x32, 0x0d, 0xd4, 0x5f, 0xa3,
  0xd4, 0x26, 0xa9, 0x0e, 0xbf, 0x75, 0x26, 0xf1, 0x96, 0x88, 0x4d, 0x21,
  0x50, 0x3e, 0xeb, 0xab, 0x28, 0x54, 0xa9, 0xc3, 0x67, 0x51, 0x29, 0x91,
  0x3e, 0x4a, 0xa5, 0x18, 0x93, 0xd0, 0x29, 0xf5, 0xaf, 0xc4, 0x79, 0xb6,
  0x37, 0xfc, 0x36, 0x20, 0xcb, 0xe0, 0xcc, 0xf7, 0x24, 0x17, 0xa3, 0x61,
  0x49, 0x43, 0xb6, 0x4c, 0x6e, 0x81, 0x47, 0xdc, 0xd6, 0x87, 0xee, 0x5b,
  0x71, 0xfb, 0x1b, 0xed, 0x1b, 0x35, 0xf4, 0xd8, 0xbe, 0x15, 0xb7, 0xc1,
  0xbe, 0xd5, 0x02, 0xc5, 0xc4, 0x79, 0x5b, 0x57, 0x09, 0xbe, 0x83, 0x43,
  0x56, 0x53, 0xa7, 0x24, 0xfb, 0x31, 0x88, 0x3c, 0xab, 0x26, 0x9c, 0x22,
  0x0e, 0x6e, 0xad, 0x35, 0x16, 0xda, 0x62, 0x83, 0xe8, 0x77, 0x89, 0x53,
  0x54, 0xc6, 0x00, 0xb6, 0xe3, 0xec, 0x23, 0xa5, 0x85, 0xd0, 0x71, 0xbb,
  0xda, 0xcd, 0x5a, 0xcb, 0x25, 0x1a, 0x6b, 0xe8, 0x6c, 0x0a, 0x27, 0x2b,
  0xdb, 0x68, 0xe9, 0x4d, 0x6a, 0x65, 0xa0, 0x01, 0xad, 0x45, 0x28, 0x83,
  0xd8, 0x70, 0x25, 0xb4, 0xae, 0xa9, 0xde, 0xcd, 0x45, 0x28, 0x84, 0x01,
  0xc7, 0x72, 0x6b, 0x39, 0x3a, 0x20, 0x4c, 0xda, 0xf3, 0xe1, 0x64, 0xb0,
  0x13, 0xfa, 0x28, 0xc2, 0x56, 0x3e, 0xf5, 0x07, 0x08, 0x1c, 0x2b, 0xe2,
  0xfc, 0x78, 0x05, 0x24, 0x75, 0x87, 0x2d, 0x5d, 0xca, 0x14, 0xc0, 0x15,
  0x9a, 0x7e, 0x99, 0x4a, 0x3c, 0x61, 0x63, 0x65, 0xe1, 0xde, 0x50, 0x9f,
  0x13, 0x35, 0xac, 0x01, 0x72, 0x49, 0xe8, 0x5d, 0x72, 0x81, 0x21, 0x62,
  0x17, 0x88, 0xd1, 0xda, 0xbc, 0x48, 0x27, 0x9c, 0xaf, 0x5f, 0xe7, 0x62,
  0xb8, 0xd6, 0x3b, 0xba, 0x5c, 0x1d, 0x8d, 0xe1, 0x58, 0xca, 0x5b, 0x1c,
  0x8b, 0x08, 0xfb, 0x56, 0x9e, 0xfc, 0x8e, 0xbe, 0x9c, 0x84, 0x56, 0x0c,
  0xd9, 0x5e, 0x4c, 0x8d, 0x24, 0x0e, 0x3d, 0x6e, 0x97, 0x47, 0x4c, 0xed,
  0xb9, 0x3e, 0x7e, 0x16, 0x5f, 0x25, 0x9c, 0x13, 0x26, 0xce, 0x6d, 0x1f,
  0xbc, 0xf1, 0x58, 0xf2, 0xc9, 0xa3, 0xb9, 0x1b, 0x95, 0x6c, 0x0d, 0x64,
  0xdc, 0xf8, 0x5c, 0x0d, 0x5d, 0xfc, 0x66, 0x80, 0xa7, 0x4b, 0xfb, 0xaa,
  0x84, 0xd2, 0xba, 0x3c, 0x6b, 0x31, 0x78, 0x74, 0xfe, 0xc2, 0x1e, 0xba,
  0x8e, 0x0d, 0xd0, 0x4d, 0xb9, 0x19, 0xd2, 0xc4, 0x8f, 0x78, 0x35, 0xa9,
  0xea, 0xd7, 0x33, 0xb7, 0xbd, 0xf3, 0xb9, 0xf2, 0xf3, 0x38, 0x4e, 0xc4,
  0x9c, 0x48, 0xf2, 0xa8, 0xdf, 0x2a, 0x24, 0x89, 0x00, 0xb6, 0x23, 0x3a,
  0xd6, 0x61, 0xed, 0xea, 0xc9, 0x10, 0xcd, 0xcf, 0x06, 0xa5, 0x29, 0x2f,
  0x21, 0x37, 0x8a, 0xa7, 0x0c, 0x4a, 0x50, 0xb7, 0x7f, 0xb3, 0x60, 0xef,
  0xc2, 0xff, 0x59, 0xa1, 0xe6, 0x01, 0xc5, 0xac, 0x60, 0xa4, 0xc8, 0x4a,
  0x77, 0xd3, 0xfa, 0x3d, 0x7d, 0x7f, 0xc9, 0xfc, 0x8a, 0x53, 0xc2, 0x5e,
  0xb5, 0x46, 0x9c, 0x24, 0x53, 0x9f, 0x29, 0x69, 0x71, 0x69, 0xe3, 0xfc,
  0x61, 0xc1, 0xdc, 0x55, 0xde, 0x53, 0x26, 0xc4, 0x5c, 0x52, 0xa2, 0xcf,
  0x82, 0x94, 0xda, 0x41, 0x8b, 0xcb, 0xd5, 0x75, 0x28, 0x81, 0x79, 0x7c,
  0x6b, 0x2c, 0x68, 0xb9, 0x10, 0x25, 0xa0, 0x9f, 0xc1, 0x41, 0xbd, 0x4c,
  0xa7, 0x13, 0x09, 0xc0, 0xf1, 0x08, 0x05, 0x0d, 0xff, 0x01, 0x37, 0x54,
  0x0c, 0xaa, 0x29, 0x17, 0x48, 0x9c, 0x84, 0xa4, 0xb1, 0xce, 0x96, 0x87,
  0x39, 0xcd, 0x7d, 0xc3, 0xee, 0x46, 0x7d, 0x43, 0xc3, 0xbd, 0xeb, 0x17,
  0xc1, 0x6d, 0x9c, 0x4e, 0x71, 0x4d, 0x50, 0x33, 0xf9, 0x72, 0x8e, 0xde,
  0xab, 0x2b, 0x75, 0x9b, 0xe6, 0xd9, 0x7c, 0xd6, 0xd4, 0xcc, 0xd7, 0xcf,
  0x8f, 0x86, 0xfb, 0xd1, 0xe9, 0x30, 0x3a, 0x3d, 0x39, 0xfe, 0x61, 0x83,
  0x96, 0x0d, 0x71, 0x9b, 0xc8, 0xf8, 0xe7, 0xae, 0x83, 0x17, 0xa3, 0xdb,
  0x38, 0x4f, 0xa1, 0x68, 0x58, 0x7a, 0x69, 0x8b, 0x81, 0x4f, 0x72, 0xd0,
  0x41, 0xd8, 0x77, 0xb6, 0xc5, 0x3e, 0xc8, 0x0c, 0x70, 0x0b, 0x45, 0xca,
  0xcc, 0x0f, 0x01, 0x57, 0x30, 0xd1, 0x8e, 0x2d, 0x15, 0x6a, 0xd9, 0xcc,
  0xcc, 0x61, 0x3b, 0x4e, 0x78, 0xaa, 0x25, 0x1c, 0xe8, 0x3a, 0xbe, 0xe5,
  0xee, 0x69, 0xa2, 0x35, 0xff, 0x38, 0x4d, 0xf4, 0x4a, 0x34, 0xb2, 0xf6,
  0xeb, 0x2c, 0x8c, 0xf7, 0x7c, 0x50, 0xdd, 0x86, 0xad, 0xc5, 0xf0, 0x2b,
  0x69, 0x1a, 0x31, 0x47, 0x27, 0x97, 0x79, 0xb6, 0x20, 0x8e, 0xfc, 0x55,
  0xcc, 0x2c, 0x0f, 0x33, 0x3d, 0x88, 0x93, 0x59, 0xc3, 0x87, 0x5b, 0x64,
  0xe3, 0x9b, 0xa4, 0x34, 0x0d, 0x53, 0xfe, 0x0a, 0x12, 0x7f, 0xa0, 0xa9,
  0x08, 0xdf, 0xe4, 0x05, 0x9d, 0xd0, 0x9d, 0xa4, 0x04, 0xc4, 0x24, 0x47,
  0x43, 0x69, 0x1a, 0xcc, 0x2c, 0x9f, 0xbe, 0x1a, 0xe4, 0xc5, 0xa7, 0x09,
  0xef, 0xcb, 0xd4, 0xea, 0x61, 0x5d, 0xfd, 0x43, 0xbe, 0x6a, 0xd8, 0x1f,
  0xfa, 0x8a, 0xff, 0x15, 0x5b, 0x5f, 0xf2, 0xe3, 0xae, 0x29, 0x45, 0x3f,
  0xb7, 0x2f, 0x43, 0x33, 0xd0, 0xb8, 0x7a, 0x9f, 0x07, 0x6d, 0x69, 0x90,
  0x12, 0xb3, 0x97, 0xab, 0x66, 0x1a, 0x89, 0xcb, 0x67, 0xd2, 0x50, 0x26,
  0x5a, 0x51, 0xe0, 0xf7, 0x44, 0x12, 0xb7, 0x3d, 0x14, 0x16, 0x13, 0x36,
  0x67, 0xd1, 0xb1, 0x74, 0xdf, 0x9e, 0x1d, 0xbe, 0x5d, 0x11, 0xa0, 0x64,
  0x31, 0x42, 0x32, 0x5d, 0x62, 0x0d, 0x4e, 0x0f, 0x95, 0x24, 0x40, 0x37,
  0xd2, 0x5a, 0xee, 0x64, 0xad, 0xb9, 0xbf, 0x2f, 0x19, 0x0f, 0x65, 0xa2,
  0x01, 0xda, 0x99, 0xd9, 0x06, 0x5c, 0xc2, 0x71, 0x3d, 0xbd, 0xd2, 0xd2,
  0x7b, 0x81, 0x93, 0x50, 0x34, 0x2c, 0xf9, 0x9d, 0x60, 0x1e, 0x1d, 0x0d,
  0x74, 0x09, 0x42, 0x81, 0x88, 0x21, 0x70, 0xca, 0x47, 0x74, 0x93, 0x3c,
  0xb8, 0x30, 0x48, 0xfb, 0x8c, 0x97, 0xa0, 0xb9, 0x76, 0xba, 0x24, 0x48,
  0xb9, 0xa5, 0x5f, 0xe6, 0xac, 0x7e, 0xfe, 0x21, 0xc2, 0xfe, 0x47, 0xba,
  0xad, 0x16, 0xfc, 0xcc, 0x8d, 0x96, 0x1e, 0xab, 0x83, 0x13, 0x76, 0x1b,
  0x49, 0x0b, 0x0e, 0x09, 0x67, 0xfa, 0xd0, 0xc6, 0x7a, 0x45, 0xaa, 0x29,
  0xc0, 0xa4, 0x34, 0x77, 0xb9, 0x28, 0x2d, 0xdc, 0x16, 0xb1, 0xc8, 0xd3,
  0x74, 0x94, 0x23, 0xc0, 0x41, 0x84, 0xa3, 0x30, 0x57, 0xa0, 0x11, 0x98,
  0xe6, 0x09, 0x88, 0xd5, 0xf7, 0x74, 0x7c, 0x83, 0x93, 0xa4, 0x1c, 0x2b,
  0xdc, 0x70, 0x93, 0xf7, 0x04, 0x09, 0x47, 0xbb, 0xab, 0x4b, 0xf7, 0x71,
  0x19, 0x33, 0x12, 0x06, 0x87, 0xae, 0xa7, 0x73, 0xb1, 0x6a, 0x63, 0xab,
  0x42, 0x1e, 0xe4, 0x98, 0x10, 0x02, 0xa7, 0xdf, 0x1f, 0x1c, 0x9d, 0x2b,
  0xb3, 0x1c, 0x3d, 0xac, 0x08, 0x80, 0x8f, 0x36, 0x93, 0x72, 0xbc, 0xb9,
  0xb8, 0x49, 0x37, 0xe7, 0x45, 0x31, 0x19, 0x6d, 0x84, 0x69, 0xb9, 0x3c,
  0x67, 0x22, 0xc0, 0xe8, 0xec, 0x9b, 0xfd, 0xe1, 0x47, 0xdb, 0xdb, 0x1c,
  0xc9, 0xbf, 0xa4, 0xa6, 0xd7, 0x69, 0x0d, 0x1a, 0xf9, 0x46, 0x05, 0x2d,
  0xfb, 0x6c, 0x50, 0x64, 0x1b, 0x10, 0xb1, 0x1d, 0xc3, 0xc5, 0x2a, 0x71,
  0x1b, 0xe2, 0x5b, 0xd3, 0x6c, 0x1c, 0x36, 0x88, 0xb5, 0x04, 0x4a, 0xfc,
  0x96, 0x71, 0x2f, 0xb4, 0xba, 0x70, 0xc0, 0x47, 0xaf, 0xf8, 0xdf, 0xf6,
  0x23, 0x1e, 0x9e, 0x71, 0x60, 0x98, 0x54, 0xf6, 0x84, 0x5f, 0x56, 0xd1,
  0xfe, 0x36, 0x9d, 0x54, 0x4f, 0x7c, 0x33, 0x02, 0x8a, 0xbd, 0x91, 0x34,
  0xcf, 0x5e, 0x74, 0x70, 0x78, 0x0e, 0x82, 0x3c, 0x3c, 0xf9, 0x0a, 0xc2,
  0x21, 0x67, 0x2c, 0x5d, 0xcd, 0xd3, 0x5f, 0x98, 0xd3, 0x51, 0x93, 0x85,
  0x2c, 0x30, 0xdf, 0x65, 0xfe, 0x84, 0xd6, 0x9a, 0xe3, 0xf5, 0xe2, 0x55,
  0xc4, 0x19, 0xfb, 0x7d, 0x97, 0x29, 0x16, 0xc6, 0xb8, 0xbf, 0x17, 0xce,
  0xee, 0x37, 0x62, 0x88, 0xf4, 0x14, 0x8d, 0x88, 0x8e, 0x62, 0x9b, 0x2f,
  0x77, 0x91, 0xa8, 0x77, 0xdc, 0xc5, 0x6d, 0x32, 0x6d, 0xa8, 0xdb, 0xc1,
  0xe3, 0x99, 0x54, 0x07, 0x86, 0x94, 0xe2, 0x46, 0x84, 0xa3, 0xff, 0x7e,
  0xbd, 0xd8, 0xa8, 0x31, 0x4f, 0xc7, 0x2e, 0x4f, 0x4c, 0xe7, 0xad, 0x1e,
  0xf1, 0xa6, 0x5a, 0xc1, 0x13, 0x8b, 0xdd, 0xf1, 0xb0, 0x8c, 0x2a, 0xac,
  0x78, 0x4f, 0x9c, 0x26, 0x95, 0xa5, 0xa7, 0x3d, 0x55, 0x99, 0x53, 0x2f,
  0xb5, 0x46, 0xf2, 0x4d, 0x09, 0x2b, 0x20, 0x5b, 0x69, 0x83, 0x36, 0x1b,
  0x9b, 0x8a, 0x61, 0x39, 0x5a, 0xd1, 0xf0, 0xbe, 0x16, 0xe9, 0x42, 0xdd,
  0xcb, 0x51, 0x77, 0x9f, 0x44, 0xda, 0xf7, 0xfb, 0x7b, 0xef, 0xbf, 0x7c,
  0x77, 0x72, 0x70, 0x7c, 0xd8, 0xad, 0x53, 0xe4, 0xa5, 0x49, 0x4d, 0x92,
  0xc0, 0xd4, 0xb3, 0x1c, 0xe3, 0x30, 0x5a, 0x0d, 0xb7, 0x3b, 0x52, 0x08,
  0xf1, 0x1b, 0x92, 0xa5, 0x74, 0xc1, 0x1b, 0x46, 0x9c, 0xf9, 0x04, 0x69,
  0x5c, 0xc1, 0xe4, 0x2d, 0x72, 0x5f, 0x9d, 0x3e, 0x36, 0xc0, 0x16, 0x1d,
  0x97, 0xe9, 0x8f, 0xee, 0x67, 0x12, 0xb1, 0x03, 0x3c, 0x85, 0x00, 0x73,
  0xa7, 0x22, 0xba, 0x23, 0x98, 0xc1, 0x00, 0xd2, 0x22, 0x1a, 0x4f, 0xcb,
  0x76, 0x5b, 0x0c, 0xa5, 0x5b, 0x0c, 0x6e, 0x8c, 0x88, 0xb9, 0xaf, 0xe3,
  0x1c, 0xe7, 0x65, 0x97, 0x1d, 0xc0, 0xa9, 0x40, 0x09, 0xf9, 0xbc, 0xf6,
  0xa6, 0xe9, 0xde, 0x47, 0xa8, 0xc5, 0x42, 0xdc, 0x83, 0xe4, 0x3e, 0x41,
  0x74, 0x82, 0x72, 0xe2, 0x7d, 0xd8, 0x26, 0xcb, 0xe8, 0xbb, 0x2c, 0xbf,
  0x11, 0x59, 0xc7, 0xde, 0xe0, 0x90, 0xf5, 0xbc, 0x71, 0xc3, 0xc0, 0x56,
  0x4f, 0x2a, 0xc6, 0x04, 0x62, 0x5c, 0x46, 0x6f, 0x00, 0x23, 0xee, 0x6c,
  0xef, 0xe2, 0xeb, 0x56, 0x73, 0xa9, 0x47, 0x8a, 0x7b, 0xfa, 0xd2, 0x01,
  0x37, 0x2d, 0x57, 0x06, 0xcd, 0x3d, 0x71, 0xe3, 0x54, 0xcf, 0x52, 0xed,
  0xd2, 0x69, 0x11, 0x56, 0xb9, 0xf7, 0x95, 0xd7, 0x4e, 0x2b, 0x6d, 0xda,
  0x9d, 0xc3, 0x57, 0xce, 0xca, 0x1b, 0xa7, 0xf5, 0xc2, 0xb1, 0xd9, 0xf2,
  0x91, 0x75, 0xf7, 0x8d, 0x5d, 0x38, 0xff, 0x7b, 0xdc, 0x38, 0x31, 0x0e,
  0x51, 0x8d, 0x95, 0x7a, 0xfa, 0xfa, 0xf7, 0x99, 0x6a, 0x40, 0xab, 0x4d,
  0x3e, 0x23, 0x9c, 0x56, 0x2e, 0xac, 0xc4, 0xf4, 0xd6, 0x90, 0x75, 0xb6,
  0x33, 0xc6, 0x9e, 0x89, 0x61, 0x2b, 0x8f, 0x05, 0x5e, 0xbb, 0xe6, 0x6c,
  0xcb, 0x51, 0xc2, 0x3c, 0x23, 0xcf, 0xc6, 0x92, 0xf6, 0xe2, 0x95, 0x1c,
  0x22, 0xe2, 0xf7, 0x79, 0x72, 0x1d, 0x17, 0x1c, 0xd9, 0x5b, 0xa6, 0x6c,
  0xd5, 0xad, 0xab, 0x02, 0x4b, 0x0e, 0x7c, 0xf3, 0xf1, 0xbf, 0x96, 0x61,
  0x15, 0x69, 0xaa, 0xb0, 0x5f, 0x3f, 0xb1, 0x38, 0xb0, 0xf6, 0x63, 0x8b,
  0xc2, 0x3a, 0x7e, 0x5d, 0x7b, 0x1d, 0x1e, 0xf7, 0x43, 0x78, 0xad, 0x19,
  0x27, 0xc6, 0xc1, 0xb6, 0x9c, 0x5c, 0xd2, 0x74, 0xd3, 0x20, 0xe7, 0xca,
  0xf2, 0xf4, 0xf5, 0xa6, 0x4b, 0x2f, 0xdb, 0xd2, 0x42, 0xec, 0x5b, 0x30,
  0x15, 0xbd, 0x83, 0x0a, 0x01, 0xe0, 0xaa, 0x5f, 0x40, 0xbf, 0x1f, 0x05,
  0x5d, 0x72, 0xac, 0x1f, 0x51, 0x71, 0xbb, 0x59, 0xe7, 0x0d, 0x87, 0xec,
  0x17, 0xec, 0x7e, 0xe4, 0xa9, 0xad, 0x33, 0xe4, 0x8c, 0xa0, 0x1a, 0xb1,
  0xc5, 0x6f, 0x3a, 0xdd, 0x60, 0xd1, 0xdd, 0x12, 0x8a, 0x10, 0xc7, 0x5f,
  0x68, 0xf2, 0x4d, 0x53, 0x54, 0x31, 0x10, 0x1c, 0xc4, 0x22, 0x01, 0x8b,
  0x13, 0x33, 0x80, 0x9f, 0x0d, 0x06, 0x37, 0xb5, 0xa9, 0x02, 0x0f, 0x92,
  0x78, 0x2d, 0x9d, 0x57, 0xff, 0x65, 0xe3, 0x50, 0xc7, 0x53, 0xd9, 0xd3,
  0x4b, 0xc1, 0x91, 0x54, 0xab, 0x31, 0xf5, 0x7e, 0x34, 0x37, 0x97, 0x95,
  0x78, 0xf2, 0x5d, 0xe8, 0xa6, 0xc0, 0xbe, 0xc9, 0x60, 0xeb, 0xca, 0x0d,
  0x52, 0xf8, 0xd8, 0x5b, 0x93, 0x4c, 0x53, 0xb1, 0x02, 0x5a, 0x76, 0x15,
  0xec, 0xca, 0x92, 0x82, 0x55, 0xb8, 0xd0, 0x4e, 0xfb, 0x92, 0xe3, 0x90,
  0xca, 0x66, 0xb6, 0x02, 0x5d, 0xd7, 0xeb, 0x92, 0x50, 0x03, 0xe8, 0x38,
  0xd1, 0x18, 0x2d, 0x92, 0x86, 0x47, 0x24, 0x5a, 0x08, 0x48, 0x67, 0xc3,
  0x92, 0x95, 0xc4, 0x9e, 0xd5, 0x66, 0xc2, 0x56, 0xb7, 0x9f, 0x50, 0xa6,
  0x60, 0xb9, 0x62, 0x0f, 0x4a, 0xb1, 0x7d, 0xc6, 0x65, 0x98, 0x26, 0x26,
  0xc9, 0x14, 0x3b, 0x3b, 0x2b, 0x6c, 0xbe, 0x9a, 0xd3, 0xa9, 0x01, 0x04,
  0x3c, 0xef, 0x7e, 0x11, 0x5f, 0x26, 0x76, 0x1c, 0x89, 0x94, 0x59, 0x78,
  0xcc, 0xc6, 0xb4, 0x76, 0x12, 0x7d, 0x83, 0xcf, 0xe6, 0x59, 0xd3, 0x5d,
  0xb3, 0x1c, 0xf3, 0x81, 0x64, 0x53, 0x80, 0x33, 0x68, 0xb2, 0x9b, 0x54,
  0x23, 0x20, 0xa2, 0x62, 0x9a, 0x2e, 0xf8, 0x94, 0xe6, 0xd9, 0xf2, 0x8a,
  0x33, 0x55, 0x12, 0x30, 0x17, 0xb9, 0x6a, 0x5b, 0x9c, 0x08, 0xb5, 0xd4,
  0x53, 0x48, 0xb6, 0xb7, 0xd9, 0x94, 0x0d, 0x9c, 0xeb, 0xb5, 0xf6, 0x9f,
  0x6f, 0x6d, 0x63, 0xb8, 0xcf, 0xb7, 0x3e, 0xad, 0xa4, 0x97, 0x72, 0xcc,
  0x72, 0x3c, 0x46, 0x6e, 0x41, 0xf4, 0x23, 0xdf, 0x1f, 0x3f, 0xb7, 0xfa,
  0x3d, 0x60, 0xa1, 0x8d, 0x61, 0x9a, 0xf5, 0x38, 0x0f, 0x37, 0x62, 0x96,
  0xef, 0xd8, 0xfb, 0xfc, 0x7a, 0x47, 0xed, 0x1a, 0xce, 0xa7, 0xd9, 0x82,
  0x9e, 0xe2, 0x94, 0x5f, 0xce, 0x15, 0x33, 0x46, 0x05, 0xb1, 0x5d, 0xf3,
  0xa2, 0x27, 0x1a, 0x57, 0x26, 0x9e, 0xd9, 0xcb, 0xcb, 0xd5, 0x36, 0x9a,
  0xbd, 0xfd, 0x7d, 0xef, 0x5a, 0xaa, 0xc6, 0x2c, 0x3d, 0xe3, 0x98, 0xa5,
  0x0f, 0x74, 0x79, 0x02, 0xac, 0xa3, 0xa7, 0x11, 0xc2, 0x30, 0x99, 0x57,
  0xf2, 0x1d, 0xcd, 0x3c, 0x59, 0xdf, 0x4e, 0x31, 0x57, 0x2e, 0x8b, 0xa4,
  0xbe, 0xa2, 0xab, 0x23, 0xf9, 0xeb, 0x40, 0x4e, 0xba, 0xa6, 0x1a, 0x4a,
  0xce, 0xa6, 0xcf, 0x4d, 0x9f, 0x00, 0x04, 0x11, 0x10, 0x61, 0xa4, 0xb1,
  0xb8, 0x13, 0x1b, 0x51, 0x2f, 0x3e, 0x06, 0x48, 0x24, 0x1f, 0x76, 0xb2,
  0xdc, 0x23, 0x15, 0x75, 0x1e, 0xc4, 0x3b, 0xeb, 0xcc, 0x4a, 0x5a, 0xa4,
  0x38, 0xe7, 0x58, 0x2c, 0xb6, 0x3a, 0x65, 0x79, 0x13, 0xfe, 0xc0, 0xe4,
  0x6d, 0xce, 0x7b, 0x60, 0x88, 0x90, 0x10, 0x1c, 0xc2, 0x3c, 0x46, 0x5e,
  0x16, 0xb4, 0xa8, 0xe3, 0x26, 0xd4, 0x64, 0x25, 0xfa, 0x3d, 0x9a, 0xa5,
  0x12, 0xa3, 0x18, 0x84, 0xd2, 0xd7, 0x17, 0x4c, 0x4f, 0xd8, 0x8f, 0xf2,
  0xb3, 0x9d, 0x06, 0x91, 0xa8, 0x93, 0x67, 0xec, 0x19, 0xe3, 0xe3, 0xab,
  0xaf, 0x48, 0xee, 0xa7, 0x04, 0x99, 0x79, 0x00, 0x0d, 0xce, 0xbd, 0x96,
  0x1b, 0x82, 0xed, 0x1f, 0xb5, 0xe6, 0xa8, 0xb5, 0xf5, 0xe1, 0x86, 0x99,
  0xd2, 0x71, 0xf9, 0x6a, 0x63, 0x71, 0x7e, 0xa5, 0x2c, 0xca, 0x85, 0x3f,
  0x06, 0xa1, 0x4e, 0xea, 0x06, 0xef, 0x37, 0xc4, 0xc8, 0x2b, 0xd1, 0x1c,
  0x38, 0x08, 0xe0, 0xb6, 0x25, 0x7a, 0x0c, 0x0a, 0xd2, 0xf8, 0x6e, 0xd2,
  0x1e, 0x4c, 0xa1, 0x80, 0x83, 0x99, 0x6e, 0xb5, 0xe6, 0xaa, 0xed, 0x7f,
  0x77, 0x10, 0x64, 0x82, 0xf1, 0x31, 0xc3, 0xa4, 0x40, 0x08, 0x12, 0x0f,
  0x34, 0x5f, 0x15, 0x9b, 0x61, 0x1a, 0x03, 0xc3, 0x5f, 0x03, 0x70, 0x60,
  0x92, 0x24, 0x0b, 0x97, 0xd3, 0x01, 0xc8, 0x0d, 0x01, 0xfb, 0x88, 0xe7,
  0x10, 0xf2, 0x1f, 0x10, 0xab, 0xf9, 0xb0, 0x62, 0x74, 0xea, 0x64, 0x1f,
  0x84, 0x58, 0x40, 0xc0, 0x5e, 0x3b, 0x7f, 0xb3, 0xbf, 0xfd, 0xe9, 0xb3,
  0xcf, 0x48, 0x4e, 0x7f, 0x40, 0x1a, 0x86, 0x5f, 0x32, 0x89, 0xbe, 0x5c,
  0x1d, 0x75, 0xa3, 0xf6, 0x25, 0x93, 0x31, 0x25, 0x05, 0x8d, 0xe8, 0x93,
  0x03, 0x00, 0x21, 0xf6, 0x08, 0x79, 0x36, 0xa3, 0x7a, 0x32, 0x5a, 0x44,
  0x5d, 0x30, 0xac, 0x17, 0x5d, 0xac, 0xbc, 0x4e, 0x72, 0xab, 0x0e, 0x02,
  0xca, 0x9c, 0x64, 0x11, 0xf2, 0x90, 0x88, 0x85, 0x9e, 0x1f, 0x5e, 0x9c,
  0x33, 0xd8, 0xf6, 0xc5, 0xe9, 0xf9, 0x8a, 0x50, 0x29, 0xba, 0x31, 0x99,
  0x2b, 0xf1, 0xa2, 0x31, 0xd1, 0x70, 0x3a, 0xb7, 0xa9, 0x58, 0x41, 0xca,
  0x00, 0x6f, 0x41, 0x2c, 0xa1, 0x72, 0x45, 0x6b, 0xa8, 0x7a, 0x10, 0xb1,
  0x5e, 0x54, 0xd0, 0x0c, 0xe8, 0x28, 0xd1, 0x39, 0x79, 0x6c, 0x62, 0xb2,
  0xe7, 0x8f, 0x53, 0x08, 0x26, 0xcc, 0xc4, 0xc8, 0x33, 0x76, 0xae, 0x1d,
  0x8c, 0x56, 0x61, 0xdc, 0x02, 0xed, 0x48, 0xee, 0xa5, 0x15, 0x14, 0x22,
  0x64, 0x95, 0x14, 0x81, 0x05, 0x51, 0x14, 0xb4, 0x8e, 0xf9, 0x9a, 0x3b,
  0x2c, 0xc4, 0xdf, 0x38, 0xb8, 0x80, 0x27, 0xe8, 0x97, 0x04, 0x86, 0x0d,
  0x3f, 0x61, 0x46, 0x6c, 0xc3, 0xf9, 0xd4, 0xf8, 0x01, 0xe3, 0x3a, 0x45,
  0x10, 0x25, 0x0a, 0x56, 0xb6, 0x62, 0x74, 0x5d, 0xec, 0x72, 0xd7, 0xb9,
  0xab, 0x33, 0xa5, 0x0e, 0xd9, 0x17, 0x92, 0x76, 0xa6, 0x25, 0xb2, 0x0b,
  0xba, 0x36, 0xaa, 0x6e, 0x9d, 0x97, 0xd0, 0xf5, 0xb2, 0xc2, 0x79, 0x8f,
  0xb8, 0x1d, 0xf6, 0x86, 0x8b, 0x7c, 0xe3, 0x12, 0xe1, 0x10, 0xf0, 0x8a,
  0xcf, 0x75, 0xc7, 0x00, 0x98, 0xce, 0x76, 0x5a, 0xa5, 0xd1, 0x86, 0x83,
  0x51, 0x36, 0x52, 0x9c, 0xea, 0xcb, 0x3a, 0x8f, 0xac, 0x7b, 0xc0, 0xdd,
  0x35, 0xa2, 0x18, 0x47, 0x75, 0xca, 0xe1, 0x4b, 0x44, 0x87, 0xce, 0xc9,
  0x9d, 0x96, 0xae, 0x51, 0xb9, 0xcd, 0xb6, 0x7f, 0xc5, 0x6d, 0xf6, 0xdb,
  0x05, 0xf0, 0x44, 0xef, 0xe6, 0x1a, 0x49, 0x33, 0xf7, 0x80, 0x24, 0x58,
  0x28, 0xe2, 0xb1, 0x2c, 0x95, 0x88, 0xf9, 0x7a, 0x92, 0xc5, 0xcd, 0x74,
  0x51, 0x03, 0xae, 0x86, 0x4e, 0x02, 0x45, 0xcf, 0xee, 0x0b, 0x6d, 0x49,
  0x43, 0x24, 0x73, 0xe0, 0x79, 0x4a, 0xbc, 0x0b, 0xab, 0xd3, 0x0d, 0xe9,
  0xc4, 0xb3, 0xd6, 0x7e, 0x99, 0x21, 0x9a, 0x2a, 0x7a, 0xa5, 0x6c, 0xe9,
  0xf3, 0xf6, 0x7d, 0x46, 0x12, 0x4a, 0x20, 0x1b, 0x19, 0x82, 0x30, 0x30,
  0xfe, 0x86, 0x6a, 0xf3, 0xa3, 0x69, 0x0c, 0x1d, 0x7b, 0x13, 0x61, 0xb6,
  0xd7, 0x48, 0x77, 0x32, 0xc4, 0x11, 0x2f, 0x63, 0x98, 0xb7, 0xda, 0x54,
  0x1a, 0xc8, 0x25, 0xc4, 0x6e, 0x2e, 0x96, 0x33, 0x5a, 0x83, 0xbb, 0x24,
  0x99, 0x74, 0x0b, 0x36, 0x79, 0x33, 0x26, 0x5c, 0x5d, 0x98, 0x64, 0x7a,
  0xc3, 0x16, 0x3b, 0xe9, 0x1f, 0x61, 0x67, 0xf0, 0x2c, 0x58, 0xd6, 0x49,
  0x6c, 0xb8, 0x60, 0x81, 0x26, 0xa3, 0x4e, 0xaa, 0xba, 0xf9, 0x7e, 0x78,
  0x74, 0x71, 0x18, 0xed, 0xbd, 0xbb, 0xf8, 0xba, 0x13, 0xe0, 0x3e, 0x06,
  0x2c, 0x0b, 0x57, 0x61, 0x49, 0xd7, 0xed, 0xad, 0xac, 0x35, 0x84, 0x32,
  0x71, 0x10, 0xb5, 0xa4, 0x7a, 0xd7, 0xec, 0xdc, 0x35, 0xfa, 0x7b, 0x31,
  0x78, 0xb1, 0x51, 0xdb, 0x18, 0xce, 0x4c, 0xc5, 0x61, 0xeb, 0xa7, 0x8b,
  0xa7, 0x43, 0xba, 0x58, 0x72, 0x36, 0x95, 0xf9, 0xe8, 0x8c, 0x01, 0x37,
  0x81, 0x80, 0x1a, 0x0c, 0xb7, 0x58, 0x5e, 0x71, 0xb8, 0x5f, 0x0b, 0xc8,
  0x13, 0x43, 0x11, 0x38, 0x79, 0x56, 0xe3, 0xb8, 0x69, 0x95, 0x41, 0x88,
  0x61, 0x8c, 0x8d, 0x74, 0xa6, 0x3b, 0x53, 0xf8, 0x3c, 0x94, 0x95, 0xce,
  0x29, 0xb6, 0x67, 0x18, 0xa2, 0x5d, 0x98, 0x35, 0xa9, 0xa8, 0xd0, 0x3e,
  0x35, 0x29, 0x18, 0x71, 0x23, 0xa5, 0xd6, 0x12, 0x57, 0x20, 0xad, 0x19,
  0xce, 0xf8, 0x58, 0x65, 0x95, 0xb0, 0xaf, 0xca, 0x82, 0x3e, 0x1f, 0xec,
  0x6c, 0xb4, 0x6a, 0x1b, 0x7a, 0x98, 0x59, 0x36, 0xa6, 0xc3, 0x48, 0x3a,
  0x32, 0x1f, 0x0f, 0x52, 0x85, 0x25, 0xb8, 0x0c, 0xe7, 0x84, 0xfa, 0x40,
  0x7c, 0x8f, 0x1d, 0x78, 0x3b, 0x59, 0x4d, 0x0c, 0x17, 0x5e, 0xa2, 0xfa,
  0x81, 0x22, 0x5d, 0x7e, 0x45, 0x6c, 0x93, 0x18, 0x2b, 0xb0, 0x4d, 0xa4,
  0xb5, 0x6f, 0x5e, 0x1c, 0x0f, 0xdd, 0x7c, 0x58, 0x38, 0xad, 0xac, 0xdb,
  0x39, 0x33, 0x99, 0x52, 0x50, 0x9b, 0x1a, 0xf7, 0xf4, 0xbc, 0xaf, 0xa0,
  0x88, 0x01, 0x74, 0x84, 0x66, 0x6d, 0x3a, 0xd2, 0x77, 0xa2, 0xab, 0xfa,
  0x54, 0x23, 0xeb, 0xb3, 0x81, 0xac, 0xe9, 0xc3, 0x20, 0x75, 0xf8, 0x7d,
  0x5b, 0x5d, 0x89, 0x17, 0xb2, 0x4f, 0xf3, 0xe4, 0xef, 0x13, 0x29, 0xb9,
  0x60, 0x60, 0x2e, 0xd1, 0x34, 0xb9, 0xad, 0x73, 0xdb, 0x64, 0x5a, 0x88,
  0x37, 0x18, 0x1e, 0x74, 0x1e, 0x99, 0x42, 0xf8, 0x4d, 0x1e, 0x63, 0xb9,
  0x8d, 0xbe, 0x5b, 0x97, 0xf0, 0x5c, 0xc1, 0x00, 0xeb, 0xab, 0xc7, 0x81,
  0x2c, 0xd1, 0x34, 0xbb, 0x4a, 0x91, 0x9e, 0x2b, 0xb1, 0xa4, 0x30, 0x9a,
  0xba, 0x24, 0xe5, 0xba, 0x5e, 0x33, 0x95, 0x28, 0x07, 0x5d, 0xc6, 0x9a,
  0xa6, 0x27, 0xf7, 0x0e, 0x2f, 0xb3, 0xce, 0xc2, 0x72, 0x39, 0x5d, 0x0c,
  0x59, 0xd3, 0x0f, 0xe9, 0xac, 0x2d, 0xe3, 0x07, 0xda, 0xbd, 0x37, 0xa2,
  0xbb, 0x07, 0x69, 0xd2, 0xb6, 0x3f, 0x6d, 0xdb, 0xd3, 0xc4, 0xee, 0xa3,
  0xed, 0xb2, 0xdd, 0x8a, 0xaa, 0xab, 0xf6, 0x49, 0xfb, 0xaa, 0xf1, 0xde,
  0xb4, 0x53, 0x9d, 0xad, 0x99, 0x5b, 0xb4, 0xd5, 0x34, 0x77, 0x21, 0x8e,
  0x4e, 0xcd, 0x35, 0x5e, 0x79, 0xaa, 0x6b, 0x53, 0x59, 0x4d, 0x68, 0x91,
  0x1b, 0x7b, 0x93, 0xe7, 0xac, 0xe0, 0x79, 0x4c, 0x00, 0xe3, 0xf1, 0x23,
  0xe2, 0xc5, 0xfe, 0xfe, 0x3e, 0x7d, 0xb0, 0x2f, 0x7b, 0xbc, 0xaf, 0xcc,
  0x69, 0xff, 0x9a, 0x93, 0xa1, 0xa6, 0x1b, 0xd1, 0xf0, 0x7a, 0xc9, 0x79,
  0x3c, 0xd9, 0x9d, 0x48, 0x56, 0x3a, 0x90, 0x7a, 0x80, 0x4b, 0xfc, 0xc0,
  0xfa, 0xb5, 0xc0, 0x85, 0x54, 0xae, 0x31, 0x51, 0x56, 0x90, 0xa0, 0x65,
  0x9e, 0x49, 0xe3, 0x33, 0xd2, 0x43, 0x6b, 0x0e, 0xe5, 0x72, 0x6e, 0x16,
  0x02, 0x6f, 0xce, 0x9a, 0x3b, 0xca, 0x51, 0xd1, 0x2d, 0x16, 0x8a, 0x3b,
  0xd9, 0xbb, 0x60, 0x38, 0xd0, 0x52, 0xc3, 0xe2, 0xda, 0xc3, 0x6f, 0xdc,
  0xee, 0x80, 0x78, 0xe2, 0x00, 0x49, 0xca, 0x64, 0x7a, 0xe0, 0x88, 0x71,
  0x72, 0x91, 0x04, 0x38, 0x4a, 0x0c, 0x40, 0x6b, 0x86, 0xb4, 0xae, 0x68,
  0x1f, 0x6f, 0xf0, 0xce, 0x4b, 0x42, 0x09, 0xff, 0x59, 0x34, 0x69, 0x6b,
  0x7b, 0xc5, 0x86, 0xc8, 0xeb, 0x3f, 0x4a, 0xc0, 0xef, 0xa6, 0xf6, 0xfa,
  0xf3, 0xbf, 0xbe, 0x4d, 0x89, 0x5e, 0x1f, 0xfc, 0x18, 0x37, 0xdd, 0xe6,
  0xcb, 0xb2, 0xe0, 0x4d, 0x74, 0xed, 0x00, 0x0f, 0x24, 0x6a, 0x48, 0x23,
  0x0d, 0x0b, 0xda, 0xee, 0x09, 0xd0, 0x51, 0x24, 0xb4, 0xd6, 0xc1, 0xa7,
  0xde, 0xc5, 0x8d, 0x6b, 0xc4, 0xa8, 0xde, 0x5f, 0xde, 0xa4, 0xc5, 0xa4,
  0x6a, 0xf4, 0x75, 0xcd, 0xe7, 0xc9, 0x62, 0xfa, 0xe0, 0x54, 0x13, 0x6d,
  0x7e, 0xd5, 0x75, 0x1e, 0x6a, 0xb8, 0x1a, 0x0b, 0x2d, 0x1b, 0xa3, 0x63,
  0x2c, 0xaa, 0xad, 0xa0, 0xa3, 0x98, 0x2f, 0xdb, 0xcb, 0x86, 0xaf, 0x24,
  0xd6, 0x9e, 0x6b, 0x80, 0x9c, 0xcd, 0x1d, 0x0a, 0x6e, 0x35, 0x97, 0x11,
  0xad, 0xa8, 0xa2, 0x9a, 0x59, 0xb0, 0x2a, 0x16, 0x4e, 0xf4, 0xcb, 0x29,
  0x2f, 0x3d, 0xee, 0xe2, 0x84, 0x24, 0x7c, 0x44, 0xb6, 0x5b, 0x9e, 0x78,
  0x3a, 0x97, 0xb4, 0x64, 0x4e, 0x24, 0x83, 0xa1, 0x30, 0x8e, 0x5a, 0x62,
  0xeb, 0xf9, 0xe2, 0x34, 0xb4, 0xa7, 0x55, 0xc9, 0xe3, 0x8a, 0x87, 0x17,
  0xc4, 0xf1, 0x22, 0x01, 0xbe, 0x4d, 0x58, 0xf0, 0xc1, 0x92, 0xfb, 0x9a,
  0x2a, 0x7e, 0xc1, 0xce, 0x66, 0x71, 0x7a, 0x92, 0x22, 0xbe, 0x89, 0xa4,
  0x70, 0x70, 0x5f, 0xb6, 0x83, 0xe5, 0x13, 0x85, 0x8d, 0x66, 0xf5, 0xf8,
  0xb3, 0x4f, 0x3e, 0x6d, 0x8d, 0xd4, 0x4b, 0x34, 0xc9, 0xc1, 0xc3, 0xb6,
  0xd2, 0x69, 0xd6, 0xa4, 0x51, 0xf1, 0x84, 0x70, 0x8d, 0x02, 0x4e, 0xb1,
  0x13, 0x41, 0x59, 0x2e, 0xce, 0xee, 0xb8, 0x69, 0x50, 0xe4, 0x01, 0x75,
  0xc5, 0x20, 0x20, 0xa9, 0x17, 0x06, 0x9a, 0xaf, 0x50, 0xeb, 0x55, 0x38,
  0x1c, 0x49, 0xbf, 0x9b, 0x47, 0x5f, 0x20, 0x55, 0x84, 0x3b, 0xa8, 0x35,
  0xf7, 0x37, 0x96, 0xd5, 0xaf, 0x92, 0xb2, 0x99, 0xbd, 0x84, 0x7d, 0x7f,
  0xb2, 0xf1, 0x36, 0xe7, 0xb1, 0x66, 0x5f, 0x45, 0xaf, 0xcc, 0x83, 0xec,
  0xf5, 0x0b, 0x57, 0x66, 0x82, 0x46, 0xc4, 0xc4, 0xf7, 0x4a, 0xf5, 0x2f,
  0xcd, 0xdc, 0xf8, 0xa2, 0x45, 0x41, 0x31, 0x0c, 0x55, 0x01, 0xa0, 0x29,
  0xcb, 0xd8, 0x0a, 0xc9, 0xc0, 0x44, 0xc7, 0xd9, 0xd6, 0xf0, 0x91, 0xaa,
  0x46, 0x6b, 0xd8, 0xe8, 0x4c, 0x2f, 0xd3, 0x36, 0x14, 0x8c, 0x57, 0xae,
  0x51, 0xc0, 0x1f, 0x4a, 0xc2, 0x3b, 0x0f, 0xa5, 0x6d, 0x25, 0x4c, 0xba,
  0xe3, 0xf0, 0x9a, 0xe4, 0xbe, 0x71, 0x7e, 0xf1, 0x6e, 0xb0, 0x4e, 0x0d,
  0x35, 0xff, 0xf0, 0x3e, 0x9e, 0xa1, 0xcc, 0x89, 0xa1, 0x8a, 0xc3, 0xd9,
  0xe8, 0x53, 0x52, 0xd4, 0x0f, 0x1f, 0xda, 0xed, 0xc4, 0x92, 0x1c, 0x75,
  0xf9, 0xa1, 0xfa, 0xde, 0xf3, 0x4b, 0x5d, 0xd3, 0x58, 0x43, 0xdf, 0x21,
  0x28, 0x52, 0x86, 0xe3, 0x40, 0xaa, 0xc4, 0x91, 0xc7, 0x5d, 0x4d, 0xea,
  0xd5, 0x78, 0x82, 0xe5, 0x00, 0x14, 0xca, 0x6e, 0xab, 0xbb, 0xbb, 0xff,
  0xc6, 0x8d, 0xf4, 0xf5, 0x17, 0x95, 0xd6, 0xee, 0xee, 0x06, 0xb3, 0x07,
  0xfb, 0xae, 0xa8, 0x14, 0x7a, 0xf2, 0xb9, 0xa2, 0x2e, 0xab, 0x9c, 0x67,
  0xd9, 0x2d, 0x1c, 0x71, 0xf9, 0x04, 0xf1, 0xb0, 0x0c, 0x82, 0x11, 0x9a,
  0x20, 0x38, 0xf6, 0x9b, 0x19, 0x1e, 0x79, 0x12, 0x5a, 0x2e, 0x30, 0x79,
  0xb1, 0x3f, 0x75, 0xd5, 0xf7, 0xa5, 0x07, 0xfd, 0x2a, 0x53, 0x99, 0x7c,
  0x44, 0xd7, 0x8a, 0x51, 0x59, 0x53, 0x70, 0x28, 0xca, 0x7c, 0x39, 0x2e,
  0x9b, 0x0e, 0xa3, 0x1f, 0xc2, 0xba, 0x42, 0xa2, 0x5f, 0x99, 0x9e, 0x00,
  0x13, 0x47, 0x85, 0x25, 0xb8, 0xd8, 0x7b, 0x54, 0x0f, 0x6b, 0xd3, 0xd8,
  0xba, 0x80, 0xea, 0xec, 0xf6, 0x24, 0x38, 0x5b, 0x13, 0xa4, 0x7d, 0x3a,
  0xef, 0xca, 0x85, 0xef, 0xdc, 0x25, 0xa3, 0xd7, 0x5f, 0x70, 0x40, 0xd4,
  0x3d, 0xa0, 0xfe, 0x04, 0xf2, 0x93, 0x69, 0x70, 0x93, 0xff, 0xec, 0x70,
  0x8a, 0x7c, 0xdb, 0xba, 0x13, 0x17, 0x5f, 0xd5, 0x62, 0x00, 0x35, 0x10,
  0xb4, 0x76, 0x99, 0x65, 0x2b, 0x1b, 0x73, 0x35, 0xa0, 0xb0, 0x18, 0x41,
  0x54, 0x3f, 0x8b, 0x1e, 0x57, 0x89, 0xa7, 0x42, 0xa1, 0x3c, 0xde, 0xc5,
  0xb9, 0xc2, 0xb9, 0xe2, 0x14, 0xb6, 0x65, 0xe8, 0x8e, 0x1e, 0x1c, 0x88,
  0xb8, 0x65, 0xeb, 0xbd, 0xee, 0x79, 0x37, 0xd7, 0xea, 0x05, 0xe1, 0xa7,
  0x5f, 0x7f, 0x01, 0xdc, 0x1a, 0xfe, 0xf5, 0x2f, 0xee, 0x6d, 0xfe, 0x87,
  0xa8, 0x98, 0x18, 0xc1, 0xca, 0x89, 0xb0, 0x28, 0x72, 0xb9, 0xcc, 0x21,
  0x66, 0x24, 0x72, 0x24, 0x0b, 0x10, 0x86, 0xa1, 0x52, 0x2a, 0x37, 0x79,
  0xbb, 0x77, 0xf2, 0x6e, 0xef, 0x78, 0xf0, 0x98, 0x92, 0x16, 0x1a, 0x7a,
  0x5c, 0x18, 0x0c, 0xcc, 0x2e, 0x15, 0xa5, 0x8b, 0xcf, 0xa3, 0x86, 0x23,
  0xcb, 0x4d, 0xf8, 0x78, 0x45, 0x02, 0x9f, 0xdf, 0xad, 0xd7, 0xa7, 0x26,
  0xc7, 0xbb, 0xb4, 0x3b, 0xc1, 0xe9, 0x70, 0xa0, 0xfe, 0xa2, 0x49, 0xb4,
  0xc6, 0xaf, 0x22, 0xc9, 0x30, 0x8f, 0xa5, 0x4a, 0x8b, 0xd3, 0x17, 0xa7,
  0x29, 0xd7, 0x03, 0x9c, 0x32, 0x6e, 0xd8, 0xb1, 0x56, 0x36, 0xeb, 0x7e,
  0xd1, 0xc5, 0x1a, 0x74, 0x5f, 0x75, 0x79, 0x43, 0xf3, 0xb8, 0x89, 0x24,
  0x29, 0x69, 0xc3, 0x1a, 0x08, 0xd8, 0x15, 0xaa, 0xe9, 0xda, 0x20, 0x74,
  0xcd, 0x64, 0x64, 0xf0, 0x40, 0xcf, 0x35, 0xba, 0x8f, 0xeb, 0x7a, 0x25,
  0xf1, 0xbc, 0xc5, 0x6a, 0x0e, 0x78, 0x1b, 0x97, 0x47, 0x27, 0xd5, 0x51,
  0x70, 0x2d, 0xf8, 0x99, 0x8b, 0x24, 0x9f, 0x33, 0xc7, 0x60, 0x07, 0xaf,
  0xc0, 0x8c, 0xb5, 0x39, 0xad, 0xdd, 0xda, 0xe8, 0x78, 0x64, 0x20, 0x1c,
  0x50, 0x40, 0xb7, 0x72, 0xca, 0x41, 0x84, 0xb0, 0x57, 0xd1, 0x97, 0x57,
  0x57, 0x9a, 0xe9, 0x87, 0x39, 0x23, 0x2f, 0x9a, 0x26, 0xdd, 0xc0, 0x3a,
  0xd3, 0x22, 0x82, 0x44, 0xc6, 0x75, 0x54, 0x97, 0xfe, 0x15, 0x89, 0x35,
  0x57, 0xd3, 0x6c, 0x94, 0x5d, 0x5e, 0x3e, 0x42, 0x1b, 0x05, 0x5d, 0x88,
  0x74, 0x39, 0x15, 0x70, 0x60, 0x21, 0xc2, 0x9f, 0xe3, 0xda, 0xf9, 0xbd,
  0x91, 0x96, 0xd6, 0x63, 0xec, 0xec, 0x81, 0x98, 0x93, 0x14, 0xbe, 0xae,
  0x31, 0xa9, 0xc0, 0xef, 0x62, 0xb1, 0xf7, 0x16, 0x32, 0x89, 0x92, 0x6b,
  0x98, 0xb6, 0x05, 0x62, 0x79, 0x28, 0x07, 0x12, 0x6d, 0xfe, 0xf1, 0xcf,
  0x1f, 0x7f, 0x6e, 0x41, 0x3f, 0x61, 0x73, 0xaa, 0x05, 0x1d, 0x73, 0xd0,
  0xa5, 0x26, 0x4b, 0xc0, 0xe0, 0x49, 0x3b, 0x50, 0x7a, 0xa8, 0x2e, 0x2d,
  0x7f, 0x10, 0x04, 0x95, 0x36, 0x2f, 0x8c, 0xc2, 0x77, 0x18, 0xc3, 0xe3,
  0x59, 0x9a, 0x1b, 0x79, 0x9a, 0x5c, 0xc5, 0x92, 0x0f, 0xed, 0x2e, 0x4f,
  0xb5, 0xf3, 0x3f, 0x18, 0x42, 0x79, 0xc3, 0xa8, 0xea, 0x73, 0x46, 0x43,
  0x41, 0x0a, 0x46, 0xbb, 0xf3, 0x23, 0x67, 0x48, 0x0e, 0x36, 0xe2, 0x2b,
  0xde, 0x88, 0xc6, 0xaa, 0xf9, 0x6c, 0x92, 0x5e, 0x0d, 0x1f, 0xba, 0x92,
  0xee, 0x8b, 0xe0, 0x74, 0x49, 0xc6, 0xad, 0x22, 0x6e, 0xac, 0x44, 0xef,
  0xc9, 0xf2, 0x1a, 0xc0, 0x87, 0x88, 0x5c, 0x66, 0x82, 0x09, 0xfc, 0xe5,
  0x5f, 0x1d, 0x5e, 0x44, 0x06, 0xa7, 0xd4, 0xa0, 0xfb, 0xa0, 0x82, 0x82,
  0x4b, 0xed, 0xf5, 0xd8, 0x4b, 0xc8, 0x03, 0x77, 0x95, 0x9c, 0xee, 0xcc,
  0xa7, 0x82, 0xf8, 0x83, 0x16, 0x25, 0x44, 0x81, 0x3c, 0x44, 0xab, 0xb3,
  0x34, 0x5f, 0xbf, 0x6c, 0xc7, 0x06, 0xb9, 0xd0, 0xfd, 0x6b, 0x37, 0xf2,
  0xb0, 0x0a, 0x6d, 0x91, 0x11, 0x1e, 0x5e, 0xac, 0x96, 0xcf, 0xda, 0x3f,
  0xea, 0xb9, 0x4c, 0x6b, 0x5d, 0x30, 0x59, 0x47, 0x37, 0x95, 0x51, 0x0b,
  0x74, 0xd2, 0xaa, 0x81, 0x7c, 0x7d, 0xb8, 0x77, 0x60, 0xb3, 0xfd, 0x2f,
  0x48, 0x49, 0x75, 0x7e, 0x8a, 0x51, 0x22, 0x70, 0x51, 0x4b, 0xb3, 0x70,
  0xcb, 0xa6, 0x39, 0x63, 0x41, 0x4b, 0x24, 0x0b, 0xc9, 0x6c, 0xc0, 0x3e,
  0x85, 0x2a, 0x27, 0x88, 0x2a, 0x0a, 0xb5, 0x2f, 0xf1, 0xc5, 0x6e, 0x3d,
  0x42, 0x03, 0x77, 0x60, 0xbe, 0x6e, 0x2d, 0x86, 0x11, 0x54, 0x86, 0x0a,
  0x28, 0xfb, 0x1a, 0x19, 0x3b, 0xd3, 0x45, 0x23, 0x75, 0x23, 0xbe, 0xe2,
  0x7c, 0xb2, 0xe9, 0x22, 0x78, 0x36, 0xc8, 0xee, 0x79, 0x25, 0x3f, 0x57,
  0x5c, 0x2c, 0x87, 0x40, 0x91, 0xd1, 0x47, 0xc3, 0xb4, 0xb5, 0xab, 0xa0,
  0x90, 0x07, 0x89, 0x1a, 0x7c, 0x67, 0x5c, 0x71, 0x6e, 0x10, 0xae, 0x7c,
  0xe2, 0xa1, 0xf5, 0x75, 0x50, 0x0e, 0x84, 0x44, 0x77, 0x57, 0x77, 0x35,
  0x09, 0x5a, 0x2f, 0xc2, 0x50, 0x74, 0xcd, 0xad, 0xb1, 0x1a, 0x16, 0x93,
  0x46, 0x81, 0x01, 0x62, 0x37, 0x45, 0x49, 0x62, 0xa0, 0x8d, 0x8c, 0x5f,
  0xba, 0x8e, 0x0b, 0x6f, 0x7d, 0x95, 0xdc, 0x68, 0x71, 0x7f, 0xf9, 0x73,
  0x63, 0x4e, 0x9a, 0x26, 0x8c, 0xbb, 0xd3, 0xec, 0x14, 0x92, 0x69, 0x89,
  0x6d, 0x83, 0xb4, 0xcd, 0x59, 0xb4, 0xfc, 0x92, 0xe6, 0x1d, 0x69, 0x97,
  0x61, 0x94, 0xcf, 0x8a, 0xf3, 0xaa, 0xb2, 0xb5, 0xf3, 0x0c, 0x65, 0xf3,
  0xa4, 0x6a, 0x39, 0xe1, 0x39, 0x5a, 0x96, 0x13, 0x72, 0x8a, 0x50, 0x40,
  0xb7, 0x71, 0xed, 0x01, 0x44, 0xb8, 0x5c, 0x5e, 0x4a, 0xcc, 0xe7, 0xdc,
  0x10, 0x82, 0x31, 0x50, 0x97, 0xeb, 0x39, 0xc9, 0x50, 0xfc, 0xd5, 0xd6,
  0xcc, 0x14, 0xff, 0xb8, 0x81, 0xb9, 0x6b, 0xc3, 0xd1, 0xe9, 0xf8, 0x14,
  0x41, 0xc7, 0xeb, 0x19, 0x9d, 0x15, 0x7b, 0xcb, 0x38, 0x2f, 0x09, 0x30,
  0x86, 0x14, 0x06, 0xf6, 0xae, 0xc9, 0xd2, 0xb5, 0xe0, 0x82, 0x64, 0xa7,
  0x32, 0xb8, 0xf7, 0x2c, 0x63, 0xa7, 0xe8, 0xdc, 0x4f, 0x5b, 0x17, 0x8c,
  0xee, 0x88, 0xab, 0xf4, 0xd6, 0x6a, 0xd4, 0x60, 0x64, 0x2d, 0x09, 0x39,
  0x36, 0x08, 0x13, 0xf6, 0x35, 0x28, 0x41, 0xf2, 0x9c, 0xa3, 0x02, 0xf8,
  0xeb, 0x6e, 0x3b, 0xc7, 0xd9, 0x14, 0x89, 0xd1, 0x31, 0x8a, 0x1b, 0xed,
  0x32, 0x61, 0xd7, 0x1d, 0x1e, 0x5f, 0x93, 0x58, 0xb7, 0xdb, 0x69, 0x0f,
  0xc7, 0xad, 0xf0, 0xf6, 0xc2, 0x41, 0x36, 0xc2, 0x6b, 0xae, 0x83, 0x06,
  0x3a, 0xf2, 0x64, 0xb2, 0xa9, 0x03, 0xd6, 0xda, 0xb3, 0xad, 0xa3, 0xb6,
  0x60, 0xf2, 0x05, 0x22, 0xac, 0xb0, 0xfb, 0x28, 0xd9, 0xc5, 0xb5, 0x92,
  0x58, 0x2f, 0x0b, 0x08, 0x1a, 0x99, 0x85, 0xbc, 0x43, 0xd4, 0x74, 0xdb,
  0x35, 0xa9, 0x31, 0xbb, 0xb9, 0x33, 0xd9, 0xe9, 0x68, 0x74, 0x51, 0x76,
  0xd9, 0xcc, 0x63, 0xaf, 0x3b, 0xdc, 0x23, 0xce, 0xe3, 0x8a, 0xf3, 0x3c,
  0xa5, 0x73, 0xd8, 0x40, 0xb8, 0x94, 0xa8, 0xaa, 0xd2, 0xd5, 0x55, 0x05,
  0x64, 0xeb, 0x4c, 0x9c, 0x29, 0xb4, 0x23, 0x6c, 0x56, 0x80, 0x48, 0xc8,
  0x69, 0xa4, 0x6b, 0xab, 0x6c, 0xe9, 0x48, 0xc5, 0xa9, 0x95, 0xcb, 0x82,
  0x35, 0x3d, 0xcc, 0x5c, 0x5c, 0x85, 0x1c, 0xb0, 0x4a, 0x04, 0x0e, 0x4a,
  0x5b, 0x82, 0x53, 0x8b, 0x4a, 0x14, 0x2c, 0xf9, 0x66, 0x0e, 0x8a, 0x6a,
  0x8b, 0x8f, 0xe0, 0xb7, 0x8c, 0x79, 0x04, 0xb2, 0x33, 0x57, 0x03, 0x5d,
  0x2c, 0x47, 0xb3, 0xc9, 0x8b, 0xe8, 0x15, 0xfd, 0x53, 0xe7, 0x6c, 0xa8,
  0x46, 0x83, 0xb0, 0x09, 0x95, 0x85, 0x55, 0x16, 0xc2, 0xef, 0xcf, 0x76,
  0xf8, 0x40, 0xdc, 0x53, 0x9b, 0xe3, 0x94, 0x65, 0x12, 0xba, 0x07, 0xae,
  0xd2, 0x52, 0xe2, 0xd2, 0xf5, 0x85, 0xf6, 0xd2, 0x29, 0x52, 0x1e, 0x22,
  0xda, 0xde, 0xf9, 0x2c, 0x1a, 0xa5, 0x65, 0xf4, 0xf6, 0xe0, 0x85, 0x14,
  0x5f, 0x2a, 0x96, 0x33, 0x5f, 0xa4, 0x0f, 0xe8, 0x90, 0xa8, 0x56, 0xca,
  0x0e, 0x3f, 0x1a, 0xe3, 0xb4, 0x51, 0x07, 0xe1, 0x26, 0x79, 0xe8, 0xd5,
  0x1d, 0x4b, 0x97, 0xe6, 0x04, 0x0b, 0xec, 0xd5, 0x8e, 0xe2, 0x50, 0xfb,
  0x54, 0x0b, 0x18, 0x34, 0x05, 0x7a, 0x9a, 0x3f, 0x8d, 0xa0, 0xb0, 0xc2,
  0x2d, 0x17, 0x35, 0x68, 0x6d, 0x26, 0x03, 0x64, 0x63, 0xed, 0x9f, 0x49,
  0xa4, 0x1c, 0x22, 0x8a, 0x82, 0xbc, 0xf2, 0xfa, 0xad, 0x10, 0x1a, 0xee,
  0x3e, 0xad, 0x9a, 0x56, 0xa5, 0x04, 0x9b, 0x61, 0x81, 0xf4, 0x49, 0xb9,
  0xba, 0x5a, 0x55, 0x57, 0x2b, 0x3a, 0xc2, 0xb3, 0x7a, 0x8a, 0x4d, 0x23,
  0x3e, 0xc6, 0x1b, 0x41, 0x62, 0xa6, 0xdc, 0xba, 0x7c, 0x0e, 0xd2, 0x31,
  0x97, 0x37, 0x6c, 0xc0, 0x1a, 0x2e, 0x3d, 0xd4, 0xa5, 0x15, 0x7b, 0xcb,
  0x97, 0x82, 0x6f, 0xbb, 0xb7, 0x60, 0x33, 0x4f, 0xb4, 0x3d, 0xb8, 0xef,
  0x85, 0xb5, 0x66, 0x14, 0x0c, 0x19, 0x25, 0x65, 0x1a, 0xd9, 0x48, 0xf0,
  0x2a, 0xd7, 0x46, 0xc3, 0x6d, 0x8b, 0x7d, 0x6d, 0xca, 0x21, 0x13, 0xb9,
  0x70, 0xe0, 0x1d, 0x62, 0x65, 0x57, 0x31, 0xb0, 0x78, 0x03, 0xca, 0x4b,
  0xe9, 0x1c, 0x28, 0x54, 0xd0, 0xaa, 0x79, 0xcb, 0xb7, 0x41, 0x61, 0x13,
  0xbb, 0x86, 0x55, 0x16, 0x97, 0x80, 0x43, 0x21, 0xb7, 0xe0, 0xeb, 0x66,
  0x41, 0x1c, 0x6e, 0xc6, 0x9d, 0x5e, 0x68, 0xbf, 0xb2, 0x02, 0x7d, 0xbe,
  0xf8, 0x7a, 0x2c, 0x73, 0x25, 0x9e, 0x4f, 0xfa, 0x18, 0x4b, 0x69, 0xb4,
  0x19, 0x5b, 0x5c, 0x58, 0x4d, 0x47, 0x54, 0x4d, 0x1f, 0x84, 0xc7, 0x09,
  0x7c, 0xfc, 0x92, 0x99, 0x5f, 0x6b, 0xa6, 0xe9, 0x99, 0x60, 0x81, 0x45,
  0xd5, 0xaa, 0xa5, 0xe6, 0x98, 0xf6, 0x62, 0xb2, 0x6b, 0x66, 0xe0, 0x4c,
  0x24, 0xc9, 0xbc, 0x6c, 0x99, 0x9a, 0xf5, 0x26, 0x13, 0x09, 0xbc, 0xa8,
  0x61, 0xa1, 0xdf, 0x41, 0xb4, 0x37, 0x37, 0x4d, 0x5c, 0x93, 0xdb, 0x25,
  0xb3, 0xa0, 0x81, 0xf4, 0x7f, 0x93, 0x34, 0x4c, 0x02, 0x6a, 0x13, 0x08,
  0x66, 0x46, 0x62, 0xd5, 0xd6, 0xee, 0x76, 0xa5, 0x42, 0xb3, 0x42, 0x89,
  0xa3, 0x70, 0xc2, 0xef, 0x17, 0x14, 0x7c, 0xa4, 0x82, 0x58, 0x1b, 0xbd,
  0x6c, 0x72, 0xdc, 0xdf, 0x9b, 0xa3, 0xe3, 0xc3, 0x8d, 0xe8, 0x0d, 0x57,
  0xbf, 0x76, 0x19, 0xdd, 0xae, 0x8c, 0x1e, 0x1d, 0xdf, 0x3f, 0xc8, 0x27,
  0x46, 0xfe, 0xaa, 0x84, 0xb6, 0x19, 0x55, 0xcd, 0xeb, 0x2d, 0xe2, 0xb4,
  0x9c, 0x09, 0xcc, 0x42, 0xb2, 0x46, 0x32, 0xdc, 0x6d, 0x06, 0xb4, 0x6b,
  0x01, 0x56, 0xad, 0xe4, 0x07, 0x6b, 0x9b, 0xaf, 0x8a, 0xe0, 0x91, 0x86,
  0x51, 0x31, 0x58, 0x63, 0x13, 0x79, 0xe0, 0x91, 0xd9, 0xe4, 0xaa, 0x15,
  0x72, 0x5b, 0x46, 0x27, 0xf5, 0x8a, 0xd2, 0x5f, 0x24, 0x40, 0x16, 0xab,
  0x36, 0xcb, 0x26, 0x0e, 0xb7, 0x4d, 0xaa, 0x17, 0xf0, 0x7c, 0x83, 0xb5,
  0xfb, 0x1b, 0xad, 0xdd, 0xdf, 0x96, 0xf3, 0x9b, 0xbe, 0x56, 0xa9, 0x52,
  0xbc, 0x81, 0xa2, 0xfd, 0xec, 0x7d, 0xe7, 0x9c, 0xfd, 0x08, 0x56, 0x14,
  0x43, 0x67, 0xb3, 0x58, 0x53, 0x1c, 0xc0, 0x36, 0xf5, 0x1e, 0x29, 0xf6,
  0xe0, 0x51, 0xbc, 0xa4, 0xca, 0xee, 0x98, 0xa3, 0x24, 0xa1, 0x1f, 0x76,
  0xac, 0x68, 0x96, 0x35, 0xdc, 0x19, 0x84, 0xd0, 0x51, 0x0d, 0x2c, 0xc8,
  0xc2, 0x12, 0x63, 0xae, 0x5d, 0xc9, 0x23, 0x48, 0xb0, 0xea, 0xc6, 0xe7,
  0xe2, 0xf5, 0xbc, 0xde, 0x74, 0xcf, 0xfb, 0x72, 0x5c, 0x5a, 0xe7, 0x9a,
  0x49, 0xa9, 0x76, 0xcd, 0x4a, 0xba, 0x92, 0xc1, 0xea, 0x16, 0x86, 0x00,
  0x62, 0x23, 0x8c, 0xea, 0x83, 0x33, 0xc8, 0x5d, 0x96, 0x0d, 0xba, 0x0d,
  0xc2, 0x19, 0x4f, 0x33, 0xa9, 0x80, 0x71, 0x17, 0xc6, 0xd8, 0xdc, 0x80,
  0xcf, 0x15, 0x6d, 0xf1, 0x2a, 0x96, 0x78, 0x17, 0xaa, 0xd0, 0x81, 0xdd,
  0x4f, 0xe5, 0x5e, 0x87, 0xb7, 0xab, 0xbc, 0xa3, 0x63, 0xad, 0x75, 0x9a,
  0x89, 0x00, 0x95, 0x3a, 0xdb, 0x30, 0x25, 0x79, 0xd0, 0x93, 0x3d, 0x5a,
  0xef, 0xc6, 0x23, 0x1c, 0x5a, 0x2d, 0xd1, 0xa5, 0x49, 0x4b, 0x0d, 0x53,
  0x81, 0x7c, 0x25, 0xa2, 0x36, 0x3f, 0x79, 0x05, 0xdc, 0xa2, 0x96, 0xdc,
  0x21, 0xe9, 0x46, 0x90, 0xe7, 0x63, 0x76, 0x27, 0xd5, 0xf7, 0xce, 0xd5,
  0x74, 0xd6, 0xdb, 0x4a, 0x1d, 0x03, 0xd3, 0x69, 0x65, 0x44, 0x1e, 0x74,
  0x22, 0x98, 0x68, 0x4b, 0x8a, 0x07, 0x50, 0xfb, 0xf5, 0x26, 0xaf, 0xac,
  0xb1, 0x31, 0x98, 0x56, 0xd1, 0xcc, 0x19, 0x7d, 0xa0, 0xc7, 0x40, 0xe2,
  0xc4, 0x55, 0xa6, 0xc8, 0xee, 0xea, 0x25, 0x44, 0x32, 0xb9, 0xd8, 0x2f,
  0x23, 0x57, 0x4b, 0x67, 0x45, 0x89, 0x1c, 0x64, 0x49, 0x5d, 0xc7, 0xf7,
  0xf7, 0x83, 0x22, 0x91, 0x9a, 0x31, 0x45, 0x31, 0x45, 0x5a, 0x56, 0xb5,
  0x36, 0x0e, 0x67, 0xe4, 0x26, 0x8b, 0x78, 0x8a, 0x28, 0x2b, 0x3e, 0x9f,
  0xab, 0x6a, 0x90, 0x54, 0x4c, 0x5c, 0xe6, 0x26, 0xc5, 0x1b, 0x71, 0xb5,
  0x52, 0xc8, 0x5c, 0xea, 0x71, 0x0b, 0x46, 0xec, 0x8c, 0xed, 0x53, 0x51,
  0x3a, 0x69, 0x46, 0x89, 0x09, 0x44, 0x0d, 0xfc, 0x21, 0xbc, 0x71, 0x6e,
  0x14, 0x2c, 0x7d, 0x8f, 0xd4, 0x30, 0xeb, 0xba, 0x30, 0x77, 0x11, 0xd7,
  0x08, 0xbf, 0x4d, 0x27, 0xcb, 0x86, 0xf2, 0x57, 0x7f, 0xdd, 0x2a, 0x10,
  0x06, 0xe1, 0xd1, 0x38, 0x89, 0xfc, 0x44, 0xe6, 0xee, 0x38, 0x40, 0x3f,
  0xa2, 0xb2, 0x55, 0x83, 0x39, 0x5e, 0x6a, 0xd2, 0x3c, 0xb8, 0xee, 0xc5,
  0xfe, 0xd9, 0xfb, 0x6f, 0x0e, 0x0f, 0xcf, 0x8e, 0x0e, 0x98, 0x1d, 0x82,
  0xff, 0xba, 0x8f, 0x4e, 0x2e, 0xbe, 0x3d, 0xf6, 0x89, 0xf3, 0x2a, 0x39,
  0xd7, 0x0f, 0x14, 0x1b, 0x42, 0xb9, 0xb9, 0xe3, 0x74, 0xbe, 0xbc, 0xef,
  0xa1, 0xf2, 0x06, 0xc9, 0xdd, 0x7b, 0x47, 0xdf, 0xf7, 0xa2, 0xaf, 0xcf,
  0xfa, 0xef, 0xbe, 0x77, 0xb7, 0xf6, 0xc6, 0xa0, 0x11, 0x0c, 0x44, 0xec,
  0xbc, 0x1e, 0xc9, 0xe2, 0x62, 0x83, 0x80, 0x99, 0xe3, 0xe7, 0x6e, 0x24,
  0xd6, 0x02, 0xe2, 0xf9, 0x81, 0x06, 0x97, 0xaa, 0x31, 0x3b, 0xbc, 0xfe,
  0x9c, 0xb1, 0x05, 0xbb, 0xdf, 0xc2, 0xfd, 0xa5, 0x5a, 0xfb, 0x20, 0x24,
  0xac, 0x87, 0xe8, 0x15, 0xfd, 0xd3, 0x96, 0x54, 0xb5, 0xc9, 0x05, 0x7c,
  0xa3, 0xb3, 0x20, 0xd3, 0xdc, 0x39, 0x74, 0x06, 0x16, 0x04, 0xa3, 0x8a,
  0xb5, 0xe6, 0x08, 0xa8, 0xd3, 0x2c, 0x6f, 0x44, 0x51, 0xba, 0x16, 0x7c,
  0xbd, 0x43, 0xad, 0x59, 0xdf, 0xea, 0x8c, 0xfb, 0x0d, 0xb3, 0xc9, 0xa8,
  0xd3, 0x27, 0xd3, 0x97, 0x1b, 0x53, 0xe4, 0x47, 0x07, 0x0e, 0xbf, 0x41,
  0x6f, 0x70, 0x6e, 0x04, 0xf3, 0x93, 0x55, 0x6b, 0x03, 0xfc, 0x95, 0xf4,
  0x66, 0x9f, 0x88, 0x8f, 0xe7, 0x52, 0x0e, 0x95, 0x38, 0x38, 0x3c, 0xef,
  0x21, 0x5b, 0x2c, 0xcc, 0x68, 0x76, 0xa8, 0x1d, 0x5a, 0xb9, 0xa5, 0x6c,
  0xb5, 0xe5, 0x00, 0x79, 0xe0, 0x7f, 0x5e, 0x26, 0xf3, 0x4d, 0x3e, 0x8a,
  0x5e, 0x4d, 0xe9, 0xc5, 0xe9, 0x8a, 0x00, 0x4e, 0x2d, 0xaa, 0xf7, 0x4d,
  0x92, 0x8f, 0x92, 0x3c, 0x2b, 0xea, 0x89, 0x2e, 0x9a, 0x1e, 0xab, 0xc5,
  0xcb, 0xb8, 0x1d, 0x4b, 0x98, 0x6b, 0x60, 0x93, 0x94, 0x60, 0xd5, 0xfc,
  0x42, 0x23, 0xa4, 0xbf, 0x8b, 0x40, 0xac, 0x6e, 0x2f, 0xea, 0x72, 0x32,
  0x0f, 0xff, 0x24, 0xf6, 0x75, 0x09, 0x5f, 0x41, 0x1a, 0x4f, 0xbb, 0x2d,
  0x09, 0xa3, 0x5d, 0x5d, 0xf5, 0x2e, 0xad, 0xf6, 0x50, 0x4d, 0x7f, 0xb0,
  0x03, 0xc2, 0xeb, 0xc7, 0xc8, 0x29, 0x18, 0x8b, 0x81, 0x28, 0xb0, 0x56,
  0xef, 0xd3, 0x07, 0x8a, 0x06, 0xf2, 0x8c, 0x6b, 0xae, 0x9a, 0x4e, 0xd1,
  0x58, 0xb0, 0x16, 0xce, 0xab, 0x21, 0x6b, 0x85, 0xf7, 0x7b, 0x58, 0xda,
  0xe9, 0x5d, 0xec, 0xd2, 0xa5, 0x25, 0x7d, 0xef, 0x46, 0x17, 0xf1, 0x79,
  0xc3, 0x39, 0x18, 0x45, 0x5f, 0x0d, 0x87, 0x7b, 0x67, 0x47, 0xd1, 0x3a,
  0xfd, 0xec, 0x9f, 0x58, 0x29, 0xdd, 0x0d, 0x23, 0x1a, 0xaf, 0xb6, 0xf1,
  0x4c, 0x90, 0x29, 0xc0, 0x72, 0x27, 0x47, 0x51, 0xbc, 0x2b, 0x1a, 0x79,
  0x79, 0xdf, 0xd2, 0x25, 0x67, 0xca, 0x87, 0xc0, 0x85, 0xa8, 0xe5, 0x2f,
  0x8f, 0x2a, 0xf5, 0xb9, 0xb8, 0x9c, 0xf8, 0xef, 0x47, 0x5b, 0xdf, 0x48,
  0xcd, 0x97, 0xcb, 0xf4, 0x8a, 0x83, 0x84, 0xf1, 0xb3, 0x0d, 0x3d, 0xc5,
  0xce, 0x9d, 0x95, 0xc9, 0xf3, 0x4f, 0x7a, 0x49, 0x12, 0x48, 0x45, 0x9a,
  0x10, 0x22, 0x02, 0xe5, 0xc0, 0x20, 0xcc, 0x1b, 0xd8, 0x2e, 0xf6, 0x72,
  0x1a, 0x84, 0x12, 0x40, 0xd8, 0x70, 0x1d, 0x04, 0x75, 0xdf, 0x7d, 0xa3,
  0xd0, 0x9c, 0x9a, 0x64, 0x6b, 0xb5, 0x82, 0xf4, 0x65, 0x31, 0x2f, 0x87,
  0x13, 0x56, 0x41, 0x52, 0x6c, 0x40, 0xec, 0x0c, 0xb7, 0x37, 0xc4, 0xc2,
  0x56, 0xb7, 0x40, 0x8d, 0x4b, 0x86, 0x07, 0x0d, 0xc7, 0x30, 0x88, 0x4e,
  0x17, 0x81, 0x14, 0x76, 0x9d, 0xa4, 0xb9, 0x77, 0x14, 0xfa, 0xf4, 0x53,
  0x70, 0x87, 0xe6, 0x64, 0x15, 0xa7, 0x2b, 0xac, 0x64, 0x10, 0xae, 0xa0,
  0xe0, 0xf5, 0x1b, 0xfb, 0x85, 0x43, 0x89, 0x26, 0xc2, 0x08, 0x67, 0xa4,
  0xc7, 0x37, 0x4e, 0x81, 0xda, 0xfd, 0x90, 0xa7, 0xcc, 0x30, 0xa6, 0x05,
  0x82, 0x53, 0x22, 0x60, 0x3f, 0x3f, 0x54, 0xbc, 0x11, 0xf0, 0x04, 0xd2,
  0x61, 0x5a, 0x57, 0xd8, 0xb1, 0xd6, 0x8a, 0x34, 0x62, 0x4a, 0xe7, 0x43,
  0x1f, 0xa0, 0x48, 0x5b, 0x09, 0x1e, 0xdf, 0xfe, 0x86, 0x2b, 0xb0, 0xec,
  0xfd, 0xa3, 0xd0, 0x25, 0x5a, 0x90, 0x9f, 0x63, 0xd9, 0x46, 0x9b, 0x80,
  0x95, 0x27, 0x0a, 0x1c, 0xab, 0x58, 0x2f, 0x48, 0xa3, 0x74, 0x33, 0x8a,
  0x98, 0xad, 0xb9, 0xda, 0x0d, 0x04, 0x97, 0x0c, 0xc8, 0x08, 0xdf, 0x49,
  0x22, 0xf7, 0x24, 0x5b, 0x32, 0x9f, 0x93, 0x4f, 0xeb, 0x7e, 0x8d, 0x44,
  0xca, 0x5f, 0x15, 0xec, 0x2b, 0x61, 0xe7, 0x46, 0x0b, 0xda, 0xb9, 0xcb,
  0xa4, 0xde, 0x8d, 0x7e, 0xfa, 0xa9, 0x17, 0xfd, 0xd4, 0xa1, 0xff, 0x95,
  0xf4, 0x3f, 0x5a, 0xcf, 0x9f, 0x04, 0x3b, 0xfb, 0xa7, 0x5b, 0xba, 0x47,
  0x23, 0x2e, 0xdb, 0x34, 0x45, 0xca, 0xaf, 0xc7, 0x45, 0x8e, 0x9a, 0x39,
  0x3f, 0x12, 0x7a, 0xe7, 0x22, 0x76, 0x90, 0xee, 0x03, 0xe3, 0x8e, 0x2f,
  0x47, 0x2d, 0xa8, 0xe7, 0xb4, 0x67, 0xcb, 0xd9, 0x5c, 0x74, 0x47, 0xdd,
  0x79, 0xde, 0xf4, 0x66, 0xfa, 0x6a, 0x1c, 0x75, 0x3f, 0x32, 0x87, 0x72,
  0x69, 0x89, 0x68, 0x61, 0xfc, 0x22, 0x0e, 0x84, 0x91, 0xb6, 0x2b, 0x95,
  0x0c, 0x23, 0x70, 0x4b, 0xa5, 0x34, 0xad, 0xdc, 0x77, 0x8a, 0x62, 0xb7,
  0x52, 0x61, 0x0d, 0x0c, 0x56, 0xd8, 0x06, 0x1b, 0x6b, 0x17, 0xd7, 0x0f,
  0xd0, 0xc1, 0xa4, 0x61, 0x5f, 0xef, 0x92, 0x86, 0xd8, 0x82, 0x63, 0xdf,
  0x14, 0xc2, 0x03, 0x3c, 0x25, 0x8b, 0x29, 0x80, 0x3b, 0x3a, 0xe0, 0x2b,
  0x34, 0xb6, 0x6e, 0xbf, 0x5b, 0x45, 0x34, 0xb3, 0xf0, 0x96, 0xb6, 0xc2,
  0x0a, 0x41, 0x0d, 0x84, 0xc7, 0x8a, 0x94, 0xab, 0x3e, 0x63, 0x65, 0xc0,
  0x9d, 0x93, 0x05, 0xce, 0xb3, 0xca, 0x44, 0x54, 0x9f, 0x25, 0xd6, 0xda,
  0x00, 0xbf, 0x57, 0xa8, 0x26, 0x7d, 0x37, 0x2d, 0x43, 0xac, 0xbf, 0xbe,
  0x54, 0x17, 0x53, 0xfc, 0x51, 0x48, 0xaf, 0x40, 0xe9, 0xe2, 0x68, 0x95,
  0x22, 0x9d, 0x2d, 0x1a, 0x16, 0x39, 0x5e, 0x60, 0x2f, 0xfc, 0xf2, 0x30,
  0x80, 0xbb, 0xcc, 0xc5, 0x1b, 0xee, 0xe6, 0xca, 0x46, 0x86, 0x19, 0x72,
  0x7d, 0xc5, 0x68, 0x03, 0x34, 0x08, 0x1f, 0xcf, 0xd2, 0xe2, 0xcd, 0x6e,
  0x98, 0x6f, 0x78, 0x4c, 0xaf, 0xa3, 0xce, 0x4a, 0x6d, 0xa5, 0x53, 0x7f,
  0xe1, 0x98, 0x51, 0x1a, 0x74, 0xc3, 0x05, 0xa1, 0x6b, 0x1c, 0xcf, 0x1d,
  0xb0, 0xd2, 0x14, 0x00, 0x02, 0x5a, 0xdf, 0xc9, 0x41, 0x49, 0xe8, 0xb2,
  0xb5, 0xc1, 0x37, 0x87, 0x29, 0x46, 0x06, 0xf8, 0xa6, 0xa7, 0x92, 0xab,
  0xc5, 0xad, 0x02, 0x2b, 0x34, 0xdb, 0x83, 0x80, 0x2a, 0x4e, 0xb0, 0x06,
  0xaa, 0x9d, 0xaf, 0x9b, 0xd6, 0xf7, 0x77, 0xbb, 0xc7, 0x36, 0xd4, 0x7a,
  0x2c, 0x39, 0x64, 0x2b, 0x90, 0x16, 0x42, 0x06, 0xea, 0xe0, 0x3f, 0x52,
  0x48, 0xf7, 0xf4, 0xde, 0x12, 0xa9, 0x27, 0x12, 0x3e, 0x67, 0x60, 0x40,
  0x2b, 0xa9, 0x1a, 0x0a, 0x0f, 0xf7, 0x98, 0x48, 0x38, 0xbc, 0x2b, 0x7c,
  0x6e, 0x9c, 0x05, 0xb6, 0xf8, 0xc2, 0x09, 0xca, 0x59, 0x4e, 0x0a, 0x6d,
  0x63, 0x67, 0xb6, 0x37, 0x5c, 0x7c, 0x24, 0x8a, 0x1f, 0x49, 0x31, 0x2c,
  0xd5, 0xc6, 0x3a, 0xd7, 0xd9, 0x0c, 0x78, 0x09, 0x9d, 0x5d, 0xd6, 0xb0,
  0x94, 0x2b, 0xf8, 0x59, 0x36, 0x8f, 0x02, 0x20, 0x50, 0xbe, 0x3e, 0x7d,
  0x7b, 0xe8, 0xb2, 0xd3, 0xc4, 0x04, 0xc6, 0x9f, 0xb4, 0x22, 0xb3, 0x0d,
  0x10, 0xa4, 0x6e, 0xd9, 0xda, 0xbd, 0xb5, 0x26, 0x40, 0x36, 0x96, 0xe8,
  0x2a, 0x29, 0x17, 0x77, 0xcb, 0x74, 0xb2, 0x8e, 0xac, 0xfa, 0xe5, 0x3c,
  0xbd, 0xef, 0x8b, 0x05, 0x55, 0x14, 0x3a, 0xcb, 0x29, 0x0f, 0xdc, 0x26,
  0x11, 0x8f, 0xbd, 0x09, 0xa1, 0xa0, 0x54, 0x83, 0x63, 0xa6, 0x30, 0x22,
  0xc8, 0x35, 0x4a, 0xe7, 0x22, 0xc4, 0x48, 0x83, 0x74, 0x6f, 0x9c, 0xce,
  0x89, 0x7d, 0x03, 0x22, 0x05, 0xdb, 0xde, 0x96, 0x69, 0x57, 0x5d, 0x89,
  0x68, 0xef, 0xec, 0xec, 0x60, 0xef, 0x62, 0xcf, 0xcd, 0x0d, 0x90, 0x25,
  0xf0, 0x0b, 0x41, 0x9c, 0x61, 0xfd, 0x3e, 0x17, 0x12, 0xec, 0x7e, 0xcc,
  0xf9, 0x49, 0xf5, 0x1b, 0xf7, 0xec, 0xfc, 0x94, 0x2d, 0x70, 0x1f, 0x6f,
  0x59, 0x3d, 0x22, 0x54, 0xde, 0x68, 0x96, 0x85, 0xd9, 0xd9, 0xe0, 0xc1,
  0xdd, 0xb9, 0xc1, 0x69, 0xf0, 0x8c, 0x48, 0x70, 0xd1, 0x7b, 0xde, 0xcd,
  0x7c, 0xec, 0x24, 0x13, 0x5b, 0x0a, 0xcc, 0xbe, 0xd7, 0x52, 0x28, 0x39,
  0x98, 0x45, 0xe6, 0x99, 0x29, 0xee, 0x7b, 0x5e, 0x2f, 0x29, 0x28, 0x91,
  0x8c, 0x97, 0x25, 0x78, 0x96, 0x1d, 0x09, 0x10, 0xd7, 0x84, 0x97, 0xa9,
  0x7e, 0xd4, 0xeb, 0x7b, 0xe3, 0xd0, 0x67, 0x95, 0xfd, 0x00, 0x72, 0x96,
  0xa8, 0x0c, 0x10, 0xec, 0x03, 0x1d, 0xad, 0x07, 0x40, 0x6d, 0x1c, 0x1c,
  0xc1, 0x3d, 0x23, 0x22, 0x37, 0x62, 0x6c, 0x2c, 0xc8, 0x47, 0xc4, 0xf5,
  0xfa, 0x16, 0x77, 0x29, 0x13, 0xa7, 0x0f, 0x1a, 0x0f, 0x95, 0x0e, 0x50,
  0x5c, 0xef, 0x98, 0x76, 0x26, 0x15, 0x72, 0xa7, 0x4e, 0x23, 0x87, 0x0f,
  0x00, 0x0f, 0xfa, 0x14, 0xd0, 0x45, 0x11, 0x9a, 0xd7, 0x74, 0x72, 0x98,
  0xb7, 0x8d, 0x1e, 0x25, 0x91, 0x98, 0xe4, 0x5b, 0xfe, 0x6b, 0x73, 0x7b,
  0xb0, 0xd5, 0x69, 0x8e, 0x9e, 0x8f, 0xca, 0x25, 0xcc, 0xc5, 0xf1, 0x5c,
  0x2e, 0x67, 0xc1, 0xd2, 0xcc, 0x9e, 0x1e, 0xa0, 0x16, 0x08, 0x8e, 0xe7,
  0xf0, 0xe5, 0xb7, 0x8d, 0xa5, 0x7f, 0xda, 0x70, 0x99, 0x88, 0xdb, 0xcf,
  0xf3, 0xe3, 0x79, 0x86, 0x58, 0xcb, 0x98, 0x2d, 0x66, 0x30, 0x9e, 0x77,
  0xda, 0x17, 0x58, 0x3c, 0xa4, 0x49, 0x7d, 0x9d, 0x1f, 0x05, 0xd0, 0x5d,
  0x1d, 0x3b, 0xe7, 0x68, 0xc0, 0x7d, 0xbc, 0x92, 0xd5, 0x55, 0x7c, 0x85,
  0x56, 0x09, 0xb8, 0x15, 0x2f, 0x71, 0x4f, 0x20, 0x4b, 0x43, 0x35, 0x83,
  0x53, 0x97, 0xb8, 0x54, 0x15, 0x87, 0x1a, 0xb1, 0xea, 0xa4, 0xd9, 0x63,
  0x6a, 0x59, 0x17, 0x29, 0x56, 0xee, 0xc9, 0xe6, 0x55, 0x5b, 0xa9, 0xab,
  0x69, 0x35, 0x88, 0xfb, 0x72, 0xdb, 0xaa, 0xb5, 0x0e, 0x90, 0xff, 0x41,
  0x0d, 0x51, 0x67, 0x1a, 0x5f, 0x91, 0xc7, 0x6f, 0x22, 0x2a, 0xe9, 0x84,
  0x53, 0x78, 0xcb, 0x9d, 0x03, 0x86, 0xd6, 0xf6, 0x4e, 0xcb, 0xfb, 0xe6,
  0xd5, 0x01, 0x6a, 0x36, 0x6f, 0x2b, 0xfa, 0x3d, 0xb7, 0xf9, 0x87, 0xb6,
  0x8a, 0xa5, 0xbb, 0x6a, 0xf3, 0xd1, 0x1c, 0xea, 0x52, 0x1d, 0xdd, 0x1c,
  0x43, 0xa0, 0x19, 0x32, 0xfd, 0x37, 0x41, 0xe1, 0xe3, 0xb9, 0x45, 0xa8,
  0xd3, 0x76, 0x34, 0x3b, 0x92, 0xe8, 0xf0, 0x2c, 0x9f, 0xa1, 0x44, 0x0d,
  0x50, 0xb7, 0xc0, 0x28, 0x32, 0xce, 0x92, 0x8e, 0x0d, 0xc3, 0x4a, 0x8f,
  0x07, 0x75, 0x74, 0x45, 0x42, 0xf3, 0x4a, 0x80, 0x43, 0x43, 0x0a, 0xf0,
  0xb5, 0x09, 0xd9, 0x9c, 0x5e, 0x58, 0xce, 0xdf, 0x7b, 0xe0, 0xe0, 0x4c,
  0x26, 0xeb, 0xcf, 0x36, 0x24, 0x12, 0xd1, 0x95, 0x1d, 0x85, 0xa7, 0x6b,
  0xa5, 0x71, 0xeb, 0x43, 0xf5, 0x4a, 0xef, 0x2d, 0x68, 0x83, 0xae, 0xa8,
  0x68, 0x9c, 0x8f, 0x26, 0xa6, 0xa0, 0x7a, 0x72, 0x1f, 0xb6, 0xa7, 0x57,
  0x24, 0x8b, 0x25, 0x93, 0xcf, 0x1f, 0x11, 0x33, 0x67, 0x5a, 0xd4, 0xd9,
  0x25, 0x62, 0xe1, 0x3d, 0x87, 0x24, 0x1d, 0xe4, 0x28, 0xc0, 0xe4, 0xd1,
  0x86, 0x13, 0xa3, 0x8e, 0x22, 0x9d, 0x1f, 0x80, 0x46, 0x25, 0xe6, 0x06,
  0x5e, 0x88, 0x58, 0xaa, 0x39, 0xd3, 0x60, 0x17, 0xe9, 0x42, 0x84, 0x0b,
  0x8e, 0xf3, 0x98, 0x88, 0xa7, 0x91, 0x69, 0xaa, 0xbe, 0xa9, 0x36, 0x12,
  0xcb, 0xd9, 0x94, 0xc8, 0x99, 0x79, 0xc9, 0x69, 0x5a, 0x23, 0x7a, 0xff,
  0x2e, 0x9d, 0x94, 0xd7, 0xad, 0xd8, 0x61, 0xb2, 0x82, 0x98, 0x73, 0x24,
  0x18, 0x03, 0x1c, 0x8a, 0x81, 0x65, 0x82, 0x83, 0x75, 0x53, 0xac, 0xca,
  0x3d, 0x33, 0x8d, 0xc7, 0x44, 0x72, 0x97, 0x9c, 0x4b, 0x10, 0x35, 0x26,
  0x65, 0x31, 0x64, 0x03, 0x77, 0x78, 0xa5, 0x28, 0xdb, 0x4d, 0x97, 0x6f,
  0xcf, 0xee, 0x37, 0x6a, 0x35, 0x11, 0xe8, 0x11, 0x04, 0x1f, 0x4b, 0x28,
  0x12, 0xdd, 0xab, 0x37, 0xe9, 0xb4, 0x59, 0xa7, 0xeb, 0x01, 0x2a, 0x56,
  0x77, 0x86, 0xd7, 0xdf, 0x76, 0xd5, 0xbe, 0x8f, 0xfa, 0x91, 0xea, 0xfd,
  0x95, 0x2c, 0x81, 0xa8, 0x7b, 0xd5, 0x95, 0xa8, 0xd0, 0xaf, 0xba, 0x96,
  0x73, 0xd0, 0xbc, 0x1b, 0xbd, 0xcb, 0xd8, 0xae, 0x97, 0x62, 0x37, 0xda,
  0xd9, 0xda, 0xfa, 0xa6, 0x17, 0x3d, 0x93, 0x02, 0x86, 0xdb, 0x5f, 0xb5,
  0xae, 0x90, 0x09, 0xa7, 0xd8, 0x65, 0xd5, 0x4b, 0xe3, 0x5b, 0x5c, 0x03,
  0xb2, 0x6e, 0x3d, 0x57, 0xe9, 0x75, 0xb2, 0xcc, 0x4d, 0x78, 0x97, 0xc5,
  0x5f, 0xb1, 0x4f, 0x30, 0x72, 0x0b, 0x9c, 0x83, 0xc4, 0x83, 0x32, 0xc5,
  0xcc, 0x10, 0x64, 0xc3, 0xbb, 0x77, 0x4d, 0xbf, 0xb1, 0xaf, 0xdb, 0x76,
  0x15, 0xbd, 0xb4, 0x64, 0xd9, 0x16, 0xd7, 0x7c, 0xf4, 0x47, 0xcb, 0x1c,
  0xe7, 0x98, 0x9d, 0x86, 0x52, 0x14, 0x83, 0x0d, 0xef, 0xd0, 0x24, 0x04,
  0x71, 0xc1, 0x17, 0xf0, 0xf3, 0x50, 0x13, 0x3c, 0x99, 0x41, 0xf3, 0xf4,
  0x21, 0xe0, 0x26, 0xd7, 0x88, 0x93, 0x40, 0x13, 0xf9, 0x81, 0x94, 0x29,
  0x8c, 0x42, 0x4e, 0x8a, 0x57, 0x4a, 0x44, 0x13, 0x6a, 0xc5, 0x4b, 0x13,
  0x8e, 0x81, 0x4a, 0xe5, 0xa6, 0xc5, 0x4a, 0x0a, 0x89, 0x80, 0x02, 0x49,
  0x48, 0x11, 0x83, 0x20, 0x2d, 0x0c, 0x8d, 0x1f, 0xa3, 0x92, 0x1e, 0x5a,
  0x22, 0x3d, 0xa6, 0xfc, 0xc6, 0xf4, 0x01, 0xc9, 0x18, 0x1c, 0x50, 0x07,
  0xd7, 0x81, 0x8d, 0x30, 0x1c, 0x1c, 0xa7, 0x6d, 0x8e, 0x51, 0x3c, 0x81,
  0x63, 0xa2, 0x7e, 0x3f, 0xcb, 0xd5, 0x94, 0x81, 0xb6, 0xd3, 0xa2, 0xec,
  0xb3, 0x67, 0xb4, 0xdd, 0x2c, 0x0a, 0xd5, 0x83, 0x9f, 0xd1, 0x94, 0x7c,
  0xf6, 0xce, 0x4e, 0x3c, 0xc2, 0x9d, 0x58, 0xbd, 0x11, 0x76, 0x2c, 0x89,
  0x43, 0x85, 0xd6, 0xda, 0x6a, 0x00, 0x0e, 0x48, 0x91, 0xe7, 0xe4, 0x8e,
  0xce, 0xd6, 0xa1, 0x87, 0x18, 0xaa, 0xf2, 0x0e, 0xc3, 0xb1, 0xa7, 0x23,
  0x30, 0xbe, 0xa6, 0xab, 0xa6, 0x8f, 0x88, 0xe5, 0xf6, 0xba, 0xd9, 0x1a,
  0xe1, 0x8b, 0x20, 0x05, 0xb6, 0x68, 0x21, 0xf0, 0xc4, 0xe3, 0x51, 0x14,
  0xa8, 0x15, 0x10, 0xd4, 0x45, 0xf1, 0x5f, 0xf1, 0x28, 0x56, 0x60, 0xda,
  0x08, 0xb8, 0xa3, 0x43, 0xad, 0x81, 0x72, 0x99, 0xe5, 0x06, 0x12, 0xf9,
  0x78, 0x4c, 0x12, 0x88, 0x55, 0x57, 0xe8, 0xe4, 0x78, 0xe8, 0x30, 0x82,
  0x9c, 0xd7, 0xb0, 0x10, 0x4b, 0x02, 0xe9, 0xaf, 0x2c, 0x00, 0xbf, 0x59,
  0x51, 0xe9, 0xb4, 0x70, 0x60, 0xd8, 0x08, 0xae, 0x41, 0xe8, 0x88, 0x88,
  0xc1, 0x69, 0x5e, 0xc9, 0x48, 0xe7, 0x3e, 0xfe, 0x22, 0xf6, 0x38, 0x09,
  0xe7, 0x6a, 0x0f, 0xf2, 0xe0, 0x64, 0xb4, 0xb0, 0xa0, 0x2c, 0xec, 0xd2,
  0x0f, 0xb3, 0x51, 0x46, 0x82, 0x3d, 0xdf, 0xe7, 0x37, 0x55, 0x79, 0x86,
  0xd3, 0x1b, 0x04, 0x13, 0xe2, 0x15, 0x31, 0xb7, 0xcf, 0x7f, 0xec, 0xd3,
  0xbf, 0x3f, 0x37, 0xdc, 0x86, 0xa5, 0xe0, 0x4a, 0xa8, 0xd5, 0xcb, 0x02,
  0x32, 0x73, 0x0f, 0x7c, 0x2d, 0xe5, 0x7d, 0xd1, 0x8e, 0x7c, 0x5b, 0x04,
  0x78, 0xe1, 0x6d, 0x28, 0x00, 0xce, 0x8b, 0x87, 0x8a, 0xef, 0x41, 0x28,
  0x67, 0xa5, 0x8d, 0xd1, 0x03, 0x11, 0x97, 0xdd, 0x3b, 0xb4, 0x51, 0xe3,
  0x38, 0x1f, 0x37, 0xa3, 0xd5, 0x54, 0x18, 0xf2, 0xb5, 0xc6, 0x46, 0xec,
  0x8a, 0x2d, 0x1e, 0x50, 0x4a, 0x1b, 0xd2, 0x1e, 0xa7, 0xd6, 0x58, 0x16,
  0x88, 0xde, 0xd7, 0x32, 0xf4, 0x96, 0x32, 0x02, 0x19, 0x07, 0xcd, 0x2a,
  0xe6, 0x42, 0xc6, 0x29, 0x0e, 0x79, 0xce, 0x58, 0x34, 0x72, 0xfc, 0x2d,
  0xa0, 0x37, 0x90, 0x1e, 0xbc, 0x3f, 0x92, 0x7a, 0x58, 0x2e, 0x5a, 0x9c,
  0xb4, 0x1c, 0xe5, 0xdf, 0xc0, 0x3a, 0x08, 0x93, 0x18, 0x43, 0x00, 0xfc,
  0xd6, 0xc8, 0x0e, 0x00, 0x44, 0x6f, 0x98, 0x81, 0xcc, 0xd5, 0x2b, 0x10,
  0x63, 0xb7, 0xb3, 0xcf, 0x6b, 0xc8, 0xb3, 0x64, 0x64, 0xf0, 0xe4, 0x9a,
  0xe5, 0x70, 0x39, 0x34, 0x6e, 0x22, 0xc8, 0x9e, 0x41, 0x06, 0xbb, 0x61,
  0xef, 0xaf, 0xb3, 0xd3, 0x73, 0x0c, 0xf3, 0x98, 0x86, 0x52, 0xd7, 0xf1,
  0xef, 0x5b, 0xa0, 0xb6, 0xe2, 0xe8, 0xd9, 0xf7, 0xdf, 0x57, 0xb1, 0xc6,
  0x36, 0x2a, 0x0c, 0xab, 0x59, 0x00, 0x8b, 0x88, 0x28, 0x6b, 0x3b, 0xe5,
  0x16, 0xa1, 0x6e, 0x51, 0x9c, 0x1c, 0xc3, 0x00, 0x5d, 0x6f, 0xe0, 0xa2,
  0xc7, 0xad, 0xea, 0xaa, 0xc6, 0x8d, 0x07, 0x21, 0x54, 0x4d, 0x5f, 0x8a,
  0x8b, 0x96, 0xe9, 0xb9, 0xa0, 0x55, 0x89, 0xd9, 0x40, 0x60, 0x97, 0xad,
  0x15, 0x2f, 0x55, 0xe1, 0xe8, 0x86, 0x6e, 0xa8, 0x3b, 0xce, 0x03, 0xff,
  0xee, 0x49, 0x28, 0x34, 0x87, 0x5c, 0xae, 0x78, 0x55, 0x38, 0xbf, 0x52,
  0x60, 0x83, 0xed, 0x57, 0xe3, 0x3c, 0x51, 0x37, 0x8f, 0x15, 0xff, 0x68,
  0x9c, 0x57, 0x31, 0x05, 0x71, 0x8c, 0x12, 0xe6, 0xc7, 0x61, 0xae, 0x72,
  0x72, 0x71, 0x05, 0xf9, 0xb0, 0x87, 0x70, 0xaf, 0xf0, 0x78, 0x9b, 0x26,
  0x7d, 0x87, 0xba, 0x02, 0x60, 0x3c, 0x66, 0xdf, 0x43, 0xbc, 0x92, 0xa6,
  0xf5, 0xe0, 0x2e, 0xc8, 0xff, 0xdc, 0x5a, 0xf9, 0x89, 0xf7, 0xbf, 0x4d,
  0xbc, 0xef, 0x97, 0xf9, 0x12, 0x4b, 0xc4, 0xee, 0x61, 0x94, 0x42, 0xf7,
  0x89, 0x58, 0xec, 0x0e, 0xb4, 0xb8, 0x2c, 0xb9, 0xc4, 0xbc, 0x63, 0x36,
  0x6a, 0xa2, 0x7e, 0xd9, 0xcc, 0x2c, 0xe3, 0x9b, 0x33, 0xbc, 0xab, 0x65,
  0x42, 0xfa, 0x24, 0xa4, 0xf6, 0xf1, 0x58, 0xd1, 0x80, 0x6c, 0xaf, 0x64,
  0x5d, 0x08, 0xda, 0x5e, 0x26, 0x8e, 0xdb, 0x60, 0xcd, 0x4c, 0x9b, 0x30,
  0x22, 0x52, 0x9f, 0x52, 0xcc, 0x14, 0x44, 0x87, 0xee, 0xab, 0xc3, 0x7a,
  0x3d, 0x98, 0x75, 0x40, 0x16, 0xa8, 0x42, 0x89, 0xcc, 0x03, 0xfa, 0xfb,
  0xec, 0xdd, 0xc5, 0x86, 0x37, 0x1a, 0x4c, 0xb2, 0x9a, 0x59, 0xcb, 0x1a,
  0x6f, 0x49, 0xe2, 0x90, 0xe8, 0x7e, 0xc5, 0x05, 0x40, 0x8e, 0x86, 0x3b,
  0x13, 0xec, 0x30, 0x7b, 0xb6, 0xb5, 0x4d, 0x72, 0xdb, 0xd6, 0x0e, 0x0c,
  0x33, 0xcf, 0xb6, 0x9e, 0x39, 0x73, 0xb7, 0x3d, 0xd5, 0xb8, 0xf1, 0x26,
  0xf2, 0x22, 0xf4, 0x47, 0x90, 0xfc, 0xb3, 0xfb, 0x7b, 0x7c, 0xdc, 0xab,
  0x03, 0x89, 0x20, 0xd3, 0x33, 0xc4, 0x0f, 0x6b, 0x0a, 0x23, 0x36, 0x70,
  0xbf, 0xe2, 0x30, 0xb2, 0x2c, 0xe7, 0x12, 0x36, 0xc5, 0x0a, 0x32, 0x72,
  0x05, 0xea, 0x97, 0x43, 0x48, 0x07, 0x8f, 0xb1, 0xa6, 0x63, 0x16, 0xf4,
  0x2b, 0x8c, 0xcc, 0xca, 0x01, 0x31, 0xa2, 0x2f, 0xf6, 0xdb, 0xd4, 0x3c,
  0xcb, 0xe2, 0xab, 0x35, 0xf7, 0x67, 0x9f, 0xa6, 0xca, 0x34, 0x3f, 0x95,
  0x93, 0x11, 0xb0, 0x37, 0x54, 0xb0, 0xe1, 0x74, 0x2b, 0x7f, 0x4c, 0xb2,
  0x81, 0xc1, 0x27, 0x36, 0x32, 0x08, 0x68, 0x95, 0xad, 0x2a, 0x55, 0xca,
  0xf8, 0x05, 0x93, 0xe5, 0x38, 0x91, 0x72, 0x35, 0x24, 0xf2, 0x96, 0x0f,
  0xd1, 0x48, 0x20, 0xdc, 0x0c, 0xc7, 0x21, 0x45, 0x39, 0x76, 0x23, 0xd2,
  0xa6, 0x32, 0x3e, 0xc9, 0x50, 0x78, 0x56, 0x70, 0x72, 0xc5, 0xde, 0xc7,
  0x1a, 0x0e, 0x1b, 0x96, 0x5c, 0x9a, 0x6d, 0x83, 0x41, 0xcc, 0x2f, 0x89,
  0xcd, 0x89, 0x75, 0xb0, 0xe9, 0xb7, 0x00, 0x59, 0xc2, 0x8f, 0x67, 0x96,
  0xf7, 0x58, 0x6a, 0x3b, 0x81, 0x76, 0xbe, 0xe4, 0x38, 0xaf, 0x5a, 0x8b,
  0x15, 0x54, 0x45, 0x3e, 0x2e, 0x90, 0x16, 0x38, 0x08, 0xee, 0x15, 0xf4,
  0x84, 0x95, 0x1e, 0x48, 0x50, 0x86, 0x29, 0x81, 0x12, 0x36, 0xb7, 0x6e,
  0xea, 0xd2, 0x86, 0x4f, 0x86, 0x15, 0x40, 0x80, 0xbb, 0xb9, 0xd4, 0x85,
  0x3f, 0xba, 0x5c, 0x15, 0x77, 0xe7, 0x79, 0x67, 0x5a, 0x0d, 0x73, 0x05,
  0xd7, 0x47, 0x5a, 0x5c, 0xaf, 0x0a, 0xfc, 0xb1, 0xaa, 0x00, 0x94, 0x94,
  0x0b, 0x8e, 0xad, 0x7e, 0x90, 0x86, 0xdc, 0x02, 0x2f, 0x13, 0xfc, 0x3d,
  0xb9, 0x87, 0xe1, 0x9f, 0x4e, 0xc2, 0x27, 0xcf, 0x06, 0x2b, 0xec, 0x0c,
  0x1e, 0x32, 0x1c, 0x13, 0xb3, 0x63, 0x2f, 0x96, 0x72, 0x4e, 0x4d, 0xe0,
  0xbc, 0x3f, 0x86, 0x22, 0x0c, 0x66, 0x07, 0xd5, 0xbe, 0x05, 0x1c, 0xa1,
  0x60, 0xe0, 0x58, 0x91, 0xc1, 0xca, 0x95, 0x40, 0x39, 0x56, 0xcd, 0xc5,
  0x1b, 0x5b, 0x78, 0x9a, 0x0d, 0x17, 0x26, 0x90, 0x57, 0xf9, 0x36, 0xe0,
  0x60, 0x79, 0xcd, 0x81, 0x6b, 0x2c, 0x96, 0xe8, 0x36, 0x60, 0xa0, 0x86,
  0x1b, 0xc0, 0x35, 0xcb, 0xf3, 0x46, 0x5c, 0x0f, 0x92, 0x8b, 0x59, 0xd4,
  0xe4, 0xc5, 0x02, 0x85, 0x04, 0x41, 0xd7, 0x8e, 0x2a, 0x66, 0x9b, 0x42,
  0x18, 0x8f, 0x86, 0x57, 0xbd, 0x35, 0x6b, 0x00, 0xb4, 0xae, 0xb9, 0xc2,
  0x51, 0xea, 0x41, 0x83, 0x3e, 0x35, 0x35, 0x00, 0x0e, 0xa2, 0xf4, 0x6c,
  0x6a, 0x16, 0x20, 0x21, 0xea, 0xa6, 0xcf, 0x85, 0xee, 0xaa, 0x41, 0x80,
  0xbb, 0x17, 0x04, 0x59, 0x2b, 0x40, 0x6a, 0x6a, 0xa0, 0xd7, 0x23, 0x54,
  0x76, 0xfd, 0x5b, 0x36, 0xd2, 0x8b, 0x98, 0x2f, 0x93, 0x36, 0xa8, 0xc3,
  0x4b, 0x84, 0xee, 0x92, 0x96, 0x48, 0xfa, 0xa9, 0x78, 0xaa, 0x78, 0x40,
  0xf3, 0xa4, 0x64, 0x15, 0x09, 0x81, 0xbd, 0x22, 0xc9, 0x92, 0xa6, 0x9b,
  0x49, 0x0d, 0x6e, 0xb9, 0xb4, 0xf9, 0x52, 0x6b, 0x20, 0x27, 0xb9, 0xa2,
  0x20, 0x2a, 0xa9, 0x61, 0x71, 0xd8, 0x1f, 0xb3, 0xe2, 0x96, 0xf9, 0xed,
  0xd4, 0xad, 0xb7, 0xd8, 0x8d, 0x79, 0x33, 0x84, 0xec, 0x2d, 0x3e, 0x1c,
  0x44, 0x07, 0x12, 0xe0, 0x2a, 0x66, 0xf2, 0xa5, 0xa6, 0x5d, 0x49, 0x05,
  0x48, 0xdf, 0xca, 0x7c, 0x93, 0x6b, 0x32, 0x96, 0xf9, 0xb8, 0xd1, 0x88,
  0x93, 0x11, 0x8a, 0xb1, 0xaa, 0xca, 0x03, 0x3c, 0x48, 0x3c, 0xe7, 0xbd,
  0xfe, 0xc2, 0x3b, 0xa6, 0x9e, 0x84, 0x0d, 0x43, 0x2c, 0x68, 0x47, 0xf7,
  0x66, 0xf1, 0xa0, 0x5b, 0x38, 0x3b, 0xb7, 0xea, 0x4e, 0xbc, 0x13, 0x00,
  0x15, 0x6a, 0x2b, 0x1e, 0xe9, 0x00, 0x08, 0x1f, 0x16, 0x0d, 0x0f, 0x7e,
  0x80, 0x81, 0x8f, 0x90, 0xf8, 0x72, 0x61, 0xbe, 0x13, 0x2f, 0xcb, 0xe1,
  0x88, 0xb3, 0x19, 0x38, 0x44, 0xfc, 0x54, 0xe4, 0x8a, 0x96, 0xd1, 0x45,
  0x8d, 0x2a, 0x9d, 0x10, 0x62, 0x30, 0xd3, 0xf5, 0xe7, 0x1b, 0x91, 0x74,
  0xb3, 0xbe, 0xbd, 0x21, 0x00, 0x4d, 0x9a, 0x69, 0xdd, 0x1a, 0xae, 0x60,
  0x30, 0xfe, 0x28, 0x05, 0x10, 0x16, 0x6b, 0x2c, 0x05, 0x41, 0x50, 0x42,
  0x09, 0x1d, 0x66, 0xbe, 0xac, 0x1b, 0x71, 0x01, 0x88, 0x58, 0x2d, 0x72,
  0xab, 0x98, 0x06, 0x16, 0xec, 0x2c, 0x28, 0x04, 0x9f, 0x97, 0x18, 0x6c,
  0x19, 0xe6, 0x56, 0x8d, 0x38, 0xd1, 0x32, 0x97, 0x04, 0xac, 0xe8, 0x2a,
  0xcf, 0x88, 0x27, 0xb0, 0x43, 0x97, 0xa7, 0xba, 0x31, 0x68, 0xb1, 0xe1,
  0xb4, 0xe2, 0xa9, 0x77, 0xd8, 0x95, 0xd5, 0xf1, 0x90, 0xb2, 0x81, 0xb7,
  0xcc, 0x79, 0x59, 0x92, 0x66, 0x56, 0x35, 0x6d, 0x64, 0x83, 0xca, 0xf7,
  0x38, 0x50, 0x20, 0x1d, 0xdf, 0xa8, 0x71, 0x43, 0x30, 0x3a, 0xe1, 0x23,
  0xe1, 0x08, 0x03, 0x15, 0x8a, 0xe8, 0x66, 0x50, 0xb9, 0x0f, 0xaa, 0x0d,
  0x5d, 0x13, 0x4a, 0x60, 0x2d, 0x65, 0x0d, 0x42, 0x88, 0x6e, 0xde, 0x6d,
  0xb5, 0x46, 0xab, 0x66, 0x2f, 0x52, 0xee, 0x24, 0xe3, 0x20, 0x4d, 0xb6,
  0xf2, 0xcb, 0xde, 0xcb, 0xae, 0xb6, 0xc8, 0x02, 0xdd, 0xd9, 0x03, 0x27,
  0x06, 0x77, 0xab, 0x58, 0xbe, 0x5d, 0xe2, 0x54, 0x74, 0x3b, 0x74, 0x6d,
  0x5d, 0x6b, 0xbe, 0xe0, 0x26, 0x28, 0xea, 0x8a, 0xbe, 0x85, 0xa0, 0xa5,
  0x0b, 0xdf, 0xba, 0x34, 0x1e, 0xdc, 0xb0, 0x98, 0x6a, 0xdf, 0xdc, 0xbe,
  0xb5, 0xb6, 0xbf, 0xb5, 0x05, 0xf3, 0x79, 0xf4, 0x78, 0xbe, 0xa7, 0xa1,
  0xf0, 0x9e, 0x81, 0x88, 0x79, 0x2f, 0x38, 0x9d, 0xcb, 0xa2, 0x99, 0x72,
  0xe5, 0xaa, 0xf6, 0xf0, 0x84, 0x99, 0x5e, 0xd8, 0x92, 0x10, 0x5b, 0x1d,
  0x02, 0xe1, 0x5f, 0xf2, 0x36, 0x9b, 0x2e, 0x06, 0x95, 0x51, 0x6a, 0x4c,
  0xd5, 0xe3, 0xc5, 0x6e, 0x2b, 0xe1, 0x57, 0xcd, 0x83, 0x84, 0x4b, 0xb4,
  0xf2, 0x4c, 0x7b, 0x26, 0x29, 0x0b, 0xa4, 0x93, 0x84, 0xa3, 0x5b, 0x24,
  0xe8, 0xe6, 0x6d, 0x3a, 0xce, 0xb3, 0x22, 0xbb, 0x94, 0x4b, 0xdc, 0x08,
  0xd3, 0xd9, 0x2f, 0x38, 0xd3, 0x33, 0x66, 0xa8, 0xf7, 0x26, 0x7b, 0xd0,
  0xc2, 0x4d, 0x12, 0x3b, 0xcb, 0x37, 0xf4, 0x8c, 0xa8, 0x9c, 0x63, 0x2e,
  0xd8, 0xca, 0x58, 0x6a, 0x78, 0x46, 0x00, 0xa8, 0x85, 0xa8, 0x64, 0x8b,
  0xd6, 0x7b, 0xf1, 0xb8, 0x6a, 0xc6, 0x5b, 0xa0, 0x40, 0xff, 0x6a, 0x17,
  0xd4, 0xca, 0x6c, 0x57, 0x86, 0x4f, 0x23, 0x02, 0xb5, 0xbd, 0xd6, 0x3e,
  0x3a, 0x9d, 0x73, 0x21, 0x08, 0xb7, 0x8a, 0x35, 0x1a, 0x96, 0xd7, 0x42,
  0x00, 0x5a, 0x74, 0x74, 0x78, 0xf1, 0x86, 0x4e, 0x5e, 0x1e, 0x5f, 0x96,
  0xfa, 0xa3, 0x61, 0x17, 0xce, 0x93, 0x5f, 0xe2, 0x9b, 0x7e, 0xb1, 0xe0,
  0xbd, 0xea, 0x33, 0xc3, 0xeb, 0x6f, 0x3d, 0x1f, 0x94, 0xf7, 0xed, 0xc9,
  0xc9, 0x88, 0xf6, 0x33, 0xcb, 0x98, 0x42, 0xaf, 0xfb, 0x9d, 0xd3, 0xac,
  0x3b, 0xbe, 0x5b, 0xb3, 0xfb, 0x87, 0x3a, 0x68, 0x5b, 0x5b, 0xc1, 0xc6,
  0x25, 0x6a, 0xb1, 0xe1, 0x71, 0x4f, 0x2c, 0xff, 0x76, 0xe4, 0x1f, 0xd6,
  0x51, 0x63, 0xfb, 0x56, 0xc0, 0xb7, 0x85, 0x78, 0xbe, 0x6d, 0xd1, 0x7d,
  0x8f, 0xc5, 0xf3, 0xad, 0xc8, 0x38, 0x72, 0x01, 0x7e, 0x15, 0x52, 0x6d,
  0x57, 0x14, 0x97, 0x4d, 0x5c, 0x69, 0x87, 0x15, 0x0a, 0xaa, 0xb0, 0x68,
  0x5f, 0x86, 0xf2, 0x81, 0x71, 0xe2, 0x89, 0x52, 0xca, 0x92, 0x69, 0xc8,
  0x81, 0xdd, 0x86, 0xbd, 0x55, 0x23, 0x3b, 0x08, 0xaa, 0xe6, 0xe8, 0x1a,
  0xa0, 0xf0, 0x22, 0xac, 0xa8, 0x75, 0xe6, 0xd6, 0x5f, 0x46, 0xbb, 0x40,
  0xd5, 0x49, 0xe6, 0x0c, 0xc2, 0x6e, 0x27, 0xdc, 0x73, 0xc3, 0xa0, 0x76,
  0x37, 0x58, 0x53, 0x58, 0xa1, 0xb3, 0xbf, 0x6c, 0x1f, 0x5d, 0x9c, 0x27,
  0x7c, 0x3b, 0x49, 0x20, 0x9e, 0x5e, 0xbd, 0xff, 0xa5, 0xf5, 0x98, 0x4f,
  0x36, 0x11, 0x32, 0x3e, 0x5a, 0xf2, 0x77, 0xb5, 0x17, 0x0f, 0xa4, 0xc8,
  0xaa, 0xcc, 0x5b, 0x9e, 0x50, 0x07, 0x60, 0xe0, 0xc9, 0x2b, 0x38, 0x54,
  0x6b, 0x16, 0x16, 0x0e, 0x40, 0x79, 0x61, 0x52, 0xc2, 0xea, 0xd4, 0xb6,
  0x14, 0x6e, 0x52, 0x4b, 0x84, 0xac, 0x19, 0x77, 0xa5, 0x1b, 0xb6, 0x66,
  0x84, 0xcd, 0xb7, 0x79, 0x4a, 0xf1, 0x3a, 0xfc, 0x5a, 0xf0, 0x8b, 0x88,
  0xd4, 0x2f, 0x11, 0xb7, 0xaa, 0xd0, 0x6a, 0x13, 0x80, 0x98, 0x06, 0x90,
  0x3c, 0x6d, 0xfe, 0xf5, 0x92, 0x24, 0xd2, 0x5e, 0x8b, 0x61, 0xd6, 0x6c,
  0x85, 0xe0, 0x6e, 0x74, 0xb5, 0x6a, 0x82, 0xb4, 0xa5, 0xd1, 0x48, 0x0b,
  0x9c, 0x89, 0x7b, 0x0b, 0x38, 0xba, 0x06, 0x1e, 0x7a, 0xdb, 0xe8, 0x7c,
  0xf5, 0xea, 0xb8, 0xf4, 0x0b, 0xd8, 0x1e, 0xfc, 0xe5, 0x8b, 0xb5, 0x19,
  0x90, 0x53, 0x72, 0x15, 0x54, 0xed, 0x56, 0x8a, 0xb3, 0xfc, 0x2c, 0x78,
  0xc3, 0x0c, 0x88, 0xa7, 0xc1, 0x4f, 0x04, 0x8b, 0x9e, 0xf8, 0x89, 0xf4,
  0x29, 0x2c, 0xca, 0x23, 0x11, 0xb4, 0x8c, 0xa4, 0x9a, 0x37, 0xf0, 0x18,
  0x1d, 0x68, 0x69, 0x63, 0x9f, 0x63, 0xc0, 0x09, 0xc7, 0x30, 0xce, 0xa9,
  0x39, 0xf0, 0x62, 0x3f, 0x04, 0x6b, 0x24, 0x1d, 0xae, 0x58, 0x99, 0x60,
  0xa3, 0xf0, 0x6e, 0x73, 0xd7, 0xfa, 0xec, 0x7f, 0xe2, 0xda, 0xf8, 0x19,
  0x04, 0xcb, 0xe3, 0x3e, 0xac, 0x2d, 0x8d, 0x26, 0x58, 0xa5, 0x93, 0xf6,
  0xcc, 0x28, 0x5d, 0x21, 0xc3, 0xa3, 0xd5, 0x35, 0xe2, 0x24, 0x26, 0xcb,
  0x62, 0x3b, 0x3a, 0xa0, 0xd1, 0xb0, 0xa0, 0x73, 0x45, 0x83, 0xfb, 0xf2,
  0x61, 0x05, 0x9e, 0x34, 0x70, 0xc5, 0x4d, 0x63, 0x84, 0xc7, 0x0c, 0xe5,
  0x3e, 0xbc, 0x39, 0x88, 0xdb, 0x48, 0x42, 0x4c, 0x05, 0xf1, 0x54, 0x5a,
  0x86, 0x5f, 0xb3, 0xa2, 0x69, 0xee, 0xb1, 0x29, 0x10, 0xa3, 0x70, 0xbd,
  0xcc, 0x25, 0xd2, 0x4f, 0xb3, 0xa9, 0x14, 0x5b, 0x25, 0x4f, 0x14, 0xeb,
  0x35, 0x18, 0x70, 0xd1, 0x72, 0x51, 0x71, 0x22, 0x41, 0x92, 0xcc, 0x14,
  0xf0, 0x64, 0x94, 0x67, 0x37, 0x74, 0x3e, 0xf8, 0x35, 0xc8, 0xa4, 0xbc,
  0xfa, 0x72, 0xc8, 0xcd, 0x5a, 0x42, 0xc7, 0x40, 0x72, 0xe1, 0x5b, 0x6c,
  0x3f, 0xb9, 0xe1, 0x7d, 0x6a, 0x5e, 0x87, 0x3f, 0x2d, 0x82, 0x03, 0x84,
  0x68, 0x34, 0xbb, 0x4a, 0x71, 0xf3, 0x70, 0xd1, 0x0c, 0xef, 0x72, 0x6f,
  0x16, 0x71, 0xaa, 0xa3, 0x8e, 0xfe, 0xee, 0x34, 0xe4, 0xc8, 0x22, 0xa4,
  0xa1, 0x96, 0x2d, 0x0f, 0x89, 0xa9, 0x9c, 0xce, 0x5c, 0xe6, 0xb0, 0xc9,
  0x7d, 0xd1, 0xc9, 0xc5, 0xf1, 0xdb, 0x68, 0x85, 0xc0, 0x87, 0xef, 0xaa,
  0x5f, 0xfd, 0x3b, 0x62, 0x1f, 0x7d, 0x71, 0x74, 0x34, 0x84, 0xd0, 0xa7,
  0xbe, 0xad, 0x86, 0xc3, 0x56, 0x2a, 0xa5, 0xe3, 0x92, 0xcc, 0x53, 0xd2,
  0xd0, 0x48, 0x22, 0xf0, 0x55, 0xe4, 0xd9, 0x5a, 0x90, 0x73, 0x43, 0x52,
  0xf7, 0x13, 0xcc, 0x9a, 0x91, 0x82, 0xa6, 0xa0, 0xb6, 0x45, 0xd2, 0x70,
  0xb8, 0x2f, 0x34, 0x90, 0xd1, 0x91, 0x88, 0xc2, 0xcb, 0xf0, 0xd9, 0xe7,
  0x22, 0x55, 0x13, 0xe5, 0x1c, 0x29, 0xa0, 0x69, 0x59, 0x70, 0x50, 0xa5,
  0xf5, 0x26, 0x45, 0x38, 0xd1, 0x0a, 0xcc, 0x75, 0x4f, 0xd8, 0xaa, 0xb9,
  0xd1, 0x45, 0x9e, 0xe5, 0xb0, 0xf4, 0x07, 0xa0, 0x0c, 0x8c, 0x24, 0xb4,
  0x84, 0x4f, 0x9d, 0x87, 0xf7, 0x90, 0x35, 0x62, 0x93, 0xef, 0xae, 0x33,
  0xf1, 0x68, 0x63, 0x99, 0x99, 0xca, 0xc4, 0x6f, 0x0a, 0x8b, 0xbe, 0x24,
  0xf3, 0xcb, 0x3d, 0xef, 0x49, 0x23, 0xdc, 0xa8, 0xd6, 0x80, 0x1b, 0x2b,
  0x13, 0x23, 0x79, 0x1c, 0x24, 0x63, 0xb0, 0xc1, 0x8a, 0x36, 0xe7, 0x20,
  0xbd, 0x5a, 0x05, 0x76, 0xd3, 0x2a, 0x4f, 0xf2, 0x88, 0x1e, 0x17, 0x25,
  0xdb, 0x62, 0x0e, 0x2b, 0xa2, 0x24, 0x51, 0xdb, 0x6f, 0x95, 0x3f, 0xc2,
  0xc7, 0x7c, 0xb5, 0x14, 0xf9, 0x84, 0xa8, 0x58, 0x4b, 0xfd, 0xe0, 0xa9,
  0xfd, 0x97, 0xca, 0x3d, 0x19, 0x8d, 0x54, 0xe5, 0x83, 0x47, 0x8a, 0xc4,
  0x9b, 0x04, 0x91, 0xe9, 0x43, 0x21, 0x08, 0x4c, 0x51, 0x4e, 0xb2, 0xa5,
  0xf8, 0x84, 0x2c, 0xbc, 0x41, 0xf8, 0xf4, 0x3f, 0xfe, 0xd9, 0x74, 0x72,
  0xfd, 0xf8, 0xb3, 0x08, 0xa6, 0x12, 0xc3, 0xe7, 0xe3, 0xd9, 0x8c, 0xa8,
  0x0a, 0x0f, 0xeb, 0xc5, 0xdb, 0xc7, 0xb1, 0xf2, 0x32, 0x45, 0x39, 0x5c,
  0x0d, 0x60, 0x6d, 0xf1, 0xed, 0x2a, 0x93, 0xd5, 0xb1, 0x59, 0x06, 0x17,
  0x50, 0x16, 0x82, 0xda, 0x7e, 0x2e, 0xc6, 0x2a, 0x32, 0x84, 0x96, 0xc9,
  0x2a, 0xa0, 0x13, 0x8b, 0x77, 0x55, 0x10, 0x0d, 0x0b, 0x5b, 0xe5, 0x58,
  0x43, 0x31, 0x8d, 0x62, 0xfc, 0xcc, 0x1c, 0x8f, 0xa5, 0x2c, 0x44, 0x33,
  0x0b, 0x5f, 0x36, 0x5a, 0xc3, 0x06, 0xff, 0xc1, 0x65, 0xb6, 0xcb, 0xbb,
  0xec, 0x9f, 0x03, 0x36, 0xca, 0x43, 0xad, 0xef, 0x67, 0x02, 0xda, 0xf7,
  0xfe, 0xa3, 0x6d, 0x56, 0xae, 0x3a, 0x4d, 0xa8, 0x42, 0xac, 0x80, 0xed,
  0xb9, 0x8b, 0x02, 0x5e, 0x91, 0xf4, 0x5f, 0xed, 0x8e, 0x7b, 0xe9, 0xb1,
  0x21, 0xe1, 0x9f, 0x03, 0xfe, 0xf7, 0xc7, 0xed, 0xfe, 0x8b, 0x9f, 0x5d,
  0xaf, 0x1f, 0x6d, 0xbf, 0xff, 0x68, 0xa7, 0xd3, 0x8a, 0x66, 0xc8, 0x6a,
  0x68, 0xa4, 0x40, 0xef, 0x61, 0x68, 0x62, 0xac, 0xf5, 0xc4, 0xc4, 0x3f,
  0x1d, 0x17, 0x3e, 0x96, 0xca, 0xc1, 0x1d, 0x35, 0x4b, 0x9c, 0x17, 0x4f,
  0x80, 0xad, 0x84, 0x45, 0x81, 0x82, 0x08, 0x44, 0xad, 0x91, 0x23, 0x50,
  0xa9, 0x70, 0xd4, 0x9b, 0x85, 0xaf, 0x81, 0x68, 0xc1, 0x11, 0x03, 0x93,
  0x07, 0xba, 0xb1, 0x24, 0xc9, 0x3c, 0x20, 0xeb, 0x53, 0x80, 0xb6, 0x30,
  0x22, 0x49, 0xbf, 0xc5, 0x60, 0x23, 0x44, 0x1d, 0x50, 0x75, 0xac, 0x3d,
  0xb9, 0x48, 0xb7, 0x89, 0x61, 0x2e, 0x3a, 0x60, 0x13, 0xa9, 0x7f, 0x0c,
  0x8c, 0x9c, 0x06, 0x6e, 0x08, 0xd2, 0x2f, 0x9c, 0x81, 0x3d, 0x84, 0xb6,
  0x09, 0x5f, 0xd6, 0x63, 0xdc, 0xf3, 0xb5, 0xa9, 0x51, 0x47, 0x61, 0x59,
  0x36, 0x73, 0x6c, 0x07, 0x1b, 0xad, 0x91, 0x52, 0x86, 0xb1, 0xe2, 0xcb,
  0x47, 0x46, 0x61, 0xa1, 0xf3, 0x42, 0x50, 0xec, 0x58, 0x55, 0x93, 0xda,
  0xdb, 0xc9, 0xc4, 0xc1, 0x13, 0x37, 0xa2, 0xb5, 0xb4, 0x20, 0x4e, 0xcf,
  0x81, 0x22, 0x24, 0xd3, 0x22, 0x69, 0xc5, 0xfb, 0x64, 0xa2, 0x58, 0x1a,
  0x2e, 0xa1, 0xab, 0xa0, 0x1c, 0x12, 0x04, 0xcc, 0x1f, 0xe0, 0xdc, 0x92,
  0xe5, 0xaf, 0x44, 0xf1, 0x14, 0x55, 0x54, 0xb6, 0xa8, 0x1f, 0x37, 0x7c,
  0x2e, 0x95, 0xf0, 0x58, 0xf1, 0xe5, 0x56, 0x0b, 0xe5, 0x68, 0x79, 0x71,
  0xab, 0x44, 0xe3, 0x26, 0xa5, 0xe5, 0xe0, 0x5a, 0xaa, 0xbd, 0xa9, 0x29,
  0x40, 0xb2, 0xc5, 0xea, 0x54, 0x22, 0x99, 0x63, 0xce, 0x0a, 0x0c, 0x8f,
  0x5b, 0x26, 0x39, 0x1d, 0x6c, 0x5f, 0x6d, 0x42, 0x43, 0xb9, 0x8b, 0xaa,
  0xa2, 0xe0, 0x60, 0x38, 0xc6, 0x85, 0xc6, 0x60, 0x1a, 0x02, 0x5d, 0x5e,
  0x9d, 0x6f, 0x8b, 0xc8, 0xeb, 0xca, 0x7f, 0x2d, 0xdd, 0xf5, 0x2d, 0x89,
  0x54, 0x38, 0x92, 0x1d, 0x3a, 0xbc, 0x51, 0xbf, 0x23, 0x89, 0x8a, 0x90,
  0xc6, 0x83, 0xe6, 0x1e, 0xc5, 0xb2, 0x79, 0x59, 0x85, 0xa0, 0x67, 0x4d,
  0x3d, 0x7a, 0xb5, 0xb8, 0xce, 0x49, 0xe8, 0x78, 0x24, 0x07, 0x99, 0x9f,
  0x92, 0x87, 0x1c, 0x03, 0x0c, 0x2a, 0x60, 0xff, 0x8e, 0xd9, 0xb0, 0x1c,
  0x38, 0xfb, 0x6c, 0x6b, 0xbb, 0x4e, 0x0d, 0x95, 0x62, 0x93, 0x39, 0x2a,
  0xc1, 0x95, 0xa8, 0xba, 0x14, 0x45, 0x3b, 0x9f, 0x6c, 0x7f, 0xb2, 0xb9,
  0xbd, 0x35, 0x78, 0x36, 0xd8, 0x09, 0x13, 0x79, 0x48, 0xfd, 0xba, 0x45,
  0x8d, 0x6d, 0xf6, 0x97, 0xb7, 0xbb, 0x98, 0x59, 0xc2, 0xa6, 0xe6, 0xd8,
  0x19, 0xee, 0x3e, 0x81, 0xb2, 0xeb, 0x6f, 0xd6, 0x98, 0xbd, 0xe1, 0xce,
  0xdd, 0x6a, 0xc8, 0xee, 0x2d, 0x25, 0x1e, 0x78, 0x28, 0x2a, 0x95, 0x2d,
  0x91, 0x3c, 0xb7, 0x1c, 0xa5, 0x24, 0x55, 0x94, 0x5c, 0xce, 0x86, 0x33,
  0xe6, 0x48, 0xd2, 0x34, 0xe4, 0x8a, 0x1e, 0xca, 0xfb, 0x05, 0xa5, 0xae,
  0xda, 0x31, 0x4d, 0xe6, 0x26, 0x44, 0x20, 0x27, 0xc9, 0xc8, 0x1e, 0x89,
  0x56, 0xa9, 0xa4, 0xe1, 0x01, 0x7e, 0x81, 0xee, 0x62, 0x54, 0x31, 0xf8,
  0xda, 0xd2, 0x00, 0xe3, 0xd6, 0xe0, 0x2d, 0x75, 0x47, 0xab, 0xa0, 0x13,
  0x4b, 0x14, 0x01, 0xd6, 0x12, 0x68, 0x04, 0xfa, 0x81, 0xd0, 0x2a, 0x7c,
  0x8b, 0x6c, 0x6c, 0xe2, 0x79, 0xb7, 0x41, 0x09, 0xa5, 0x0e, 0x3b, 0xdc,
  0xef, 0xb8, 0x66, 0xf3, 0xb3, 0x43, 0x0d, 0xf1, 0x25, 0x77, 0xde, 0xb2,
  0xf5, 0x68, 0xd4, 0xd0, 0x23, 0xb8, 0x4b, 0x22, 0xbe, 0x11, 0xab, 0x61,
  0x81, 0xef, 0x51, 0x8a, 0x58, 0xb0, 0x7f, 0x80, 0xc3, 0x67, 0x53, 0x49,
  0xbf, 0xa8, 0x99, 0xbb, 0x4c, 0x37, 0xd0, 0x5a, 0x35, 0xb3, 0xd9, 0xb2,
  0x51, 0x93, 0xd5, 0x4a, 0xe3, 0xa8, 0x9c, 0x57, 0x06, 0xc1, 0xa9, 0x18,
  0x86, 0x33, 0x11, 0x5a, 0x70, 0x65, 0x2c, 0x69, 0xce, 0x73, 0xe1, 0xb7,
  0xed, 0x04, 0xb6, 0xe9, 0xe2, 0x2a, 0x72, 0x4e, 0x5a, 0xea, 0x93, 0x44,
  0xb1, 0x68, 0x14, 0xe6, 0xdb, 0x69, 0x4e, 0x19, 0xd0, 0x29, 0x8f, 0x4e,
  0x98, 0x3b, 0x5f, 0xe9, 0x7d, 0x8f, 0xc2, 0x99, 0xda, 0xcc, 0x56, 0x89,
  0x3b, 0x5a, 0x50, 0x59, 0xe6, 0xf8, 0x4e, 0x2c, 0x26, 0x68, 0x13, 0x6c,
  0x90, 0x85, 0x70, 0x5e, 0x96, 0xa0, 0x2f, 0x61, 0xa2, 0x8d, 0x09, 0xe3,
  0x76, 0x92, 0x08, 0x21, 0x79, 0x2e, 0xb5, 0x9a, 0x33, 0x96, 0xa2, 0x55,
  0x1f, 0xa4, 0xee, 0x0a, 0xe6, 0xd4, 0x14, 0xdf, 0x0b, 0xe9, 0x88, 0x07,
  0x56, 0x2b, 0x91, 0x27, 0x6b, 0x34, 0x81, 0x1e, 0xd1, 0xba, 0x48, 0xcd,
  0x55, 0x12, 0xa5, 0xa3, 0x3e, 0x02, 0xa9, 0x92, 0xf3, 0x2f, 0x2e, 0x92,
  0xf4, 0xdf, 0xb2, 0x4a, 0xda, 0x57, 0x6b, 0xdc, 0x4d, 0xb8, 0x4c, 0x8d,
  0x19, 0xad, 0xf2, 0x8f, 0xac, 0xd8, 0xf9, 0x55, 0x3e, 0x92, 0xfa, 0xb4,
  0xda, 0xdc, 0xd6, 0xed, 0x13, 0x93, 0x62, 0x10, 0x81, 0xa3, 0x46, 0x7d,
  0x19, 0x6e, 0x7e, 0xe8, 0xb8, 0x6e, 0x58, 0x70, 0x0f, 0x6b, 0x20, 0x5e,
  0x85, 0x14, 0x9e, 0x3e, 0xde, 0xac, 0x9d, 0x3d, 0xb2, 0x8b, 0x0e, 0x47,
  0x5c, 0xe6, 0xdc, 0x34, 0x03, 0xfc, 0x7b, 0xbb, 0x08, 0x4b, 0x44, 0x65,
  0x0f, 0xd1, 0x45, 0x65, 0x2a, 0x75, 0x2c, 0x99, 0xea, 0xe6, 0x2d, 0x36,
  0x75, 0x26, 0x25, 0xc7, 0x5a, 0x4e, 0x5b, 0x03, 0xc1, 0x50, 0xf4, 0x95,
  0x86, 0x2f, 0xea, 0xab, 0x5d, 0x8f, 0xeb, 0xfd, 0x7b, 0x7b, 0x77, 0xa3,
  0xd7, 0x8c, 0x43, 0x04, 0x87, 0x69, 0xb9, 0x69, 0xac, 0x25, 0x98, 0x22,
  0x0c, 0x55, 0x50, 0x8b, 0x4e, 0xe2, 0x0f, 0x19, 0x88, 0xab, 0x9c, 0x6a,
  0x65, 0xeb, 0xb9, 0x9f, 0x47, 0xe0, 0x77, 0x67, 0x24, 0xff, 0x4c, 0x2d,
  0xce, 0x2d, 0x2d, 0xb5, 0xe4, 0x06, 0x20, 0xb8, 0x20, 0x0e, 0xbb, 0xc0,
  0x0a, 0x85, 0x0c, 0xa4, 0x5e, 0x1a, 0x4c, 0x94, 0x7a, 0x8d, 0x17, 0xd4,
  0x11, 0xc2, 0x95, 0x0a, 0x01, 0x23, 0x72, 0xab, 0x2f, 0x60, 0xc0, 0xb2,
  0x04, 0xd1, 0xfe, 0xe9, 0xc9, 0xc9, 0xe1, 0xfe, 0x45, 0x10, 0x48, 0xd9,
  0x0c, 0x73, 0x69, 0xaa, 0xe5, 0xaa, 0xfe, 0x4b, 0x40, 0x9d, 0x46, 0x56,
  0xa9, 0x99, 0xd5, 0xbc, 0xb8, 0x4a, 0x7d, 0xac, 0x61, 0xb7, 0xeb, 0x8b,
  0xe2, 0xbf, 0x8f, 0xe7, 0x12, 0xe0, 0xa7, 0x6b, 0x65, 0x4b, 0x55, 0x66,
  0x95, 0x63, 0xb9, 0x1c, 0x3d, 0x02, 0xd7, 0xc2, 0x62, 0x92, 0x98, 0x46,
  0x1e, 0x45, 0x6a, 0x71, 0xce, 0x1b, 0x31, 0x01, 0xac, 0xc4, 0x46, 0xfc,
  0x9f, 0x8e, 0xd4, 0x72, 0xb6, 0x19, 0x94, 0xd9, 0x7b, 0xa5, 0x50, 0x74,
  0x9f, 0xaf, 0xa8, 0xe4, 0x04, 0x73, 0x57, 0x11, 0x24, 0x06, 0x97, 0x59,
  0xbe, 0x39, 0x85, 0xf0, 0xc1, 0xf1, 0xbd, 0xd9, 0xd4, 0xca, 0x24, 0x07,
  0x95, 0xe0, 0x5a, 0x38, 0x20, 0xf5, 0xe7, 0x2e, 0x52, 0xb5, 0x31, 0x59,
  0x52, 0x09, 0x62, 0x1b, 0x5c, 0x51, 0x34, 0xae, 0xef, 0xe5, 0xc2, 0xd4,
  0xbd, 0xc1, 0xa1, 0x9e, 0x0a, 0xca, 0x05, 0xbd, 0xd8, 0xeb, 0xb2, 0x60,
  0x8d, 0x27, 0x65, 0x60, 0x5b, 0xbc, 0x28, 0xe5, 0xe4, 0xab, 0x15, 0xb6,
  0x78, 0x2b, 0x8c, 0x56, 0xe4, 0x98, 0x34, 0x43, 0xf7, 0x51, 0x6b, 0x8e,
  0x01, 0x2c, 0x3d, 0xb8, 0x9f, 0x41, 0xf4, 0x49, 0x82, 0x55, 0x5e, 0xf6,
  0xd4, 0xda, 0x8c, 0x72, 0x6b, 0xa8, 0xfa, 0xeb, 0xe3, 0x9c, 0x5b, 0xc2,
  0xb4, 0x18, 0x2d, 0x76, 0xd1, 0x68, 0x04, 0xaa, 0xae, 0xa3, 0x5b, 0x5a,
  0x11, 0xb7, 0xfc, 0xde, 0xa0, 0xd7, 0x50, 0x61, 0x04, 0x3c, 0xa5, 0xa1,
  0xfd, 0x3b, 0xa8, 0xbf, 0xf6, 0x0a, 0x92, 0xe9, 0x80, 0xb5, 0x07, 0x46,
  0x01, 0xec, 0xc8, 0xb4, 0x8b, 0x0a, 0xc8, 0x8e, 0x7b, 0x9b, 0x66, 0x1d,
  0x00, 0x12, 0x36, 0xa3, 0x0a, 0x8d, 0x97, 0xaa, 0xd2, 0x03, 0xe1, 0x67,
  0xfd, 0xdd, 0x3c, 0xbd, 0x87, 0xb4, 0xd7, 0x84, 0x52, 0x72, 0x6d, 0xad,
  0x1e, 0x56, 0x67, 0xfb, 0xe5, 0xce, 0x60, 0xfb, 0x93, 0xcf, 0x06, 0x24,
  0xbc, 0x6f, 0x77, 0xc2, 0x54, 0x7d, 0xb8, 0x9e, 0xb8, 0x0d, 0x39, 0xb3,
  0x6b, 0x2d, 0x1c, 0xb8, 0x2d, 0x16, 0x23, 0x6c, 0x7b, 0xf6, 0x30, 0x08,
  0x82, 0x29, 0x2a, 0xad, 0x6b, 0xb0, 0x45, 0xbd, 0xd5, 0x7e, 0x60, 0x31,
  0x03, 0x93, 0x80, 0x50, 0xd9, 0x56, 0xf4, 0xce, 0x20, 0x6d, 0x5c, 0xb1,
  0xbb, 0x36, 0xa8, 0xe4, 0x80, 0x08, 0xda, 0x4b, 0xe0, 0xb9, 0xfe, 0x7f,
  0x75, 0x66, 0x5e, 0xe3, 0x50, 0xb3, 0xef, 0xc5, 0x31, 0x63, 0x55, 0x46,
  0x9d, 0x97, 0x0a, 0x27, 0x42, 0x62, 0xd0, 0x5d, 0x45, 0xd0, 0x81, 0xf3,
  0xd6, 0xc0, 0x39, 0x1c, 0xde, 0x1e, 0xcb, 0x5a, 0x5a, 0x0b, 0x6a, 0xec,
  0xf9, 0x3c, 0xcb, 0xf0, 0xca, 0x40, 0xcb, 0x2e, 0x36, 0x9a, 0x45, 0x22,
  0xb4, 0xd9, 0x4f, 0x16, 0x6c, 0x0c, 0xc5, 0x8b, 0x69, 0xa1, 0xc5, 0x31,
  0xad, 0x39, 0x7e, 0xe7, 0xcf, 0x7f, 0x0e, 0xd8, 0xd0, 0xdf, 0x6d, 0x0d,
  0x0c, 0xca, 0xc5, 0x03, 0x6b, 0x78, 0x4c, 0x91, 0xcc, 0x10, 0x1f, 0x3c,
  0x68, 0x4b, 0xcf, 0x14, 0x25, 0x64, 0x46, 0x37, 0x93, 0x70, 0x1c, 0xc6,
  0x41, 0xe4, 0x23, 0xa6, 0x46, 0x89, 0x60, 0x53, 0x28, 0xa4, 0x80, 0xc6,
  0x96, 0xc3, 0x20, 0x15, 0x40, 0x5a, 0x34, 0xf3, 0x40, 0xaa, 0x11, 0x5a,
  0xad, 0x28, 0x05, 0x45, 0xc2, 0xf5, 0x84, 0x61, 0xda, 0x09, 0x26, 0xf7,
  0xdf, 0xa9, 0x55, 0xe0, 0x99, 0x3c, 0x5a, 0xa4, 0x53, 0x4b, 0x60, 0xb3,
  0x17, 0x9e, 0x19, 0x46, 0x9c, 0x8f, 0xd2, 0x32, 0x8f, 0x35, 0x04, 0x41,
  0xf3, 0x74, 0x82, 0xbb, 0x0d, 0xf9, 0x44, 0x2c, 0x97, 0x0d, 0x57, 0x65,
  0xea, 0x10, 0x47, 0xf9, 0xef, 0xe8, 0xd5, 0x97, 0xf4, 0x14, 0xfc, 0x2b,
  0xb6, 0x6b, 0x7e, 0x79, 0xf8, 0xe6, 0xf4, 0xfc, 0xb0, 0x56, 0xee, 0xae,
  0xe0, 0xe0, 0xc8, 0xa6, 0xe8, 0x24, 0xd0, 0xd0, 0xeb, 0xa8, 0xff, 0x23,
  0xba, 0x61, 0x08, 0x0d, 0x71, 0xf6, 0xdd, 0x41, 0xc0, 0xa3, 0x2d, 0xc3,
  0xc8, 0x1a, 0xed, 0x35, 0x63, 0xaf, 0xd8, 0x41, 0xc1, 0x47, 0x7b, 0x03,
  0xe5, 0x9c, 0xe4, 0xa4, 0xd9, 0x00, 0x91, 0xcb, 0x26, 0xfd, 0x69, 0xb1,
  0xb7, 0xb0, 0x40, 0xfc, 0xaa, 0xc0, 0xd5, 0xb0, 0xfc, 0xd2, 0xcc, 0xc4,
  0x36, 0xc6, 0xaa, 0x60, 0x54, 0x92, 0x01, 0x8a, 0xed, 0x58, 0x3e, 0x87,
  0x5b, 0x09, 0xf8, 0x00, 0x5b, 0xa0, 0xae, 0xa5, 0x5b, 0x4b, 0x5f, 0x96,
  0xda, 0x59, 0x6a, 0x7a, 0x9a, 0x44, 0x96, 0xf3, 0x16, 0xa6, 0x98, 0xfd,
  0x4d, 0x80, 0x81, 0x2e, 0x25, 0x07, 0x70, 0x55, 0x42, 0xa2, 0xf5, 0xbc,
  0x5e, 0x6c, 0x54, 0x8a, 0x45, 0xb9, 0x5a, 0x9d, 0x3c, 0xe8, 0xee, 0x9f,
  0xbb, 0xd1, 0x7a, 0xe9, 0x6a, 0x4a, 0xb7, 0x64, 0xbd, 0x39, 0xec, 0x32,
  0x15, 0xca, 0x99, 0x64, 0x06, 0xce, 0x46, 0xd7, 0x8e, 0x42, 0xef, 0xeb,
  0x55, 0xb7, 0x86, 0x48, 0xbb, 0xec, 0x1c, 0x41, 0x83, 0xd0, 0x04, 0x20,
  0x07, 0x71, 0xe0, 0x8a, 0xea, 0x49, 0x23, 0x76, 0xe0, 0x5a, 0xb3, 0x2f,
  0x83, 0xb0, 0x5b, 0x67, 0x69, 0x8f, 0x47, 0x8a, 0xb5, 0xf6, 0x83, 0xd9,
  0xb2, 0x10, 0x80, 0x5e, 0x3c, 0xcc, 0x4b, 0xbe, 0xad, 0x25, 0xee, 0x52,
  0x4b, 0xde, 0x36, 0x8b, 0x92, 0xfb, 0x0d, 0xa3, 0x6d, 0x38, 0x7f, 0xb3,
  0xff, 0xf2, 0xc5, 0x4b, 0x3e, 0x78, 0x00, 0x04, 0xa7, 0xf3, 0xc0, 0x4f,
  0xa8, 0xeb, 0xae, 0x27, 0xa7, 0x21, 0xc4, 0xc3, 0x6f, 0x01, 0xcb, 0x91,
  0xbd, 0x87, 0xc8, 0xc2, 0xa8, 0x62, 0x53, 0x89, 0x16, 0x1c, 0x06, 0xed,
  0x0c, 0x56, 0x62, 0x79, 0xaf, 0x82, 0xe8, 0xae, 0x15, 0xb7, 0x31, 0x4b,
  0x37, 0xb7, 0x09, 0xe7, 0xa1, 0x56, 0xc6, 0x30, 0x61, 0x9d, 0x2b, 0x08,
  0x43, 0x96, 0xb6, 0x0d, 0xec, 0x05, 0xd4, 0xe6, 0x8a, 0x8e, 0x14, 0x6d,
  0xcd, 0x09, 0x2a, 0x92, 0x9f, 0x88, 0x52, 0x5d, 0x90, 0xa8, 0x30, 0xab,
  0x56, 0xcb, 0xe2, 0xb2, 0x96, 0x2b, 0x0b, 0xb4, 0xab, 0x6a, 0x8e, 0x6c,
  0x3e, 0x8e, 0xa9, 0x9f, 0x4e, 0x03, 0xf2, 0x42, 0x7f, 0xd5, 0xee, 0x9a,
  0xa5, 0x87, 0xae, 0xaf, 0xf2, 0x85, 0x06, 0x87, 0xb6, 0xe0, 0xc8, 0x04,
  0x76, 0x6b, 0x79, 0xd2, 0x68, 0xdd, 0x61, 0x64, 0xca, 0xab, 0x47, 0x07,
  0xae, 0x4a, 0x97, 0x37, 0xbe, 0xd3, 0x8d, 0xb2, 0xba, 0x98, 0xbb, 0x72,
  0x74, 0x90, 0x9b, 0x67, 0x8c, 0xae, 0x35, 0x2f, 0xb7, 0x8d, 0x1e, 0xfc,
  0x37, 0x8f, 0x54, 0xfe, 0x9e, 0x4b, 0x1d, 0x11, 0x6d, 0xc1, 0x9a, 0xc5,
  0xe6, 0x19, 0x50, 0x3a, 0x6f, 0x0c, 0x87, 0xc2, 0x5b, 0x27, 0x4d, 0xc4,
  0xfd, 0xeb, 0x59, 0x36, 0x91, 0x5a, 0x82, 0x8f, 0xaf, 0x85, 0x3e, 0xe9,
  0x2f, 0x53, 0xcd, 0x68, 0x29, 0xc2, 0xb9, 0xa1, 0x9d, 0x11, 0x70, 0x85,
  0x2e, 0x5b, 0x48, 0xb9, 0x8e, 0x54, 0x28, 0x5a, 0x02, 0x9a, 0xc7, 0x9b,
  0xe1, 0x14, 0xe6, 0x51, 0x36, 0x2e, 0x83, 0x19, 0xf0, 0x03, 0xed, 0xcd,
  0x09, 0xcb, 0x68, 0x99, 0x19, 0xe7, 0x24, 0x20, 0xda, 0xeb, 0xa9, 0x5d,
  0xe6, 0x07, 0x1b, 0xbb, 0x4c, 0x1f, 0x0a, 0x23, 0xaa, 0x6d, 0xb1, 0x6c,
  0xce, 0x0a, 0x81, 0x89, 0x1f, 0xb3, 0x59, 0x98, 0xa0, 0x6e, 0x61, 0xd5,
  0xb4, 0xc5, 0xc1, 0xd4, 0x61, 0x18, 0x75, 0xdf, 0x7e, 0xc0, 0x2e, 0xa3,
  0x91, 0x47, 0x37, 0x19, 0x4f, 0xb4, 0xec, 0xf1, 0x74, 0xae, 0x40, 0x16,
  0xef, 0x25, 0x8f, 0x02, 0x45, 0xe6, 0xdf, 0x3f, 0xbe, 0x28, 0xd3, 0xb9,
  0xa5, 0xb4, 0x72, 0x0a, 0x80, 0x3f, 0xbb, 0xea, 0xe4, 0x8a, 0xab, 0xc9,
  0xae, 0x91, 0xe8, 0xb8, 0x2b, 0x48, 0xdf, 0xf7, 0xe7, 0x73, 0x20, 0x17,
  0x59, 0x3a, 0xb7, 0xd8, 0x15, 0xd5, 0x75, 0x82, 0x21, 0x46, 0x6d, 0xb9,
  0x72, 0x81, 0x83, 0xbe, 0x31, 0xc5, 0xd9, 0x0d, 0xe3, 0xd8, 0xb8, 0xeb,
  0xed, 0xfd, 0x6a, 0x01, 0x1b, 0xb4, 0x2c, 0x8f, 0x7b, 0x5a, 0x96, 0x59,
  0x19, 0x29, 0xfb, 0xb8, 0xfc, 0xa7, 0x77, 0xbc, 0xda, 0xa5, 0xdb, 0xb1,
  0xfa, 0xf8, 0x16, 0x77, 0x13, 0xeb, 0x9c, 0x7f, 0xb5, 0x8e, 0x43, 0x2c,
  0xa3, 0x78, 0x54, 0x64, 0xd3, 0x65, 0x29, 0x1e, 0xb6, 0xb0, 0x08, 0x20,
  0xb1, 0xd8, 0x15, 0x4b, 0x01, 0x57, 0x6f, 0xe3, 0x6e, 0x6f, 0x74, 0x9e,
  0x0b, 0xf8, 0x99, 0xe5, 0xef, 0x62, 0x3b, 0x56, 0x2f, 0x8e, 0x3e, 0xed,
  0x87, 0x28, 0xd8, 0x5c, 0xee, 0x14, 0x64, 0x79, 0xcb, 0x02, 0xad, 0x66,
  0x7a, 0xda, 0x6b, 0x8d, 0xe9, 0x4d, 0x12, 0x4e, 0x7d, 0x57, 0x52, 0x60,
  0x8f, 0xa2, 0x63, 0x9f, 0xd1, 0x53, 0x84, 0xb4, 0x72, 0x8d, 0xf3, 0xd9,
  0x53, 0x2c, 0x8c, 0xf1, 0xf0, 0xdd, 0x9e, 0x4b, 0x01, 0x8b, 0x22, 0x04,
  0x3a, 0xaf, 0x33, 0xe0, 0xd5, 0xcd, 0xad, 0x1e, 0x43, 0x85, 0x0e, 0x1f,
  0x59, 0x65, 0x3c, 0xe8, 0x17, 0x59, 0xc6, 0x82, 0xa5, 0x71, 0x8b, 0xcb,
  0xd2, 0x0a, 0xc2, 0xdf, 0x6d, 0x5c, 0xed, 0xcd, 0xe9, 0x60, 0xfd, 0x7b,
  0x3a, 0xb8, 0x9e, 0x59, 0x6f, 0x26, 0x40, 0x1f, 0x2b, 0x22, 0xd6, 0x93,
  0x9a, 0xd4, 0x61, 0x47, 0xfc, 0x57, 0xb1, 0x08, 0x56, 0x3d, 0xa6, 0xf3,
  0x8a, 0x47, 0x94, 0x7a, 0xcc, 0x66, 0xc8, 0x95, 0x6b, 0x0f, 0xc8, 0x90,
  0x48, 0xbb, 0x10, 0x2f, 0xc5, 0x6d, 0xbc, 0xa4, 0x58, 0x08, 0x3a, 0x90,
  0xd5, 0xfc, 0xb8, 0x0b, 0xd3, 0xcc, 0x5b, 0x80, 0x3a, 0x0d, 0xbb, 0x9b,
  0x04, 0x2c, 0xe9, 0x1a, 0x01, 0x9e, 0x5a, 0xbb, 0x18, 0xc1, 0xa2, 0x9a,
  0x37, 0xac, 0x96, 0x83, 0x24, 0x99, 0x38, 0x30, 0x09, 0x7e, 0xbc, 0x81,
  0x2f, 0xcb, 0xb1, 0x50, 0x52, 0x75, 0xa3, 0x0a, 0x5d, 0x3e, 0x68, 0xb8,
  0xff, 0x93, 0xab, 0x49, 0x5f, 0x39, 0x7d, 0x95, 0x19, 0xf5, 0xf3, 0x4d,
  0x2c, 0xc4, 0x15, 0x2d, 0x01, 0x7e, 0x7c, 0xfe, 0x44, 0x01, 0x81, 0xe8,
  0x3c, 0x61, 0x48, 0xb6, 0x5b, 0x60, 0xce, 0x72, 0x9e, 0xa0, 0xe6, 0xcb,
  0xaf, 0xb3, 0x19, 0x40, 0x6a, 0xcd, 0x08, 0x8c, 0x9d, 0x04, 0x99, 0x6c,
  0xd4, 0x75, 0x08, 0x81, 0xc6, 0x47, 0xa3, 0xdb, 0x83, 0xed, 0x5e, 0x20,
  0x58, 0x02, 0x97, 0x4c, 0x83, 0x03, 0xb8, 0xaf, 0x41, 0x74, 0x2e, 0x6e,
  0x68, 0x95, 0x0c, 0x99, 0xa6, 0x1a, 0xd2, 0x95, 0x56, 0x84, 0x60, 0xac,
  0x09, 0x27, 0x86, 0x73, 0x7e, 0x5f, 0x83, 0x66, 0xb6, 0xfa, 0xcf, 0x5f,
  0xbe, 0xac, 0xdc, 0xe5, 0xa1, 0xea, 0xfb, 0x62, 0x6b, 0x4b, 0x92, 0x1e,
  0xeb, 0xaf, 0xd1, 0x17, 0xfd, 0x97, 0x78, 0xb1, 0xfa, 0x9a, 0xa4, 0xc6,
  0xad, 0x7e, 0xaf, 0xcf, 0xdf, 0xb4, 0x74, 0x07, 0x83, 0xc2, 0xca, 0xb7,
  0x5e, 0x72, 0x77, 0x2d, 0x6f, 0x09, 0x42, 0x0c, 0xd6, 0x2e, 0xbb, 0xbc,
  0xe4, 0x62, 0x4b, 0xfc, 0xa4, 0x20, 0x74, 0x65, 0xf9, 0x5d, 0x9c, 0x4f,
  0x9a, 0xd3, 0xdd, 0xea, 0xf5, 0xb7, 0x57, 0x4d, 0xd7, 0x95, 0x46, 0xc0,
  0x06, 0xb2, 0xf6, 0xb3, 0xfe, 0xa7, 0x8d, 0xf5, 0xaf, 0x37, 0xda, 0x66,
  0xff, 0xe9, 0xd6, 0x56, 0xef, 0x13, 0xfe, 0xf9, 0xf2, 0x65, 0xfb, 0xc1,
  0xaa, 0xf4, 0xf1, 0xcc, 0xa6, 0x56, 0x19, 0x2d, 0xb5, 0xd3, 0xd2, 0xfa,
  0x36, 0xb5, 0xba, 0xfd, 0xf2, 0x65, 0x8f, 0x7b, 0x79, 0xf1, 0x41, 0xad,
  0x97, 0x77, 0x99, 0xb7, 0xd7, 0x6e, 0xbb, 0xae, 0x40, 0x81, 0x45, 0x6d,
  0x0a, 0xf4, 0x67, 0x14, 0xbd, 0x96, 0x64, 0xd0, 0x28, 0x08, 0xc5, 0xf4,
  0xc6, 0xfe, 0x5a, 0xc5, 0x6b, 0xa9, 0x31, 0xad, 0x3a, 0xad, 0x2b, 0xb1,
  0xbc, 0xe6, 0xc1, 0x24, 0xe0, 0x5a, 0xf4, 0xa0, 0x56, 0x88, 0x44, 0x41,
  0x55, 0x1f, 0x8f, 0x31, 0x5a, 0x44, 0xeb, 0x44, 0x2f, 0x1b, 0xd0, 0xfe,
  0x6f, 0xe3, 0x69, 0x0a, 0xda, 0xec, 0x22, 0x99, 0x55, 0x52, 0x96, 0xf8,
  0x8f, 0x6c, 0xd1, 0x15, 0xcd, 0x09, 0xe3, 0x5e, 0x73, 0x4c, 0x8d, 0x18,
  0xc9, 0x7d, 0xa4, 0x4f, 0xf7, 0xf1, 0xd8, 0x40, 0xac, 0x55, 0x31, 0x1c,
  0x11, 0xb5, 0xae, 0x22, 0x97, 0x24, 0xaa, 0x21, 0x59, 0x68, 0xcd, 0xc5,
  0xcf, 0xfa, 0xb9, 0x75, 0x8b, 0x20, 0xdf, 0x5c, 0xb9, 0x13, 0x97, 0x73,
  0x15, 0x04, 0x3b, 0x81, 0x04, 0xa4, 0xdb, 0xcd, 0x81, 0x1c, 0xb1, 0x52,
  0xe9, 0x60, 0x05, 0xd6, 0x2a, 0x86, 0x0e, 0xa9, 0x9d, 0x7b, 0x99, 0x5e,
  0x2d, 0x45, 0xfb, 0xf4, 0xa7, 0xec, 0x87, 0xb0, 0x22, 0x9d, 0x54, 0xac,
  0x65, 0x95, 0xf4, 0x2e, 0xb6, 0x5a, 0x58, 0x08, 0x61, 0xb1, 0x63, 0xef,
  0x10, 0x4e, 0xb4, 0xfc, 0x94, 0x86, 0xd4, 0x7b, 0x18, 0x26, 0x03, 0x95,
  0x92, 0xa8, 0xc4, 0x09, 0x90, 0xbd, 0x34, 0xf6, 0x98, 0x1d, 0x3c, 0x88,
  0x7f, 0xa9, 0x98, 0xd1, 0x0c, 0x0c, 0x4d, 0x16, 0x21, 0xd2, 0x14, 0xec,
  0xb5, 0x9a, 0xe3, 0xc5, 0x6a, 0x2a, 0x4b, 0xf2, 0xaa, 0x2b, 0x3c, 0xe2,
  0x66, 0x01, 0xd5, 0x4f, 0xf1, 0x3f, 0x2c, 0x23, 0x58, 0xcd, 0x03, 0x41,
  0xc2, 0x91, 0xc8, 0x7e, 0x9a, 0x11, 0xd7, 0xb6, 0x6d, 0x8e, 0x04, 0x03,
  0x64, 0x50, 0xd0, 0x55, 0xa0, 0xe6, 0x1b, 0x90, 0x49, 0x36, 0x63, 0x8c,
  0xb6, 0xc9, 0x06, 0x12, 0x9e, 0x64, 0x17, 0x9c, 0xe1, 0x4b, 0x03, 0x1d,
  0xd6, 0xaa, 0x6a, 0x75, 0x34, 0x3c, 0xfa, 0x1f, 0x87, 0x83, 0xd0, 0x9c,
  0xf9, 0x5b, 0x05, 0x83, 0xe4, 0xf1, 0x5d, 0xb5, 0x82, 0xa5, 0x54, 0x24,
  0x91, 0x58, 0xb8, 0x78, 0x3a, 0xf5, 0x95, 0xd8, 0xe0, 0x5c, 0x22, 0x61,
  0x3e, 0x33, 0x78, 0x36, 0x57, 0x65, 0x6d, 0x25, 0x9e, 0x17, 0xea, 0x6b,
  0xa2, 0xc8, 0x50, 0xe8, 0x63, 0x70, 0x39, 0x70, 0x33, 0x24, 0xb5, 0x18,
  0xb8, 0xf3, 0x72, 0x8e, 0xd2, 0x85, 0x34, 0x86, 0xba, 0xb4, 0x12, 0xdf,
  0x0d, 0x1e, 0xab, 0xfa, 0x7e, 0xee, 0xc3, 0x8c, 0x78, 0xe6, 0x4f, 0x57,
  0xe7, 0x0c, 0x31, 0x48, 0xcc, 0x38, 0x60, 0x94, 0x85, 0x3b, 0xfe, 0x8a,
  0xe9, 0x50, 0x51, 0x5a, 0x1b, 0x81, 0xb7, 0xb4, 0xb6, 0x65, 0x3c, 0x5b,
  0xb4, 0x84, 0xa0, 0x09, 0x46, 0x1c, 0x92, 0xc1, 0xc5, 0x7a, 0xed, 0xe0,
  0x92, 0xb5, 0xb3, 0x66, 0x73, 0x41, 0x5c, 0x9c, 0x10, 0x2a, 0xbd, 0x08,
  0x5b, 0xb8, 0xeb, 0xa7, 0x1a, 0xcf, 0xc5, 0x92, 0x16, 0xb0, 0x79, 0x5a,
  0x62, 0x5a, 0x63, 0x5d, 0xf9, 0x14, 0xd0, 0x20, 0x49, 0x9e, 0x0b, 0x10,
  0xb5, 0x48, 0xef, 0x89, 0xc6, 0x66, 0x88, 0x8f, 0x1b, 0xa1, 0x7d, 0x41,
  0x0d, 0x95, 0x78, 0xc5, 0x0e, 0x7a, 0xf0, 0x0b, 0xe9, 0x1a, 0xeb, 0xe7,
  0x6f, 0x5d, 0x09, 0x4f, 0xb3, 0x92, 0x1a, 0x5a, 0xa0, 0x2f, 0x5a, 0x2e,
  0x06, 0x4d, 0xcc, 0xa0, 0x00, 0xd8, 0x57, 0xdf, 0xa7, 0xee, 0xb7, 0x94,
  0x16, 0x30, 0x28, 0xf0, 0x05, 0xf4, 0xc3, 0x83, 0x53, 0x18, 0xd5, 0xb4,
  0x68, 0x45, 0xe2, 0x84, 0x71, 0x98, 0x4d, 0x9c, 0x6e, 0xbe, 0x32, 0x5d,
  0x01, 0x25, 0x4b, 0x52, 0x4e, 0x21, 0xd8, 0x65, 0x64, 0x74, 0xc9, 0xee,
  0xee, 0x05, 0x28, 0x51, 0x2f, 0xee, 0xef, 0x9b, 0x98, 0x41, 0x1e, 0xad,
  0x46, 0x70, 0xc0, 0x85, 0xd8, 0xe9, 0xd1, 0xea, 0x97, 0x8f, 0x81, 0x90,
  0x60, 0xbf, 0x47, 0x99, 0x04, 0x3c, 0xca, 0x6a, 0xc5, 0x2d, 0xeb, 0x28,
  0x97, 0xf1, 0x5d, 0x9c, 0xe2, 0x58, 0x36, 0x4c, 0xcb, 0x90, 0x30, 0x1c,
  0x60, 0xad, 0x45, 0xde, 0x71, 0xb4, 0xfa, 0x35, 0xb1, 0x02, 0x01, 0x1d,
  0x91, 0x05, 0xb2, 0x06, 0x0d, 0x3d, 0xb8, 0x65, 0x9d, 0xb8, 0x17, 0x59,
  0xf6, 0x14, 0xe8, 0x1e, 0x65, 0xca, 0x45, 0x76, 0x23, 0x60, 0x5d, 0x50,
  0x0b, 0xdb, 0xb4, 0xfc, 0xe9, 0x7c, 0xa9, 0x40, 0x74, 0x52, 0x22, 0xca,
  0xc3, 0xbe, 0xb7, 0x2d, 0xfb, 0x14, 0x69, 0x94, 0x52, 0x12, 0xa5, 0x0e,
  0xac, 0xad, 0xe3, 0x92, 0xb4, 0x13, 0xf5, 0x57, 0x18, 0xc9, 0xf6, 0xf1,
  0x6a, 0x4b, 0x80, 0x5f, 0xe4, 0x42, 0xfb, 0xf4, 0x68, 0x26, 0xf7, 0xb4,
  0xda, 0x82, 0x94, 0x13, 0x01, 0x45, 0x9c, 0x8b, 0x19, 0xd3, 0x1a, 0x5c,
  0x65, 0x39, 0x6d, 0xea, 0x4c, 0xa5, 0x5c, 0xdc, 0x36, 0x75, 0xe9, 0x4b,
  0xbb, 0x72, 0x88, 0x07, 0x0c, 0xea, 0xe9, 0xb0, 0x68, 0xca, 0xac, 0x54,
  0xc6, 0xa8, 0xe9, 0xc9, 0xce, 0xc8, 0x6b, 0xe3, 0x7e, 0x2c, 0x68, 0x6a,
  0x67, 0xf0, 0x6c, 0xe3, 0x49, 0xb0, 0xc7, 0x40, 0x94, 0xaf, 0x95, 0x25,
  0x6c, 0x2d, 0x67, 0xd2, 0x58, 0x5c, 0xae, 0x1a, 0x5d, 0x29, 0x68, 0x52,
  0x3b, 0xf7, 0xb2, 0x88, 0x8f, 0x00, 0x39, 0x98, 0x53, 0xad, 0x98, 0x26,
  0xc9, 0x42, 0xc6, 0xa6, 0x10, 0x3c, 0x7a, 0x54, 0xdd, 0xde, 0x21, 0xf4,
  0x52, 0x89, 0x54, 0xaf, 0xd7, 0x55, 0x1c, 0x40, 0x6d, 0xf4, 0x6c, 0xb8,
  0x36, 0x90, 0xf9, 0x76, 0x4e, 0xb3, 0x2e, 0x82, 0x8a, 0x05, 0x91, 0xae,
  0x40, 0x9d, 0xb6, 0x2d, 0x95, 0x02, 0x3e, 0xb6, 0xad, 0x6e, 0x60, 0xba,
  0x19, 0xb5, 0x6a, 0x34, 0x4d, 0xac, 0x46, 0xb9, 0x9d, 0x71, 0x35, 0x25,
  0x82, 0x4e, 0x87, 0xa2, 0x34, 0x32, 0x23, 0x94, 0x48, 0xd5, 0x44, 0xdf,
  0x81, 0xe3, 0x3d, 0x82, 0x40, 0x8a, 0x25, 0x6c, 0x38, 0x4d, 0x7e, 0x49,
  0xf2, 0x2c, 0x28, 0xca, 0x85, 0x55, 0x34, 0x61, 0xd1, 0xc5, 0x56, 0x39,
  0x6a, 0xe4, 0xb1, 0x0f, 0x3c, 0x89, 0x34, 0x81, 0x0d, 0xff, 0x97, 0xa1,
  0x98, 0x27, 0xd1, 0x3f, 0x2e, 0xf4, 0xe0, 0x4a, 0xa4, 0xb1, 0x5e, 0x17,
  0x28, 0xec, 0x6a, 0x4c, 0x5d, 0xad, 0xa6, 0xcc, 0xb4, 0x02, 0x9a, 0xd0,
  0xdb, 0xb2, 0x7e, 0x68, 0xce, 0x95, 0x37, 0x19, 0x0f, 0x41, 0x56, 0x59,
  0xcc, 0xd2, 0x09, 0xd7, 0x83, 0x58, 0xe7, 0x3c, 0x0d, 0x1d, 0xda, 0x06,
  0x7f, 0x8c, 0x1c, 0xec, 0xd8, 0x57, 0x74, 0xaa, 0xcb, 0x11, 0x8a, 0xb1,
  0x20, 0xfc, 0x6a, 0xd2, 0x82, 0x91, 0x72, 0x92, 0x95, 0xe9, 0xd8, 0x57,
  0xfd, 0x75, 0xed, 0xe8, 0x9b, 0x0d, 0x3e, 0x2f, 0xed, 0x68, 0xec, 0x3b,
  0x37, 0xd1, 0xab, 0x80, 0x44, 0xd9, 0xb0, 0x11, 0x54, 0x03, 0xbf, 0x11,
  0xe2, 0x10, 0xf4, 0x92, 0x6c, 0xb1, 0xf2, 0x83, 0xad, 0xb3, 0x6f, 0x08,
  0x9e, 0x35, 0x9e, 0x4e, 0x0b, 0x9e, 0x0b, 0x36, 0x80, 0xda, 0x48, 0xb3,
  0x09, 0x7c, 0x72, 0xc2, 0x94, 0x9a, 0x31, 0xa4, 0xd4, 0xde, 0x34, 0x71,
  0xd1, 0x3a, 0xdd, 0x22, 0x00, 0xe9, 0xe1, 0x26, 0x7a, 0xea, 0x37, 0xae,
  0xc0, 0xba, 0x0c, 0x04, 0x8f, 0x6f, 0x75, 0xa5, 0x39, 0x62, 0x82, 0x20,
  0xee, 0x52, 0x84, 0x6e, 0x43, 0x3b, 0x71, 0xcc, 0xfa, 0x43, 0xd8, 0x5c,
  0x4d, 0xd4, 0x5c, 0x45, 0xb1, 0xba, 0xac, 0x31, 0x20, 0xdb, 0xfe, 0x15,
  0xa2, 0x2d, 0x18, 0xa5, 0x93, 0x6b, 0x20, 0xd4, 0x37, 0x6e, 0x88, 0x0f,
  0x61, 0x5b, 0x1f, 0x44, 0x07, 0x80, 0x36, 0x63, 0x64, 0x36, 0x41, 0xf7,
  0xe5, 0x68, 0x01, 0xf5, 0x60, 0xe7, 0x4e, 0x0a, 0x90, 0x54, 0xd1, 0x81,
  0xe2, 0xa2, 0xd4, 0x91, 0xe1, 0x01, 0x57, 0xba, 0x0c, 0x53, 0xc5, 0xfb,
  0x43, 0xee, 0x9b, 0xda, 0xec, 0xa3, 0x85, 0xf6, 0x0c, 0x72, 0x03, 0x29,
  0xe9, 0x0b, 0x8a, 0x6b, 0x80, 0xb8, 0xc2, 0x83, 0xa9, 0x74, 0xcd, 0xd4,
  0xc8, 0x9b, 0xcc, 0x6c, 0xb3, 0x12, 0x58, 0xc9, 0xf5, 0xba, 0x8a, 0xe7,
  0xd1, 0x2b, 0xa4, 0x8d, 0xec, 0xb2, 0x6e, 0xf1, 0xf3, 0xe7, 0x8d, 0x9a,
  0xdb, 0x89, 0x61, 0x82, 0xaa, 0x9d, 0x6f, 0x78, 0xba, 0xff, 0xcd, 0xf0,
  0xb9, 0x45, 0xd5, 0x59, 0x19, 0x11, 0x0f, 0x8d, 0x68, 0x39, 0xf5, 0x2b,
  0xab, 0xa7, 0xf4, 0xd4, 0xb4, 0xa6, 0xa5, 0x96, 0x22, 0x43, 0x56, 0xdc,
  0xde, 0xfa, 0x6c, 0xeb, 0x31, 0x2c, 0xc2, 0x96, 0x44, 0x2e, 0x86, 0x68,
  0xcd, 0xd3, 0x49, 0x22, 0x50, 0x64, 0x8c, 0xe9, 0x93, 0x66, 0x4b, 0x97,
  0x8a, 0x1a, 0xf9, 0x78, 0x3b, 0xad, 0xac, 0xcc, 0x10, 0x95, 0x75, 0x27,
  0x30, 0xf1, 0x15, 0x5a, 0x7e, 0xc9, 0x4c, 0x4f, 0xee, 0xc7, 0x53, 0x12,
  0x16, 0x6e, 0x7f, 0xd7, 0x82, 0x59, 0xb2, 0xea, 0xf1, 0xbf, 0xb4, 0xec,
  0xf1, 0x87, 0xad, 0x7b, 0xab, 0x95, 0xea, 0x57, 0xac, 0x7b, 0x5b, 0xb1,
  0xb4, 0x2a, 0x7e, 0xb9, 0x5f, 0xf9, 0xd6, 0xa5, 0x0f, 0x57, 0x5e, 0x78,
  0xea, 0xff, 0x22, 0xeb, 0xfe, 0x02, 0x35, 0x95, 0x61, 0x40, 0x7d, 0x6a,
  0xfd, 0x55, 0xcd, 0xf6, 0xde, 0x27, 0x6c, 0xc1, 0x0b, 0x0d, 0x4a, 0x5c,
  0x87, 0x09, 0x2b, 0x09, 0xe3, 0x14, 0x19, 0xee, 0x73, 0x7a, 0xdb, 0x26,
  0xac, 0xba, 0x00, 0xa6, 0x8d, 0x27, 0x4f, 0x8c, 0xdb, 0x29, 0x09, 0x38,
  0x92, 0xbd, 0xaa, 0xaf, 0xdd, 0xff, 0x15, 0x3b, 0x57, 0x13, 0x81, 0xab,
  0xb3, 0xe0, 0x44, 0x4d, 0x37, 0x76, 0xa9, 0x87, 0x43, 0x17, 0x1e, 0xff,
  0x52, 0x49, 0x59, 0xd5, 0xb8, 0x9f, 0x66, 0x3e, 0xbe, 0x92, 0x43, 0xa5,
  0x02, 0x8a, 0x41, 0x68, 0x1b, 0xf4, 0xf6, 0x46, 0x83, 0x78, 0xfe, 0x95,
  0x33, 0x6b, 0x04, 0xc3, 0xf1, 0x66, 0x8c, 0xfe, 0xe2, 0xc8, 0x44, 0xe8,
  0x0b, 0xa4, 0xd1, 0x16, 0xdc, 0x06, 0x65, 0x9c, 0xc1, 0x3a, 0x54, 0x54,
  0xfb, 0x00, 0x92, 0xa9, 0x1c, 0xee, 0x96, 0x84, 0x55, 0x21, 0x98, 0xff,
  0x43, 0x18, 0x6a, 0x1b, 0x79, 0x58, 0x38, 0xf5, 0x07, 0x13, 0x87, 0x8a,
  0x0f, 0xff, 0x3e, 0x79, 0x94, 0x13, 0x5a, 0xb8, 0x76, 0x27, 0xce, 0xb9,
  0x61, 0x42, 0x42, 0x7b, 0x46, 0xdd, 0x26, 0x98, 0x3b, 0xf4, 0x1d, 0x8b,
  0xe2, 0xa8, 0x38, 0xf8, 0x7d, 0x1a, 0xf5, 0x6a, 0xac, 0x43, 0x30, 0x31,
  0xc9, 0x59, 0x07, 0x2a, 0x58, 0xb7, 0xdf, 0x35, 0x2a, 0x30, 0xe3, 0x96,
  0x2b, 0xa5, 0x06, 0x77, 0x8e, 0xe4, 0xee, 0x3e, 0xca, 0x1c, 0x14, 0x4e,
  0x10, 0x9e, 0x66, 0xd1, 0xc5, 0xd8, 0x8e, 0xe9, 0xb2, 0x7c, 0x63, 0x92,
  0x2e, 0x12, 0x9e, 0x04, 0x4b, 0x1e, 0x13, 0xd4, 0xef, 0x5c, 0x81, 0xa6,
  0xca, 0x4f, 0x8f, 0xe3, 0x45, 0x3c, 0x4a, 0xa7, 0xa4, 0xf6, 0xb7, 0x04,
  0xcd, 0xfc, 0x86, 0x8c, 0xbd, 0x1c, 0x2f, 0xfa, 0xf3, 0xac, 0x4d, 0xab,
  0xbf, 0x60, 0xb8, 0xc6, 0x00, 0xa3, 0xe3, 0xfd, 0xc9, 0xe9, 0xc1, 0xe1,
  0xf1, 0xde, 0x0f, 0xe6, 0x85, 0x72, 0xe1, 0x80, 0xa8, 0xaf, 0x90, 0xc4,
  0xc5, 0xc3, 0x7b, 0xd2, 0x37, 0xe8, 0xcb, 0xf5, 0x67, 0x1b, 0x6c, 0x30,
  0xae, 0x9f, 0x21, 0x16, 0xa6, 0x42, 0x04, 0x37, 0x35, 0xb1, 0xf8, 0x79,
  0xd4, 0xb8, 0xf1, 0x76, 0xc5, 0x34, 0x58, 0xd2, 0xe1, 0x29, 0x93, 0xe9,
  0x3c, 0x29, 0x15, 0xba, 0x2b, 0x7a, 0x75, 0x7a, 0x76, 0xf1, 0xfa, 0x36,
  0x6e, 0x14, 0x82, 0x44, 0x3a, 0x9e, 0x56, 0x51, 0x35, 0x02, 0x91, 0x37,
  0x83, 0xd8, 0xa2, 0xa1, 0x8b, 0xe0, 0xb1, 0x27, 0xe9, 0xe8, 0x35, 0x22,
  0x77, 0x2e, 0x2e, 0x7e, 0x38, 0x3b, 0x7c, 0xfd, 0x8a, 0x6d, 0xed, 0x9f,
  0xb3, 0x78, 0xae, 0x0a, 0x8e, 0x98, 0xde, 0xa7, 0x52, 0x88, 0xb3, 0xfe,
  0xce, 0xf7, 0x07, 0x47, 0xc3, 0xb3, 0xe3, 0xd3, 0xfd, 0xd7, 0xaf, 0xbe,
  0xb7, 0x4a, 0xd7, 0xc1, 0xbb, 0xee, 0x33, 0x17, 0x99, 0xd0, 0x04, 0x30,
  0x39, 0xfc, 0xee, 0xfd, 0xe1, 0xc9, 0xb7, 0xaf, 0x5f, 0xdd, 0xc6, 0x79,
  0x8f, 0xe7, 0x27, 0x6f, 0xa3, 0x50, 0x7a, 0x13, 0x3c, 0x2e, 0xd8, 0xcb,
  0x0b, 0x86, 0x39, 0x5a, 0xb0, 0xd5, 0xfb, 0x11, 0xaf, 0x28, 0x48, 0xd6,
  0x23, 0x86, 0x54, 0x4f, 0x4f, 0x60, 0xc3, 0xd4, 0x85, 0x73, 0x99, 0xb4,
  0xef, 0xce, 0x8f, 0xc1, 0x4d, 0x5b, 0x11, 0x3e, 0xa4, 0x4a, 0x90, 0xcf,
  0xe9, 0xb5, 0x7a, 0x3f, 0xae, 0x61, 0xe4, 0xcf, 0x7a, 0x40, 0xbe, 0xd8,
  0x2a, 0xaa, 0x3c, 0x62, 0x44, 0x95, 0xf4, 0x00, 0xf8, 0x7f, 0x1c, 0x82,
  0x25, 0xe2, 0xe2, 0x04, 0xff, 0x87, 0xa6, 0x20, 0x25, 0x9e, 0x36, 0x8d,
  0x44, 0x99, 0xd4, 0xd7, 0x56, 0x04, 0x4b, 0x44, 0x5a, 0x9b, 0x91, 0xd9,
  0x2a, 0x3b, 0xa9, 0x31, 0x3f, 0x8c, 0xc7, 0xd2, 0x25, 0xaa, 0xb3, 0x90,
  0x70, 0x88, 0xba, 0xf6, 0xe0, 0xd1, 0x0c, 0x39, 0x11, 0xf8, 0xc6, 0x8d,
  0x2b, 0x97, 0x63, 0x56, 0x8d, 0x52, 0xb0, 0xb8, 0xb1, 0xc0, 0xaa, 0x5c,
  0xcf, 0xb1, 0x50, 0x4f, 0xb4, 0xd6, 0x23, 0x35, 0xf7, 0xf3, 0x8c, 0x2f,
  0x35, 0x8e, 0x7c, 0xe3, 0x80, 0x3f, 0xe7, 0xe9, 0x92, 0x8d, 0x0d, 0x42,
  0x07, 0x5b, 0xeb, 0x46, 0x0f, 0x1c, 0x6b, 0x30, 0x9e, 0x80, 0x5a, 0xec,
  0x9c, 0xed, 0xbe, 0x5e, 0x6c, 0xa8, 0xe3, 0x46, 0x38, 0xc3, 0xd9, 0x3b,
  0x9f, 0x33, 0xd0, 0x5a, 0x91, 0x7c, 0x45, 0x2d, 0x51, 0x27, 0xdd, 0xf9,
  0x85, 0xea, 0xf4, 0x3b, 0x24, 0xd2, 0x99, 0xde, 0xcb, 0x01, 0xa5, 0x1b,
  0x16, 0xf6, 0x8e, 0xe2, 0x75, 0x21, 0x08, 0x42, 0xdc, 0x9a, 0x5f, 0xdd,
  0x9a, 0xbd, 0x61, 0x38, 0xd4, 0x16, 0xae, 0xc9, 0x6c, 0xac, 0x7f, 0xe1,
  0x33, 0x8e, 0x39, 0x5f, 0xb8, 0x25, 0xd6, 0x79, 0x10, 0x1d, 0xf2, 0xb7,
  0xfd, 0x8b, 0x06, 0x10, 0x31, 0xbf, 0xb0, 0x88, 0xd3, 0x3c, 0xf0, 0x49,
  0xc2, 0xeb, 0xcf, 0x63, 0x95, 0xe5, 0xd5, 0x88, 0x11, 0x94, 0x2e, 0x1a,
  0x68, 0x1d, 0x4f, 0x36, 0x40, 0xad, 0x00, 0xb1, 0x28, 0xa2, 0xce, 0xd5,
  0x34, 0x1b, 0x8d, 0x68, 0xe2, 0x1d, 0xb3, 0x9e, 0xd2, 0x08, 0xad, 0x4a,
  0x67, 0xcf, 0xf2, 0x3c, 0x3d, 0x05, 0x03, 0xaf, 0x01, 0x7d, 0xad, 0x0a,
  0x93, 0x54, 0x9c, 0x5a, 0xc9, 0x54, 0xb2, 0x35, 0x05, 0x9e, 0xc2, 0x43,
  0x1d, 0xe5, 0x99, 0x3f, 0xb5, 0xfe, 0xeb, 0x36, 0x88, 0xf2, 0x61, 0x1a,
  0x94, 0xf0, 0xb5, 0x13, 0x89, 0x73, 0xa8, 0x09, 0xfb, 0x2d, 0x25, 0xf5,
  0x30, 0x61, 0x9a, 0x40, 0xe7, 0x1f, 0x3c, 0x88, 0xed, 0x1e, 0xff, 0xbb,
  0xf3, 0xcf, 0x8e, 0xa1, 0x25, 0xdc, 0xdd, 0xdd, 0x0d, 0x64, 0xf0, 0x25,
  0xa7, 0xc2, 0x17, 0x06, 0xd1, 0xd0, 0x82, 0xc8, 0xc0, 0x00, 0xb1, 0x2b,
  0x5b, 0x4f, 0x67, 0x57, 0x3f, 0x6e, 0xf7, 0xb7, 0xb7, 0xb6, 0xb6, 0x7e,
  0x1e, 0x2c, 0x78, 0xe9, 0x2e, 0xd1, 0x3c, 0xe7, 0xbb, 0x2c, 0xd2, 0x31,
  0xbb, 0x0e, 0x69, 0x33, 0xd3, 0x18, 0x65, 0xa3, 0xa4, 0xbf, 0xcd, 0xf0,
  0xc6, 0xca, 0x39, 0xec, 0xb9, 0x95, 0xb9, 0x19, 0x3a, 0x4e, 0x1c, 0x5d,
  0x2e, 0x05, 0x18, 0x89, 0x9e, 0x9c, 0x2c, 0xc5, 0xc5, 0xc3, 0x02, 0x04,
  0x57, 0x53, 0x10, 0xe3, 0xbb, 0x48, 0x30, 0x74, 0x03, 0x19, 0xd4, 0x6c,
  0x5c, 0xc6, 0xbd, 0xd6, 0xd2, 0x0b, 0x88, 0x75, 0x4a, 0x0a, 0x2e, 0x10,
  0x82, 0xe2, 0xdf, 0x01, 0x54, 0x60, 0xcf, 0xc5, 0x54, 0x82, 0x8a, 0x15,
  0x26, 0x41, 0x82, 0x0c, 0x9b, 0x75, 0x6e, 0xf9, 0x98, 0x90, 0x88, 0x10,
  0x16, 0x87, 0x74, 0x68, 0x64, 0x06, 0x5e, 0x96, 0x48, 0xc6, 0x88, 0x89,
  0x1b, 0x1f, 0x24, 0x6d, 0x86, 0x92, 0x26, 0x02, 0x21, 0xfb, 0xb7, 0x82,
  0xaa, 0x32, 0xe2, 0x4a, 0x4a, 0x92, 0x03, 0x8f, 0xa5, 0x68, 0x64, 0xd2,
  0x17, 0xe3, 0x34, 0xfd, 0x5d, 0x85, 0x0b, 0xf4, 0x8a, 0x6e, 0xfe, 0x2f,
  0xde, 0x30, 0x06, 0xcf, 0x4e, 0x50, 0xcb, 0x24, 0x40, 0x15, 0xc5, 0x54,
  0x05, 0x55, 0x74, 0x9a, 0xc4, 0x1c, 0x8b, 0x65, 0xa2, 0xf2, 0x75, 0x72,
  0x2f, 0xb7, 0x68, 0x33, 0xc9, 0x4f, 0x5d, 0xd9, 0xd7, 0x9c, 0x31, 0x27,
  0xe5, 0x01, 0x87, 0xfb, 0x47, 0x47, 0x15, 0x1c, 0x0d, 0x5e, 0x3c, 0xa9,
  0xea, 0x03, 0xab, 0x56, 0x31, 0xa3, 0x55, 0x64, 0x8b, 0x1a, 0x86, 0xdb,
  0xb8, 0xbc, 0xd9, 0xb5, 0x8f, 0x14, 0x6d, 0x4e, 0x36, 0x88, 0x8b, 0xd4,
  0x62, 0x29, 0x62, 0x01, 0x76, 0x58, 0xce, 0xf9, 0x9a, 0x45, 0x9d, 0xbc,
  0x25, 0x1d, 0xc9, 0xe2, 0xb7, 0x26, 0xc8, 0xc1, 0xef, 0x4d, 0x7a, 0x2d,
  0x5e, 0xe4, 0xb3, 0x5c, 0xdd, 0xf4, 0xe2, 0x53, 0x8c, 0xc4, 0x05, 0xcc,
  0x18, 0x4a, 0x7c, 0x6b, 0x08, 0x05, 0xd2, 0x10, 0x6d, 0xb4, 0x5a, 0x2b,
  0x4d, 0x00, 0x83, 0x5b, 0x92, 0xaf, 0x55, 0x9c, 0x63, 0x0b, 0x65, 0x45,
  0x7a, 0x7d, 0x5e, 0x41, 0x92, 0x30, 0x04, 0xca, 0xe8, 0x15, 0xff, 0xbb,
  0x6b, 0x08, 0x90, 0x2b, 0x91, 0xdd, 0x15, 0x17, 0xb9, 0x8a, 0x16, 0x69,
  0x09, 0x47, 0x40, 0x30, 0x91, 0xc0, 0x97, 0x1a, 0xfe, 0x57, 0xad, 0xb9,
  0x53, 0xb7, 0x23, 0x1e, 0x6d, 0x1a, 0x8d, 0xd6, 0x41, 0x70, 0xdb, 0x78,
  0x00, 0xdf, 0x56, 0xc8, 0xd9, 0xb8, 0x4a, 0x6f, 0x13, 0x0f, 0x64, 0x89,
  0x83, 0xb0, 0x6e, 0xaa, 0x1d, 0xaa, 0xa4, 0x8b, 0x72, 0x23, 0xd5, 0x98,
  0x37, 0x5a, 0x17, 0x09, 0x9b, 0x44, 0x72, 0x17, 0xbb, 0xe5, 0x05, 0xf4,
  0xc3, 0xa1, 0x4d, 0xaf, 0x84, 0xb6, 0x82, 0x98, 0xc7, 0x50, 0x71, 0x67,
  0x47, 0x7d, 0x0d, 0x24, 0x51, 0x04, 0x30, 0xc9, 0x13, 0xe0, 0x79, 0x4c,
  0xb2, 0x7a, 0x92, 0x73, 0x1b, 0xba, 0x96, 0x47, 0x4a, 0x12, 0xb8, 0xb5,
  0x0a, 0x0e, 0xc2, 0x72, 0x51, 0x9b, 0x5b, 0x75, 0xd5, 0xdb, 0x02, 0xe0,
  0x34, 0x37, 0x35, 0x94, 0xc6, 0x47, 0x0f, 0x56, 0x88, 0x52, 0x85, 0x15,
  0x55, 0xf8, 0xe4, 0xf6, 0xc6, 0xca, 0xb4, 0x65, 0x78, 0x06, 0xc4, 0xbe,
  0x4b, 0xdc, 0x66, 0x19, 0xed, 0x76, 0x7e, 0x47, 0x76, 0xfc, 0xce, 0xec,
  0x0f, 0xbf, 0x86, 0x14, 0xf1, 0x68, 0x05, 0xae, 0x39, 0xc0, 0xd1, 0x69,
  0x43, 0x18, 0xfb, 0xff, 0x77, 0x34, 0xd8, 0xd1, 0x77, 0xbf, 0xef, 0x8e,
  0xa2, 0x2e, 0xf3, 0x2b, 0x12, 0xea, 0x56, 0x32, 0x92, 0x58, 0xab, 0x2f,
  0x3b, 0x28, 0xb1, 0x26, 0x14, 0x09, 0xa9, 0x1b, 0x34, 0xcb, 0x6b, 0x5a,
  0xa4, 0x07, 0x67, 0xb5, 0x58, 0x6b, 0x4f, 0x64, 0x35, 0x49, 0x9c, 0x9a,
  0x64, 0x75, 0x02, 0x91, 0x9b, 0x41, 0x5e, 0xdf, 0xa3, 0xd7, 0x83, 0x02,
  0x37, 0x8b, 0x45, 0xb1, 0x92, 0x78, 0x25, 0x89, 0x41, 0x92, 0x7e, 0x66,
  0x99, 0x9f, 0x22, 0x82, 0xb7, 0x2d, 0x2e, 0x6a, 0x5a, 0x17, 0x66, 0x9d,
  0xe9, 0x39, 0xef, 0x6e, 0x08, 0xd0, 0xa6, 0x69, 0xa4, 0x4f, 0x80, 0x5b,
  0xa9, 0xe6, 0x1f, 0xac, 0x67, 0x70, 0x4d, 0xb5, 0xa2, 0xf2, 0x43, 0xed,
  0xe1, 0x55, 0x64, 0x62, 0x10, 0xe0, 0x68, 0x7d, 0x7c, 0xb3, 0x8c, 0xa7,
  0x37, 0x31, 0x8b, 0x1b, 0xec, 0xaa, 0x92, 0x25, 0x65, 0x44, 0x70, 0x04,
  0x44, 0xb4, 0xe5, 0x48, 0x8e, 0x96, 0x57, 0x57, 0x82, 0xed, 0x79, 0x8c,
  0x2c, 0x2d, 0xa9, 0x99, 0xe1, 0xe0, 0x26, 0xba, 0x9f, 0x77, 0x35, 0x04,
  0xa6, 0x23, 0x35, 0x8e, 0x20, 0xef, 0x74, 0x44, 0xde, 0x68, 0x84, 0xbf,
  0x33, 0xfd, 0xf7, 0xa2, 0xee, 0xab, 0xf6, 0x77, 0xb8, 0xe2, 0x5d, 0x7a,
  0xab, 0xa0, 0x8b, 0x4e, 0xe7, 0xa5, 0x35, 0xbc, 0x4e, 0xe9, 0xc2, 0x9a,
  0x37, 0xbd, 0xde, 0x0a, 0xcb, 0xab, 0x45, 0x38, 0x23, 0x53, 0xac, 0x8a,
  0xfa, 0x18, 0xff, 0x64, 0xfd, 0xc5, 0x93, 0x49, 0xaa, 0x40, 0xe7, 0x2c,
  0x6c, 0xd5, 0x35, 0x25, 0x8b, 0x0a, 0xd7, 0xfe, 0x1f, 0xad, 0x65, 0x9e,
  0x1a, 0xb7, 0x10, 0x59, 0x47, 0x0a, 0x59, 0x0a, 0x1a, 0x82, 0x15, 0x7b,
  0xf2, 0xd5, 0xb9, 0x65, 0xbb, 0xeb, 0x52, 0x60, 0xa5, 0x7a, 0x94, 0x13,
  0x6f, 0x94, 0x0c, 0xd5, 0x24, 0xc7, 0x18, 0xf3, 0x0a, 0x58, 0xb7, 0x92,
  0x61, 0x99, 0x92, 0xef, 0x69, 0xb8, 0x28, 0xa5, 0x7a, 0x90, 0x54, 0x99,
  0xc3, 0xc5, 0xc8, 0x0f, 0x2a, 0xde, 0xb3, 0x1a, 0xb6, 0x7a, 0xcd, 0xf4,
  0x5a, 0xc4, 0x8e, 0xbb, 0xcc, 0x5f, 0x27, 0x63, 0x54, 0x05, 0x64, 0xb3,
  0x5a, 0xfe, 0xab, 0x32, 0x56, 0xa5, 0x31, 0xdf, 0x7a, 0x40, 0xde, 0x01,
  0xd8, 0x62, 0x13, 0xb0, 0x17, 0x52, 0x4c, 0x05, 0x07, 0x5d, 0x0c, 0x74,
  0xa2, 0x04, 0x6b, 0x39, 0x02, 0x8b, 0xb1, 0x33, 0xb4, 0x25, 0x2d, 0xee,
  0xd8, 0x56, 0xe9, 0x40, 0x22, 0x0d, 0x20, 0x3d, 0xe9, 0x5e, 0xe8, 0xf9,
  0x61, 0x41, 0xdf, 0xde, 0x67, 0xbb, 0xb8, 0x10, 0xaf, 0xcf, 0xed, 0x6b,
  0x11, 0x7b, 0xa5, 0x4c, 0x52, 0x3e, 0x81, 0xa4, 0xfb, 0xa0, 0x80, 0x93,
  0x29, 0x20, 0xfe, 0xe6, 0x37, 0xe6, 0xcc, 0xad, 0x16, 0x95, 0x6e, 0xaf,
  0xa0, 0xa9, 0x61, 0x59, 0x32, 0xac, 0x75, 0x90, 0xb3, 0x42, 0xe7, 0x74,
  0xce, 0x0c, 0x24, 0x64, 0xb7, 0xb3, 0xa1, 0x22, 0x76, 0x2c, 0x52, 0x8b,
  0x7c, 0xdc, 0x26, 0x3b, 0xdb, 0x98, 0x5d, 0xc9, 0xb6, 0xcc, 0x54, 0xee,
  0xd6, 0xee, 0x89, 0x94, 0xf2, 0x49, 0x5b, 0xdf, 0x6f, 0x24, 0x60, 0x36,
  0xe8, 0xda, 0x81, 0xa2, 0x69, 0x2c, 0x6d, 0xbd, 0xfb, 0x96, 0x9e, 0xb3,
  0x4b, 0x14, 0xf4, 0xdc, 0x73, 0x91, 0x8a, 0xf6, 0xaa, 0xad, 0xff, 0x6e,
  0x13, 0x77, 0xe0, 0xf6, 0x93, 0xc0, 0xce, 0xc2, 0x9c, 0x14, 0x1f, 0xe9,
  0x72, 0xa6, 0x4d, 0x79, 0xff, 0x26, 0x1f, 0x3d, 0xa7, 0x1f, 0xdf, 0xf0,
  0x0f, 0xab, 0xff, 0xc1, 0x28, 0x1c, 0x66, 0x67, 0x68, 0xa6, 0x77, 0x32,
  0x04, 0xa8, 0x1c, 0xe0, 0x21, 0xa8, 0xe8, 0x0d, 0x7e, 0xc9, 0x93, 0x47,
  0xde, 0xa1, 0xb9, 0xfd, 0x42, 0x3f, 0xf6, 0x96, 0x65, 0xc6, 0x94, 0x38,
  0x46, 0xac, 0x01, 0xc9, 0x8e, 0xb9, 0xc0, 0xe4, 0x6a, 0xae, 0x2e, 0xfe,
  0x54, 0x8b, 0x7f, 0x21, 0xf5, 0x46, 0xc1, 0x26, 0xd2, 0x15, 0x20, 0x0a,
  0xab, 0xfb, 0x13, 0x28, 0xdd, 0x56, 0xb8, 0x9c, 0x47, 0xe7, 0xf6, 0x58,
  0x5d, 0x85, 0x06, 0xde, 0x4f, 0xad, 0x61, 0x5e, 0x0a, 0x5a, 0xcc, 0x17,
  0x1f, 0xb6, 0x8a, 0x07, 0x7c, 0x5d, 0x28, 0x27, 0xb0, 0x90, 0x26, 0xd4,
  0x80, 0x57, 0x2a, 0x08, 0xb0, 0xfb, 0xf1, 0xa8, 0x83, 0x0d, 0x51, 0xa4,
  0xec, 0xf6, 0xc1, 0xc9, 0x05, 0x86, 0x68, 0x07, 0xb0, 0x8a, 0x1b, 0xa7,
  0x66, 0xcf, 0xe8, 0xce, 0xcc, 0x1f, 0xfc, 0x2d, 0x15, 0xd1, 0x9d, 0x27,
  0xe5, 0x12, 0x50, 0xab, 0x7a, 0x45, 0x66, 0x1a, 0xc9, 0x2f, 0x53, 0xb6,
  0x4f, 0x16, 0xe0, 0xdd, 0x8d, 0xfa, 0xd1, 0x7b, 0xc5, 0xc3, 0x7c, 0x7c,
  0x7d, 0x70, 0x32, 0x5c, 0x95, 0xa4, 0x54, 0x9d, 0x1c, 0x9e, 0x26, 0x69,
  0x8c, 0x79, 0x1c, 0xc4, 0x38, 0x75, 0xfd, 0xb5, 0xa4, 0x10, 0x9f, 0x9d,
  0x1c, 0x7e, 0x75, 0x6a, 0x3f, 0x56, 0x2e, 0xf9, 0xa3, 0x2b, 0x7c, 0xcc,
  0x09, 0x48, 0x8f, 0x65, 0x73, 0xd9, 0xe0, 0x1c, 0x20, 0xad, 0xb7, 0xa1,
  0x73, 0x9d, 0x4c, 0x7e, 0x5d, 0x48, 0xb1, 0xa7, 0x14, 0x29, 0x35, 0xa1,
  0x56, 0xe5, 0xa9, 0xd1, 0x71, 0xdb, 0xf9, 0xea, 0xcb, 0xe6, 0xd5, 0x73,
  0x70, 0xb2, 0xa2, 0x3b, 0xfe, 0xa6, 0x6f, 0x21, 0xdc, 0x7a, 0xd7, 0x0a,
  0x5c, 0x07, 0x56, 0xa7, 0x65, 0x55, 0x48, 0xcc, 0x76, 0x3f, 0x00, 0x21,
  0xe3, 0x26, 0x6f, 0xea, 0x1d, 0x1f, 0x78, 0xa1, 0x7a, 0xc9, 0x43, 0xe5,
  0x9c, 0xa0, 0x69, 0x4c, 0x77, 0xde, 0xea, 0x0c, 0x51, 0xee, 0x2b, 0x2c,
  0xeb, 0x13, 0xac, 0xb1, 0xa2, 0x17, 0x19, 0x76, 0xaf, 0x94, 0x35, 0x74,
  0x8a, 0x6c, 0x7b, 0x73, 0x4d, 0x35, 0xb0, 0x7f, 0x47, 0x97, 0x14, 0xfc,
  0x7c, 0x2c, 0xcc, 0x45, 0xaf, 0xe4, 0x3a, 0xfa, 0xbc, 0x71, 0x20, 0x24,
  0xb7, 0xdd, 0xcc, 0xb7, 0xe6, 0x54, 0xc1, 0x1d, 0xcd, 0x96, 0x18, 0x07,
  0x8b, 0x80, 0xba, 0x3f, 0x49, 0x99, 0x88, 0x6d, 0x57, 0x41, 0x12, 0x1a,
  0x91, 0x35, 0x8c, 0xc3, 0x67, 0x96, 0x75, 0x49, 0xe9, 0x92, 0x7e, 0xb5,
  0x3e, 0xa9, 0x80, 0xdb, 0xaa, 0x84, 0x02, 0xe8, 0x57, 0x4d, 0x1c, 0x8b,
  0xc4, 0x7d, 0x58, 0xbf, 0x1b, 0xb8, 0xfa, 0xdb, 0x2c, 0xbd, 0x77, 0xf5,
  0x36, 0x2b, 0xe2, 0xae, 0x03, 0xa8, 0x95, 0x8e, 0xb4, 0xf1, 0x27, 0xd3,
  0xa4, 0x62, 0x12, 0xeb, 0xe4, 0xd9, 0x0e, 0xac, 0x58, 0x1c, 0x64, 0x2e,
  0x86, 0x1a, 0x49, 0xca, 0x42, 0xee, 0xd6, 0x78, 0xc9, 0x06, 0x26, 0x58,
  0xe6, 0x21, 0x44, 0xb5, 0x37, 0xc7, 0x01, 0x97, 0x34, 0x91, 0xce, 0x17,
  0x66, 0xd9, 0xea, 0xa8, 0x8e, 0x84, 0xdc, 0x58, 0xf6, 0x51, 0x7a, 0xf0,
  0xc8, 0x78, 0xa2, 0xf0, 0xc9, 0x58, 0x0e, 0xee, 0xab, 0x61, 0x69, 0x66,
  0x0b, 0x3f, 0x30, 0x3e, 0x01, 0x16, 0xdb, 0xf9, 0xa2, 0xdf, 0x69, 0xbd,
  0xfd, 0x3c, 0x30, 0x2f, 0xb3, 0x6e, 0xa6, 0x0e, 0x35, 0x4a, 0x9b, 0x15,
  0x4e, 0xba, 0xf0, 0xd8, 0xc3, 0xc5, 0x72, 0x44, 0x02, 0x57, 0xb9, 0x6c,
  0x96, 0x28, 0x74, 0xa9, 0xcc, 0x28, 0x4a, 0x07, 0x71, 0x9f, 0x97, 0xdc,
  0x97, 0xb0, 0x86, 0xe8, 0xc6, 0x96, 0xbb, 0x12, 0x81, 0x18, 0x62, 0x0d,
  0x1c, 0x19, 0x96, 0x41, 0x5d, 0x5c, 0xd9, 0x9b, 0x86, 0xb0, 0xc1, 0xb8,
  0x9c, 0xbc, 0x4b, 0x8c, 0x8d, 0xe5, 0x1f, 0xff, 0xc3, 0xbe, 0x46, 0xd6,
  0xed, 0x3f, 0xcd, 0x4f, 0xd0, 0x6e, 0x56, 0x8b, 0x4d, 0x80, 0xfe, 0xd8,
  0x1b, 0x51, 0x64, 0x6d, 0x90, 0x29, 0x21, 0x2d, 0x7e, 0xec, 0xeb, 0x6c,
  0xea, 0xfc, 0x63, 0xae, 0x8b, 0xca, 0xc2, 0x41, 0x73, 0xb2, 0x22, 0x39,
  0xfe, 0xc4, 0xb5, 0x11, 0xe8, 0x0d, 0x92, 0x00, 0xd9, 0x97, 0x1a, 0x16,
  0xd4, 0xfb, 0x29, 0xd7, 0x9a, 0xad, 0x24, 0xfb, 0xd0, 0xe0, 0x59, 0xbe,
  0x94, 0xf8, 0xde, 0x9f, 0x1a, 0x3e, 0x6b, 0x29, 0xaf, 0xc7, 0x1b, 0xf2,
  0x71, 0x9f, 0x0e, 0x86, 0xe6, 0x22, 0x29, 0x0c, 0x2b, 0x0d, 0xda, 0x3e,
  0x33, 0x38, 0xfe, 0xf9, 0xb3, 0x9d, 0x7e, 0xa0, 0x18, 0xf7, 0x1a, 0x68,
  0xe8, 0x09, 0xca, 0x74, 0x4f, 0x43, 0x5c, 0x6d, 0x26, 0xf3, 0x8f, 0x23,
  0x85, 0x64, 0x1d, 0x25, 0x16, 0xd9, 0x3e, 0xb1, 0x10, 0x65, 0x8d, 0x29,
  0x5f, 0x19, 0xec, 0xd8, 0x2c, 0x6b, 0xe5, 0x84, 0x9a, 0xea, 0x3e, 0x59,
  0x5a, 0x18, 0x7c, 0xee, 0x0d, 0xf9, 0x06, 0x7e, 0x69, 0x94, 0xf9, 0x60,
  0x49, 0x5d, 0x24, 0x40, 0xd1, 0x86, 0x71, 0x90, 0x11, 0xe9, 0xa0, 0xf8,
  0xd4, 0x50, 0xb5, 0x7d, 0xe9, 0x33, 0x51, 0x8a, 0x57, 0xe6, 0xb4, 0xc9,
  0xf5, 0xe9, 0x31, 0x3c, 0x05, 0xb2, 0xbc, 0x0b, 0xb7, 0xe2, 0x74, 0x12,
  0x60, 0xf1, 0x69, 0x49, 0xd4, 0xc7, 0xd2, 0xcb, 0x43, 0xbb, 0x86, 0x95,
  0xe3, 0x6d, 0x72, 0x73, 0xf6, 0xc0, 0xbc, 0x47, 0x56, 0x83, 0x3b, 0x4f,
  0xc4, 0x51, 0x92, 0x9c, 0x81, 0x41, 0x6a, 0x69, 0x0f, 0x92, 0x69, 0xc5,
  0x76, 0x6b, 0x86, 0xd1, 0xd4, 0x8d, 0x7c, 0xbc, 0x6f, 0xd8, 0x19, 0x72,
  0x4d, 0x0d, 0x95, 0x3a, 0x84, 0xeb, 0xc3, 0x0d, 0x41, 0x0a, 0x21, 0x81,
  0x8d, 0x75, 0xfd, 0xa0, 0x64, 0x7c, 0x74, 0x34, 0x7f, 0xbc, 0x39, 0x84,
  0x52, 0xed, 0xc8, 0x11, 0x8d, 0xa7, 0x69, 0xec, 0x53, 0xd8, 0xde, 0xfb,
  0xf2, 0xa7, 0xb0, 0x95, 0xb2, 0xc0, 0x4c, 0xf2, 0xee, 0x13, 0x2b, 0x63,
  0xfe, 0x2e, 0x56, 0x4e, 0x56, 0xad, 0x8c, 0x62, 0x95, 0xd5, 0x56, 0xa6,
  0xba, 0x20, 0xba, 0x22, 0x5e, 0x7f, 0x6c, 0x71, 0x19, 0x47, 0x2b, 0x32,
  0x4a, 0xb8, 0xae, 0x2c, 0x4c, 0x45, 0xb1, 0xc2, 0xf2, 0x6d, 0x98, 0x8b,
  0x4e, 0xb7, 0x5b, 0x41, 0xfa, 0x9e, 0x6a, 0x0e, 0x21, 0xc1, 0x8d, 0x68,
  0xdd, 0xe7, 0x8d, 0xb8, 0x33, 0x36, 0x8a, 0xbc, 0x97, 0x5c, 0x07, 0xa7,
  0x3e, 0xb8, 0xcc, 0x87, 0x5e, 0x50, 0xdf, 0xb1, 0xe7, 0x11, 0xff, 0xa0,
  0x5a, 0xc9, 0x45, 0xf6, 0x01, 0xc4, 0x86, 0xd9, 0x27, 0x0a, 0xf6, 0x00,
  0x53, 0xb8, 0x0b, 0xf6, 0x96, 0xdb, 0xd4, 0xae, 0xaf, 0x59, 0x3a, 0x7d,
  0xa2, 0xb9, 0x69, 0xaa, 0x8a, 0x15, 0x64, 0xb4, 0x65, 0xeb, 0x11, 0xc6,
  0x84, 0x98, 0x7b, 0xb2, 0xea, 0xbd, 0x0a, 0x66, 0xa4, 0xa2, 0x2d, 0x35,
  0x26, 0x8a, 0x5b, 0xab, 0xe4, 0xea, 0x70, 0x61, 0xe5, 0x24, 0x68, 0x52,
  0x8f, 0x37, 0x27, 0x09, 0x33, 0x56, 0xa0, 0x56, 0x25, 0x49, 0xd8, 0x31,
  0xe2, 0xc2, 0x4b, 0x08, 0xed, 0x43, 0xae, 0x92, 0x96, 0x05, 0x70, 0xa7,
  0xf3, 0xa8, 0x6d, 0x5c, 0x06, 0x22, 0xfe, 0xeb, 0x06, 0x15, 0x14, 0xc0,
  0x09, 0x40, 0x3c, 0x2c, 0xf2, 0x42, 0x82, 0xdc, 0xd6, 0xb3, 0xfc, 0xf1,
  0xe6, 0x94, 0x28, 0x3f, 0x60, 0x46, 0xf1, 0x62, 0xa1, 0xbd, 0x3d, 0xbd,
  0x09, 0xbf, 0xcb, 0x7c, 0x15, 0x39, 0x7b, 0x93, 0x58, 0xaf, 0x83, 0x19,
  0xdc, 0x64, 0x03, 0x64, 0x71, 0x2d, 0xc9, 0x75, 0x59, 0xf4, 0x34, 0xcf,
  0x0a, 0x90, 0x53, 0x6b, 0x93, 0x7e, 0x04, 0xd2, 0x3b, 0x5c, 0x06, 0x86,
  0x0f, 0x52, 0x9e, 0xf6, 0x5f, 0xb4, 0x0e, 0xbe, 0xca, 0xac, 0xc2, 0x8a,
  0x09, 0x74, 0x18, 0xcc, 0x2e, 0x58, 0x84, 0x51, 0x42, 0xda, 0xd7, 0xe0,
  0xa9, 0xd1, 0xa5, 0x85, 0xb7, 0xb0, 0x88, 0xc9, 0x22, 0xe9, 0xd7, 0xf1,
  0xb4, 0x24, 0x6f, 0x13, 0x85, 0xea, 0x9e, 0xe2, 0x0c, 0x5a, 0x8f, 0x07,
  0x5c, 0x25, 0x90, 0x85, 0xc6, 0xe6, 0x3a, 0x0d, 0x04, 0x4d, 0xa2, 0xb9,
  0xa7, 0x9a, 0x63, 0xdb, 0x89, 0xd8, 0x8a, 0x6f, 0x59, 0x7b, 0x5b, 0x41,
  0x92, 0xae, 0xf4, 0xf3, 0x8a, 0x93, 0x0f, 0x88, 0x55, 0x5e, 0x67, 0x4d,
  0xa3, 0x0b, 0x30, 0xc6, 0x1f, 0xef, 0x9f, 0x38, 0xdc, 0xc2, 0x2d, 0x8f,
  0x9c, 0x7e, 0xe1, 0x3f, 0x3d, 0x47, 0x79, 0x3d, 0x84, 0x3b, 0x7e, 0x18,
  0x29, 0x40, 0x4a, 0x0e, 0xb2, 0x67, 0x5c, 0x72, 0x0d, 0x57, 0xec, 0x64,
  0x56, 0x8d, 0xaf, 0x14, 0x6d, 0x9f, 0xc9, 0xf2, 0xa9, 0xd1, 0xc5, 0xa2,
  0x90, 0x55, 0x17, 0x41, 0x4c, 0x40, 0x1a, 0xd7, 0x02, 0xa2, 0x8e, 0xc4,
  0xb2, 0xf5, 0x21, 0x5c, 0x5d, 0x53, 0xe3, 0x90, 0x11, 0xe7, 0x82, 0x4a,
  0x82, 0xf5, 0x0a, 0x53, 0x45, 0x9e, 0xbc, 0xc6, 0xdb, 0xf2, 0x48, 0x30,
  0x56, 0x8c, 0xfc, 0xc3, 0x8f, 0xcf, 0x6f, 0xce, 0xcb, 0xc3, 0x6c, 0x26,
  0xc0, 0x20, 0x54, 0x4f, 0x8f, 0x54, 0x9b, 0x6a, 0xc5, 0xc1, 0xab, 0x23,
  0x28, 0x25, 0x24, 0xb3, 0xba, 0xa2, 0xb7, 0xce, 0x50, 0x59, 0x63, 0x10,
  0xba, 0xf3, 0x2d, 0xc9, 0x8a, 0x2d, 0xb2, 0x8a, 0xee, 0x40, 0x05, 0x50,
  0x75, 0x9e, 0x24, 0x13, 0x0d, 0xea, 0x21, 0xb9, 0x84, 0x4f, 0x4f, 0x99,
  0x7c, 0x10, 0x93, 0x2b, 0x68, 0x0b, 0x9b, 0x10, 0x2a, 0xe9, 0x2f, 0xc9,
  0x7b, 0x4b, 0x71, 0x0f, 0x85, 0x03, 0x9f, 0x25, 0x28, 0xd8, 0x0a, 0x22,
  0xfa, 0x24, 0x28, 0x0b, 0x26, 0x4f, 0xb7, 0x9c, 0x40, 0xb4, 0xa6, 0x01,
  0x50, 0xd1, 0x87, 0xb5, 0x26, 0x4f, 0xaf, 0x6a, 0x4b, 0xbd, 0x0f, 0x8f,
  0xb6, 0x65, 0xe1, 0x0a, 0x6e, 0x58, 0x10, 0x7d, 0x9f, 0xd8, 0xac, 0x36,
  0xc9, 0x18, 0x3d, 0x3a, 0x60, 0x64, 0x65, 0xd6, 0x22, 0x37, 0xad, 0x1e,
  0x7f, 0xa0, 0x7e, 0x3e, 0xde, 0x23, 0x4c, 0x8a, 0x26, 0xb5, 0x35, 0xba,
  0x5e, 0xd0, 0xae, 0xfa, 0x7d, 0xe0, 0xae, 0x63, 0xf6, 0xe1, 0x5d, 0xf9,
  0x79, 0xc9, 0x33, 0x81, 0x66, 0x4a, 0x5a, 0x43, 0xb1, 0xcc, 0xa5, 0x70,
  0xc6, 0xd3, 0xa4, 0xe4, 0xce, 0xbf, 0xab, 0xdf, 0xde, 0x3e, 0x06, 0xb7,
  0x7b, 0x98, 0xbe, 0x0d, 0xc2, 0xa2, 0xda, 0x7e, 0xa3, 0x31, 0x48, 0x6b,
  0x4d, 0xdc, 0x33, 0x01, 0x0f, 0x78, 0xcf, 0xd1, 0xb0, 0x3a, 0x82, 0x7d,
  0xf9, 0xa8, 0x7f, 0xc1, 0x1f, 0xe9, 0x4e, 0x07, 0xe5, 0xe5, 0x5d, 0x24,
  0x79, 0xaf, 0xa5, 0x5a, 0x48, 0xd4, 0x16, 0x60, 0x0a, 0x8d, 0x61, 0xde,
  0xc4, 0x12, 0x22, 0x49, 0xdf, 0x04, 0xb4, 0x82, 0x75, 0x5b, 0x57, 0x4e,
  0x85, 0x75, 0xe9, 0xc8, 0x7d, 0x83, 0x34, 0x40, 0x03, 0xda, 0x40, 0xe4,
  0xf5, 0x87, 0xf2, 0x86, 0x0f, 0xc8, 0xab, 0xe3, 0x31, 0x18, 0x7f, 0x2d,
  0xdc, 0x18, 0x68, 0x08, 0xfe, 0x43, 0xd5, 0x37, 0x79, 0x26, 0xbe, 0x4a,
  0xd3, 0x8a, 0x82, 0xdd, 0x1f, 0xa8, 0x31, 0x34, 0xc7, 0x61, 0xdd, 0xbd,
  0x87, 0x3a, 0x22, 0xa9, 0x6e, 0x71, 0x85, 0x80, 0xb1, 0x8c, 0x0e, 0x67,
  0x9c, 0xf9, 0x64, 0xff, 0x18, 0x30, 0x09, 0x18, 0xd2, 0x53, 0xe3, 0xd0,
  0xc9, 0x28, 0xf8, 0x7a, 0xb5, 0x56, 0x14, 0xf2, 0xe6, 0xa0, 0xee, 0xa1,
  0x4e, 0x29, 0x6b, 0xd9, 0x4f, 0x5c, 0xa4, 0xae, 0xc1, 0xe8, 0x0e, 0xb0,
  0x23, 0xc8, 0xbb, 0x14, 0x14, 0xf0, 0x46, 0x56, 0x4e, 0x33, 0x8f, 0xed,
  0x92, 0x74, 0x3e, 0x80, 0x55, 0xbd, 0x07, 0xa6, 0xd3, 0x45, 0x80, 0xb3,
  0x8a, 0x0f, 0xcc, 0x30, 0x8e, 0x64, 0x03, 0x8e, 0x08, 0x48, 0x15, 0xfa,
  0x7e, 0x9a, 0xc1, 0xa0, 0xfd, 0xf8, 0xe0, 0x24, 0xdb, 0xb2, 0x06, 0x22,
  0x6b, 0x48, 0x91, 0xb5, 0x1c, 0xbb, 0xa6, 0xe6, 0x56, 0x14, 0xd3, 0xf7,
  0xf4, 0x64, 0x7a, 0xf9, 0xf0, 0x5e, 0xd8, 0xf7, 0xd3, 0xd7, 0xa3, 0x3c,
  0x67, 0x27, 0x85, 0x7d, 0x26, 0x74, 0x62, 0x49, 0x76, 0x4b, 0x48, 0xd2,
  0xba, 0x14, 0xdb, 0x6a, 0x84, 0x26, 0xd3, 0x0f, 0x32, 0x23, 0x78, 0x8d,
  0xd7, 0x9d, 0xb9, 0x01, 0x23, 0x34, 0xc0, 0x57, 0xcb, 0x3d, 0x58, 0x5b,
  0x4f, 0xcb, 0x4f, 0xdc, 0x88, 0x47, 0x96, 0x7d, 0x4c, 0xb4, 0xfe, 0xed,
  0xa2, 0x1a, 0x5c, 0x9e, 0x4c, 0xf4, 0x0a, 0x3f, 0x9e, 0x48, 0x1b, 0xf2,
  0xb6, 0x3a, 0x5f, 0x36, 0x60, 0x55, 0xa6, 0x98, 0x54, 0xbb, 0xf1, 0x89,
  0x3f, 0x75, 0xd3, 0xe8, 0xea, 0x1c, 0xbf, 0x0f, 0xcd, 0x0b, 0x4b, 0xee,
  0x53, 0x49, 0x63, 0x6f, 0x0b, 0xd6, 0x57, 0x4e, 0x50, 0x34, 0x71, 0x4b,
  0x65, 0xbe, 0x16, 0x0c, 0xae, 0x49, 0x4b, 0x39, 0x03, 0x8d, 0x03, 0xef,
  0x22, 0x6c, 0xcc, 0x1f, 0x3d, 0x6e, 0x48, 0x60, 0x21, 0xe2, 0xb6, 0xe6,
  0x7c, 0x94, 0x4c, 0x21, 0xb9, 0x0f, 0xd2, 0x43, 0x07, 0xf8, 0xde, 0x36,
  0x62, 0x9a, 0xf3, 0xa3, 0xfe, 0xf8, 0xd8, 0x99, 0x14, 0x6a, 0x6a, 0x81,
  0xe6, 0x52, 0x73, 0x88, 0x39, 0x22, 0xd1, 0x82, 0xd5, 0x6f, 0x8b, 0xfe,
  0x02, 0xbf, 0x5d, 0x70, 0x35, 0x63, 0x0e, 0x8d, 0x10, 0x88, 0x35, 0x2e,
  0x39, 0x24, 0x46, 0x20, 0x7e, 0x57, 0xa2, 0x16, 0x41, 0xa3, 0x16, 0x6e,
  0x47, 0xdf, 0x37, 0xad, 0xeb, 0xe6, 0x91, 0xf5, 0x8a, 0x49, 0x30, 0x3c,
  0x71, 0xf7, 0x2b, 0x7c, 0xb5, 0x03, 0x6d, 0xf1, 0x86, 0xbd, 0x66, 0x19,
  0x5f, 0x29, 0x92, 0x5a, 0x58, 0xdd, 0x41, 0xac, 0x57, 0xbd, 0xd0, 0x81,
  0x65, 0x29, 0x8a, 0x31, 0x19, 0xd8, 0xb9, 0xae, 0xf2, 0x4d, 0x3d, 0xf8,
  0xa0, 0x56, 0xe2, 0x62, 0x95, 0x45, 0x73, 0x68, 0xa1, 0x14, 0xd2, 0x12,
  0x22, 0x06, 0xb7, 0x7b, 0x41, 0x42, 0x24, 0x14, 0xdb, 0xc0, 0x2b, 0x20,
  0x24, 0x2e, 0x4e, 0xee, 0xb8, 0xa1, 0xba, 0xc3, 0x3e, 0x76, 0x17, 0xbb,
  0xb2, 0xf2, 0xd2, 0x46, 0x2b, 0xd9, 0x40, 0xf8, 0x56, 0x85, 0xc8, 0x2d,
  0x66, 0x63, 0x8d, 0x81, 0xbc, 0xbc, 0xae, 0x81, 0xdf, 0x1b, 0x10, 0x7f,
  0x13, 0x3a, 0x45, 0x38, 0xfd, 0x70, 0xea, 0xfc, 0xf9, 0xd1, 0x18, 0xbe,
  0xdf, 0x88, 0x15, 0x7c, 0x8f, 0x00, 0x1e, 0xb9, 0xbc, 0x56, 0x82, 0x82,
  0x4b, 0x69, 0xd4, 0xa1, 0x8b, 0xe9, 0x8f, 0x49, 0xca, 0x29, 0x4a, 0xd2,
  0x29, 0xec, 0x4d, 0xad, 0x9d, 0xa3, 0x81, 0x6b, 0x1f, 0x50, 0xf1, 0x25,
  0xac, 0x6b, 0x04, 0xb2, 0x76, 0x30, 0xc1, 0x17, 0x95, 0xb4, 0x96, 0x3a,
  0xdc, 0x40, 0x0b, 0xfc, 0x71, 0x90, 0xfa, 0xc0, 0xcd, 0xe9, 0x50, 0x10,
  0xd1, 0x70, 0x97, 0x16, 0x1a, 0x0f, 0xa5, 0x10, 0x39, 0x86, 0x50, 0xa1,
  0x8a, 0xc2, 0x57, 0x87, 0x17, 0x1b, 0x4d, 0x5c, 0x06, 0x75, 0xc8, 0x60,
  0x58, 0x00, 0xe3, 0xd2, 0x53, 0x10, 0xbb, 0x0a, 0x6f, 0x2e, 0xc1, 0x8a,
  0xf7, 0xec, 0x7e, 0x31, 0x8d, 0xe7, 0x71, 0x2d, 0xd0, 0xc9, 0x56, 0xee,
  0xcd, 0x8a, 0x85, 0x0b, 0x10, 0xa5, 0x6d, 0xd5, 0x82, 0x79, 0x1c, 0x1f,
  0x0d, 0x2f, 0xb0, 0x8a, 0xf5, 0xa0, 0x26, 0x04, 0x66, 0x0b, 0xec, 0x6a,
  0x5a, 0x58, 0x70, 0x03, 0x47, 0xf5, 0xff, 0x7e, 0x04, 0xf2, 0xc0, 0xd9,
  0xfe, 0x2c, 0xde, 0x2a, 0x3a, 0x06, 0xff, 0xdb, 0x82, 0xa8, 0x14, 0x7b,
  0x81, 0x9c, 0xdd, 0xc0, 0x2c, 0x80, 0x29, 0xbc, 0x83, 0xbc, 0x2c, 0x48,
  0x0e, 0xa2, 0x25, 0x2c, 0xb8, 0xa8, 0x97, 0x98, 0x33, 0x27, 0xcb, 0xbc,
  0x29, 0x2c, 0xc4, 0x51, 0xd0, 0xa1, 0xa0, 0x41, 0xf4, 0x2a, 0xba, 0x0c,
  0xbb, 0xe6, 0x0a, 0x0f, 0xe8, 0x4d, 0xdd, 0x07, 0x2f, 0x34, 0x3c, 0x1e,
  0xbe, 0xd2, 0xa1, 0xe1, 0x93, 0x84, 0x43, 0xb2, 0x69, 0x6f, 0x93, 0xde,
  0x3b, 0x65, 0x80, 0x04, 0x66, 0xe5, 0x82, 0x5d, 0xf0, 0xf0, 0xc4, 0x9d,
  0xa4, 0xa1, 0x74, 0x45, 0x14, 0xb8, 0xaa, 0x35, 0x90, 0x67, 0x59, 0x78,
  0x98, 0xff, 0x58, 0xea, 0xa0, 0x17, 0x4d, 0x09, 0xd0, 0x89, 0xcf, 0xf0,
  0xfe, 0x07, 0x89, 0x45, 0x08, 0xfa, 0x23, 0xe6, 0x3c, 0xb7, 0x5a, 0xb3,
  0x34, 0xfe, 0xdc, 0x5c, 0x72, 0xa8, 0x0c, 0xc0, 0xef, 0xf5, 0x5b, 0xec,
  0x06, 0x2c, 0x73, 0xae, 0x60, 0x88, 0xbf, 0x1d, 0x4d, 0xfc, 0xe0, 0x68,
  0x42, 0xd6, 0xf0, 0x15, 0xfe, 0xf8, 0x55, 0x54, 0x11, 0x80, 0x7e, 0xe0,
  0x65, 0xd8, 0x2e, 0x2a, 0xe4, 0xd1, 0x6f, 0x84, 0xe6, 0x33, 0x2a, 0x19,
  0xac, 0x2e, 0xc1, 0x6e, 0xab, 0xb9, 0x83, 0x05, 0x8b, 0x2a, 0x51, 0x54,
  0x28, 0x82, 0x37, 0xb5, 0xad, 0x0c, 0x53, 0xff, 0x07, 0xab, 0xc3, 0xfc,
  0x6c, 0x8b, 0xaf, 0x27, 0x24, 0x2d, 0x27, 0xe5, 0xef, 0xb8, 0x74, 0xbf,
  0x70, 0x96, 0x25, 0x3d, 0xde, 0x07, 0xf9, 0xbf, 0x9a, 0xb0, 0xe4, 0x49,
  0x2c, 0x44, 0x23, 0x6f, 0x56, 0xa2, 0x8b, 0x02, 0x58, 0x54, 0x58, 0x61,
  0xac, 0x56, 0x4d, 0xbe, 0xc0, 0x5d, 0x95, 0x46, 0x85, 0xee, 0x66, 0x2f,
  0x5b, 0xe9, 0x97, 0xb8, 0xbd, 0xd4, 0xa6, 0xe0, 0x09, 0xf1, 0xe1, 0xa3,
  0x67, 0x7b, 0x91, 0xc2, 0xeb, 0xaf, 0x68, 0x2f, 0x00, 0xb7, 0x69, 0x24,
  0x6d, 0x0b, 0xaa, 0x8a, 0xc2, 0xb3, 0x86, 0xd3, 0xb0, 0x5b, 0x15, 0x48,
  0xee, 0x08, 0xae, 0x20, 0xa6, 0x86, 0x67, 0xc4, 0xbf, 0x5e, 0x70, 0xa7,
  0x0d, 0xbd, 0x94, 0xd1, 0xf4, 0x34, 0xf0, 0x6f, 0x16, 0x73, 0x2d, 0x1e,
  0xf6, 0xea, 0x3b, 0x48, 0x3d, 0x1a, 0xa3, 0x9a, 0x29, 0xf3, 0xd4, 0xb2,
  0xb7, 0x80, 0x6a, 0xe8, 0x0c, 0x42, 0xad, 0x71, 0xc7, 0xb1, 0xab, 0x9b,
  0x17, 0x56, 0x2a, 0x55, 0x5e, 0xfb, 0x87, 0x6a, 0x86, 0x2d, 0x35, 0xc7,
  0x83, 0x5c, 0x9d, 0x5d, 0x5b, 0x08, 0xf7, 0xaf, 0x4d, 0x56, 0x6f, 0x83,
  0x76, 0x01, 0x44, 0xf8, 0x4e, 0xed, 0x8d, 0xb0, 0x30, 0xc4, 0x7a, 0x7f,
  0x43, 0xaa, 0x28, 0x72, 0xf1, 0xde, 0xd2, 0x5d, 0x78, 0x4d, 0xc3, 0x41,
  0xec, 0xb5, 0x7a, 0x17, 0x5f, 0x9a, 0x4d, 0x27, 0xc1, 0x6e, 0xeb, 0x4c,
  0xb9, 0xb7, 0x4d, 0xb1, 0x07, 0x1a, 0xc3, 0x63, 0x96, 0xd2, 0xb8, 0x4b,
  0x6a, 0x6d, 0x91, 0x3e, 0x1f, 0xb6, 0xe5, 0xef, 0x60, 0xd7, 0xde, 0xef,
  0x19, 0x67, 0xcd, 0x28, 0x3d, 0x50, 0x58, 0x8b, 0x56, 0xcc, 0x3e, 0x46,
  0xee, 0x09, 0x40, 0x7e, 0x82, 0xb2, 0xae, 0x51, 0x68, 0x7a, 0xed, 0xbb,
  0x52, 0x99, 0x85, 0xc3, 0x2e, 0x6b, 0x4b, 0xaa, 0xad, 0x94, 0x80, 0x0c,
  0xab, 0xe1, 0xb6, 0xd6, 0x5b, 0xd0, 0xba, 0x59, 0x9c, 0x71, 0xd7, 0x9e,
  0xa2, 0x02, 0x52, 0xf3, 0x55, 0x3a, 0x43, 0x5b, 0x70, 0xd4, 0xe1, 0x18,
  0xee, 0x51, 0xb1, 0xcc, 0x27, 0xcb, 0x59, 0x67, 0xc0, 0x80, 0x6f, 0xba,
  0x29, 0xba, 0x30, 0xcc, 0x40, 0xeb, 0x07, 0x41, 0x2e, 0x21, 0xea, 0xf5,
  0xc5, 0x56, 0xcd, 0xb0, 0x6c, 0x08, 0x46, 0x01, 0x66, 0x51, 0x7f, 0x3b,
  0xa4, 0x1f, 0x6a, 0xaf, 0x21, 0x6f, 0x95, 0x7c, 0xaf, 0xfd, 0x8e, 0x9b,
  0xb7, 0x45, 0x8b, 0xc9, 0x72, 0xec, 0xf6, 0x60, 0xab, 0x5d, 0x72, 0x7c,
  0xc3, 0x39, 0x04, 0xbe, 0x66, 0x60, 0x4a, 0xea, 0x1f, 0x0f, 0xb6, 0xf0,
  0x75, 0x4e, 0x25, 0x5e, 0x41, 0x45, 0xae, 0x2d, 0x77, 0x40, 0x1b, 0xe5,
  0x88, 0x5d, 0x41, 0xb8, 0xc2, 0x71, 0x06, 0x24, 0x1c, 0x27, 0x62, 0x65,
  0xde, 0x75, 0x52, 0x5b, 0x30, 0xbc, 0x6d, 0x66, 0xb9, 0xd3, 0xe2, 0x76,
  0xbb, 0x15, 0xbe, 0xda, 0x06, 0x57, 0xa9, 0x68, 0x78, 0x31, 0x3c, 0x76,
  0x11, 0xb4, 0xdb, 0x22, 0xcf, 0x5a, 0x15, 0x42, 0x17, 0x9c, 0xbd, 0xa2,
  0xe6, 0xe4, 0xc5, 0xf1, 0xd0, 0x84, 0x59, 0x3f, 0x84, 0x1d, 0xbe, 0x30,
  0x8b, 0xe9, 0xed, 0x4e, 0xeb, 0x10, 0x6a, 0xcb, 0xc3, 0x03, 0x18, 0x06,
  0x03, 0xd8, 0x69, 0x0e, 0xc0, 0xb0, 0xe5, 0xda, 0x87, 0xc0, 0x2f, 0x37,
  0x86, 0xf0, 0x4c, 0x87, 0xf0, 0xec, 0xc3, 0x57, 0x21, 0x1c, 0xc4, 0xb3,
  0x5f, 0xb7, 0x0a, 0xad, 0x43, 0x78, 0xce, 0x51, 0xe3, 0x8b, 0xdb, 0xe7,
  0x4d, 0x42, 0x34, 0x6b, 0x12, 0x07, 0xe5, 0x31, 0x2c, 0xc3, 0x34, 0x11,
  0xf3, 0x9e, 0x79, 0x91, 0x59, 0x43, 0xb7, 0x72, 0x57, 0x38, 0x8d, 0x3e,
  0x99, 0xf7, 0xa8, 0x5e, 0x73, 0x48, 0x47, 0x4c, 0x0f, 0x1a, 0x2e, 0xa6,
  0x80, 0x4e, 0x5c, 0xda, 0x2f, 0x8b, 0xdb, 0x4f, 0xfa, 0xda, 0x4b, 0xad,
  0xd0, 0x21, 0x0a, 0xb5, 0xad, 0x88, 0x03, 0x96, 0x42, 0xbf, 0x80, 0x46,
  0x51, 0xf8, 0xfc, 0x8c, 0x63, 0x79, 0x9f, 0xdb, 0xb8, 0x12, 0x09, 0xca,
  0x0c, 0xa6, 0xfb, 0x89, 0x4c, 0xf7, 0x93, 0xff, 0x93, 0xa6, 0xfb, 0xc9,
  0xea, 0xe9, 0x7e, 0x24, 0x6a, 0x39, 0x50, 0xc6, 0xfa, 0xa3, 0x38, 0x5f,
  0x89, 0xb9, 0x68, 0xa1, 0x84, 0x0e, 0x92, 0xac, 0x12, 0x12, 0x0f, 0xc4,
  0x10, 0xfb, 0x86, 0x9a, 0x59, 0xcd, 0x0a, 0x2a, 0x12, 0x7d, 0x49, 0xaf,
  0x17, 0x65, 0x3a, 0x66, 0x3e, 0xc7, 0xe8, 0xe8, 0x2e, 0x06, 0xf6, 0x3f,
  0x37, 0x07, 0xad, 0x35, 0xb9, 0x0e, 0x9a, 0x55, 0xb3, 0x7a, 0x11, 0x50,
  0xf7, 0xaa, 0xb5, 0xb7, 0x82, 0xeb, 0xfd, 0xf0, 0xe4, 0xdb, 0xa3, 0xf3,
  0xd3, 0x93, 0xb7, 0x87, 0x27, 0x2e, 0x08, 0x05, 0xb1, 0x31, 0x62, 0x0a,
  0xf8, 0xd1, 0x34, 0x7d, 0x52, 0xe7, 0x7f, 0x06, 0x12, 0xcf, 0xe7, 0x6a,
  0x53, 0x6b, 0xde, 0x65, 0x85, 0x9a, 0x0f, 0x3c, 0xba, 0xb6, 0x25, 0x7c,
  0xc1, 0x4e, 0xe3, 0x16, 0x15, 0x51, 0xdd, 0xef, 0xcf, 0xce, 0x4f, 0xbf,
  0xff, 0xe1, 0x37, 0x6c, 0x7f, 0x58, 0x41, 0x74, 0xfe, 0x4d, 0x9b, 0x7f,
  0x13, 0x8e, 0x7e, 0xef, 0xf8, 0xf8, 0x37, 0x6b, 0x1c, 0xc2, 0xb9, 0x33,
  0xa6, 0xf4, 0x9d, 0x65, 0xca, 0xd5, 0x30, 0xad, 0x88, 0xed, 0x27, 0xa7,
  0xda, 0xb1, 0x98, 0x34, 0xfa, 0x06, 0x8a, 0x3e, 0x71, 0x45, 0x86, 0x78,
  0x0c, 0x0d, 0x88, 0x47, 0x7c, 0x09, 0x99, 0xc2, 0x41, 0x62, 0x99, 0x41,
  0x11, 0xd0, 0xdd, 0xc8, 0x49, 0xc9, 0x9c, 0xd5, 0x4a, 0x40, 0x88, 0xcc,
  0x18, 0xda, 0x54, 0x31, 0x68, 0xe8, 0x71, 0xc4, 0x21, 0x40, 0x79, 0x5a,
  0xdc, 0x20, 0x99, 0x87, 0x8f, 0x8c, 0x02, 0x21, 0x96, 0xc0, 0x95, 0x45,
  0xa9, 0x75, 0x1e, 0x0a, 0x93, 0xd7, 0xf7, 0x47, 0x17, 0xd1, 0xfe, 0xe9,
  0x81, 0xa7, 0xdd, 0x0b, 0xb8, 0x66, 0x60, 0xf0, 0x44, 0xfd, 0xa6, 0xe5,
  0x9c, 0xcb, 0xc0, 0x5f, 0x7a, 0xf8, 0x71, 0x45, 0xd2, 0xe3, 0x20, 0xac,
  0x42, 0x03, 0x4c, 0xaf, 0x13, 0xa9, 0x83, 0x92, 0x4b, 0x60, 0xd5, 0x24,
  0x50, 0xaf, 0xe5, 0x61, 0x07, 0xf9, 0x17, 0x86, 0xdb, 0x32, 0x5e, 0x08,
  0x9d, 0x35, 0x51, 0xc7, 0xe9, 0xd8, 0x71, 0x41, 0x93, 0xb9, 0xa4, 0x1c,
  0x91, 0xd4, 0xb1, 0x57, 0x3a, 0xbc, 0xc8, 0xa0, 0xea, 0xa5, 0xc0, 0xc5,
  0xe7, 0xc0, 0xcd, 0xed, 0xa9, 0xdd, 0x8c, 0x81, 0x4d, 0x65, 0x30, 0x21,
  0xd8, 0xcb, 0xb6, 0xda, 0x92, 0xe7, 0x1e, 0x2e, 0xc1, 0x03, 0xc5, 0x40,
  0xa7, 0xe6, 0xf8, 0x7a, 0x98, 0x3e, 0xc0, 0x21, 0x14, 0xe7, 0xc7, 0x10,
  0xc5, 0xa5, 0x68, 0x61, 0x5a, 0xac, 0x30, 0x53, 0xfa, 0x6d, 0xdf, 0x51,
  0xa2, 0x16, 0x00, 0x56, 0x96, 0x34, 0xc4, 0x65, 0x91, 0xfe, 0x12, 0xc8,
  0xae, 0xcf, 0x74, 0x30, 0xe7, 0xc7, 0x34, 0xf3, 0xa9, 0x70, 0x1e, 0x0d,
  0x14, 0x16, 0xac, 0xf2, 0xbb, 0x58, 0xd0, 0xab, 0xb4, 0x16, 0x98, 0x7f,
  0xf3, 0x85, 0xfc, 0xd8, 0x37, 0x52, 0xf0, 0x58, 0x59, 0xbe, 0x26, 0x77,
  0xad, 0x4e, 0xb7, 0x05, 0x17, 0x8d, 0xe1, 0x82, 0x11, 0xab, 0x69, 0x13,
  0x52, 0xb9, 0x16, 0xb7, 0xf1, 0x49, 0xad, 0x1f, 0xeb, 0x46, 0x6a, 0x18,
  0x5f, 0x38, 0x41, 0xbf, 0x1e, 0xa0, 0xc3, 0xcd, 0x37, 0x5b, 0xfb, 0xb4,
  0xbe, 0x28, 0x41, 0x89, 0xda, 0x6a, 0xf1, 0xe0, 0xcf, 0x1c, 0x4f, 0x88,
  0xee, 0x12, 0x4e, 0xa4, 0x71, 0x15, 0xd9, 0x16, 0x53, 0x37, 0x3b, 0xf3,
  0xb7, 0xc3, 0xc1, 0x2b, 0x75, 0x39, 0x34, 0x3e, 0x6f, 0xac, 0xe3, 0x6d,
  0x28, 0x4e, 0x79, 0x11, 0x2c, 0xff, 0x4b, 0xdf, 0x49, 0x14, 0xc3, 0xed,
  0xc1, 0x56, 0xb9, 0x79, 0x6a, 0x71, 0x72, 0xda, 0xbe, 0x7c, 0xc4, 0xde,
  0x24, 0x92, 0x9f, 0x33, 0xf7, 0xb7, 0xbe, 0xd1, 0x80, 0x66, 0xa9, 0x85,
  0xcd, 0xf0, 0x2a, 0x48, 0x91, 0x9a, 0xb0, 0xb4, 0x0d, 0x42, 0xa8, 0xe3,
  0xb9, 0x5a, 0xc4, 0x05, 0xe3, 0x54, 0x93, 0x09, 0x1b, 0xb7, 0x4b, 0xe9,
  0x70, 0xf4, 0x59, 0xdf, 0x94, 0x75, 0x03, 0x62, 0xaf, 0x9c, 0x6a, 0xdf,
  0x28, 0xce, 0x90, 0xe9, 0xad, 0x38, 0xaa, 0x51, 0xc3, 0xe5, 0x13, 0xd4,
  0x41, 0xf3, 0x67, 0x62, 0xbb, 0xb6, 0xd8, 0x67, 0x7b, 0xc3, 0xa1, 0x2d,
  0x35, 0x80, 0x73, 0x6c, 0x3d, 0x65, 0x05, 0xd5, 0x5b, 0x86, 0x7c, 0x59,
  0x85, 0x44, 0x68, 0xd1, 0xf0, 0xb5, 0x91, 0x9a, 0x37, 0x7d, 0xfb, 0x99,
  0x5f, 0x73, 0xd7, 0xd9, 0xb7, 0xd2, 0x5a, 0xef, 0x03, 0x3b, 0x6b, 0xed,
  0xeb, 0xdb, 0x96, 0xbe, 0x9e, 0xd7, 0xe6, 0xb5, 0xb3, 0xf3, 0x69, 0x64,
  0xa7, 0x4c, 0xcb, 0xea, 0xba, 0xce, 0xb4, 0x37, 0xd1, 0xe1, 0xe9, 0xc1,
  0xbe, 0x61, 0x01, 0x24, 0xad, 0x85, 0x24, 0x31, 0x98, 0xa0, 0xab, 0x17,
  0x7e, 0x5a, 0xa4, 0xae, 0x71, 0x7b, 0x6c, 0x11, 0x90, 0x63, 0xd2, 0x38,
  0x3d, 0x40, 0x7e, 0xe0, 0xa3, 0x72, 0xc4, 0x23, 0x23, 0x3e, 0xbe, 0x22,
  0x3e, 0xc1, 0x86, 0x11, 0xf4, 0xf3, 0xa9, 0xeb, 0xc7, 0x8d, 0x9c, 0x15,
  0x34, 0xc9, 0xaa, 0x1e, 0x84, 0x1c, 0x41, 0x69, 0x24, 0x08, 0x60, 0xb2,
  0xb2, 0xf2, 0xcd, 0xea, 0x93, 0xf2, 0xb6, 0xef, 0x45, 0x8e, 0xdf, 0x99,
  0x56, 0x88, 0x11, 0xc8, 0x0c, 0x14, 0xd1, 0x88, 0x2b, 0xf8, 0x13, 0xb0,
  0x63, 0xf0, 0x71, 0xb7, 0x3e, 0xf2, 0xf0, 0xb4, 0x6f, 0xbf, 0x0c, 0xd6,
  0xc4, 0x86, 0x65, 0x46, 0xb8, 0x4d, 0x3b, 0x3e, 0x8e, 0x85, 0x88, 0xd8,
  0xc3, 0x7f, 0x9f, 0x1f, 0x5e, 0x9c, 0x73, 0x0c, 0x24, 0x40, 0x34, 0xea,
  0x2a, 0x24, 0x9d, 0xa9, 0x0d, 0x67, 0xaf, 0x16, 0x7c, 0xeb, 0x80, 0xeb,
  0x7a, 0x4a, 0x96, 0x3a, 0x7d, 0xb8, 0x67, 0xe8, 0xd6, 0xa8, 0x96, 0xed,
  0xf3, 0xe0, 0xfa, 0x72, 0x0f, 0xf9, 0x88, 0x3e, 0x3d, 0x19, 0x6e, 0xfd,
  0x7d, 0x5c, 0x88, 0x60, 0x9a, 0x89, 0x4f, 0xd1, 0x45, 0x4f, 0x1b, 0x27,
  0xf2, 0xe1, 0x0e, 0x52, 0x43, 0x5b, 0x18, 0xa0, 0x44, 0x20, 0x37, 0xac,
  0x27, 0xae, 0xf3, 0x78, 0x2e, 0xc9, 0x8e, 0x32, 0x88, 0x6a, 0x39, 0x70,
  0xbd, 0x20, 0x25, 0x0a, 0x7c, 0x94, 0x40, 0xd3, 0x7a, 0xce, 0x85, 0x6a,
  0x9a, 0xc6, 0x98, 0x51, 0x76, 0x6b, 0x4e, 0x2f, 0x4d, 0x13, 0x10, 0x44,
  0x7c, 0xec, 0x17, 0x2e, 0x53, 0xc8, 0xe0, 0xfd, 0x4b, 0x2e, 0x6b, 0x1d,
  0xa7, 0x53, 0xd3, 0xaf, 0x83, 0x65, 0x93, 0x43, 0xf9, 0x1d, 0xf2, 0x16,
  0x6c, 0xcd, 0x6a, 0x87, 0x51, 0x92, 0x1a, 0xc0, 0x64, 0xc1, 0x76, 0x3c,
  0x7a, 0x57, 0xf1, 0x40, 0x33, 0x9f, 0x35, 0x07, 0xa6, 0x10, 0x28, 0x41,
  0x37, 0x2f, 0x9a, 0xc4, 0x3b, 0xbc, 0x38, 0x3d, 0x0f, 0x2a, 0xf5, 0x55,
  0x59, 0xae, 0x1c, 0x46, 0x3c, 0xe2, 0xfd, 0x7e, 0xbd, 0x16, 0x9b, 0xba,
  0x09, 0x7c, 0x1a, 0xb6, 0xc2, 0xb9, 0xd6, 0xbe, 0xd7, 0x4f, 0xbc, 0x33,
  0x45, 0xa7, 0xf6, 0x6d, 0x9c, 0x23, 0x9d, 0x96, 0x33, 0x5e, 0x78, 0x65,
  0xe9, 0x7e, 0x24, 0x95, 0x64, 0x16, 0x18, 0x26, 0x76, 0xe4, 0x9c, 0x9d,
  0x2e, 0x4b, 0xa9, 0x00, 0xcf, 0x29, 0x72, 0x4c, 0x46, 0x9a, 0x2c, 0xc7,
  0xf6, 0x1c, 0xb5, 0xd8, 0x38, 0x2b, 0x59, 0x9d, 0x14, 0xe5, 0x0c, 0x9d,
  0xfa, 0xf2, 0x9f, 0x6a, 0x13, 0x77, 0xb7, 0x97, 0xc7, 0x4b, 0x85, 0x15,
  0x96, 0xcd, 0xe5, 0xe2, 0x61, 0x50, 0x6f, 0x3e, 0x60, 0xaf, 0xeb, 0x9b,
  0x3d, 0x26, 0x51, 0x60, 0xa2, 0xa5, 0xed, 0xb4, 0x7a, 0xb2, 0xc9, 0x46,
  0x5e, 0xac, 0xd8, 0x72, 0xeb, 0x8c, 0x42, 0xc4, 0x3a, 0x34, 0x74, 0x5b,
  0x29, 0x1f, 0x6e, 0x5f, 0x9c, 0x64, 0xe6, 0xfc, 0xc5, 0x61, 0xd5, 0x92,
  0x2f, 0xed, 0x65, 0x56, 0x75, 0x53, 0xd0, 0x8e, 0x35, 0xc4, 0x28, 0xd2,
  0xf9, 0x83, 0x39, 0x85, 0x1c, 0xce, 0xfc, 0xa5, 0xcb, 0x83, 0x66, 0xfe,
  0xdc, 0xee, 0x2b, 0xf3, 0x99, 0x83, 0xcf, 0xb6, 0x9b, 0xd4, 0xc1, 0xe2,
  0xf6, 0xf9, 0xe1, 0xf0, 0x42, 0xc6, 0xce, 0xbf, 0x35, 0xc6, 0x2e, 0xe9,
  0x73, 0xae, 0x08, 0x73, 0xb1, 0x8a, 0x3a, 0x38, 0xec, 0x82, 0x1d, 0xd8,
  0x61, 0x21, 0xde, 0x70, 0xcd, 0x9e, 0x05, 0x21, 0x60, 0x60, 0x9c, 0x4a,
  0x2b, 0x17, 0x56, 0xaf, 0x27, 0xea, 0x68, 0x2f, 0x1d, 0xba, 0x72, 0xe5,
  0x48, 0x64, 0xf9, 0x4d, 0xd0, 0xc2, 0x73, 0xdf, 0xc2, 0x82, 0x99, 0xbb,
  0x36, 0x70, 0x64, 0x66, 0x63, 0xfe, 0xd0, 0x39, 0x38, 0xaf, 0xb8, 0x3c,
  0xbc, 0x10, 0x86, 0x3c, 0xe7, 0xdb, 0x79, 0xe1, 0x92, 0x69, 0x4d, 0x3c,
  0x0a, 0x86, 0xc2, 0x1f, 0x5b, 0xf4, 0x34, 0x3c, 0x70, 0x35, 0xb2, 0x7b,
  0xf6, 0x89, 0x67, 0xba, 0x2c, 0x3b, 0x7b, 0xaf, 0x87, 0xae, 0x40, 0x70,
  0x1d, 0xb1, 0xd3, 0x28, 0x9d, 0x2f, 0x01, 0xd4, 0x41, 0x5c, 0x62, 0xca,
  0x88, 0x40, 0xea, 0xb4, 0x68, 0x58, 0x68, 0xeb, 0x11, 0x69, 0xcf, 0xf4,
  0x22, 0x22, 0xfd, 0xd6, 0x6f, 0x97, 0xa4, 0xa8, 0xe1, 0x30, 0x7b, 0x19,
  0x8f, 0x0e, 0xee, 0xdc, 0xdd, 0x16, 0x83, 0xe8, 0x8c, 0x01, 0x15, 0x61,
  0x7b, 0x2e, 0xfe, 0xea, 0x5b, 0x93, 0xc3, 0x72, 0x7c, 0xb0, 0x77, 0xc6,
  0xd7, 0x27, 0x84, 0xd3, 0x94, 0x6b, 0x53, 0xe2, 0x13, 0xfe, 0x35, 0x00,
  0xc3, 0x6b, 0x4c, 0xf9, 0xa5, 0x7f, 0x59, 0x8b, 0x4d, 0xd7, 0x1f, 0x79,
  0xae, 0xb4, 0x45, 0x5a, 0x0b, 0x9a, 0x70, 0xdc, 0x99, 0xcf, 0x34, 0x6f,
  0x49, 0xca, 0x11, 0x72, 0x68, 0xe1, 0xd2, 0x9e, 0xa9, 0x70, 0xf1, 0xa0,
  0x29, 0xb9, 0x13, 0xf6, 0x64, 0x9d, 0x00, 0x73, 0x40, 0x27, 0x87, 0xab,
  0x0c, 0x50, 0x5b, 0x73, 0x66, 0xb8, 0x53, 0xf3, 0xcf, 0xfa, 0xfc, 0x20,
  0xe6, 0x98, 0xa3, 0x4c, 0x4d, 0xf0, 0x3c, 0x93, 0x06, 0x3a, 0x57, 0xd5,
  0x4d, 0xf6, 0x5c, 0xa8, 0xd1, 0x91, 0x8e, 0xbb, 0xc6, 0x2a, 0xa3, 0xe3,
  0x8e, 0x5d, 0xda, 0x21, 0x76, 0xdb, 0xd5, 0x05, 0x0f, 0x9a, 0x7a, 0xe1,
  0x9b, 0xe2, 0x72, 0xf6, 0x9e, 0xbf, 0xef, 0x55, 0x78, 0x90, 0x03, 0xdb,
  0x72, 0x85, 0xef, 0x1f, 0xd3, 0x14, 0xaa, 0xf7, 0xc7, 0x73, 0x21, 0x86,
  0x8b, 0x2c, 0x93, 0xe2, 0x51, 0x2e, 0x7e, 0x6c, 0x20, 0x91, 0x69, 0x4d,
  0x7b, 0x74, 0xa1, 0x79, 0xa5, 0xd7, 0x5a, 0xe8, 0x83, 0xcd, 0xe9, 0xfd,
  0x06, 0x4a, 0xde, 0xac, 0x81, 0x36, 0xff, 0xfc, 0x33, 0x55, 0xdf, 0x6e,
  0xe6, 0x5c, 0x57, 0xf5, 0xe2, 0xf0, 0xf8, 0xe4, 0xf0, 0xc2, 0x21, 0x36,
  0xd8, 0x6c, 0x82, 0xe7, 0x5f, 0xaa, 0xc5, 0x67, 0xaa, 0xf1, 0x2b, 0x0a,
  0x0e, 0x5a, 0xf7, 0x4b, 0xbe, 0xd8, 0x76, 0xf1, 0x59, 0x1c, 0x8d, 0xd5,
  0x2d, 0xe4, 0xfc, 0x05, 0x31, 0x59, 0xa8, 0xdd, 0xf7, 0x75, 0xf4, 0xf6,
  0xe0, 0x05, 0x87, 0x7f, 0x5f, 0x71, 0x45, 0x62, 0x40, 0xbf, 0x2a, 0x95,
  0x64, 0x37, 0xbe, 0xad, 0x9d, 0x10, 0x83, 0x40, 0x54, 0x14, 0xe5, 0x18,
  0x2a, 0xc8, 0xd2, 0x1a, 0x71, 0xd2, 0x22, 0xa9, 0xaa, 0x62, 0x27, 0x33,
  0x44, 0x4a, 0x43, 0x8f, 0x80, 0x6c, 0x50, 0xaf, 0x21, 0x58, 0xe5, 0x12,
  0x2f, 0x9e, 0x79, 0x2e, 0x91, 0x3f, 0x2c, 0x18, 0xd2, 0x4a, 0x8a, 0x0c,
  0x3a, 0x92, 0xf5, 0x8f, 0x0a, 0x63, 0xda, 0x97, 0x73, 0xc5, 0xd2, 0x62,
  0xf3, 0x2d, 0xe4, 0x4d, 0xc2, 0x0a, 0xe5, 0x5f, 0x7b, 0x11, 0x2a, 0x6b,
  0x56, 0x4f, 0x99, 0x16, 0x8f, 0xd9, 0x1e, 0x04, 0x01, 0xff, 0xe8, 0x27,
  0xee, 0x51, 0x2e, 0xc1, 0x94, 0xce, 0x15, 0x86, 0x64, 0xf5, 0x0b, 0x2a,
  0x60, 0xca, 0xbd, 0xeb, 0x45, 0x1f, 0x11, 0x2a, 0x82, 0x65, 0xf7, 0x6f,
  0xbc, 0xac, 0x2a, 0xa2, 0xcb, 0x4a, 0x30, 0x18, 0x26, 0x94, 0x2e, 0x68,
  0x1d, 0xbd, 0xe6, 0x2a, 0x97, 0xe0, 0x59, 0x3d, 0xb6, 0xce, 0xd8, 0x4b,
  0x25, 0x65, 0xdc, 0x4e, 0x91, 0x50, 0xd5, 0xfe, 0x5e, 0x64, 0xaf, 0xd4,
  0x69, 0x92, 0x9f, 0xf5, 0xb5, 0x00, 0x3f, 0xd9, 0x56, 0x6a, 0xa4, 0xe9,
  0x66, 0x57, 0x73, 0xd2, 0xed, 0x27, 0xcd, 0x2a, 0x5a, 0xfe, 0xe9, 0x1d,
  0x3d, 0x89, 0x52, 0x6e, 0x0e, 0xdc, 0x86, 0x63, 0x27, 0xdd, 0xf7, 0xcf,
  0x94, 0x56, 0xc5, 0xb3, 0x24, 0x55, 0x43, 0xa9, 0x4d, 0xc6, 0x86, 0x4e,
  0x92, 0x49, 0xe2, 0x77, 0xf4, 0x93, 0xe7, 0x2a, 0xd2, 0x98, 0xd4, 0xc9,
  0xec, 0x9e, 0xd7, 0x60, 0xca, 0x69, 0xf9, 0xca, 0xfd, 0xfc, 0xd3, 0x7a,
  0xa1, 0xf8, 0x8a, 0xd8, 0x22, 0xc6, 0x29, 0xdf, 0x2b, 0x10, 0x9f, 0x79,
  0x97, 0xce, 0x35, 0x6a, 0xb8, 0xfe, 0xf6, 0x27, 0x2b, 0x0c, 0x19, 0x6a,
  0x95, 0x3f, 0x04, 0x01, 0xf9, 0xc7, 0x3f, 0xb5, 0x58, 0xbd, 0xbc, 0x17,
  0xe2, 0x99, 0xc1, 0x57, 0xae, 0x98, 0x78, 0x76, 0x66, 0x58, 0x05, 0x58,
  0x58, 0xb6, 0x36, 0xd8, 0xc1, 0xa5, 0xf5, 0xd2, 0x80, 0x8a, 0xa5, 0x4e,
  0x7c, 0x1f, 0x42, 0x3d, 0x6f, 0x80, 0x49, 0xea, 0xe5, 0x6c, 0x62, 0x07,
  0x3e, 0x76, 0xd3, 0x3f, 0xfc, 0x52, 0xe9, 0xc0, 0xae, 0x1d, 0x93, 0xf6,
  0x56, 0xbd, 0xf0, 0xe9, 0x56, 0x28, 0xfa, 0x4d, 0xd8, 0x5e, 0x26, 0x49,
  0xb6, 0xab, 0x9e, 0x17, 0x22, 0x38, 0x22, 0x5e, 0x7c, 0x45, 0xc4, 0x8b,
  0x47, 0xdc, 0x65, 0xe5, 0x9f, 0xda, 0xa9, 0x32, 0xae, 0x50, 0x0c, 0x89,
  0x8e, 0x0e, 0xfc, 0x73, 0xcf, 0xfc, 0xdc, 0xe2, 0x29, 0x5f, 0xa8, 0x0f,
  0x66, 0x75, 0x5b, 0xe7, 0x97, 0x7c, 0x0c, 0xe6, 0xa7, 0xcf, 0x35, 0x7e,
  0x8f, 0x63, 0x36, 0xaf, 0x25, 0x4e, 0xab, 0xfe, 0x88, 0xec, 0xfc, 0xbe,
  0x2b, 0x44, 0x28, 0x71, 0x78, 0x85, 0xbf, 0x45, 0xfd, 0xa3, 0x9f, 0x3c,
  0xf2, 0xa8, 0x5e, 0x3a, 0x85, 0xbb, 0x2a, 0xfd, 0x6b, 0x9f, 0x36, 0x0f,
  0xb2, 0x49, 0xd5, 0x16, 0xde, 0x4a, 0xc7, 0x89, 0x4f, 0x53, 0xb4, 0xce,
  0xd1, 0xba, 0x7f, 0x35, 0xbb, 0x49, 0xce, 0xc1, 0x7b, 0xc5, 0x5f, 0x83,
  0xc1, 0x7e, 0x16, 0x86, 0xc8, 0x8a, 0xcd, 0x04, 0xce, 0x34, 0xce, 0x32,
  0x0e, 0x41, 0x4d, 0x61, 0xe2, 0xc0, 0xc6, 0x63, 0x61, 0x7c, 0x03, 0xb2,
  0xd3, 0x74, 0x09, 0x2f, 0xe7, 0x9e, 0x35, 0x88, 0x22, 0xa5, 0xf9, 0xca,
  0x16, 0xe5, 0xa3, 0x63, 0xfb, 0x9a, 0xf6, 0x12, 0x34, 0xe1, 0xed, 0x4e,
  0x5b, 0x35, 0x6a, 0x2f, 0xae, 0x97, 0xa2, 0xb4, 0xba, 0xe9, 0xf8, 0xea,
  0xad, 0xfe, 0xad, 0x1d, 0xcf, 0x9c, 0x30, 0x30, 0x08, 0x5c, 0xfb, 0x34,
  0x54, 0x51, 0x6a, 0x23, 0x90, 0x1e, 0x2a, 0x36, 0xe6, 0x8a, 0xb1, 0x1e,
  0x59, 0x0a, 0x7c, 0xb4, 0x1e, 0xaf, 0xae, 0x47, 0x54, 0x09, 0xba, 0xfd,
  0x4c, 0x85, 0x02, 0x76, 0x59, 0xd2, 0xfe, 0x5c, 0x27, 0xe3, 0x1b, 0x3b,
  0x30, 0xda, 0x46, 0x4b, 0xa4, 0xee, 0xf7, 0xdf, 0x07, 0xe6, 0x5b, 0x0f,
  0xc8, 0x1c, 0xe7, 0x82, 0x08, 0x12, 0x1a, 0x6d, 0xe5, 0x16, 0xe2, 0xed,
  0x46, 0x41, 0xc7, 0x3c, 0x99, 0x26, 0x8c, 0x09, 0x05, 0xb9, 0xb3, 0x7e,
  0x19, 0x59, 0xe0, 0x2b, 0x87, 0x42, 0x08, 0x90, 0x7d, 0xa2, 0xb0, 0x61,
  0x73, 0x76, 0xda, 0xaa, 0xf1, 0x81, 0xae, 0xab, 0xbd, 0x77, 0x17, 0x5f,
  0x9f, 0x9e, 0x0f, 0xa3, 0x4d, 0xce, 0x99, 0xbd, 0x38, 0x3f, 0xfa, 0xf2,
  0x1d, 0x69, 0x73, 0xce, 0xaa, 0x7c, 0x10, 0x93, 0x9e, 0x37, 0x8d, 0x86,
  0x65, 0x32, 0x1f, 0x25, 0xf9, 0x95, 0xc1, 0x28, 0x03, 0xe9, 0x82, 0xd9,
  0x73, 0x96, 0x0b, 0x6a, 0xa6, 0xaf, 0x04, 0x69, 0x46, 0x73, 0x89, 0x78,
  0x4a, 0xe9, 0xcb, 0xcc, 0x6b, 0x2a, 0x69, 0x35, 0x0f, 0xda, 0x17, 0x20,
  0xbd, 0xf8, 0x7a, 0xef, 0xe4, 0x9b, 0xa1, 0xe1, 0x96, 0x7d, 0xf7, 0xdd,
  0x77, 0xa1, 0xd3, 0x64, 0x77, 0x73, 0x13, 0x48, 0x55, 0xd7, 0xf1, 0xfd,
  0xfd, 0xa0, 0x20, 0x56, 0x46, 0x67, 0x68, 0xcd, 0xc7, 0x9e, 0x2b, 0x58,
  0x6d, 0xb1, 0xa4, 0x9b, 0x8c, 0xbe, 0xde, 0x5c, 0x2c, 0x47, 0x0c, 0x8e,
  0xbb, 0xb9, 0x2c, 0x15, 0xb1, 0x1d, 0x6f, 0x6f, 0xae, 0xad, 0x0d, 0x0f,
  0x0f, 0xa3, 0xbd, 0xe3, 0xe1, 0x69, 0xf0, 0xee, 0xfa, 0xf6, 0x06, 0xdd,
  0xf1, 0x57, 0x49, 0x49, 0xbf, 0xac, 0xad, 0x1d, 0xef, 0x5d, 0xb0, 0x06,
  0xf3, 0xed, 0xe1, 0xf9, 0xf0, 0xe8, 0xf4, 0x84, 0xb7, 0x88, 0x51, 0x01,
  0xe2, 0x29, 0x57, 0xc1, 0x65, 0xa1, 0x82, 0x73, 0xf6, 0xee, 0x0c, 0x2b,
  0x9d, 0xd1, 0x2e, 0x48, 0x0c, 0x11, 0x99, 0x4c, 0xbc, 0x51, 0x77, 0x8c,
  0xd6, 0x10, 0x5b, 0x75, 0xda, 0x92, 0xd5, 0x08, 0x73, 0xb9, 0xad, 0x45,
  0xde, 0x88, 0x21, 0x80, 0x1d, 0xc9, 0x48, 0xe2, 0x44, 0x7a, 0x02, 0x3e,
  0x8e, 0x10, 0xe7, 0x20, 0x69, 0xbe, 0x75, 0xe2, 0xc3, 0xa3, 0xb7, 0x67,
  0x24, 0xcf, 0xbf, 0x1b, 0xee, 0x7d, 0x75, 0xc8, 0x8f, 0x7e, 0x95, 0x94,
  0x7e, 0x3f, 0x04, 0xd3, 0x9d, 0x3b, 0x39, 0x49, 0xca, 0x62, 0x1c, 0x2f,
  0x38, 0x60, 0x99, 0xba, 0xe9, 0x0b, 0x3f, 0x0c, 0xda, 0x16, 0xc9, 0xce,
  0xc3, 0x08, 0xcf, 0xf5, 0x79, 0x60, 0xfc, 0x86, 0xed, 0x9e, 0x1f, 0xee,
  0x1d, 0xbc, 0x3d, 0xb4, 0x20, 0x22, 0x81, 0xf1, 0xa3, 0x46, 0xaf, 0xb3,
  0x59, 0x58, 0x71, 0x9a, 0xef, 0x24, 0x5e, 0x7c, 0xfa, 0x86, 0x96, 0x74,
  0x45, 0x77, 0x7e, 0xa3, 0xf0, 0xec, 0xe0, 0x32, 0xdd, 0x94, 0xd6, 0xad,
  0xbf, 0xd8, 0x2d, 0x89, 0x81, 0x68, 0xa8, 0x6c, 0x26, 0x1a, 0x2a, 0x54,
  0xdb, 0xcf, 0xb6, 0xb6, 0xb6, 0x1e, 0x99, 0x07, 0x8c, 0x88, 0x6a, 0x22,
  0xa2, 0xa9, 0xec, 0xf2, 0xe3, 0x9b, 0xbe, 0x7d, 0x23, 0xcd, 0xd0, 0x24,
  0xcb, 0x7f, 0xce, 0x25, 0xa5, 0x20, 0x2d, 0x93, 0xf6, 0x41, 0x8f, 0xb3,
  0xcc, 0xed, 0x41, 0x65, 0x79, 0x26, 0x0c, 0x7c, 0x92, 0x96, 0x06, 0x83,
  0x84, 0x37, 0x64, 0xe8, 0x93, 0x14, 0x0c, 0x28, 0xce, 0x1f, 0xea, 0x4d,
  0xf2, 0x37, 0xd4, 0x26, 0xff, 0x18, 0x64, 0xf9, 0xd5, 0xe6, 0x6c, 0x17,
  0x41, 0x22, 0xf4, 0xd0, 0x1b, 0x06, 0x3f, 0x40, 0x5d, 0x5e, 0x8b, 0xb7,
  0x29, 0x78, 0x69, 0x39, 0xb8, 0xef, 0x03, 0xc6, 0xf5, 0x2b, 0xd6, 0x41,
  0xaa, 0x57, 0x5f, 0xda, 0xcc, 0x2d, 0x06, 0xa1, 0xa5, 0x93, 0x82, 0xb7,
  0x8c, 0x2d, 0x48, 0x03, 0x62, 0x21, 0xd4, 0x0b, 0x7d, 0x2e, 0x44, 0x42,
  0xbf, 0xe6, 0x44, 0x34, 0x83, 0xf2, 0x1e, 0xec, 0x9d, 0xd1, 0x69, 0xd5,
  0x12, 0x0c, 0xae, 0x45, 0x1c, 0x2c, 0xcf, 0x48, 0xfe, 0x8e, 0x25, 0x5d,
  0x63, 0x88, 0x60, 0x68, 0x85, 0x49, 0x71, 0x00, 0x02, 0xdc, 0x70, 0xbd,
  0xcf, 0x7e, 0x1f, 0x14, 0x54, 0x38, 0x7a, 0xf9, 0x80, 0xce, 0x83, 0x49,
  0xc9, 0xea, 0xcf, 0xf5, 0xe6, 0x08, 0xa8, 0x67, 0x48, 0xa3, 0x68, 0xf4,
  0x05, 0xcc, 0x9d, 0x1c, 0x51, 0x5e, 0x85, 0x74, 0x87, 0x9a, 0x10, 0x83,
  0xe4, 0x3e, 0xe6, 0x24, 0x2b, 0xf4, 0x45, 0x7b, 0xb2, 0x89, 0x18, 0x94,
  0x0f, 0xee, 0x69, 0xff, 0xcc, 0x95, 0x98, 0xa0, 0x15, 0xb8, 0xe5, 0x25,
  0xb8, 0x49, 0x30, 0xfb, 0x50, 0x9e, 0x7d, 0x64, 0x30, 0xbb, 0xb4, 0x0a,
  0xfc, 0xc6, 0x7f, 0x6e, 0x0e, 0x8a, 0xe2, 0x7a, 0x33, 0x9d, 0xbc, 0x9f,
  0x14, 0x31, 0x7d, 0x46, 0x7c, 0xad, 0xf1, 0xf1, 0x80, 0x3e, 0x8c, 0x7e,
  0x72, 0x4d, 0xfd, 0x3f, 0xc5, 0xb8, 0x7d, 0x1a, 0xff, 0xb9, 0xc9, 0x50,
  0x50, 0x40, 0x97, 0x0d, 0x56, 0xad, 0x85, 0x75, 0xd0, 0x94, 0x04, 0x75,
  0x8c, 0xce, 0x62, 0x3b, 0x59, 0xf4, 0xaf, 0xa2, 0x8e, 0xd2, 0xda, 0x8f,
  0x3b, 0x5b, 0x5b, 0xdb, 0xbb, 0xdb, 0x9f, 0xbd, 0xdc, 0xda, 0xdd, 0xde,
  0xde, 0xde, 0xd9, 0xdd, 0xde, 0xdd, 0xdd, 0xd9, 0xfa, 0x79, 0xb3, 0xb3,
  0xb6, 0x76, 0x70, 0xfa, 0xdd, 0xc9, 0xf1, 0xe9, 0xde, 0x41, 0x74, 0x71,
  0x4a, 0x6a, 0x2c, 0x1b, 0x21, 0x5a, 0x8e, 0x39, 0x30, 0x80, 0xca, 0x4c,
  0x2e, 0xb5, 0xd0, 0x60, 0xd9, 0xe8, 0x52, 0x2a, 0x16, 0xf3, 0x4b, 0x83,
  0xeb, 0x72, 0xf6, 0x34, 0xef, 0xfa, 0x90, 0x4e, 0x7a, 0x12, 0x07, 0xe5,
  0xb5, 0x9a, 0xa0, 0x5a, 0x6c, 0x62, 0x65, 0x6c, 0xaa, 0xc5, 0x68, 0x5d,
  0x1c, 0xdc, 0xba, 0xb8, 0x98, 0x3d, 0xe8, 0xbe, 0x14, 0x5a, 0x28, 0x02,
  0x8d, 0x27, 0xc4, 0x78, 0x57, 0x87, 0xa4, 0x14, 0x2a, 0x25, 0x81, 0x60,
  0xa3, 0x31, 0xc1, 0xd3, 0x95, 0x53, 0xe2, 0xf2, 0xd2, 0xf7, 0x98, 0x75,
  0x95, 0x47, 0x08, 0xae, 0x95, 0x9f, 0x1d, 0xd0, 0x6c, 0x4c, 0x4f, 0x4b,
  0x73, 0x1b, 0x32, 0xfc, 0xd2, 0x2d, 0xdd, 0x71, 0x3f, 0xc6, 0x3a, 0x7c,
  0x17, 0xfc, 0x4d, 0x78, 0xe3, 0x6c, 0x3a, 0xbb, 0x92, 0x0c, 0xe0, 0xdd,
  0xf0, 0xe8, 0xe4, 0x2b, 0x38, 0x8e, 0xbe, 0x3b, 0x3d, 0x3f, 0x18, 0x52,
  0xb3, 0x7c, 0x15, 0xaf, 0xc1, 0xb4, 0x00, 0xe0, 0x34, 0x19, 0x95, 0xd0,
  0x3f, 0x77, 0xfd, 0x67, 0x28, 0x18, 0x88, 0xd8, 0x95, 0x1c, 0x07, 0x0c,
  0x33, 0x10, 0x15, 0x19, 0x7f, 0xa7, 0x9d, 0xbb, 0xe1, 0x28, 0xc8, 0xeb,
  0x5f, 0xcc, 0x62, 0x46, 0xf9, 0x4c, 0x06, 0x82, 0xb1, 0x85, 0x68, 0x80,
  0x4d, 0xc6, 0xd7, 0xd8, 0x64, 0x89, 0x75, 0xb3, 0xcc, 0xc0, 0x27, 0xd0,
  0x4a, 0x96, 0x3b, 0x5c, 0xd4, 0xca, 0x8a, 0xf0, 0x01, 0xbb, 0x9c, 0xc6,
  0x57, 0xe8, 0xb0, 0x79, 0xf6, 0x82, 0xce, 0xb4, 0xfb, 0x0f, 0xed, 0x92,
  0xd9, 0x1b, 0xda, 0x3b, 0x2a, 0x5d, 0xda, 0x33, 0x40, 0x85, 0xd4, 0xe2,
  0x2d, 0xf2, 0x11, 0xea, 0x65, 0xb0, 0xef, 0x9c, 0xeb, 0x17, 0xd4, 0x01,
  0x5c, 0xb5, 0xb6, 0xd3, 0x9a, 0x98, 0x0b, 0xfa, 0x41, 0x26, 0x8d, 0x08,
  0xf5, 0xdc, 0x52, 0xa0, 0x21, 0x4b, 0x08, 0x38, 0xfa, 0x44, 0x6e, 0x10,
  0x94, 0x42, 0x59, 0x72, 0x1e, 0x0c, 0x8d, 0x9d, 0x65, 0x10, 0x4d, 0x1a,
  0x51, 0x81, 0xad, 0xc3, 0xe8, 0xb9, 0xe9, 0x38, 0x2d, 0x3b, 0x96, 0x97,
  0xe2, 0x51, 0x98, 0xbc, 0x67, 0xab, 0x28, 0x69, 0x28, 0x31, 0x5d, 0x1d,
  0x5a, 0xa1, 0x51, 0x33, 0x34, 0xb3, 0xd9, 0x4c, 0x52, 0xf7, 0x3a, 0x9c,
  0xc0, 0xe0, 0x5b, 0x49, 0x35, 0xfd, 0xc6, 0x61, 0x22, 0x31, 0x93, 0xe5,
  0xde, 0x05, 0x60, 0x0c, 0xab, 0xee, 0xf8, 0xb9, 0x37, 0xe8, 0x30, 0x2f,
  0x26, 0x71, 0x93, 0x18, 0xa5, 0x50, 0x8e, 0xc6, 0xb1, 0x07, 0x80, 0xec,
  0x95, 0x65, 0x0b, 0x8b, 0x4e, 0x34, 0x58, 0x6a, 0x35, 0x19, 0x62, 0x0d,
  0xa1, 0xaf, 0x2e, 0x13, 0x26, 0x58, 0x1e, 0xc9, 0xc2, 0xf1, 0xaf, 0xf2,
  0x5e, 0xa4, 0x65, 0x91, 0x4c, 0x2f, 0xd9, 0xd0, 0xc0, 0xd1, 0x01, 0x24,
  0x0f, 0x88, 0xb5, 0x30, 0xae, 0x80, 0x13, 0x5b, 0xc4, 0xeb, 0x72, 0x4e,
  0xe2, 0x76, 0xac, 0xee, 0x60, 0xe1, 0x19, 0x57, 0x60, 0x9c, 0xaa, 0x3f,
  0x57, 0x19, 0x85, 0x78, 0x5c, 0x06, 0x06, 0xdd, 0xbd, 0x16, 0x39, 0xdc,
  0xd5, 0xda, 0x14, 0x1c, 0x38, 0x18, 0xd0, 0x99, 0x40, 0x1d, 0xc1, 0x83,
  0xcb, 0x11, 0xad, 0xb6, 0x7b, 0x8e, 0xd7, 0x8e, 0x8d, 0xd7, 0x58, 0xb5,
  0xfd, 0xb0, 0x1a, 0x86, 0x80, 0xd2, 0x35, 0xc1, 0xa1, 0x53, 0x2d, 0xb8,
  0x4c, 0x07, 0x0d, 0xe1, 0x99, 0xcb, 0xc2, 0xad, 0x28, 0xc0, 0x99, 0x63,
  0x57, 0x08, 0xa5, 0xed, 0x18, 0x2a, 0x47, 0x5a, 0x7d, 0x0e, 0x9f, 0x3e,
  0x82, 0xcd, 0x21, 0x99, 0xc4, 0x3f, 0x7d, 0x90, 0x53, 0x12, 0x58, 0x0d,
  0x5a, 0x0f, 0xa3, 0x0e, 0xe2, 0x83, 0x3a, 0xc6, 0x5c, 0x01, 0xbc, 0x59,
  0x88, 0x99, 0xd3, 0xc7, 0xbe, 0x88, 0x67, 0x15, 0xb1, 0xe5, 0x2d, 0xd8,
  0x8f, 0x15, 0x70, 0x3f, 0x1c, 0x04, 0x09, 0x6c, 0xdd, 0x8d, 0xbe, 0x8c,
  0x8b, 0x74, 0xdc, 0x8b, 0x0e, 0x52, 0x12, 0xd4, 0xcb, 0x9e, 0xc7, 0xe7,
  0x73, 0xb8, 0x86, 0x83, 0xe8, 0x3b, 0x2b, 0xac, 0x45, 0x77, 0x2e, 0x42,
  0x1d, 0x61, 0x31, 0x74, 0x59, 0x4e, 0x6b, 0x62, 0x8c, 0x55, 0x73, 0xaa,
  0xcb, 0x29, 0x22, 0x2a, 0x42, 0xdb, 0x1e, 0x78, 0x0c, 0x9b, 0x19, 0x17,
  0x37, 0x55, 0xfc, 0x6c, 0x11, 0xa9, 0x0a, 0x36, 0x0b, 0xb2, 0xfc, 0x83,
  0xf5, 0x9d, 0x6b, 0x7d, 0x02, 0xa5, 0x39, 0xfc, 0xed, 0xa8, 0xdc, 0xb0,
  0xe8, 0x61, 0xba, 0x29, 0x34, 0x1e, 0xc6, 0x5c, 0xb8, 0xb8, 0x8d, 0xec,
  0xb8, 0xae, 0x21, 0x98, 0x9a, 0xd6, 0x89, 0x57, 0x44, 0xf9, 0xc9, 0xe9,
  0xc5, 0xe1, 0x1f, 0xa2, 0x21, 0x31, 0xeb, 0xc4, 0x53, 0x0e, 0x1f, 0x72,
  0xf6, 0x62, 0xab, 0x7b, 0xa9, 0xb1, 0xa7, 0x2e, 0xb3, 0x51, 0xad, 0x7e,
  0x16, 0xfd, 0x2f, 0x55, 0x4f, 0xee, 0xa4, 0xc8, 0x27, 0xaf, 0x0c, 0x68,
  0xf6, 0x36, 0x8d, 0x23, 0x57, 0xfb, 0x91, 0xe7, 0xfe, 0x9e, 0x49, 0xff,
  0xbd, 0x47, 0x8e, 0x5e, 0xea, 0x8b, 0xc0, 0x02, 0xe3, 0x76, 0xd4, 0x22,
  0x00, 0x23, 0xca, 0x38, 0xcd, 0xe9, 0x0a, 0x66, 0x3e, 0x35, 0x16, 0x94,
  0x45, 0xc4, 0xa8, 0x61, 0xec, 0x6c, 0xe2, 0x88, 0x47, 0x44, 0x57, 0x58,
  0x2e, 0x66, 0x5a, 0x70, 0xb0, 0xfa, 0xfa, 0xa2, 0x76, 0xee, 0x42, 0x56,
  0x8a, 0x1c, 0x42, 0xa4, 0x65, 0xa1, 0xb0, 0x82, 0x02, 0xd2, 0xad, 0x21,
  0x20, 0x8c, 0x5a, 0x85, 0x2c, 0x31, 0x77, 0x37, 0x5b, 0x20, 0xd8, 0x71,
  0xbc, 0x0e, 0xd3, 0xe9, 0x24, 0x9a, 0x3d, 0x68, 0x7e, 0xac, 0xf2, 0x61,
  0xce, 0x4a, 0x81, 0xae, 0xf2, 0xd9, 0x67, 0x8d, 0x7b, 0xf7, 0xde, 0x3d,
  0xbd, 0x4b, 0x5f, 0x07, 0x3a, 0xd1, 0x94, 0x9d, 0x89, 0x56, 0xc1, 0xc5,
  0x2b, 0x46, 0x0d, 0x81, 0x33, 0x4c, 0x80, 0x93, 0x0e, 0x9d, 0x91, 0xb0,
  0x65, 0x5f, 0x5c, 0x85, 0x9a, 0x35, 0x91, 0xb8, 0x15, 0x21, 0xbe, 0x10,
  0x97, 0xf4, 0x0a, 0x11, 0xd4, 0x4e, 0x5e, 0x7d, 0xb0, 0x81, 0x80, 0x42,
  0x42, 0xd2, 0x80, 0x65, 0x1a, 0x96, 0xb7, 0x86, 0x99, 0x36, 0xcc, 0x99,
  0x16, 0x3a, 0x18, 0x07, 0x5f, 0x57, 0x03, 0xa3, 0x77, 0x48, 0xe8, 0xee,
  0xc6, 0xe8, 0xbf, 0x5b, 0x3d, 0x9c, 0x77, 0xff, 0xca, 0x70, 0xc6, 0x4d,
  0xbe, 0xa8, 0x65, 0x5e, 0x79, 0x69, 0x82, 0x32, 0x86, 0x52, 0x4f, 0x99,
  0xf3, 0x7a, 0xac, 0x78, 0xac, 0xd4, 0x62, 0x90, 0xf2, 0x88, 0xb8, 0xa7,
  0x92, 0x44, 0x5a, 0x42, 0xb8, 0x5a, 0x6b, 0x02, 0xf1, 0x7e, 0xc0, 0x38,
  0x64, 0x3b, 0xc0, 0x7e, 0x48, 0x1d, 0xce, 0x11, 0x38, 0xa0, 0x09, 0xb8,
  0x9a, 0xfc, 0x45, 0x8d, 0x9e, 0xef, 0x9d, 0x7c, 0x75, 0x08, 0x7a, 0x65,
  0xb6, 0xe1, 0xf3, 0x06, 0x39, 0x9b, 0xa9, 0x9f, 0x4b, 0x95, 0xef, 0x3b,
  0x31, 0xf3, 0xd0, 0x1b, 0x93, 0xe5, 0x98, 0x3d, 0xa8, 0xef, 0x0a, 0x2b,
  0xb4, 0x0d, 0xc8, 0xc1, 0x29, 0xca, 0x83, 0x33, 0xcb, 0x50, 0x5f, 0xe5,
  0x5a, 0x64, 0xba, 0x15, 0x28, 0x9e, 0xaf, 0xe4, 0x4c, 0xcd, 0x47, 0xc5,
  0x72, 0xb4, 0x88, 0x35, 0xa9, 0x26, 0x0e, 0xf3, 0x34, 0x54, 0x92, 0x1d,
  0x54, 0xa6, 0xc0, 0xbc, 0x4f, 0x22, 0xf5, 0x9c, 0xd4, 0x94, 0x43, 0x6a,
  0x1a, 0x84, 0x1a, 0x83, 0xe0, 0xbc, 0x6c, 0x6f, 0x6d, 0x79, 0xf0, 0x90,
  0xd8, 0x35, 0xd8, 0xd8, 0xc5, 0x3c, 0xda, 0xea, 0xbf, 0x7c, 0xb9, 0x6a,
  0xbb, 0x5c, 0xa3, 0xc8, 0x1b, 0x78, 0xf1, 0xc1, 0x6d, 0xf6, 0xf9, 0xd1,
  0x55, 0x6d, 0xb6, 0xdc, 0x8d, 0xa8, 0x1e, 0xa0, 0x7e, 0xe2, 0xc2, 0x05,
  0x23, 0xa8, 0x0c, 0x2d, 0x86, 0x1b, 0x98, 0xd1, 0xe6, 0xee, 0x82, 0xe4,
  0xa5, 0x5c, 0x8b, 0xdc, 0x4d, 0x06, 0x2c, 0x1c, 0x13, 0xb7, 0x17, 0xec,
  0x2a, 0x4e, 0x9d, 0x83, 0xea, 0x83, 0x16, 0x26, 0x10, 0x91, 0x56, 0x2c,
  0xd1, 0x65, 0x73, 0x36, 0x6a, 0x7f, 0x89, 0x48, 0xf2, 0x3e, 0x63, 0x75,
  0x8a, 0xa4, 0x6f, 0x11, 0x39, 0x49, 0x7e, 0x82, 0x5e, 0xbd, 0x59, 0x93,
  0xa6, 0xde, 0x69, 0xe5, 0x2c, 0x06, 0x46, 0x67, 0x17, 0x82, 0x40, 0xb0,
  0xa6, 0x73, 0x09, 0x09, 0xf1, 0xfb, 0xbf, 0x42, 0xb5, 0xbb, 0x88, 0xfa,
  0x01, 0x53, 0x52, 0x88, 0x11, 0xe6, 0x48, 0xb3, 0x07, 0xbb, 0x65, 0xb5,
  0x07, 0xb4, 0x6e, 0x76, 0x9a, 0x4a, 0xc1, 0xc7, 0x9e, 0x8a, 0x46, 0xa0,
  0xa1, 0x06, 0x53, 0x6a, 0xe9, 0x52, 0xba, 0x01, 0x93, 0xab, 0xb1, 0xa0,
  0x0f, 0x1b, 0x4a, 0xdc, 0x52, 0x29, 0xcf, 0xe4, 0xb0, 0x94, 0xb3, 0xd6,
  0x54, 0xbe, 0xae, 0xab, 0x7a, 0x8a, 0x3e, 0xc7, 0x0f, 0xe2, 0x04, 0x65,
  0xbb, 0x6b, 0xd1, 0xbf, 0x3b, 0xb8, 0x47, 0x86, 0xc5, 0xe7, 0xd3, 0x2a,
  0x6e, 0xd6, 0x86, 0xd9, 0xaa, 0xf3, 0x5e, 0xc8, 0xfb, 0xd2, 0x75, 0xdc,
  0xde, 0x9d, 0xbc, 0x6f, 0xeb, 0xd1, 0x42, 0xf7, 0x7c, 0x73, 0x29, 0xee,
  0x8c, 0x8b, 0x44, 0xb6, 0xec, 0x79, 0x16, 0xb0, 0xc1, 0x30, 0xb4, 0xc4,
  0xbb, 0x85, 0x47, 0xaf, 0x45, 0x1a, 0xe8, 0x0e, 0x54, 0x1a, 0x26, 0x1c,
  0xc0, 0x66, 0x82, 0xbd, 0xdd, 0xc0, 0xd3, 0x7f, 0xa9, 0x39, 0xf9, 0x28,
  0x99, 0x70, 0x74, 0x69, 0xd9, 0x78, 0x1e, 0xe2, 0x20, 0x5f, 0xce, 0x65,
  0x16, 0xb0, 0x99, 0xd3, 0xe0, 0xe3, 0xe2, 0x1a, 0x0e, 0x60, 0x27, 0xe3,
  0x37, 0x0d, 0x3f, 0x61, 0x9a, 0x3e, 0x31, 0x7b, 0xe1, 0xf4, 0x60, 0xac,
  0x95, 0xa5, 0xa8, 0xae, 0x40, 0x20, 0x12, 0x7f, 0x28, 0xe9, 0x33, 0xd7,
  0x68, 0x35, 0xf6, 0x81, 0xfa, 0x1b, 0xc5, 0xd5, 0x6a, 0x34, 0x57, 0x55,
  0x29, 0xa4, 0x2d, 0xb9, 0x8d, 0x21, 0xc1, 0xa3, 0x22, 0x15, 0xb2, 0x22,
  0x6b, 0x4b, 0x08, 0x71, 0x0c, 0x65, 0xfe, 0x24, 0x49, 0xd2, 0x38, 0xad,
  0xa6, 0x8e, 0x41, 0x8f, 0xf2, 0xd0, 0x1e, 0x9a, 0x2c, 0xc1, 0x18, 0xdf,
  0x12, 0x81, 0x06, 0x0b, 0x34, 0x43, 0x2b, 0x67, 0xd2, 0x27, 0x66, 0x28,
  0x03, 0x94, 0x4c, 0x04, 0x14, 0x11, 0x3c, 0x1d, 0x5e, 0xb0, 0x9c, 0x08,
  0xb9, 0xd6, 0x44, 0x99, 0x6f, 0x0f, 0xcf, 0xbf, 0x3c, 0x1d, 0x1e, 0x12,
  0x8b, 0x38, 0x38, 0xfc, 0xf2, 0x1d, 0xb3, 0x0f, 0xde, 0x31, 0xe7, 0xcc,
  0x2b, 0x14, 0x33, 0x16, 0x09, 0x20, 0x4e, 0xcc, 0x93, 0x44, 0xb6, 0x9e,
  0x51, 0x86, 0xc6, 0x1b, 0xa9, 0x20, 0xc8, 0xa5, 0xa2, 0x79, 0xa3, 0x53,
  0x44, 0x7a, 0x79, 0xa0, 0x06, 0x16, 0xff, 0xe6, 0x8c, 0x97, 0x5a, 0x5a,
  0x81, 0x02, 0xc3, 0xeb, 0x2c, 0x76, 0xbd, 0x78, 0x77, 0x2b, 0x6a, 0xb8,
  0x1e, 0x08, 0x5f, 0xdf, 0xc3, 0x2a, 0x79, 0x0c, 0x82, 0xca, 0x94, 0x8a,
  0xc5, 0x3b, 0xcd, 0xe4, 0x02, 0xe3, 0xdc, 0x0f, 0x1c, 0x66, 0x00, 0x4d,
  0xa7, 0xa8, 0xf7, 0xa5, 0x58, 0x7a, 0x5a, 0x55, 0xa3, 0x10, 0x82, 0x23,
  0x3e, 0x23, 0xd9, 0x00, 0x56, 0xd5, 0x1a, 0x6c, 0xa8, 0x48, 0x24, 0xcb,
  0x54, 0x2e, 0x50, 0x35, 0x53, 0x4b, 0x34, 0x85, 0x62, 0xc4, 0xad, 0xf3,
  0x91, 0xe0, 0x3c, 0x6f, 0x11, 0x78, 0x05, 0x0b, 0x55, 0x8a, 0x4f, 0x38,
  0x30, 0x1d, 0x5e, 0xf9, 0x8d, 0x41, 0x9d, 0x74, 0x6e, 0x57, 0xb3, 0x83,
  0x0b, 0x99, 0x29, 0x67, 0x04, 0xca, 0x9d, 0x1c, 0x22, 0x02, 0x84, 0xe9,
  0x2c, 0x1c, 0x34, 0xe2, 0x50, 0xa1, 0xe4, 0x3c, 0x71, 0xd0, 0x56, 0x20,
  0xc4, 0xad, 0x2e, 0x57, 0x61, 0xa6, 0x02, 0x0d, 0x35, 0xf1, 0x01, 0x9b,
  0xae, 0xae, 0x25, 0x31, 0x65, 0x6c, 0x29, 0xec, 0x1f, 0x51, 0xbd, 0xe2,
  0xa0, 0x9e, 0x41, 0x69, 0x5d, 0x2a, 0x55, 0x94, 0xf7, 0x65, 0x68, 0x25,
  0x22, 0xde, 0xb8, 0x76, 0x70, 0x78, 0xb1, 0x77, 0x74, 0x7c, 0x78, 0x10,
  0x1d, 0x9d, 0xbc, 0x39, 0x3d, 0x7f, 0xbb, 0x77, 0xa1, 0x5e, 0x92, 0x03,
  0xa7, 0x67, 0xb9, 0x02, 0x0d, 0x4e, 0x8d, 0xf5, 0x3a, 0x18, 0x68, 0x98,
  0xb6, 0xf1, 0x4a, 0x71, 0x52, 0x64, 0x1d, 0x92, 0xca, 0x22, 0xac, 0x45,
  0xea, 0x5d, 0xf1, 0x25, 0x17, 0xf8, 0x8e, 0xde, 0x74, 0x16, 0xf1, 0x81,
  0xad, 0xa7, 0x69, 0x49, 0x00, 0x3b, 0x7a, 0xb4, 0x29, 0x57, 0x27, 0x48,
  0x6e, 0x27, 0xde, 0x4f, 0x49, 0xd1, 0x00, 0x51, 0xf6, 0x8f, 0x38, 0x23,
  0x11, 0xf6, 0x03, 0xad, 0x7b, 0x7b, 0x54, 0xba, 0x3a, 0x62, 0x4c, 0x2f,
  0xdc, 0x8e, 0x03, 0x3c, 0x06, 0x09, 0xa2, 0x8a, 0x67, 0xd0, 0xa6, 0x4b,
  0x96, 0xb1, 0x9a, 0x0a, 0x12, 0x09, 0x26, 0x05, 0x10, 0x82, 0x0d, 0xd6,
  0xcc, 0x5a, 0x22, 0x67, 0xf5, 0xed, 0xdd, 0x97, 0xc9, 0xdc, 0x95, 0x94,
  0x7e, 0xa3, 0x8d, 0x78, 0x2e, 0x6a, 0xb6, 0x48, 0x45, 0x70, 0x0b, 0x9b,
  0x5a, 0x77, 0x56, 0x74, 0x92, 0x5e, 0xfa, 0x47, 0x0a, 0xdb, 0xc4, 0x6b,
  0xb1, 0xb1, 0x26, 0x35, 0xe9, 0xe6, 0x96, 0x8d, 0xed, 0xc2, 0x09, 0xbc,
  0xd0, 0x1d, 0x94, 0x64, 0xd1, 0xe3, 0xe6, 0x0f, 0x6e, 0x61, 0xa4, 0x76,
  0x40, 0x0f, 0x71, 0xfd, 0xba, 0xbe, 0x76, 0x6f, 0x15, 0xa9, 0x59, 0x48,
  0xb2, 0x2d, 0x14, 0x01, 0x0a, 0x62, 0xc0, 0x88, 0x18, 0x15, 0x24, 0x13,
  0x5e, 0x03, 0x99, 0x07, 0x08, 0xbc, 0x34, 0xc3, 0x27, 0x6b, 0x02, 0xde,
  0x56, 0xe9, 0xea, 0xc7, 0x34, 0xaa, 0xd3, 0xba, 0xda, 0x45, 0x43, 0xf7,
  0x2c, 0x56, 0x32, 0x78, 0x21, 0xf6, 0x8e, 0x43, 0xac, 0xff, 0xba, 0x01,
  0x35, 0x33, 0xcd, 0x6a, 0x83, 0x6a, 0xfd, 0x6e, 0x9a, 0x5a, 0x2b, 0x93,
  0x0a, 0x5f, 0xac, 0xba, 0xda, 0x42, 0x56, 0x6f, 0x5d, 0x63, 0xf4, 0x93,
  0xb6, 0x11, 0x28, 0x1b, 0x47, 0x65, 0x41, 0xa2, 0x2a, 0x86, 0xa1, 0x8e,
  0xe1, 0x72, 0xe2, 0x14, 0xfb, 0x35, 0x05, 0x21, 0x54, 0x56, 0x09, 0xf3,
  0x5f, 0x98, 0x3b, 0x39, 0xe6, 0xf2, 0x37, 0x5c, 0xd0, 0x47, 0x4b, 0x5d,
  0x05, 0x81, 0xce, 0xd1, 0x5b, 0xb8, 0x53, 0xb4, 0x38, 0x33, 0x73, 0xbd,
  0xf9, 0x9a, 0x01, 0xc1, 0xd9, 0x4b, 0x63, 0x15, 0x44, 0xc1, 0xfe, 0x25,
  0x8b, 0x16, 0x5c, 0x9e, 0xfd, 0x71, 0x5c, 0x08, 0x1a, 0xb6, 0x04, 0xd6,
  0x89, 0xe5, 0xd2, 0x00, 0x09, 0x60, 0xae, 0xce, 0xf4, 0x86, 0xdb, 0xc7,
  0x97, 0x33, 0xed, 0x0b, 0xd8, 0x40, 0xcc, 0x29, 0x4f, 0x76, 0x28, 0x24,
  0xf2, 0xca, 0xb5, 0x82, 0xcb, 0x8e, 0xb3, 0x7b, 0xf3, 0x29, 0xc2, 0x68,
  0x34, 0xa4, 0xeb, 0x2c, 0x2b, 0xe4, 0xbc, 0x41, 0xda, 0xee, 0x08, 0x9a,
  0x3d, 0x93, 0x41, 0x67, 0x71, 0x4d, 0x7d, 0x74, 0xa2, 0x2b, 0xd6, 0x57,
  0x46, 0x34, 0xf4, 0x06, 0x07, 0x9d, 0xc8, 0xe3, 0xaf, 0xcf, 0xe3, 0xcb,
  0x38, 0x99, 0x7e, 0xbc, 0xb3, 0x35, 0x8c, 0xaf, 0x96, 0xd3, 0xf8, 0x8f,
  0x78, 0xf1, 0xf5, 0xb3, 0x67, 0x3b, 0x5b, 0x9f, 0x7e, 0xb6, 0xd5, 0x09,
  0x7c, 0x1d, 0x35, 0x47, 0x29, 0xfc, 0x5e, 0xa8, 0x14, 0xcb, 0x8c, 0x17,
  0xfd, 0x0c, 0xc6, 0x57, 0x29, 0x77, 0xf3, 0x35, 0x4b, 0x2f, 0xba, 0x06,
  0x31, 0xdc, 0xfa, 0xc2, 0x27, 0xa5, 0xd6, 0x0d, 0x27, 0x3c, 0x13, 0x5d,
  0x7f, 0xb4, 0xbd, 0x2b, 0xac, 0xec, 0x0a, 0xb6, 0x95, 0x58, 0x28, 0x36,
  0x7a, 0x95, 0xce, 0xe9, 0x0a, 0xfa, 0x3c, 0x2a, 0xe3, 0x2b, 0x47, 0xab,
  0x68, 0xc1, 0x15, 0x91, 0x35, 0x6b, 0xee, 0x25, 0x13, 0x79, 0xca, 0x75,
  0xb3, 0x2f, 0x04, 0x2c, 0x0a, 0x92, 0xcf, 0x22, 0xc9, 0xa7, 0x92, 0xa3,
  0x18, 0xcf, 0x2c, 0x1e, 0x90, 0xdf, 0x67, 0x6f, 0xf2, 0x60, 0x31, 0x75,
  0x25, 0x73, 0xa1, 0x85, 0xa5, 0x9e, 0xe0, 0xa6, 0x8b, 0xc2, 0x57, 0x7e,
  0x91, 0xfb, 0x46, 0x40, 0xb4, 0x00, 0x43, 0x15, 0xd3, 0x62, 0x01, 0xd5,
  0xbe, 0x83, 0x59, 0xf5, 0x5c, 0x01, 0x89, 0xfe, 0xc4, 0x66, 0x3a, 0xc0,
  0xef, 0x28, 0x94, 0xa5, 0xf5, 0x3c, 0x3b, 0x0b, 0x49, 0x5e, 0x71, 0x75,
  0x0b, 0x34, 0x07, 0xb4, 0x32, 0xaf, 0xd8, 0x87, 0x6b, 0x44, 0xaf, 0x4c,
  0xd1, 0xdd, 0xfe, 0xfc, 0x35, 0x08, 0x62, 0xfb, 0xf3, 0x3f, 0xba, 0xcf,
  0x76, 0xf4, 0xb3, 0x9d, 0xcf, 0xff, 0x38, 0x18, 0x60, 0x7c, 0x4c, 0x21,
  0x5d, 0xfb, 0xba, 0xab, 0x19, 0x71, 0xb1, 0x1e, 0x61, 0xf9, 0xcb, 0xe1,
  0xa5, 0xc8, 0x5e, 0x77, 0xac, 0xe7, 0x70, 0x95, 0x7b, 0x6a, 0x3f, 0x76,
  0x7c, 0x2b, 0x35, 0xf4, 0x55, 0xc0, 0x18, 0x16, 0x6d, 0x8b, 0xee, 0xcc,
  0x5c, 0x68, 0xa7, 0x70, 0x40, 0x13, 0x71, 0xf4, 0x27, 0xa6, 0xd4, 0x3f,
  0xad, 0x45, 0x6a, 0xe6, 0xe5, 0xed, 0x40, 0xc5, 0xb4, 0xc8, 0xc8, 0x56,
  0x6a, 0x3d, 0x0b, 0xd2, 0x15, 0xb7, 0xcc, 0x01, 0x80, 0x7c, 0x09, 0x06,
  0xb8, 0xfd, 0x7f, 0x56, 0xa0, 0x16, 0xd9, 0x70, 0xe6, 0x67, 0x08, 0xb5,
  0x97, 0x94, 0x15, 0x41, 0xe8, 0xd7, 0xcd, 0xfa, 0xf8, 0xfb, 0xef, 0x55,
  0x9e, 0xa2, 0x5f, 0x74, 0xdc, 0xd7, 0xc4, 0x89, 0x26, 0xc4, 0xdc, 0x66,
  0xc0, 0x86, 0xd7, 0x6a, 0x0b, 0x7a, 0xe3, 0x5f, 0xea, 0x3c, 0xa5, 0x11,
  0xda, 0x58, 0x29, 0x21, 0xca, 0x23, 0xc3, 0x92, 0x1e, 0x0a, 0x13, 0x03,
  0x65, 0xae, 0xc3, 0x9d, 0xe5, 0x63, 0x05, 0x42, 0xc2, 0xe7, 0x9d, 0xc3,
  0xa6, 0x83, 0xf6, 0xa9, 0x31, 0x53, 0x85, 0x75, 0x23, 0x41, 0xb1, 0x22,
  0xe4, 0xbc, 0xee, 0xc8, 0x83, 0x57, 0x69, 0x47, 0x8d, 0x94, 0xf2, 0x49,
  0xc7, 0x27, 0x38, 0xca, 0x6e, 0x60, 0xcb, 0x5e, 0x8b, 0xe4, 0x94, 0xfe,
  0x92, 0xbc, 0xde, 0xde, 0x6a, 0x7f, 0x82, 0xd5, 0x21, 0x14, 0x5f, 0x7f,
  0xed, 0x8d, 0xbc, 0x8f, 0x3d, 0x9f, 0x4e, 0xe4, 0x69, 0xad, 0x77, 0x86,
  0xa2, 0x11, 0xaf, 0x3b, 0x23, 0xbe, 0x5f, 0xf9, 0xff, 0x57, 0x8c, 0x03,
  0x01, 0x4b, 0xfa, 0x6c, 0xb1, 0x1c, 0xcd, 0xd2, 0xca, 0x80, 0x37, 0x79,
  0x82, 0x9f, 0xc3, 0xac, 0x92, 0x38, 0xda, 0x40, 0x39, 0x4c, 0x11, 0xfd,
  0xba, 0x97, 0x59, 0x36, 0x8a, 0xf3, 0xae, 0x1a, 0x02, 0x6d, 0x9c, 0xdd,
  0xed, 0x9d, 0x67, 0xcf, 0x5f, 0x74, 0x07, 0x2a, 0xa6, 0x81, 0x41, 0x40,
  0x33, 0x4b, 0x55, 0x97, 0x91, 0x26, 0x62, 0x39, 0x9e, 0x61, 0x59, 0xeb,
  0x56, 0x83, 0x39, 0xf3, 0x30, 0xee, 0xee, 0xb5, 0xf4, 0xf6, 0x47, 0xee,
  0xe7, 0x35, 0xba, 0xf8, 0x63, 0x3a, 0x79, 0xed, 0x66, 0xf8, 0x47, 0x9e,
  0xcb, 0x6b, 0x9d, 0x04, 0xed, 0xab, 0x45, 0x79, 0x17, 0x1b, 0x6b, 0xad,
  0x5c, 0xad, 0x75, 0x73, 0x6d, 0x13, 0xd7, 0x30, 0x69, 0x78, 0x6b, 0xfa,
  0x13, 0xb1, 0x3e, 0x42, 0x58, 0xf5, 0x51, 0xce, 0x9b, 0xf7, 0x7d, 0x6a,
  0xa5, 0xcf, 0xad, 0xf4, 0x3d, 0xbb, 0x8e, 0x66, 0x9c, 0xd2, 0xc0, 0x1b,
  0xd1, 0xd3, 0x50, 0xf7, 0x29, 0xec, 0x1d, 0x2a, 0x08, 0x64, 0x19, 0x7c,
  0x21, 0xfb, 0x5f, 0x1d, 0x75, 0xd5, 0xc9, 0x28, 0x9a, 0x5b, 0xaf, 0xcd,
  0xc0, 0xe6, 0xdc, 0xfe, 0x9a, 0x3a, 0xbe, 0x66, 0x49, 0xe8, 0x31, 0xfb,
  0xcc, 0xb8, 0x5f, 0xc9, 0x4a, 0xa1, 0xce, 0xf4, 0xce, 0xa1, 0x6b, 0x11,
  0xd0, 0x33, 0x8c, 0x48, 0x1a, 0x34, 0x03, 0x2c, 0x0e, 0x71, 0x9e, 0xc1,
  0xda, 0xea, 0x21, 0x4e, 0xfb, 0x6f, 0x9c, 0x45, 0xdb, 0x85, 0x50, 0xeb,
  0xa3, 0xf4, 0x95, 0x70, 0x13, 0x63, 0x10, 0x1d, 0x57, 0x52, 0x47, 0x28,
  0x21, 0xe4, 0x1d, 0xb0, 0xc7, 0x8f, 0x92, 0x4a, 0xad, 0x16, 0x11, 0x0b,
  0x99, 0x7b, 0xbe, 0x72, 0x35, 0x58, 0x3e, 0x8f, 0x00, 0x62, 0x2e, 0x6f,
  0x69, 0x90, 0x74, 0xa5, 0xf4, 0x24, 0x5e, 0x52, 0xed, 0xc0, 0x59, 0xef,
  0x03, 0xcf, 0xa3, 0x8a, 0x05, 0xd2, 0x82, 0x4c, 0x74, 0xf4, 0xa0, 0xfa,
  0x3f, 0xb7, 0xd0, 0xfd, 0x0b, 0x0e, 0xc1, 0x2b, 0xde, 0x06, 0x7c, 0xfd,
  0x79, 0x57, 0xcc, 0x78, 0x95, 0x62, 0xee, 0x35, 0xef, 0x80, 0x10, 0x68,
  0x38, 0x9f, 0xec, 0xd2, 0x81, 0x70, 0x88, 0x2c, 0xc6, 0x19, 0x90, 0x28,
  0x5a, 0x42, 0xb2, 0xd4, 0x94, 0xd3, 0x9f, 0x58, 0xac, 0x54, 0x59, 0xa8,
  0xa7, 0x8d, 0x27, 0x1c, 0x04, 0xc7, 0xb2, 0x63, 0x97, 0x23, 0x48, 0xf0,
  0x5e, 0xd7, 0x61, 0x7a, 0xb0, 0x48, 0x9d, 0x80, 0xdd, 0xe5, 0x89, 0x15,
  0x51, 0x5a, 0x53, 0x10, 0x09, 0x2f, 0xcb, 0x87, 0x13, 0x2b, 0x02, 0xd1,
  0xc1, 0x07, 0x92, 0x4b, 0x82, 0x6c, 0xe3, 0x88, 0xbc, 0xe1, 0x2c, 0x0d,
  0xed, 0xf4, 0x35, 0x2f, 0xf7, 0xf6, 0xe0, 0x2a, 0xbd, 0x94, 0xc5, 0x20,
  0x16, 0x79, 0x95, 0x6c, 0xd2, 0x9f, 0x5c, 0xea, 0x7c, 0x87, 0x65, 0x32,
  0xfe, 0xe5, 0x19, 0x7c, 0xcf, 0xe1, 0xcd, 0x1f, 0x9c, 0x0d, 0x77, 0x2e,
  0xf8, 0x97, 0xd4, 0xdd, 0xf8, 0x8a, 0x37, 0xa9, 0xa3, 0x04, 0x99, 0x2b,
  0xde, 0x60, 0x00, 0x37, 0x19, 0x14, 0x4e, 0x62, 0x3d, 0x8b, 0x35, 0xd2,
  0x25, 0x07, 0x3e, 0xba, 0x38, 0x2d, 0x75, 0x8e, 0xa9, 0x98, 0xce, 0x52,
  0x77, 0xaa, 0x16, 0x13, 0x8e, 0x11, 0xc5, 0xbd, 0x9a, 0xdc, 0x6d, 0xf4,
  0xc2, 0xe8, 0x17, 0x2b, 0x04, 0xe8, 0x2a, 0x95, 0x22, 0x1f, 0x94, 0xbb,
  0x5f, 0xd7, 0x6a, 0x3d, 0x41, 0x2a, 0x07, 0xb6, 0x39, 0xad, 0xef, 0x60,
  0xb5, 0xe2, 0x8d, 0x04, 0x2d, 0xa4, 0x45, 0xb9, 0x81, 0x42, 0xee, 0xd3,
  0x02, 0xaa, 0x3a, 0x0f, 0x7a, 0x2d, 0x0a, 0xd6, 0xdd, 0xb0, 0x0d, 0xd0,
  0x55, 0x97, 0xeb, 0xef, 0x6c, 0xc2, 0xa7, 0x21, 0xbc, 0xed, 0x70, 0x26,
  0x10, 0xd7, 0x20, 0xdb, 0x69, 0x5f, 0xee, 0x4b, 0x15, 0x82, 0xfa, 0x6f,
  0x06, 0xd1, 0x31, 0x62, 0xb7, 0x8a, 0x58, 0xd2, 0x5e, 0xed, 0x4e, 0x35,
  0x0a, 0x20, 0x72, 0x11, 0xa9, 0x7b, 0x4d, 0x62, 0x22, 0x39, 0xd3, 0xd0,
  0xc8, 0x08, 0xf8, 0x63, 0x5e, 0xcf, 0x14, 0x89, 0x42, 0x25, 0x90, 0x1e,
  0x2c, 0xd1, 0xee, 0x39, 0x94, 0xa2, 0xc2, 0x53, 0x31, 0x82, 0x81, 0x1d,
  0x91, 0x06, 0x8d, 0xb8, 0x42, 0xe1, 0x2c, 0x72, 0x06, 0xac, 0xdc, 0x11,
  0xbe, 0x24, 0x34, 0x26, 0x62, 0x67, 0xd1, 0xaa, 0xa3, 0xe2, 0x87, 0xa1,
  0xd6, 0x40, 0x59, 0x3c, 0x77, 0x26, 0x9d, 0x0e, 0x34, 0xc5, 0x69, 0xe2,
  0xf4, 0x69, 0x45, 0x20, 0xd5, 0xb0, 0x48, 0x05, 0xb4, 0x11, 0x01, 0xc3,
  0xa3, 0xe9, 0xf1, 0x20, 0x79, 0x5c, 0xf1, 0x2d, 0xfd, 0xc2, 0x97, 0xfc,
  0x28, 0xa7, 0x9d, 0xe6, 0x50, 0x69, 0x5e, 0x19, 0xa9, 0x37, 0x1e, 0x14,
  0x62, 0xfa, 0xfa, 0xe2, 0xed, 0x71, 0x64, 0xe9, 0xc3, 0x97, 0x5e, 0x38,
  0xb4, 0xc8, 0x13, 0x4c, 0x51, 0x8d, 0x21, 0x22, 0x01, 0xe9, 0x53, 0x72,
  0xb3, 0xc9, 0xda, 0x72, 0x06, 0x52, 0xc4, 0x8b, 0x53, 0x39, 0xa6, 0xc1,
  0x13, 0xf2, 0x2a, 0xd3, 0x0e, 0x91, 0x46, 0x97, 0x97, 0xa0, 0xdb, 0x8b,
  0xba, 0x3c, 0x54, 0xfe, 0xa2, 0x8b, 0xf5, 0xc4, 0xc7, 0xc1, 0xf2, 0x75,
  0x07, 0x2d, 0x27, 0x8f, 0x9f, 0x79, 0xfd, 0x45, 0x65, 0x95, 0xf0, 0xb9,
  0x35, 0xf5, 0x5a, 0xc2, 0x3d, 0x1b, 0x52, 0xb6, 0xbd, 0x1b, 0xb4, 0xff,
  0x7a, 0x9f, 0x5a, 0x91, 0x42, 0x4f, 0xb2, 0x27, 0x10, 0xa8, 0xdd, 0x67,
  0x29, 0xf2, 0x24, 0x1a, 0x0d, 0x3d, 0x7d, 0x72, 0x2f, 0x8c, 0xfd, 0xb8,
  0x10, 0x17, 0xe1, 0x68, 0x42, 0x02, 0xc6, 0x6d, 0x69, 0x37, 0x53, 0xd1,
  0xf4, 0xee, 0x32, 0xd8, 0x15, 0xc0, 0x67, 0xb6, 0x07, 0x88, 0xa1, 0xf7,
  0x08, 0x28, 0xae, 0x01, 0xa7, 0xae, 0x77, 0xb0, 0xa0, 0x1d, 0xb3, 0x93,
  0x38, 0x25, 0xde, 0x56, 0xb9, 0x69, 0x02, 0xa6, 0xa9, 0x2f, 0xd2, 0x31,
  0x4a, 0x37, 0xbe, 0xfe, 0x62, 0x92, 0x5d, 0x31, 0xbb, 0xea, 0xd1, 0xcd,
  0xca, 0x3f, 0x3b, 0x11, 0x1e, 0xdf, 0xd1, 0x7e, 0x65, 0xcc, 0x38, 0x2e,
  0x22, 0xba, 0xdb, 0xdf, 0x1a, 0x85, 0x13, 0xb5, 0x6c, 0xc9, 0x24, 0x1b,
  0x6b, 0xf3, 0xae, 0x75, 0xd9, 0x13, 0xea, 0xc2, 0x7d, 0xe1, 0xbb, 0x0b,
  0x56, 0x28, 0xd6, 0xb6, 0xa5, 0xea, 0xd6, 0x34, 0x2d, 0xe5, 0x0e, 0x77,
  0x68, 0xd2, 0x30, 0x6c, 0x31, 0x6a, 0xbe, 0x5c, 0x58, 0x53, 0x0d, 0xfa,
  0xee, 0x7e, 0xd1, 0x95, 0x80, 0xbd, 0xee, 0xab, 0x2e, 0x58, 0x17, 0x33,
  0x24, 0xc3, 0x12, 0xd5, 0x5b, 0xa9, 0x2b, 0xd7, 0x61, 0x5f, 0x84, 0x06,
  0xad, 0x89, 0x56, 0x09, 0xb3, 0x60, 0xae, 0x61, 0xda, 0x63, 0x18, 0x21,
  0x02, 0xeb, 0x00, 0x40, 0x8d, 0x31, 0x2a, 0xc6, 0x8f, 0x19, 0x95, 0xe2,
  0x5b, 0xd5, 0xdb, 0x16, 0xf2, 0x18, 0x52, 0x51, 0x0b, 0xf6, 0x1c, 0x8a,
  0x79, 0x73, 0x39, 0x5f, 0x70, 0xe2, 0xd1, 0x18, 0xc5, 0x42, 0xf5, 0x40,
  0x0d, 0xa2, 0x77, 0x73, 0x41, 0x2c, 0x4b, 0x58, 0x47, 0x0e, 0x1d, 0xbf,
  0x3d, 0xe7, 0xc0, 0xa6, 0x95, 0x0a, 0x4e, 0x6f, 0x75, 0xc0, 0x62, 0x13,
  0x11, 0xe3, 0xb5, 0xf6, 0xcb, 0xf7, 0x6b, 0xce, 0x6e, 0x75, 0x35, 0x4e,
  0x43, 0x1c, 0x70, 0x29, 0xa9, 0xca, 0x85, 0xd8, 0x4d, 0x77, 0xf8, 0xe6,
  0xf0, 0xfc, 0xfc, 0xf0, 0x9c, 0xd7, 0x7b, 0xaf, 0x8a, 0xda, 0x7d, 0xad,
  0xf1, 0xbd, 0x1e, 0x54, 0xcb, 0x42, 0x9b, 0x9a, 0xd5, 0x5a, 0x85, 0x1d,
  0x2a, 0x0a, 0xce, 0x5a, 0x64, 0x0e, 0x5b, 0xc9, 0xc3, 0x16, 0xb3, 0x30,
  0x6c, 0x8a, 0x08, 0x6c, 0x73, 0xf6, 0xfb, 0x29, 0xdf, 0x2d, 0x02, 0xbe,
  0x1d, 0x4a, 0x14, 0x6b, 0x91, 0xbd, 0x9a, 0x6b, 0x45, 0x05, 0xdc, 0xd7,
  0xa6, 0x40, 0x06, 0xc2, 0xe9, 0x40, 0x63, 0x91, 0x12, 0x75, 0xc3, 0x4e,
  0x9d, 0x4d, 0x02, 0xf3, 0xbd, 0xe4, 0x53, 0xca, 0xfa, 0x12, 0x56, 0xa2,
  0x28, 0x97, 0x8b, 0x74, 0xe2, 0x4c, 0xbc, 0xf4, 0x39, 0x09, 0x7d, 0x91,
  0x9c, 0xf3, 0xc2, 0x46, 0x0c, 0xaf, 0xa2, 0x19, 0x20, 0x42, 0x0b, 0x9b,
  0x24, 0x3e, 0x7b, 0xfb, 0x18, 0x62, 0xd5, 0xa5, 0x18, 0x9f, 0xe2, 0x05,
  0x83, 0xc5, 0x36, 0x98, 0x51, 0x02, 0xd3, 0x22, 0xf3, 0x0b, 0x73, 0x7a,
  0x87, 0xbc, 0x81, 0xed, 0x57, 0x33, 0x1f, 0xd1, 0xe7, 0x8b, 0xa4, 0x9d,
  0x23, 0xdd, 0x20, 0xdf, 0x8d, 0x7e, 0x2c, 0xd2, 0xf1, 0xcf, 0xfe, 0xfa,
  0x40, 0x20, 0xae, 0x0f, 0xba, 0x13, 0x27, 0x39, 0x4d, 0x5e, 0x17, 0x4a,
  0x15, 0x60, 0x52, 0xfb, 0x06, 0x1c, 0xc3, 0x76, 0x78, 0x1e, 0xed, 0x7d,
  0xc5, 0xc0, 0x3c, 0xff, 0xde, 0xee, 0xf2, 0x73, 0x7a, 0x3d, 0xd8, 0xde,
  0x6a, 0xd2, 0x68, 0x62, 0xe6, 0x6f, 0x45, 0x8b, 0x0f, 0x37, 0x36, 0xb5,
  0x7a, 0x18, 0xfe, 0x8e, 0xaf, 0x6e, 0xe1, 0x5a, 0xf4, 0xe4, 0x26, 0x7e,
  0xc8, 0x16, 0xf2, 0x01, 0x0b, 0x37, 0x51, 0xb2, 0xcd, 0xc5, 0x0d, 0x61,
  0x5b, 0xa3, 0xa3, 0x2f, 0x1a, 0xba, 0xa6, 0x6c, 0xd2, 0x5e, 0xd4, 0x7d,
  0x9b, 0xfd, 0x42, 0xd2, 0x40, 0xbc, 0xf9, 0x6c, 0xb0, 0x15, 0xad, 0x7f,
  0x97, 0xce, 0x5f, 0xbe, 0xf8, 0x4b, 0x74, 0xb4, 0xd1, 0xad, 0x44, 0x2b,
  0x0a, 0x9e, 0xed, 0x28, 0x9e, 0xdf, 0xb8, 0x1d, 0x3b, 0xc5, 0xa9, 0x96,
  0x18, 0x0c, 0xc3, 0x71, 0xdc, 0x05, 0x09, 0xac, 0x6c, 0x11, 0xa9, 0x32,
  0x1a, 0xf8, 0x18, 0x7d, 0xeb, 0x90, 0xc4, 0x58, 0xb1, 0xa7, 0xa7, 0x26,
  0xbc, 0x74, 0x2f, 0x5f, 0x34, 0x9a, 0x78, 0xee, 0xda, 0x78, 0x27, 0x6d,
  0xfc, 0xca, 0x26, 0x76, 0x06, 0x5b, 0x3b, 0xd1, 0xfa, 0xe9, 0x70, 0x73,
  0xc7, 0xb5, 0xd0, 0x6c, 0x62, 0x07, 0x4d, 0xf0, 0x43, 0xd5, 0x97, 0x9f,
  0x73, 0xff, 0x3f, 0x26, 0xf3, 0x9f, 0xa3, 0xf5, 0xef, 0xb7, 0xb7, 0xa9,
  0x81, 0xbf, 0x44, 0x7b, 0x47, 0xdf, 0x47, 0xcf, 0x07, 0xd4, 0xd8, 0x49,
  0x7c, 0xab, 0xcd, 0x29, 0xca, 0xd0, 0x10, 0x8d, 0xd0, 0xf7, 0x8d, 0x36,
  0x5e, 0xd4, 0xda, 0x38, 0x26, 0x65, 0xf0, 0x9e, 0x2e, 0x95, 0xad, 0xc1,
  0xb3, 0x9d, 0x28, 0x7d, 0xf1, 0xd9, 0x27, 0xd6, 0x90, 0xb6, 0x81, 0xef,
  0xab, 0x06, 0x4a, 0xc9, 0x43, 0x25, 0x59, 0xe7, 0xf0, 0x9e, 0x98, 0x19,
  0x38, 0x04, 0x90, 0x2f, 0xaf, 0xe3, 0x7c, 0xa2, 0xe4, 0xc6, 0x85, 0x23,
  0x68, 0xa7, 0xc4, 0x88, 0xcd, 0xde, 0x08, 0x12, 0x79, 0xe9, 0xe6, 0xdc,
  0x6d, 0x0c, 0x87, 0x15, 0x52, 0x7b, 0xf4, 0x2f, 0xd1, 0xdb, 0xe1, 0xd1,
  0x21, 0xcd, 0x68, 0x8b, 0x86, 0xe6, 0xd7, 0x50, 0x06, 0x84, 0xaf, 0xb0,
  0xb8, 0xb4, 0xaa, 0x6b, 0x8c, 0x8d, 0x82, 0x36, 0x4c, 0xd0, 0x96, 0xd0,
  0x24, 0x46, 0xdc, 0xcb, 0x8a, 0x02, 0xfd, 0x72, 0xce, 0x59, 0x7f, 0xef,
  0x8a, 0xf5, 0x06, 0xbd, 0x6b, 0xb9, 0xeb, 0x6f, 0xb2, 0x39, 0x1d, 0x93,
  0x3c, 0xcb, 0x37, 0xb7, 0x07, 0x5b, 0xdd, 0x8a, 0xb8, 0xf0, 0xcd, 0xc1,
  0xa1, 0x24, 0x5a, 0xbd, 0x8d, 0xe7, 0xc4, 0x22, 0x19, 0x76, 0xa0, 0xb8,
  0x61, 0xf7, 0xbb, 0xb8, 0x70, 0xe4, 0xfd, 0xe3, 0x87, 0xf9, 0x3d, 0xed,
  0xe3, 0xa7, 0x83, 0x6d, 0x06, 0x24, 0x63, 0x55, 0xf7, 0xcd, 0x5b, 0xfa,
  0x7b, 0xfb, 0x79, 0x37, 0xe2, 0xaf, 0xaa, 0x6a, 0xbb, 0x9d, 0xd7, 0xb5,
  0xfd, 0xd3, 0xd3, 0x6f, 0x8e, 0x24, 0x12, 0x63, 0x5f, 0x2d, 0xa9, 0x2c,
  0x5d, 0x39, 0x55, 0x58, 0x98, 0x2b, 0xa9, 0x6c, 0x3e, 0x10, 0x1a, 0x0e,
  0xb8, 0x9b, 0x24, 0x59, 0x00, 0x41, 0xac, 0xc6, 0x11, 0x4a, 0x65, 0xd1,
  0x32, 0x32, 0x96, 0xa6, 0xd3, 0x49, 0x15, 0x32, 0x81, 0x71, 0xe6, 0x9d,
  0xd5, 0x76, 0xf4, 0xe0, 0x12, 0x36, 0x63, 0x5f, 0xd6, 0x4e, 0xeb, 0x73,
  0x6b, 0x53, 0x66, 0x75, 0x96, 0xe2, 0xd6, 0xf4, 0xa2, 0x2a, 0xbc, 0xdd,
  0x61, 0x52, 0xf6, 0x65, 0xd0, 0xbb, 0x6a, 0xa8, 0xed, 0xaa, 0xd5, 0xc9,
  0xd9, 0xcc, 0x16, 0x0a, 0x27, 0x0a, 0x6b, 0xf1, 0xc3, 0x82, 0xcb, 0xef,
  0xd1, 0x9c, 0x94, 0x35, 0xa3, 0xc0, 0x64, 0x82, 0xf8, 0xb1, 0x93, 0xbd,
  0xb7, 0x87, 0xaf, 0xbf, 0xdd, 0x3b, 0x7e, 0x77, 0x48, 0xaf, 0x30, 0xa0,
  0xe6, 0xba, 0x87, 0xbf, 0xc2, 0x18, 0x67, 0xe9, 0x38, 0x9b, 0xb2, 0x67,
  0xa9, 0xfb, 0x97, 0xee, 0x9a, 0xc4, 0x09, 0x46, 0x1d, 0x7e, 0x6b, 0x5b,
  0x5e, 0x23, 0xba, 0xe0, 0xbf, 0x76, 0xe4, 0xaf, 0x9d, 0xbf, 0x74, 0x36,
  0x2a, 0x93, 0x6e, 0xa8, 0xc6, 0x4c, 0x2f, 0x77, 0x12, 0x20, 0x86, 0xda,
  0x10, 0x08, 0x4e, 0x95, 0x55, 0xe9, 0x98, 0x5b, 0xc6, 0xae, 0x36, 0x7e,
  0x76, 0x7d, 0xf4, 0x10, 0x2a, 0xde, 0x1d, 0x7e, 0xe9, 0x35, 0x84, 0x8b,
  0x0e, 0x67, 0xee, 0xa8, 0xb8, 0x01, 0x97, 0x35, 0xb7, 0x61, 0x4d, 0x24,
  0xf7, 0x0b, 0x8e, 0x43, 0x5a, 0xef, 0xc8, 0x2f, 0xaf, 0x0f, 0xf6, 0x2e,
  0x0e, 0xf9, 0x05, 0xeb, 0xde, 0xaa, 0xf5, 0x5a, 0x08, 0x29, 0x8f, 0x67,
  0xbd, 0x23, 0x1f, 0xbe, 0xe6, 0x09, 0x75, 0x04, 0x65, 0x5d, 0xa0, 0xf1,
  0x6a, 0xe3, 0xca, 0xe6, 0x1a, 0x8d, 0x17, 0xa4, 0x9a, 0x15, 0x16, 0x30,
  0xb2, 0xde, 0x91, 0xef, 0x3a, 0xce, 0x68, 0xab, 0xc5, 0x28, 0xd5, 0x45,
  0x39, 0x41, 0x80, 0x69, 0x23, 0xc9, 0x45, 0xea, 0xc1, 0xf8, 0xfd, 0x51,
  0xff, 0x84, 0x98, 0x99, 0x02, 0xc4, 0x33, 0xb7, 0xf1, 0x9a, 0x18, 0xc7,
  0x86, 0xa5, 0x2c, 0xdb, 0xde, 0x79, 0xf6, 0x17, 0xac, 0xe7, 0xeb, 0xce,
  0x26, 0xdd, 0x0d, 0x9d, 0xbf, 0x70, 0xd7, 0x69, 0x19, 0x14, 0x99, 0xd0,
  0x6e, 0x58, 0xa1, 0x52, 0x8a, 0x92, 0x68, 0x15, 0xde, 0x75, 0x18, 0xc4,
  0x64, 0x5e, 0x58, 0xd0, 0x3b, 0x09, 0x83, 0xb7, 0x24, 0x68, 0x73, 0xe2,
  0x63, 0xbf, 0x50, 0x04, 0x6d, 0xee, 0x20, 0x1d, 0xa5, 0xbb, 0xf0, 0xfe,
  0xe8, 0xc9, 0xbb, 0x32, 0x47, 0x2d, 0x7d, 0xc1, 0x7d, 0xce, 0x1e, 0x2c,
  0x52, 0x1e, 0x7d, 0x41, 0x28, 0x97, 0x3d, 0x6b, 0xd8, 0x08, 0x46, 0x6a,
  0xd0, 0x31, 0x6d, 0x04, 0x22, 0x01, 0xb1, 0x96, 0x07, 0xc8, 0x49, 0xe2,
  0xf5, 0x0f, 0x82, 0x1d, 0xec, 0xce, 0x8e, 0x47, 0x9c, 0xef, 0xe5, 0xc2,
  0x82, 0x03, 0x55, 0xdc, 0x2d, 0xbd, 0x1d, 0xbf, 0x34, 0x48, 0x79, 0xe7,
  0x8b, 0x52, 0xd6, 0xb2, 0x70, 0x86, 0x23, 0x38, 0x18, 0xf5, 0xd9, 0xea,
  0x3e, 0xd5, 0x02, 0xee, 0x31, 0x0d, 0xd1, 0xe3, 0x45, 0x41, 0x26, 0x56,
  0x33, 0x4f, 0xf2, 0x47, 0x03, 0x1d, 0x5a, 0xfc, 0x4f, 0x98, 0x62, 0x90,
  0xaf, 0xc1, 0xef, 0x0c, 0x06, 0x03, 0x5f, 0x02, 0x81, 0xb7, 0x45, 0xdd,
  0x4e, 0x00, 0x83, 0x0e, 0x70, 0xb9, 0xb0, 0xc6, 0xeb, 0x10, 0xe4, 0x21,
  0x4c, 0x6f, 0x68, 0xd4, 0x8b, 0x9a, 0x24, 0xdc, 0xd1, 0x08, 0x0c, 0x1b,
  0x5d, 0xed, 0xb6, 0x6b, 0xf8, 0xf0, 0x37, 0x6d, 0x9b, 0xf0, 0xc8, 0xd8,
  0xc4, 0xe0, 0x58, 0xc4, 0x48, 0x20, 0x77, 0x7c, 0x2a, 0x73, 0x6b, 0xc1,
  0x14, 0xcc, 0x49, 0xe5, 0x52, 0xd5, 0x11, 0x5b, 0x22, 0x8b, 0xa6, 0x43,
  0xe9, 0x49, 0xbc, 0x01, 0x33, 0xb9, 0xec, 0x0e, 0xf9, 0x88, 0x52, 0xf8,
  0x7c, 0x91, 0xb3, 0xaa, 0x87, 0xe2, 0x78, 0x99, 0x05, 0x6d, 0x9b, 0xb8,
  0xac, 0xed, 0x4c, 0xc4, 0x3e, 0xcb, 0x4a, 0x33, 0xe4, 0x7e, 0x4d, 0xe3,
  0x50, 0xa4, 0xdd, 0x22, 0x56, 0xf4, 0x26, 0x12, 0xdb, 0xb2, 0x19, 0x3c,
  0x5d, 0x3a, 0x79, 0x6f, 0x2b, 0xe1, 0x60, 0xaf, 0xbe, 0x64, 0xf9, 0x5a,
  0xa6, 0x85, 0x71, 0x0f, 0x4d, 0xf9, 0x7c, 0xcc, 0x47, 0x3e, 0xb6, 0x16,
  0x9d, 0x83, 0xbc, 0xb6, 0x36, 0xfe, 0x56, 0xae, 0xb2, 0x2e, 0x5a, 0x51,
  0x31, 0x29, 0x43, 0x50, 0x0e, 0xf8, 0x5e, 0x14, 0xdf, 0x71, 0x25, 0x0e,
  0xa2, 0x41, 0xf1, 0x95, 0x89, 0x59, 0xe6, 0x38, 0x30, 0x2e, 0xba, 0x19,
  0x5a, 0x09, 0x5b, 0x89, 0x2d, 0x92, 0x22, 0xb5, 0x0a, 0xe5, 0x29, 0x30,
  0x64, 0x66, 0xc5, 0x4b, 0x51, 0x54, 0x81, 0x61, 0xa3, 0x54, 0x50, 0x37,
  0xfd, 0x9c, 0x47, 0x4e, 0x2c, 0x7a, 0xa8, 0x74, 0x93, 0x22, 0x2c, 0x90,
  0x0d, 0x1d, 0x12, 0x4b, 0x61, 0xab, 0x25, 0xf5, 0x8b, 0xad, 0x13, 0xe7,
  0x92, 0x86, 0xcd, 0x29, 0x41, 0x4d, 0xe5, 0x79, 0xdf, 0xe5, 0x98, 0xba,
  0xc0, 0xab, 0x3c, 0xbd, 0xba, 0x12, 0x8d, 0x2d, 0xaa, 0x4f, 0xad, 0x9d,
  0xc8, 0x8e, 0x79, 0x55, 0x92, 0xd9, 0xa2, 0x7c, 0x58, 0xb5, 0x9a, 0x17,
  0xae, 0x32, 0xa3, 0x9a, 0x5d, 0x2a, 0xc4, 0x6c, 0x6e, 0x48, 0xd9, 0x37,
  0xc0, 0x3b, 0x49, 0xb2, 0x20, 0xdb, 0xbe, 0xaa, 0x6e, 0xe3, 0xd3, 0x73,
  0x66, 0x62, 0x85, 0xdb, 0xf2, 0x6e, 0xe1, 0x36, 0x1d, 0xb0, 0x27, 0x3e,
  0xea, 0x64, 0xc2, 0xc6, 0xe5, 0x19, 0x5f, 0xc5, 0x77, 0x2e, 0xe4, 0x49,
  0xf0, 0x51, 0x47, 0xb1, 0xd7, 0xb8, 0xd6, 0xa2, 0x8a, 0x89, 0xb7, 0x40,
  0x25, 0x5e, 0xe5, 0x43, 0xd9, 0x6d, 0xe2, 0x91, 0x77, 0xbc, 0x95, 0xd1,
  0xc3, 0xa5, 0xe9, 0xe9, 0x77, 0xcc, 0xa4, 0xe6, 0xd3, 0x75, 0xfc, 0x0a,
  0x93, 0xac, 0xad, 0xca, 0x20, 0x0a, 0x9a, 0x14, 0x5b, 0x49, 0x16, 0xb2,
  0x78, 0x19, 0x9b, 0xba, 0xaa, 0xad, 0x45, 0x0d, 0x4a, 0x07, 0x54, 0x7a,
  0xa0, 0x9a, 0xf0, 0x82, 0xa4, 0xa5, 0x52, 0x55, 0xe1, 0x02, 0xe4, 0xbc,
  0xcb, 0xd7, 0x66, 0xd9, 0x71, 0x9b, 0xd4, 0x41, 0xee, 0xc4, 0x48, 0x89,
  0x00, 0x34, 0xc0, 0x02, 0x9d, 0xf3, 0xda, 0xef, 0x4d, 0xe3, 0x02, 0x25,
  0xd1, 0x11, 0x10, 0x80, 0x2d, 0x03, 0x51, 0xc3, 0x9a, 0x56, 0xe3, 0xa9,
  0x8d, 0xe3, 0xe7, 0x02, 0x34, 0x84, 0xd6, 0x00, 0x9c, 0xc6, 0xcd, 0x10,
  0x95, 0x20, 0x3a, 0x77, 0x6c, 0xcc, 0xfd, 0xf1, 0x24, 0xc2, 0x51, 0xe5,
  0x8c, 0x3e, 0x75, 0x64, 0xcf, 0xce, 0x4f, 0xbf, 0x3a, 0x3f, 0x1c, 0x0e,
  0xa3, 0xb7, 0x87, 0x17, 0xa2, 0xf2, 0x5f, 0x48, 0x34, 0x9c, 0xe0, 0xca,
  0xc2, 0xd7, 0x60, 0x29, 0xfe, 0x16, 0x70, 0x62, 0xf6, 0x04, 0xe0, 0x7d,
  0x66, 0xec, 0x47, 0x83, 0x28, 0x07, 0x75, 0x7e, 0xaa, 0x41, 0x74, 0xd7,
  0xb0, 0xf6, 0x23, 0xa4, 0x09, 0xee, 0x48, 0x67, 0x3c, 0xf7, 0x26, 0xd5,
  0xa0, 0xe0, 0xfa, 0xb5, 0x71, 0x2e, 0x6f, 0x42, 0xd7, 0x9a, 0xd6, 0x98,
  0xde, 0xc7, 0xd1, 0x85, 0x95, 0x1f, 0xfe, 0x98, 0xd4, 0x60, 0xa5, 0x8f,
  0x8f, 0xa3, 0xef, 0xa9, 0xcd, 0x09, 0x97, 0xe4, 0x96, 0x22, 0x73, 0x43,
  0x14, 0x97, 0xf3, 0x35, 0x28, 0x50, 0xfb, 0x30, 0xf8, 0x8f, 0xa8, 0x3c,
  0x7f, 0xa2, 0x84, 0x29, 0xd2, 0xbe, 0x05, 0x90, 0x48, 0x43, 0xea, 0x5c,
  0xcf, 0xfb, 0x28, 0x29, 0x5e, 0x46, 0xd1, 0x71, 0x72, 0x59, 0x42, 0x20,
  0xe1, 0xee, 0xa8, 0xb9, 0x2d, 0x06, 0xd8, 0xdb, 0x7e, 0xcb, 0x1f, 0x6d,
  0x45, 0xcf, 0x3e, 0xfb, 0x64, 0xeb, 0x33, 0xf9, 0xd5, 0xfe, 0x7d, 0xf9,
  0x7c, 0x4b, 0x81, 0x2a, 0xe9, 0xaf, 0xe7, 0xbb, 0xcf, 0xb7, 0x77, 0x19,
  0x40, 0x67, 0x6b, 0x77, 0x8b, 0xfe, 0xff, 0xb9, 0x7e, 0xc2, 0x28, 0x41,
  0x2f, 0x77, 0x3e, 0xfb, 0x14, 0xb1, 0x30, 0x4c, 0x1f, 0x53, 0xea, 0xa4,
  0x5f, 0x66, 0x7d, 0x00, 0x11, 0x40, 0x08, 0xfa, 0xb8, 0x6a, 0x95, 0x64,
  0xe7, 0x3a, 0x97, 0x8f, 0xe3, 0x89, 0xbb, 0x82, 0xb3, 0x66, 0x61, 0x95,
  0x6c, 0xf4, 0xb0, 0x28, 0xa6, 0x9b, 0x86, 0xbe, 0x2d, 0x75, 0x09, 0x01,
  0xe0, 0x51, 0x79, 0x87, 0x44, 0x46, 0x49, 0x06, 0x0a, 0x5f, 0xfe, 0x35,
  0x5d, 0x5b, 0xd2, 0xdc, 0x1a, 0x20, 0x40, 0x74, 0xab, 0xf4, 0x3d, 0xa9,
  0xca, 0xce, 0x55, 0x97, 0x82, 0x62, 0x8b, 0xb5, 0xd2, 0x88, 0xbf, 0xb6,
  0x3f, 0x31, 0x60, 0xf1, 0x5b, 0x4a, 0x0d, 0x51, 0xb3, 0x37, 0xab, 0x11,
  0xd9, 0xd6, 0x57, 0x85, 0x78, 0xd6, 0xfc, 0xf6, 0xfb, 0x95, 0x0a, 0x6a,
  0x29, 0x3a, 0x4c, 0x0c, 0xa9, 0x63, 0xd8, 0x32, 0xe5, 0x46, 0x73, 0xef,
  0x16, 0x61, 0x7b, 0x1f, 0xd2, 0x9c, 0x9f, 0x11, 0x28, 0xd8, 0xed, 0x5c,
  0x3f, 0xd8, 0x9c, 0x54, 0xe2, 0xda, 0x5c, 0x41, 0x44, 0x43, 0x6e, 0x72,
  0x75, 0xd4, 0xf0, 0xaa, 0x23, 0xd9, 0xbe, 0xbc, 0xa1, 0xe2, 0x67, 0x81,
  0x14, 0x17, 0x11, 0x14, 0x6e, 0x33, 0xdc, 0xf6, 0xf2, 0xbc, 0x51, 0x76,
  0xa3, 0x2b, 0xa6, 0xc6, 0xa0, 0x3f, 0xed, 0x03, 0xe7, 0xc9, 0x1d, 0xba,
  0x47, 0xa7, 0xe6, 0xa3, 0xdc, 0x5d, 0x21, 0x92, 0x75, 0x17, 0x35, 0xde,
  0x76, 0x24, 0xfd, 0x73, 0x08, 0x24, 0x0f, 0x4b, 0x13, 0xbb, 0x8b, 0x08,
  0x55, 0x68, 0x14, 0x6b, 0x97, 0xe1, 0xa0, 0x18, 0x3e, 0x75, 0xc3, 0x58,
  0x58, 0xff, 0x23, 0x17, 0xb4, 0x85, 0x7b, 0x4d, 0xb1, 0xb4, 0x63, 0xa1,
  0xfc, 0x69, 0x98, 0x1f, 0x55, 0x41, 0xd1, 0x0e, 0x61, 0x4a, 0xd7, 0xa4,
  0x5a, 0x2a, 0xdd, 0xb4, 0x74, 0x73, 0x04, 0xf5, 0x8b, 0xfe, 0xb0, 0xb6,
  0x36, 0x3c, 0x3b, 0x3c, 0x3c, 0x88, 0x8e, 0x8f, 0xde, 0x1e, 0x5d, 0x04,
  0x02, 0xb9, 0xbb, 0x48, 0xcc, 0xe0, 0x5a, 0x68, 0x14, 0x5b, 0x6d, 0x39,
  0x3c, 0x2e, 0x9e, 0xf4, 0x67, 0x57, 0xf9, 0x2c, 0xd1, 0x7c, 0x86, 0x69,
  0xfd, 0x3d, 0xa8, 0xde, 0x80, 0x5b, 0x40, 0x69, 0x04, 0x2f, 0xd0, 0x15,
  0x24, 0xdc, 0x8c, 0xb9, 0x06, 0x8f, 0x5c, 0x12, 0x3f, 0x68, 0x94, 0x46,
  0x55, 0x72, 0x52, 0x78, 0x2f, 0x57, 0x7c, 0x47, 0x43, 0x5b, 0x6b, 0xa3,
  0xe2, 0xb5, 0x4d, 0xa6, 0x5a, 0x3e, 0xd1, 0x59, 0xe8, 0x10, 0xb4, 0x77,
  0x97, 0x20, 0xb3, 0x73, 0x96, 0x0a, 0xc8, 0x70, 0x18, 0x52, 0xec, 0x0a,
  0x5e, 0x5c, 0x64, 0xc2, 0xc7, 0xc3, 0x1e, 0xc3, 0x5a, 0x44, 0x16, 0x4f,
  0x6b, 0x7d, 0x85, 0x55, 0x6e, 0x9e, 0x6d, 0xb9, 0xc4, 0x81, 0x05, 0x78,
  0x8e, 0x8a, 0xfa, 0xdc, 0xd9, 0x76, 0x44, 0xf2, 0xc8, 0x92, 0xa5, 0xfa,
  0x7c, 0x39, 0x6f, 0x5c, 0x77, 0x3f, 0xc8, 0xbb, 0x34, 0xff, 0x4f, 0xb6,
  0x70, 0xbd, 0x5d, 0xc6, 0x79, 0x9f, 0x24, 0xaf, 0x87, 0xbe, 0x19, 0x57,
  0x85, 0x22, 0x34, 0xdc, 0x58, 0x4c, 0x3f, 0x89, 0x2f, 0xcf, 0x50, 0x93,
  0x16, 0x7d, 0xf6, 0x47, 0x06, 0xbf, 0xe4, 0x54, 0x0f, 0x00, 0x4f, 0xbd,
  0x17, 0xa1, 0xe6, 0xae, 0x0b, 0x80, 0x16, 0x59, 0xc7, 0x43, 0xbf, 0xd9,
  0x2e, 0x7a, 0x1e, 0x85, 0x5a, 0x8f, 0x99, 0x7a, 0x88, 0x52, 0x9e, 0xa6,
  0xce, 0xa5, 0x29, 0x5a, 0xcf, 0xa2, 0xed, 0xcf, 0x78, 0x1e, 0x1f, 0x36,
  0x1f, 0xae, 0x42, 0x60, 0xa1, 0x6c, 0xa2, 0x2e, 0x64, 0x7e, 0x37, 0x25,
  0x3d, 0x01, 0x78, 0xda, 0xb2, 0xba, 0x16, 0x13, 0x8b, 0x90, 0x3d, 0xd6,
  0x4f, 0xd4, 0x9f, 0x0e, 0xcb, 0x14, 0x1c, 0xdc, 0x22, 0x21, 0xa1, 0x62,
  0x9d, 0xac, 0x0b, 0xdb, 0x5a, 0x25, 0x64, 0xaf, 0x9b, 0xfb, 0xd4, 0x2f,
  0x2c, 0x03, 0x5b, 0x47, 0x88, 0xd6, 0xee, 0xd2, 0x09, 0xa4, 0x6a, 0x33,
  0x02, 0x80, 0xfe, 0x84, 0xf8, 0x24, 0x54, 0x1a, 0xfe, 0x4b, 0x38, 0x3e,
  0xdd, 0xc8, 0x54, 0x80, 0xe1, 0x65, 0xcd, 0x60, 0x5c, 0x58, 0x87, 0xfc,
  0xc0, 0x15, 0x34, 0xaa, 0xae, 0x01, 0x66, 0xcd, 0x1d, 0xdf, 0x0b, 0x87,
  0xef, 0x97, 0xe5, 0xd4, 0xec, 0x0a, 0x1e, 0x22, 0xbf, 0x3a, 0x67, 0xce,
  0x4a, 0x0f, 0xa6, 0xbd, 0xbd, 0x45, 0xf2, 0xeb, 0x34, 0xab, 0xd7, 0xd2,
  0x6a, 0x2a, 0xa5, 0x98, 0x56, 0x1f, 0xab, 0xb3, 0xbd, 0xf5, 0xcd, 0xea,
  0x55, 0x07, 0xbe, 0xe9, 0xa3, 0x2f, 0xef, 0x3c, 0x7f, 0x64, 0xd3, 0x4e,
  0x73, 0x57, 0x1c, 0xc5, 0xc3, 0x65, 0x78, 0x07, 0x4c, 0x63, 0xdb, 0x88,
  0xf0, 0x93, 0xab, 0x18, 0x35, 0xa5, 0x1f, 0x19, 0xbd, 0xa5, 0x69, 0xd4,
  0x86, 0xf2, 0x56, 0x83, 0xb2, 0xe5, 0xcb, 0x82, 0x2d, 0x64, 0x0b, 0x40,
  0xe6, 0x78, 0x35, 0xd6, 0xe5, 0x26, 0x4a, 0xb2, 0x72, 0xf0, 0xb6, 0x70,
  0xce, 0x5e, 0x95, 0x49, 0x18, 0xf5, 0xe4, 0xc9, 0xd5, 0x52, 0xb2, 0x81,
  0x33, 0x51, 0xfb, 0x19, 0x31, 0x50, 0xcf, 0x2b, 0xf1, 0x66, 0x0e, 0x1f,
  0x12, 0x7a, 0x02, 0xe3, 0x1d, 0xc7, 0x26, 0xb2, 0x8a, 0xc8, 0x51, 0xbf,
  0x18, 0xd8, 0x3e, 0x3b, 0xce, 0x50, 0x0c, 0xfd, 0xce, 0x7c, 0x09, 0x61,
  0x91, 0x1e, 0x29, 0x60, 0x33, 0x40, 0xaa, 0x9d, 0x10, 0x8a, 0x63, 0xf6,
  0x9c, 0xe0, 0xc5, 0x4e, 0xb1, 0x52, 0x3c, 0x04, 0x68, 0xa0, 0xa7, 0x54,
  0x8b, 0x96, 0x5c, 0x57, 0xcc, 0xf1, 0x0b, 0xcb, 0xa5, 0x14, 0x18, 0x53,
  0xb6, 0xfb, 0xef, 0x9f, 0x9e, 0xbc, 0x39, 0xfa, 0xca, 0x21, 0x34, 0x08,
  0x13, 0x5f, 0x96, 0x19, 0xdb, 0x35, 0xc5, 0x68, 0x28, 0x96, 0xe4, 0xd0,
  0xeb, 0xad, 0x45, 0x12, 0x34, 0xf6, 0x96, 0xd8, 0xd3, 0xfb, 0xf0, 0x03,
  0x30, 0x90, 0xf9, 0x33, 0xb6, 0x95, 0x4b, 0x1a, 0x74, 0xb1, 0xe1, 0x2d,
  0x0f, 0x35, 0x00, 0x19, 0x49, 0xd2, 0x88, 0xf3, 0x72, 0xb9, 0x70, 0x21,
  0x84, 0x41, 0x91, 0x05, 0x05, 0x38, 0xe4, 0x5b, 0x81, 0xeb, 0xe4, 0x2e,
  0x17, 0xc2, 0x9a, 0x24, 0xf4, 0xb1, 0x6a, 0xd8, 0x95, 0x3b, 0x80, 0x2d,
  0x0b, 0x9a, 0x37, 0xae, 0x17, 0x40, 0x23, 0x2e, 0x67, 0xca, 0xd8, 0x4e,
  0x61, 0xb8, 0xbc, 0xb9, 0x72, 0xb8, 0xc2, 0x92, 0x4c, 0xd4, 0xea, 0xe3,
  0xcc, 0x44, 0x33, 0xe3, 0x79, 0x4b, 0xdd, 0xca, 0x1f, 0x5c, 0x05, 0x4f,
  0x8d, 0xfd, 0xf5, 0xae, 0xa2, 0x22, 0xb2, 0xa4, 0x07, 0x17, 0x9f, 0x24,
  0x83, 0x45, 0x1c, 0x61, 0xd1, 0x13, 0x97, 0x27, 0x3e, 0x79, 0xcd, 0x1e,
  0x9a, 0x5d, 0x86, 0xf9, 0x9c, 0x09, 0xc8, 0x4b, 0x58, 0x3e, 0x48, 0xb9,
  0xa4, 0x87, 0xe3, 0x3c, 0xba, 0x0c, 0x72, 0xcb, 0x24, 0x4e, 0xd0, 0x88,
  0x4e, 0xcc, 0xc5, 0x6c, 0x6b, 0xe9, 0x7e, 0xd4, 0xed, 0xeb, 0x77, 0x9a,
  0x77, 0xe1, 0xb2, 0x83, 0xed, 0xa1, 0x92, 0xa6, 0x81, 0xc0, 0x41, 0xa9,
  0x18, 0x87, 0xae, 0x03, 0x0b, 0xa5, 0x8f, 0x95, 0xf2, 0xe3, 0x17, 0xfc,
  0x77, 0x78, 0x8a, 0x6c, 0x16, 0x2e, 0x55, 0x3d, 0x99, 0x8f, 0xa7, 0x99,
  0x52, 0x35, 0x67, 0x78, 0x62, 0xa5, 0xaa, 0x53, 0x67, 0xdf, 0x5f, 0xb6,
  0x64, 0x63, 0x07, 0xb0, 0x9d, 0x49, 0xdc, 0x61, 0xe3, 0xf0, 0x77, 0x36,
  0x41, 0x7e, 0x5b, 0xbe, 0xd0, 0x98, 0x7c, 0xcb, 0xf1, 0xa7, 0x86, 0x04,
  0x0c, 0x9a, 0x86, 0xfa, 0x93, 0xd8, 0x16, 0xc5, 0x03, 0xf8, 0x83, 0x75,
  0x6e, 0x8f, 0xd6, 0x96, 0x9e, 0xe8, 0x29, 0xce, 0xaf, 0x14, 0x39, 0x47,
  0x9d, 0x6a, 0x50, 0x12, 0x1d, 0x44, 0xb7, 0xb3, 0x51, 0xb2, 0x50, 0xe2,
  0x62, 0x66, 0x20, 0x3e, 0x2d, 0x25, 0xbb, 0x4f, 0x93, 0xa0, 0xc4, 0x3a,
  0xe9, 0x08, 0x31, 0xe0, 0x38, 0x1f, 0xb9, 0xb8, 0x94, 0xd8, 0xdf, 0x65,
  0x06, 0x1d, 0xec, 0x4d, 0xb5, 0x7a, 0x99, 0x05, 0xaf, 0xb1, 0x3d, 0x0f,
  0x9a, 0x70, 0xa2, 0x36, 0x14, 0xe9, 0x0a, 0xb2, 0x04, 0xc3, 0x46, 0x21,
  0xf7, 0x27, 0x29, 0x7c, 0x13, 0xf2, 0xfd, 0x6b, 0xcd, 0x95, 0xa6, 0xf3,
  0xac, 0xd9, 0xef, 0x0a, 0xe9, 0xf3, 0xd9, 0x96, 0x5a, 0xe2, 0x4a, 0x0d,
  0x56, 0x2d, 0xa2, 0xbd, 0xf3, 0x43, 0x92, 0x6c, 0xaf, 0xe6, 0xc8, 0x6e,
  0xe6, 0x11, 0x96, 0xba, 0x3f, 0x10, 0xac, 0x79, 0x15, 0xf4, 0x7c, 0x70,
  0x87, 0x77, 0xc1, 0x9b, 0x4c, 0x4c, 0x1a, 0x1f, 0x40, 0x87, 0xcc, 0x45,
  0xa1, 0x31, 0xc9, 0x8d, 0x0d, 0x70, 0x0e, 0x5c, 0x87, 0xd3, 0x94, 0x85,
  0xa4, 0xd8, 0x5b, 0x42, 0x5d, 0x65, 0x86, 0x28, 0x7e, 0xd6, 0x60, 0xeb,
  0x21, 0xcc, 0x9c, 0xad, 0x35, 0x4e, 0xb5, 0x4f, 0x44, 0xf8, 0xbb, 0xa1,
  0x65, 0x69, 0x5f, 0x15, 0x0f, 0xa8, 0x27, 0xa7, 0x5e, 0xbb, 0xf5, 0xe8,
  0xef, 0xb8, 0x67, 0x58, 0x16, 0xa9, 0xcb, 0x05, 0x89, 0x8b, 0xaf, 0x17,
  0x43, 0xf6, 0x24, 0x10, 0x7e, 0x25, 0x2b, 0x8f, 0x23, 0xac, 0xc5, 0x46,
  0xcd, 0xc2, 0x4f, 0x5c, 0x24, 0x56, 0x02, 0x07, 0xea, 0xc0, 0x44, 0xcf,
  0x2a, 0x53, 0x05, 0x07, 0x0b, 0x8f, 0x18, 0x31, 0xe2, 0x46, 0x04, 0x80,
  0x90, 0x3f, 0xb5, 0x9a, 0x79, 0x3f, 0x72, 0xb3, 0xf5, 0x63, 0x70, 0x5f,
  0xf2, 0x47, 0xaf, 0x1d, 0x80, 0x0e, 0x8f, 0x62, 0xc0, 0x1d, 0x81, 0xa5,
  0xc2, 0x7d, 0xca, 0xbf, 0xe0, 0x63, 0x44, 0xbd, 0x19, 0x06, 0x59, 0x05,
  0x04, 0x43, 0x51, 0xc9, 0xc3, 0x81, 0x88, 0x8f, 0x0f, 0x1c, 0x7a, 0x14,
  0x8a, 0xc6, 0x41, 0x81, 0x1a, 0x36, 0xe5, 0x70, 0x2a, 0xaf, 0x1d, 0xf8,
  0x22, 0xa9, 0x14, 0xb4, 0x71, 0x89, 0x42, 0x9d, 0x7e, 0x87, 0xd6, 0xa2,
  0x3b, 0x9d, 0x7a, 0x86, 0x6f, 0x8f, 0xf1, 0xae, 0x22, 0xa7, 0xce, 0x0b,
  0x4c, 0xca, 0xbb, 0x18, 0xf1, 0xf8, 0xa1, 0x92, 0xe0, 0xc0, 0x15, 0x23,
  0x38, 0xff, 0xc7, 0x81, 0x98, 0x20, 0x49, 0x04, 0xe1, 0x02, 0xb7, 0x69,
  0x61, 0x7e, 0x48, 0xa2, 0xed, 0xb1, 0xc6, 0x46, 0x48, 0x46, 0x75, 0x52,
  0x8e, 0x83, 0xa5, 0x4c, 0xc6, 0xd7, 0x99, 0xc4, 0xd4, 0xd2, 0xa2, 0x05,
  0xc9, 0x97, 0x9d, 0xe8, 0x3f, 0x94, 0x06, 0xbe, 0xf1, 0x39, 0x7b, 0x4c,
  0x08, 0x03, 0xc1, 0x86, 0x1a, 0x78, 0x82, 0x38, 0xfc, 0xfe, 0xe2, 0x7c,
  0x2f, 0xfa, 0xfa, 0x70, 0xef, 0xe0, 0xf0, 0x7c, 0x58, 0xbb, 0xf4, 0x35,
  0x0a, 0x44, 0x24, 0x34, 0xb6, 0x07, 0x43, 0x34, 0xb6, 0xe4, 0x75, 0x8d,
  0xda, 0x37, 0xae, 0x17, 0x3f, 0xe0, 0x20, 0xd1, 0xf9, 0x60, 0x85, 0x48,
  0x1c, 0x07, 0x1c, 0x9a, 0xc6, 0xe1, 0xcf, 0x59, 0xd0, 0x86, 0x56, 0x6d,
  0x75, 0xd6, 0xf3, 0x30, 0x5f, 0xc6, 0xe3, 0x12, 0xf9, 0xcb, 0x64, 0x92,
  0x59, 0x2e, 0x60, 0x75, 0xe7, 0xbe, 0xf6, 0x99, 0xd7, 0x01, 0xdb, 0xd2,
  0x4b, 0x46, 0x0d, 0x88, 0x9d, 0xef, 0xfb, 0xd4, 0x6f, 0x9f, 0x16, 0xbf,
  0xcf, 0xb8, 0x51, 0x0f, 0x49, 0xd1, 0xa9, 0x59, 0x03, 0xab, 0xdd, 0xaf,
  0x09, 0x4a, 0x7e, 0xe3, 0x24, 0x7d, 0xdd, 0xda, 0x12, 0x9f, 0xae, 0x29,
  0x63, 0xd7, 0xd7, 0x35, 0x08, 0x5c, 0xaa, 0x81, 0x90, 0xac, 0x27, 0xa8,
  0x91, 0xdc, 0xa2, 0x71, 0x4a, 0x5e, 0xcd, 0xd4, 0xd8, 0x30, 0x0c, 0x44,
  0xa7, 0x00, 0x59, 0x27, 0x2d, 0xf5, 0x52, 0x87, 0x5d, 0x44, 0x21, 0x0d,
  0x79, 0x58, 0xfa, 0x50, 0x78, 0x3f, 0xc0, 0x17, 0xa2, 0x51, 0xfa, 0x45,
  0xc5, 0x55, 0xaa, 0x76, 0x51, 0x05, 0x79, 0xd4, 0xe6, 0x78, 0x0c, 0x8e,
  0xe6, 0x2d, 0xb8, 0x9f, 0xbb, 0x34, 0xe8, 0x66, 0x7d, 0x57, 0x22, 0xc2,
  0x58, 0xa9, 0x87, 0xa9, 0x93, 0x63, 0xce, 0x64, 0xe3, 0x4d, 0x5e, 0x0d,
  0x32, 0x81, 0x42, 0x62, 0x46, 0x99, 0x09, 0x44, 0x8f, 0xbb, 0xe7, 0x92,
  0xe8, 0xeb, 0xac, 0xc0, 0x5d, 0xd0, 0x7c, 0x9c, 0x2f, 0xf9, 0xb6, 0xe5,
  0xc7, 0x1b, 0xea, 0xea, 0x72, 0xc0, 0x6d, 0x40, 0x3a, 0x04, 0xfb, 0x3a,
  0xdb, 0xbb, 0xf8, 0x1a, 0x8e, 0x56, 0x90, 0xf0, 0x41, 0xc6, 0x0a, 0x8f,
  0xb9, 0xd7, 0x9a, 0x09, 0x59, 0x4e, 0x81, 0x13, 0xf9, 0xd7, 0x40, 0xa8,
  0x4c, 0x9e, 0x84, 0x23, 0x0f, 0x26, 0x4a, 0x60, 0xda, 0xa4, 0x6a, 0x78,
  0xac, 0x16, 0x3f, 0x41, 0xe8, 0xbb, 0xcb, 0xb6, 0x73, 0xb1, 0x97, 0x5d,
  0x49, 0x49, 0xef, 0xca, 0x9c, 0x40, 0xf4, 0x2c, 0xcc, 0xb1, 0xc6, 0x13,
  0xe2, 0x01, 0xe2, 0x8b, 0x4b, 0x4d, 0xb4, 0xed, 0xd1, 0x9e, 0xb6, 0x63,
  0x3c, 0x05, 0x47, 0xfa, 0x8b, 0xd9, 0xc3, 0xa0, 0x09, 0x80, 0x11, 0x7d,
  0xb9, 0x2c, 0xab, 0x6c, 0xa5, 0x86, 0x4a, 0xe8, 0x24, 0xcb, 0x3c, 0xcb,
  0xca, 0x2a, 0xae, 0x1f, 0x56, 0x47, 0x4e, 0xb4, 0x80, 0x79, 0xc9, 0x58,
  0xb8, 0xa9, 0xb9, 0xca, 0xdd, 0xa1, 0x60, 0x18, 0x8f, 0x8a, 0x6c, 0xba,
  0x2c, 0x83, 0xe8, 0xeb, 0x5f, 0x37, 0xe6, 0x60, 0xd0, 0xeb, 0x47, 0x83,
  0xc4, 0x08, 0x8a, 0xc3, 0x87, 0xf3, 0x98, 0x34, 0x7d, 0x2e, 0xe0, 0xc9,
  0x7e, 0xc7, 0x3c, 0x9b, 0x57, 0xeb, 0x73, 0x20, 0xd0, 0x7b, 0x63, 0x6d,
  0x6d, 0x68, 0x9b, 0xcd, 0x10, 0x72, 0xcd, 0x4d, 0x07, 0x60, 0x04, 0x70,
  0xea, 0xc4, 0x6f, 0x30, 0xa6, 0x5f, 0x0c, 0xd8, 0x27, 0x91, 0x3d, 0x05,
  0x0b, 0x97, 0x3d, 0x4e, 0x8b, 0xea, 0xa4, 0xf0, 0x95, 0xf3, 0x5c, 0x58,
  0x76, 0xd9, 0x45, 0x66, 0x68, 0xaf, 0xea, 0xb9, 0xf3, 0x04, 0x51, 0x49,
  0x50, 0x6f, 0xc5, 0x7d, 0xe4, 0x4b, 0x40, 0x51, 0xa6, 0x7c, 0x68, 0x2e,
  0x0f, 0x72, 0xf3, 0x3f, 0x37, 0xa3, 0x9e, 0xe0, 0xb5, 0xc4, 0x45, 0x0b,
  0xca, 0xc8, 0xff, 0x8b, 0x10, 0x2c, 0x85, 0xdc, 0xe3, 0x36, 0x6b, 0x50,
  0x75, 0x03, 0x52, 0xa1, 0xae, 0xf3, 0xb1, 0xa7, 0x7e, 0x92, 0x0e, 0x92,
  0x3b, 0xd6, 0x5f, 0x4c, 0x47, 0x78, 0x23, 0xc5, 0xed, 0xa5, 0xf2, 0xbc,
  0x43, 0x40, 0x01, 0xf0, 0xc5, 0xa5, 0xb3, 0xea, 0x71, 0x69, 0x23, 0x29,
  0xf4, 0x23, 0x62, 0x3d, 0x70, 0xee, 0xcd, 0x83, 0xba, 0x16, 0x55, 0xf4,
  0xf6, 0x22, 0x2a, 0x32, 0xf9, 0x69, 0x29, 0x47, 0x1a, 0xe3, 0xa5, 0xe4,
  0xaf, 0x6a, 0x94, 0x16, 0x69, 0xc8, 0x45, 0xfc, 0xb1, 0xe0, 0x53, 0x09,
  0xab, 0x33, 0xc7, 0xa4, 0x8d, 0xd1, 0x84, 0x00, 0xf6, 0x5b, 0x02, 0xc1,
  0x4b, 0xab, 0xf8, 0xb9, 0xa2, 0x96, 0x48, 0xd9, 0xe6, 0xba, 0x38, 0xa6,
  0xc8, 0xd8, 0x8d, 0x6a, 0x59, 0x1c, 0x6e, 0xa3, 0xfc, 0xe8, 0xf5, 0xea,
  0x47, 0x5a, 0x3c, 0x7c, 0x74, 0x77, 0x71, 0x5a, 0x86, 0x12, 0x81, 0xcd,
  0x88, 0x34, 0x3c, 0x05, 0x54, 0x1f, 0x3d, 0x54, 0x42, 0x53, 0x7c, 0xdc,
  0xe6, 0x15, 0x27, 0x79, 0xa8, 0x45, 0x4a, 0x41, 0x45, 0x60, 0xfe, 0xba,
  0x4e, 0x35, 0xba, 0x54, 0x16, 0xdd, 0xcc, 0x81, 0x6c, 0xcf, 0x80, 0x79,
  0x6f, 0x2d, 0x0a, 0xbd, 0xab, 0x2e, 0x00, 0x62, 0xd0, 0x3c, 0x2d, 0x03,
  0x07, 0x1f, 0xa7, 0x37, 0xc8, 0x51, 0x98, 0x4f, 0x8e, 0x55, 0x71, 0x31,
  0xcf, 0x1f, 0xd4, 0x75, 0xd8, 0x1f, 0x47, 0xb1, 0xce, 0x23, 0xbf, 0x1e,
  0x85, 0x5c, 0x25, 0x3b, 0xdb, 0x50, 0x49, 0x25, 0x70, 0x03, 0x68, 0x6c,
  0x56, 0x70, 0xc9, 0xe3, 0xb4, 0x54, 0xd7, 0x1d, 0x95, 0x0e, 0x01, 0xf6,
  0x67, 0xa9, 0xf6, 0xea, 0x67, 0x16, 0x89, 0x30, 0xf0, 0x38, 0x55, 0x6a,
  0x73, 0x48, 0xfa, 0x76, 0x51, 0xe6, 0xcb, 0x71, 0x05, 0x79, 0x09, 0xc4,
  0x50, 0xf1, 0xcf, 0xbb, 0xe5, 0xcd, 0x42, 0xad, 0x7e, 0x3d, 0xae, 0xe4,
  0xb2, 0xe8, 0x93, 0x61, 0x17, 0x1b, 0x52, 0xc1, 0x51, 0xeb, 0xd7, 0x42,
  0x3b, 0xa1, 0xf1, 0x3b, 0x02, 0xeb, 0x9f, 0xb9, 0x54, 0xfa, 0x0a, 0x80,
  0x95, 0xe4, 0x25, 0x04, 0xb7, 0xae, 0x8a, 0x60, 0x10, 0x39, 0xf2, 0x48,
  0xa1, 0xb4, 0x20, 0xd0, 0xb0, 0xb1, 0x72, 0xcd, 0xc1, 0x5d, 0x51, 0x77,
  0x7d, 0x5f, 0xb2, 0x91, 0xfa, 0xdb, 0xa4, 0x85, 0x34, 0x78, 0x78, 0x57,
  0x75, 0xa0, 0xf0, 0x90, 0x59, 0xb5, 0x58, 0xd5, 0x64, 0x4a, 0x53, 0x76,
  0x92, 0xa1, 0x9c, 0xc4, 0x99, 0xae, 0xdf, 0xc0, 0x15, 0x51, 0xb4, 0x62,
  0x95, 0x35, 0x41, 0xa2, 0x79, 0x2b, 0x9e, 0x09, 0x18, 0x49, 0x83, 0x88,
  0x0e, 0xcc, 0x9a, 0x0a, 0x66, 0x83, 0x05, 0x63, 0x9d, 0xc6, 0x36, 0xe9,
  0xe8, 0xcc, 0x75, 0x41, 0x43, 0xe0, 0x19, 0x77, 0xa7, 0xc9, 0x56, 0x37,
  0x28, 0x9b, 0xb0, 0x2e, 0xa1, 0xff, 0x19, 0xf4, 0x1e, 0xb6, 0x1c, 0x62,
  0x82, 0x62, 0xb7, 0xe0, 0x08, 0xb7, 0x8d, 0x96, 0xa1, 0x50, 0x13, 0xbf,
  0x76, 0x30, 0xdb, 0x2f, 0x77, 0x06, 0xdb, 0x9f, 0x7c, 0x36, 0xd8, 0x1a,
  0x6c, 0x6f, 0x31, 0x67, 0xe1, 0xa1, 0x04, 0x83, 0x93, 0x75, 0x69, 0xe9,
  0xaa, 0xf2, 0x5e, 0xb3, 0xcf, 0x93, 0xc3, 0x8b, 0xef, 0x4e, 0xcf, 0xbf,
  0x89, 0x8e, 0x4e, 0x2e, 0x0e, 0xcf, 0xdf, 0xec, 0xed, 0x7f, 0x28, 0x80,
  0x6e, 0x68, 0xb0, 0x0e, 0x4a, 0xe5, 0x25, 0x7e, 0x61, 0x9a, 0x56, 0x41,
  0xbf, 0x66, 0x49, 0x79, 0xbd, 0xb5, 0xbb, 0xfd, 0x28, 0xf0, 0x66, 0x8b,
  0x61, 0xd0, 0xbf, 0x6f, 0x93, 0xda, 0xe6, 0x49, 0xad, 0x6e, 0xc5, 0xc1,
  0x79, 0x0d, 0x25, 0xc0, 0xca, 0x05, 0xe7, 0x82, 0xc1, 0x03, 0x41, 0x3f,
  0x1d, 0xe5, 0xb1, 0x99, 0xa4, 0x46, 0x82, 0xfe, 0x27, 0x69, 0xb5, 0x0a,
  0xf3, 0xa2, 0x41, 0xe8, 0xca, 0x6e, 0x39, 0x46, 0x79, 0x99, 0x4e, 0x4b,
  0x35, 0xa4, 0x08, 0x98, 0xdf, 0x04, 0xc2, 0x5d, 0x6b, 0x59, 0x55, 0xd4,
  0x8d, 0x92, 0xba, 0xaa, 0x13, 0x97, 0x2d, 0xe2, 0xd0, 0x07, 0x2a, 0x39,
  0x37, 0x18, 0x6b, 0xb5, 0xb2, 0x60, 0x18, 0x43, 0x5b, 0x43, 0xd2, 0x2b,
  0x2c, 0xb6, 0x19, 0x13, 0xab, 0x18, 0x45, 0xf7, 0x75, 0x20, 0x38, 0x0d,
  0xc1, 0x68, 0xa4, 0x2b, 0x88, 0x52, 0x86, 0xde, 0x5a, 0xc5, 0x81, 0x94,
  0xdb, 0x09, 0x19, 0x14, 0x22, 0xf9, 0x19, 0xca, 0x34, 0xb7, 0x5e, 0x54,
  0xf0, 0xc1, 0x22, 0xa9, 0x69, 0x10, 0xbe, 0x2e, 0x42, 0x36, 0x42, 0x34,
  0x27, 0x79, 0x7c, 0xc7, 0x15, 0x52, 0x44, 0x6c, 0xf0, 0xc1, 0x8c, 0x41,
  0x59, 0x06, 0x16, 0x99, 0xfc, 0x9a, 0x47, 0x67, 0x87, 0x6f, 0xfb, 0x56,
  0xa9, 0x8d, 0x7e, 0x17, 0x33, 0x94, 0xe1, 0x47, 0x4a, 0x86, 0xcf, 0x22,
  0x99, 0x5b, 0x40, 0x0d, 0x78, 0xa2, 0x46, 0x00, 0x85, 0x13, 0xe0, 0x43,
  0x23, 0x16, 0x09, 0xe1, 0xb5, 0x7c, 0x18, 0x2d, 0xf0, 0xd2, 0x21, 0xdf,
  0x55, 0xa0, 0xdc, 0x78, 0x3f, 0x35, 0x6a, 0x39, 0x5a, 0x77, 0x91, 0xba,
  0xdc, 0x1f, 0xc2, 0x51, 0x11, 0x2d, 0xe0, 0x02, 0x04, 0x32, 0xcb, 0xb8,
  0x3e, 0xfb, 0x66, 0x7f, 0xf8, 0xd1, 0xf6, 0x8e, 0x0e, 0x67, 0x63, 0xe0,
  0x71, 0x19, 0x1b, 0xc9, 0xf8, 0x60, 0xd7, 0xe1, 0x18, 0x2d, 0xb5, 0x1a,
  0x07, 0x1c, 0x9b, 0xb1, 0xee, 0xd2, 0x83, 0x36, 0x2a, 0xf9, 0x41, 0x6b,
  0x52, 0x1f, 0xd3, 0x84, 0x4b, 0x57, 0x49, 0x8d, 0x9d, 0x21, 0x28, 0x17,
  0xa0, 0x98, 0xfd, 0xa5, 0x8b, 0xf7, 0x8b, 0xe7, 0xf6, 0x91, 0xb4, 0xac,
  0xad, 0x21, 0x77, 0xdc, 0xc7, 0xb4, 0xd4, 0xf7, 0x9c, 0xd7, 0xdb, 0x7f,
  0xcb, 0xf0, 0x7f, 0x7a, 0xa9, 0x1b, 0x3a, 0x8f, 0xef, 0x06, 0x07, 0x40,
  0x43, 0xd8, 0x27, 0x56, 0xf7, 0x63, 0xee, 0x61, 0xc9, 0xf9, 0xe9, 0x53,
  0xda, 0x28, 0x3a, 0x59, 0x82, 0xd7, 0xc0, 0x4c, 0x41, 0x2a, 0xc5, 0xbb,
  0x47, 0x0e, 0x72, 0xc6, 0x7f, 0x5f, 0x48, 0x30, 0xe9, 0xc9, 0x20, 0xfa,
  0x3a, 0x99, 0x73, 0xc2, 0x3c, 0x87, 0xdd, 0x59, 0x06, 0x16, 0x82, 0x03,
  0xb9, 0xac, 0x0f, 0x8a, 0xb0, 0x1c, 0x27, 0xb1, 0xa2, 0xe1, 0x11, 0xaf,
  0x2b, 0x44, 0xb7, 0xb5, 0x12, 0x05, 0x31, 0x87, 0xe8, 0xe1, 0x26, 0x52,
  0x03, 0x2d, 0xaa, 0xf0, 0xa5, 0x85, 0x36, 0xb0, 0x5e, 0xc5, 0xb4, 0x03,
  0xc0, 0x32, 0x9a, 0xd3, 0x63, 0x0e, 0x2f, 0x93, 0xda, 0x93, 0xaf, 0x01,
  0x1a, 0xca, 0x76, 0x42, 0xd1, 0xb5, 0x3c, 0x53, 0x99, 0xe4, 0xd7, 0x6c,
  0xf4, 0x28, 0xe8, 0xba, 0x89, 0xe7, 0xe3, 0x87, 0xc1, 0x84, 0xa4, 0x58,
  0x36, 0x9b, 0x0d, 0x96, 0x37, 0x9b, 0xc1, 0x31, 0x65, 0x96, 0x7f, 0x2d,
  0xd8, 0x00, 0x55, 0x93, 0xb7, 0x95, 0x8f, 0x6b, 0xc2, 0x77, 0xc5, 0x95,
  0x33, 0xc1, 0x24, 0x61, 0x59, 0xfe, 0x72, 0x3c, 0x57, 0xc2, 0x5c, 0x1d,
  0x46, 0x0e, 0xaf, 0x92, 0x5b, 0x18, 0x2c, 0x92, 0xd9, 0xae, 0xcb, 0x43,
  0x36, 0xfe, 0xa0, 0x18, 0xd7, 0x4e, 0xa5, 0x08, 0xcc, 0xb3, 0xf3, 0xe4,
  0x6a, 0xaa, 0x02, 0x45, 0xa8, 0xb4, 0x78, 0xfc, 0xd1, 0x66, 0x1a, 0x88,
  0xa8, 0x3a, 0x5a, 0x87, 0x1d, 0xb2, 0x3a, 0xd1, 0x61, 0xa9, 0x71, 0xb5,
  0xf2, 0x30, 0x8a, 0x96, 0xfa, 0x46, 0x14, 0x31, 0x04, 0xd0, 0x99, 0x2c,
  0x06, 0xab, 0x71, 0xc7, 0xc2, 0x91, 0xd4, 0xf1, 0x44, 0xdf, 0x0a, 0x85,
  0x00, 0xac, 0x56, 0x43, 0xa3, 0xe1, 0xf6, 0xb4, 0x32, 0x6d, 0x72, 0x56,
  0xe8, 0xeb, 0xdb, 0x67, 0x6c, 0xeb, 0xbe, 0x38, 0x1e, 0xf6, 0x84, 0x1e,
  0xe6, 0xc9, 0x5d, 0x40, 0x59, 0x82, 0xaf, 0xac, 0xe4, 0xc7, 0x96, 0x1f,
  0x09, 0x5f, 0xb3, 0x12, 0xb1, 0xb9, 0x8c, 0x46, 0x38, 0x83, 0x77, 0x92,
  0xf9, 0x2c, 0x08, 0x5b, 0x08, 0x8d, 0x27, 0xe6, 0xe1, 0x58, 0x45, 0x0c,
  0x11, 0x88, 0x1c, 0xca, 0x0b, 0x63, 0xe8, 0x91, 0xc0, 0xf4, 0xac, 0x17,
  0xf5, 0x77, 0x00, 0x9e, 0xb3, 0x5d, 0x5d, 0xc8, 0x98, 0x4b, 0x55, 0xc4,
  0x63, 0x14, 0xde, 0x59, 0x73, 0x75, 0xb2, 0x8d, 0x25, 0xac, 0x2b, 0x59,
  0xdf, 0xd2, 0xfb, 0xfc, 0x63, 0x47, 0x27, 0x75, 0xbb, 0x8d, 0xd0, 0x6d,
  0x96, 0x47, 0x6f, 0x93, 0xe9, 0x43, 0x53, 0x6c, 0xd8, 0x79, 0x74, 0x67,
  0x91, 0x24, 0x71, 0x97, 0x3a, 0x6c, 0x50, 0x81, 0x87, 0x86, 0x21, 0x94,
  0x4f, 0x36, 0xed, 0x95, 0x0d, 0x80, 0x96, 0x51, 0x4d, 0xdc, 0xf3, 0xe8,
  0x76, 0xc7, 0x3c, 0xcd, 0xfc, 0x8d, 0x2d, 0x9e, 0x98, 0xea, 0x3d, 0x23,
  0x69, 0x24, 0x30, 0x72, 0xb8, 0x5b, 0x40, 0xb9, 0x9c, 0xfa, 0x44, 0x74,
  0x4b, 0x9c, 0xa4, 0xc2, 0x69, 0x58, 0x83, 0x2a, 0x1d, 0x06, 0x11, 0x6f,
  0x3f, 0xa0, 0x4b, 0x49, 0x16, 0xf6, 0x41, 0x4e, 0x08, 0x01, 0xc7, 0x99,
  0x26, 0x09, 0xb6, 0x58, 0xce, 0xb4, 0x86, 0x10, 0x18, 0x71, 0x0f, 0xd7,
  0x6d, 0x19, 0x11, 0x27, 0x4e, 0x25, 0xe4, 0x6f, 0x0a, 0x61, 0x1a, 0x02,
  0x96, 0x1a, 0x4b, 0xfd, 0x42, 0xb1, 0x05, 0x4c, 0x70, 0xf5, 0x40, 0x2f,
  0xd7, 0xa9, 0xd8, 0x30, 0x10, 0xa1, 0x8a, 0x05, 0x23, 0x56, 0xd1, 0x8d,
  0xe8, 0xf4, 0x2d, 0xb9, 0xd1, 0x32, 0x43, 0x08, 0xac, 0x13, 0x18, 0x34,
  0x9b, 0x6e, 0x08, 0xa9, 0x33, 0xea, 0x86, 0x4c, 0xb2, 0xff, 0x39, 0x2f,
  0x42, 0xd1, 0xf5, 0xab, 0xa6, 0x70, 0xb7, 0xd5, 0x25, 0x50, 0xff, 0x08,
  0xad, 0xb7, 0x34, 0x75, 0x96, 0x5b, 0xc1, 0xcb, 0x6e, 0x72, 0xcf, 0x22,
  0x52, 0xd7, 0xfa, 0x95, 0xef, 0x05, 0x0d, 0x00, 0xeb, 0x7b, 0x76, 0x74,
  0x22, 0x45, 0x1c, 0xdd, 0x59, 0x4a, 0x58, 0xf2, 0x96, 0xe7, 0x44, 0x10,
  0x16, 0x0b, 0x3f, 0x7b, 0x2d, 0xc5, 0xe6, 0xc4, 0x04, 0xc7, 0x87, 0x24,
  0xb5, 0xee, 0xce, 0x97, 0x32, 0x82, 0x2e, 0xdf, 0x94, 0x45, 0x31, 0xed,
  0xd6, 0x6a, 0x93, 0xb9, 0x1d, 0xad, 0x5d, 0x49, 0xce, 0x9a, 0x35, 0x9e,
  0x84, 0xc5, 0x56, 0xb5, 0x95, 0x0a, 0xa7, 0xec, 0xd5, 0x32, 0x26, 0x43,
  0x33, 0xfa, 0x47, 0xd1, 0x60, 0x93, 0x3a, 0x2c, 0x36, 0xed, 0xc5, 0xc5,
  0xcd, 0xb8, 0xa0, 0x3b, 0x92, 0xd3, 0x83, 0x7f, 0x74, 0xb8, 0xc4, 0x3c,
  0xe4, 0xc9, 0xcf, 0x51, 0x7f, 0x3c, 0x95, 0x19, 0xa2, 0x0a, 0xe2, 0x8f,
  0x44, 0x37, 0xfc, 0xc4, 0xcf, 0x6b, 0x9c, 0x2a, 0x37, 0x7c, 0xf7, 0x96,
  0x51, 0xc1, 0x51, 0x69, 0xee, 0xe2, 0x7c, 0xef, 0x64, 0xf8, 0x46, 0x2c,
  0xad, 0x17, 0x59, 0x50, 0xc0, 0x4e, 0xcd, 0xd4, 0xe6, 0x8e, 0x74, 0xa0,
  0x63, 0x77, 0x02, 0x55, 0x6d, 0x91, 0xda, 0x5a, 0xdd, 0xae, 0x57, 0x87,
  0xe4, 0x95, 0xd2, 0x78, 0x60, 0xd8, 0x74, 0xa2, 0xd6, 0x8b, 0x0d, 0x77,
  0xbb, 0x16, 0x61, 0xe1, 0x0d, 0x0f, 0x77, 0x27, 0x5a, 0x8a, 0x7b, 0x88,
  0xcf, 0xcc, 0xbe, 0x0d, 0xc6, 0x3e, 0x15, 0x86, 0xbe, 0x12, 0x65, 0x72,
  0x9f, 0xf4, 0x8f, 0xbe, 0x82, 0xbc, 0x07, 0x65, 0x46, 0x9c, 0x75, 0x4e,
  0x18, 0xba, 0x02, 0xc3, 0xb9, 0xc6, 0xc3, 0x6c, 0x42, 0x6b, 0x7a, 0xfd,
  0x4f, 0xdb, 0x1b, 0xed, 0xcd, 0x5f, 0xfc, 0xda, 0xe6, 0xdb, 0xc7, 0x6e,
  0x02, 0xbf, 0x4f, 0x56, 0x59, 0xff, 0xd3, 0xce, 0xc6, 0xa3, 0x33, 0x0a,
  0xd3, 0xed, 0x7c, 0x9f, 0xf4, 0x06, 0x0f, 0x36, 0x7a, 0x6d, 0xe5, 0x4a,
  0xf5, 0x22, 0x76, 0x01, 0x1f, 0x97, 0x1e, 0xf0, 0xae, 0x82, 0xff, 0xc0,
  0x01, 0xc1, 0x4e, 0xfc, 0xf3, 0x7e, 0x1c, 0xcd, 0x5b, 0x38, 0xfa, 0x1f,
  0x87, 0x21, 0x50, 0x20, 0x69, 0xe3, 0x21, 0xcf, 0xe3, 0xc4, 0xf3, 0x22,
  0x1b, 0xa0, 0xef, 0x9d, 0x47, 0xfa, 0xf6, 0xb3, 0x0b, 0x74, 0x5d, 0x76,
  0x8a, 0x72, 0x54, 0x15, 0x4b, 0xe3, 0x9b, 0xa4, 0x5d, 0x68, 0x3f, 0x6b,
  0xbe, 0x32, 0xe2, 0xea, 0xfe, 0x2e, 0x8e, 0xde, 0x1e, 0x72, 0xd9, 0x9b,
  0x83, 0x23, 0x46, 0x32, 0x1b, 0x2a, 0x98, 0xa0, 0xa9, 0xb5, 0x0e, 0x6a,
  0x35, 0x84, 0x6a, 0x17, 0x6f, 0xa1, 0x0b, 0x5e, 0x72, 0xe7, 0xdf, 0xed,
  0x04, 0x77, 0xad, 0xd1, 0xb5, 0x85, 0xe5, 0xf0, 0x1d, 0x5d, 0xf6, 0xdf,
  0x66, 0x13, 0xa8, 0x5e, 0x7d, 0x01, 0x57, 0xa6, 0xb7, 0xe8, 0xc3, 0x77,
  0xf3, 0x59, 0xe5, 0xe3, 0x30, 0x53, 0x50, 0xb5, 0xea, 0xb5, 0x55, 0x70,
  0xf6, 0xbf, 0x6c, 0xf6, 0xfb, 0x28, 0x4b, 0x2a, 0x41, 0x42, 0xea, 0x2a,
  0xa8, 0xa0, 0x3d, 0xd8, 0xd9, 0xa7, 0xf5, 0x49, 0xa7, 0x0f, 0xe2, 0xd6,
  0x8e, 0x7d, 0x30, 0x92, 0x4f, 0x0b, 0xbc, 0xe2, 0xd4, 0x24, 0x6f, 0x31,
  0x12, 0x9b, 0xd0, 0x5a, 0x88, 0x4e, 0x09, 0xe1, 0x3c, 0xb9, 0xf3, 0xd1,
  0x34, 0x5a, 0x08, 0x2e, 0x5b, 0x3c, 0x60, 0x92, 0x77, 0x15, 0x47, 0x7d,
  0xab, 0xb7, 0xee, 0x17, 0x79, 0xa7, 0x52, 0xc0, 0x41, 0x7a, 0x08, 0x09,
  0x50, 0x3f, 0xd1, 0x7a, 0x07, 0xa7, 0x79, 0xc0, 0xc0, 0x74, 0xd8, 0x56,
  0xbf, 0x24, 0x40, 0xae, 0x0c, 0x80, 0x36, 0xab, 0xe3, 0xf4, 0x26, 0xcc,
  0x35, 0xbe, 0xdb, 0x06, 0x6c, 0x39, 0x37, 0x57, 0x0b, 0x71, 0x9d, 0x45,
  0xb5, 0xe2, 0x5a, 0x12, 0x59, 0xe6, 0xb0, 0x64, 0x87, 0x77, 0xfb, 0x5d,
  0xe0, 0x43, 0xa7, 0xf3, 0x96, 0xc9, 0xf4, 0x7f, 0xfd, 0x6c, 0x1a, 0x8e,
  0xbc, 0xa8, 0x73, 0xc9, 0x10, 0x0b, 0xec, 0x15, 0xe9, 0xc8, 0x00, 0x04,
  0x75, 0x44, 0x68, 0x8b, 0x84, 0x7a, 0x66, 0x6b, 0xa6, 0x9c, 0x88, 0xa2,
  0xe6, 0xe2, 0x2c, 0x9d, 0xc9, 0x55, 0x2c, 0x5d, 0xcc, 0x47, 0x97, 0x8b,
  0x09, 0x5c, 0xfc, 0x12, 0xdc, 0xf8, 0xdf, 0xe2, 0xf9, 0x32, 0xce, 0x1f,
  0xa2, 0xed, 0x9d, 0x5e, 0xb4, 0xb3, 0xb5, 0xbd, 0xd3, 0x32, 0x87, 0xce,
  0x7f, 0xe3, 0x10, 0x9b, 0x1d, 0x7c, 0xdd, 0xf9, 0xd0, 0x59, 0xf8, 0x40,
  0x79, 0xdc, 0xac, 0x9a, 0x52, 0x4a, 0xbc, 0x87, 0xbd, 0x7d, 0x52, 0x88,
  0x95, 0xcb, 0xb2, 0x01, 0x1a, 0x0d, 0x82, 0x85, 0x18, 0x9e, 0xac, 0x8c,
  0x92, 0x2b, 0xba, 0xc1, 0x4f, 0xac, 0x69, 0x95, 0x2c, 0xc4, 0x51, 0x38,
  0xeb, 0x5b, 0x9c, 0xa3, 0x46, 0x54, 0x75, 0x8f, 0xd2, 0xd2, 0xb6, 0x85,
  0x03, 0x35, 0x78, 0x6f, 0x88, 0xde, 0x0f, 0x8e, 0xf6, 0x2f, 0x0c, 0x3b,
  0xef, 0x92, 0xaf, 0xd3, 0xfc, 0xe1, 0xc3, 0xca, 0xed, 0x3c, 0xfa, 0xcc,
  0x64, 0xf7, 0x3a, 0x21, 0xb1, 0x6c, 0x3e, 0x5a, 0x5e, 0xed, 0xfe, 0x2d,
  0xce, 0xaf, 0x82, 0x1a, 0xed, 0x2b, 0x9e, 0x9f, 0x20, 0x53, 0x69, 0x97,
  0x18, 0xd4, 0xf6, 0xcb, 0xed, 0x67, 0x12, 0x06, 0x9f, 0x72, 0x6d, 0x2e,
  0xf0, 0x87, 0xee, 0xac, 0x2b, 0xd0, 0x0d, 0x88, 0xbf, 0x77, 0x78, 0x0d,
  0xf3, 0x49, 0x57, 0x74, 0xae, 0x38, 0x7c, 0x76, 0xa2, 0xcf, 0x4a, 0x4a,
  0x73, 0x17, 0x88, 0x21, 0xf4, 0x38, 0xe7, 0xff, 0x2d, 0x17, 0xdd, 0x41,
  0xe5, 0x84, 0x3f, 0x31, 0x57, 0xee, 0xc2, 0x55, 0x17, 0xda, 0x17, 0x9e,
  0xac, 0xec, 0x74, 0x94, 0x27, 0xf1, 0x8d, 0xaf, 0xd7, 0xe6, 0x71, 0x1d,
  0xcc, 0x80, 0x7e, 0xfe, 0x66, 0x5f, 0xe0, 0x30, 0x2d, 0x11, 0x07, 0x4b,
  0x1d, 0x39, 0x73, 0xc7, 0x06, 0x8f, 0xf2, 0x89, 0xfe, 0x39, 0x52, 0x7e,
  0x77, 0x32, 0xfa, 0x80, 0x87, 0xe8, 0xdc, 0x09, 0xf0, 0xd8, 0x5e, 0x15,
  0x9c, 0x9f, 0x05, 0xff, 0x92, 0x49, 0xcd, 0xea, 0xb3, 0xad, 0x4b, 0xb1,
  0x31, 0x31, 0x60, 0xf3, 0xd0, 0x5c, 0x6d, 0x58, 0xb5, 0x18, 0xd0, 0xb8,
  0xb9, 0x90, 0xd7, 0xc1, 0xde, 0x59, 0xa0, 0x3c, 0x41, 0x39, 0xf1, 0x86,
  0x22, 0x7e, 0x8e, 0x05, 0x67, 0x14, 0x78, 0x14, 0x7b, 0xd2, 0x43, 0xcf,
  0x8b, 0xbc, 0x25, 0xf8, 0xe4, 0xe4, 0x36, 0x96, 0x70, 0xeb, 0x4c, 0xaf,
  0x13, 0xd8, 0x34, 0x80, 0xee, 0x3d, 0x9d, 0xc4, 0x70, 0xab, 0xe9, 0x25,
  0x04, 0x79, 0x1c, 0x6d, 0xa5, 0x1a, 0x5b, 0x43, 0x7b, 0x73, 0x1f, 0x69,
  0x4a, 0x80, 0xe6, 0x3e, 0xc8, 0xef, 0xf2, 0x18, 0xa7, 0xbb, 0x3e, 0xd8,
  0x04, 0x84, 0x3f, 0xd3, 0xe0, 0xe3, 0xe2, 0x86, 0x58, 0xa9, 0xb8, 0x83,
  0xa9, 0xf7, 0x74, 0x9c, 0x98, 0x61, 0x75, 0x92, 0x4a, 0x58, 0x06, 0x9b,
  0x34, 0x80, 0xaa, 0x53, 0xd9, 0x30, 0xb9, 0x81, 0x58, 0x83, 0x99, 0x16,
  0x89, 0x20, 0xe0, 0x45, 0x17, 0x77, 0x99, 0x48, 0x9d, 0x0e, 0x75, 0x40,
  0x02, 0x1b, 0x8b, 0x65, 0x2a, 0x20, 0x1a, 0xb4, 0x79, 0xe0, 0x07, 0x41,
  0xa5, 0xb0, 0x8e, 0xb3, 0xa6, 0x1c, 0x38, 0x2f, 0xda, 0xf0, 0xe0, 0x9b,
  0x88, 0x13, 0xb5, 0xb9, 0x8f, 0x7d, 0x46, 0xd8, 0x67, 0x87, 0xf8, 0x0c,
  0xda, 0xc4, 0x57, 0x4b, 0x3e, 0xef, 0xfb, 0xd7, 0xf1, 0x82, 0x85, 0xe2,
  0xed, 0x2d, 0x56, 0xc1, 0xbf, 0xb3, 0x94, 0x2f, 0x3e, 0xa8, 0x56, 0x3e,
  0xb3, 0xe8, 0x04, 0xda, 0xf9, 0x84, 0xeb, 0x5f, 0xb2, 0x50, 0x5c, 0x35,
  0xfc, 0xd1, 0xed, 0x59, 0x6c, 0xce, 0x98, 0x61, 0x4d, 0x0b, 0x22, 0x8d,
  0xbc, 0x98, 0xdc, 0x6c, 0x8e, 0xe9, 0x9f, 0x67, 0x5b, 0x9b, 0x00, 0x65,
  0x2c, 0x61, 0x27, 0x63, 0x9a, 0xdc, 0xd9, 0x79, 0xf1, 0xa2, 0x17, 0x75,
  0xd8, 0x72, 0x65, 0x1d, 0xf0, 0x91, 0xa0, 0x93, 0xd5, 0x69, 0x2b, 0x99,
  0xb6, 0x99, 0x5f, 0x8e, 0xf9, 0x7f, 0xfc, 0x9a, 0x55, 0x3e, 0xba, 0xd0,
  0x1c, 0x0e, 0xac, 0xc3, 0x3c, 0x44, 0x5d, 0x31, 0xb2, 0xba, 0xa3, 0x7d,
  0x30, 0xdb, 0x04, 0xbb, 0x21, 0x16, 0x49, 0xb6, 0x30, 0x5f, 0xe3, 0xec,
  0x41, 0xaf, 0x1b, 0xd0, 0x58, 0x54, 0xc9, 0xdf, 0xbc, 0x96, 0xe0, 0x2a,
  0xcd, 0xae, 0x2f, 0x96, 0xa3, 0xbe, 0xa6, 0x99, 0x8a, 0xae, 0x91, 0xd2,
  0xc9, 0x9d, 0x71, 0x7d, 0x77, 0x35, 0x01, 0x37, 0x38, 0xf2, 0x97, 0x51,
  0x47, 0x69, 0x8b, 0x7f, 0x0c, 0xe0, 0x2a, 0x4c, 0xc6, 0x3c, 0x8d, 0xec,
  0xb5, 0xfe, 0xf1, 0xd7, 0xbf, 0x52, 0xb3, 0x7f, 0xe5, 0x56, 0x5e, 0xff,
  0xa9, 0x28, 0xaf, 0x83, 0x67, 0x3a, 0x4a, 0xf0, 0x47, 0xde, 0x51, 0x8a,
  0xe0, 0x27, 0x40, 0x96, 0x22, 0x1b, 0xea, 0xed, 0xb1, 0x72, 0xe4, 0x5e,
  0x30, 0xbf, 0x14, 0x79, 0x6a, 0x62, 0x78, 0x73, 0xb1, 0x07, 0x5f, 0xb2,
  0x13, 0x33, 0xe1, 0xfc, 0x66, 0xa2, 0x42, 0x60, 0xd2, 0x6d, 0x98, 0x88,
  0x71, 0x78, 0xf2, 0xed, 0xd1, 0xf9, 0xe9, 0xc9, 0xdb, 0xc3, 0x93, 0x8b,
  0xe8, 0xdb, 0xbd, 0xf3, 0xa3, 0xbd, 0x2f, 0x8f, 0x35, 0x8d, 0x9a, 0xa7,
  0xc0, 0x21, 0x23, 0x22, 0x7a, 0xd7, 0x10, 0x45, 0x83, 0xb4, 0x96, 0x56,
  0x28, 0xfd, 0x5a, 0xe5, 0xbb, 0xf7, 0x8a, 0x51, 0x0d, 0x1b, 0xeb, 0x7b,
  0x94, 0x63, 0xe8, 0xb1, 0xd7, 0xef, 0xbd, 0x55, 0x66, 0x60, 0xdb, 0xe5,
  0x43, 0x90, 0x98, 0xcb, 0xd1, 0x2c, 0x4c, 0xa5, 0xc6, 0x9f, 0x7c, 0x15,
  0x1d, 0x05, 0xfb, 0x1f, 0x44, 0x5f, 0x49, 0x6e, 0xb7, 0xc6, 0x55, 0xb9,
  0x57, 0x35, 0xcf, 0x48, 0x6d, 0x39, 0xf2, 0x9f, 0xfb, 0x65, 0xef, 0xf8,
  0xd8, 0x77, 0xb9, 0x27, 0x82, 0x6d, 0xdf, 0xa7, 0x48, 0x5b, 0x45, 0xb9,
  0x6b, 0xb6, 0x53, 0x0a, 0xc0, 0x8f, 0xa4, 0x04, 0x5d, 0x5b, 0x19, 0xdc,
  0xab, 0xcc, 0x03, 0x6f, 0xcf, 0x1f, 0x42, 0x8c, 0x6d, 0xee, 0x94, 0xb6,
  0x65, 0x5d, 0x80, 0x19, 0xd8, 0xf7, 0x48, 0x07, 0x29, 0x2d, 0x6e, 0x7a,
  0x51, 0xf7, 0x4f, 0x5d, 0x49, 0xd5, 0x4a, 0x00, 0x40, 0x8b, 0xd6, 0x0b,
  0x5f, 0x31, 0x32, 0x3a, 0x39, 0xf5, 0x63, 0x3a, 0x42, 0x6a, 0x00, 0x13,
  0x15, 0x22, 0x41, 0x73, 0x07, 0x6e, 0x94, 0x68, 0x8a, 0x73, 0x1f, 0x9e,
  0x61, 0x89, 0x58, 0xc7, 0x30, 0xad, 0x65, 0xef, 0x2d, 0x2d, 0x12, 0x87,
  0x0a, 0x09, 0xcc, 0x61, 0xd2, 0xd1, 0xe2, 0x71, 0x80, 0x27, 0x2c, 0xa6,
  0x1b, 0xd6, 0x76, 0x71, 0xed, 0x6b, 0x75, 0x5e, 0x59, 0x57, 0x36, 0x0a,
  0xa9, 0x3f, 0x6a, 0x59, 0x28, 0xbb, 0x04, 0x09, 0xdd, 0x6f, 0x2a, 0xa4,
  0xb7, 0x38, 0xa9, 0x38, 0x94, 0x3c, 0x4f, 0x27, 0x0a, 0x4f, 0xd7, 0x4a,
  0x02, 0x03, 0xf8, 0x36, 0xce, 0xf7, 0x01, 0xe6, 0x3d, 0xe7, 0xda, 0x45,
  0xae, 0x06, 0x82, 0x84, 0x9d, 0x12, 0xcb, 0xc8, 0x39, 0x97, 0x6b, 0xae,
  0x12, 0x07, 0x42, 0x39, 0x21, 0x8f, 0xc7, 0x57, 0x99, 0xc9, 0xda, 0xb1,
  0x73, 0xb8, 0x4a, 0x8e, 0x96, 0x44, 0xe9, 0x98, 0xc8, 0xe5, 0xf0, 0xa7,
  0x9c, 0xcd, 0x0b, 0xae, 0x59, 0xb3, 0x30, 0x73, 0x64, 0x12, 0x2c, 0x64,
  0x1a, 0xb9, 0x50, 0x04, 0x09, 0xbe, 0x3e, 0xf0, 0x9d, 0x19, 0x87, 0x38,
  0x25, 0x0d, 0x10, 0x0a, 0xb0, 0x5b, 0x96, 0x10, 0x8c, 0x18, 0x39, 0x0c,
  0x8b, 0x1f, 0x44, 0x93, 0x1a, 0xee, 0x88, 0x26, 0xcd, 0xf8, 0x49, 0x47,
  0x65, 0xca, 0xb9, 0x47, 0xc6, 0x76, 0xe2, 0x68, 0x94, 0x5e, 0x45, 0x66,
  0xf7, 0x88, 0x98, 0x14, 0x00, 0x0e, 0x96, 0xcd, 0x12, 0xde, 0x2a, 0x40,
  0x7f, 0x41, 0x50, 0xbf, 0xe6, 0xaa, 0xe5, 0x1e, 0xab, 0xca, 0x66, 0x52,
  0x70, 0x6c, 0x7e, 0x60, 0x37, 0x83, 0xed, 0x7c, 0xc9, 0xeb, 0x68, 0x81,
  0x4c, 0x8a, 0x6b, 0xad, 0x61, 0x5d, 0x6c, 0x94, 0x05, 0xca, 0xde, 0x1c,
  0x49, 0x24, 0x96, 0x90, 0x8b, 0x75, 0xb0, 0x90, 0x57, 0x66, 0x0d, 0x30,
  0xa5, 0x70, 0xa1, 0xa4, 0x75, 0x07, 0x4c, 0x8d, 0xda, 0xf4, 0x82, 0xec,
  0xc9, 0x94, 0x2d, 0x11, 0xe9, 0x95, 0x42, 0x12, 0xb6, 0x59, 0x8a, 0xc0,
  0x74, 0x29, 0xa5, 0xd6, 0x69, 0x7c, 0xeb, 0x01, 0x97, 0x99, 0x13, 0x89,
  0xc8, 0x63, 0xa2, 0x2c, 0xea, 0x5f, 0x7d, 0xf1, 0x57, 0xc6, 0x56, 0x33,
  0xaa, 0xd8, 0xf0, 0x3e, 0x6b, 0xb9, 0xf2, 0x99, 0x56, 0xc7, 0x5a, 0x8b,
  0x09, 0xe3, 0xa5, 0xfd, 0x32, 0xd3, 0x53, 0x68, 0xb9, 0x8a, 0x2c, 0x57,
  0x63, 0x3a, 0x0d, 0x90, 0xa9, 0xc5, 0xf6, 0x10, 0x37, 0x24, 0x0d, 0x57,
  0x32, 0x7d, 0x4f, 0xa3, 0x46, 0x04, 0xc5, 0x36, 0x98, 0x89, 0xc6, 0x23,
  0xb3, 0x2c, 0x56, 0x33, 0x88, 0x05, 0xec, 0xcb, 0xfc, 0xab, 0xe1, 0x35,
  0xa4, 0x25, 0x11, 0xd2, 0x78, 0x26, 0x92, 0xa2, 0x27, 0xbf, 0xd9, 0x83,
  0x44, 0xac, 0xad, 0xad, 0xed, 0xbf, 0x1b, 0x5e, 0x9c, 0xbe, 0x8d, 0x4e,
  0xdf, 0x5d, 0x9c, 0xbd, 0xbb, 0xd0, 0x7b, 0x6a, 0x24, 0x31, 0xbd, 0xa2,
  0x10, 0xca, 0x95, 0x6f, 0xbb, 0x39, 0x53, 0xa7, 0x31, 0xc2, 0x13, 0x32,
  0x20, 0xd2, 0x05, 0xb8, 0x34, 0x2e, 0x9f, 0x07, 0x68, 0x4d, 0x02, 0x74,
  0x8b, 0x35, 0xbf, 0xa3, 0x35, 0x47, 0x2e, 0x26, 0x0c, 0x39, 0x96, 0x1e,
  0x04, 0x25, 0xa7, 0xbd, 0xe0, 0x48, 0xad, 0x04, 0x17, 0xdc, 0xbb, 0x55,
  0x18, 0x20, 0x1f, 0x83, 0x63, 0x86, 0x1c, 0x6f, 0xe7, 0x09, 0xc3, 0x01,
  0x11, 0x08, 0x33, 0x2e, 0xcd, 0x7c, 0x69, 0x11, 0x99, 0x08, 0x53, 0xa9,
  0x26, 0xa5, 0x85, 0xb9, 0x71, 0x65, 0x46, 0x33, 0xbc, 0x76, 0xd1, 0xd4,
  0x1c, 0x81, 0x82, 0x28, 0x32, 0x71, 0xc1, 0x73, 0xb8, 0x96, 0xd5, 0x3d,
  0xbf, 0x63, 0xa3, 0x77, 0xe3, 0x4e, 0xbd, 0x8b, 0xba, 0xdf, 0x25, 0x61,
  0x83, 0x1f, 0xff, 0x83, 0x53, 0xfe, 0xde, 0xdb, 0x27, 0xff, 0x94, 0x2e,
  0x7f, 0x9a, 0x77, 0x11, 0x7c, 0x55, 0xf5, 0xb5, 0x7e, 0x73, 0x78, 0xfe,
  0xe5, 0xe1, 0xf9, 0xe9, 0x10, 0x01, 0x27, 0x66, 0xdb, 0x6a, 0x12, 0xfb,
  0x4d, 0x92, 0x8f, 0x92, 0x3c, 0xd3, 0x1a, 0x32, 0xf6, 0xd7, 0x8b, 0xcd,
  0xaf, 0x86, 0xc3, 0xbd, 0xb3, 0x23, 0x57, 0x6e, 0xc4, 0x25, 0x1f, 0x89,
  0x42, 0x34, 0x97, 0xf4, 0x38, 0x9e, 0xbf, 0xbd, 0x42, 0x74, 0x31, 0xbe,
  0x91, 0xa0, 0xd4, 0x86, 0x57, 0xd3, 0xac, 0xb2, 0xec, 0xce, 0xd4, 0x9c,
  0x34, 0x6e, 0xd8, 0xf0, 0x84, 0x24, 0x35, 0x5b, 0x08, 0xf8, 0x0d, 0x1b,
  0x91, 0x7b, 0x2e, 0x70, 0xeb, 0x26, 0x1f, 0xf5, 0x89, 0xd0, 0x6f, 0xac,
  0xb4, 0xa1, 0x84, 0xcf, 0x13, 0x9b, 0x94, 0xb8, 0x5a, 0x6f, 0x54, 0xb8,
  0xe1, 0x6a, 0xa6, 0x9b, 0x37, 0x7c, 0x34, 0xb8, 0x1e, 0xc6, 0x74, 0x20,
  0x9c, 0x5d, 0xce, 0x92, 0x05, 0x4b, 0x32, 0x7b, 0x7d, 0x0c, 0xde, 0x80,
  0x7a, 0x73, 0xa5, 0x96, 0xc4, 0xae, 0x45, 0x9f, 0x3c, 0x77, 0x30, 0x4f,
  0x61, 0xa1, 0xcb, 0x4b, 0x92, 0xb4, 0x17, 0x77, 0x13, 0xbd, 0x40, 0x80,
  0x6c, 0x3c, 0x17, 0xbb, 0xb6, 0xf0, 0xef, 0xba, 0x77, 0x83, 0x6b, 0x43,
  0x21, 0xce, 0x5f, 0xa3, 0x98, 0xa3, 0xd1, 0x34, 0x9e, 0xdf, 0xe0, 0x26,
  0xc3, 0xcd, 0xc4, 0xba, 0xa5, 0xa1, 0x17, 0x71, 0x25, 0x2d, 0x38, 0xb3,
  0x14, 0x50, 0x00, 0xd2, 0x9e, 0xd5, 0xeb, 0x66, 0x43, 0xae, 0x03, 0x69,
  0x0a, 0xdc, 0x36, 0x38, 0x49, 0x7e, 0x11, 0xd8, 0x44, 0x74, 0x78, 0x4c,
  0x97, 0x92, 0xcb, 0x4d, 0x80, 0x2e, 0x9e, 0x4c, 0x19, 0x6a, 0xc7, 0xc2,
  0x49, 0x24, 0x1d, 0x2f, 0x05, 0x13, 0x13, 0xc6, 0x61, 0xa0, 0xdb, 0x70,
  0x3c, 0x80, 0x52, 0x90, 0x75, 0x58, 0xb8, 0xda, 0x14, 0xca, 0xb5, 0xb5,
  0x5c, 0x7b, 0x59, 0x29, 0x55, 0x11, 0x56, 0x2f, 0xd1, 0x28, 0xad, 0x7d,
  0x1f, 0x4c, 0x12, 0xdb, 0x77, 0x32, 0x08, 0x2f, 0x7f, 0x3a, 0xf7, 0x54,
  0x25, 0x29, 0x62, 0xe5, 0x36, 0xc9, 0xeb, 0x6d, 0xda, 0x3e, 0x18, 0x20,
  0x35, 0x20, 0xc6, 0x6e, 0x07, 0x28, 0x63, 0x91, 0xae, 0xd5, 0xe8, 0x52,
  0x1b, 0xf8, 0xc0, 0xaa, 0x82, 0x23, 0xe0, 0x49, 0x3c, 0x4e, 0x88, 0x8c,
  0xd4, 0xdb, 0xb7, 0x9c, 0x80, 0xdb, 0xe4, 0x15, 0x80, 0xd3, 0x30, 0xa8,
  0x53, 0x30, 0x0f, 0x60, 0x03, 0x94, 0x30, 0x7f, 0xa8, 0x2b, 0x4e, 0x90,
  0xed, 0x9f, 0xf0, 0x55, 0x91, 0xf5, 0x47, 0x4b, 0x28, 0x60, 0x1e, 0x9d,
  0x4b, 0x53, 0xff, 0xb8, 0x98, 0x2d, 0xe0, 0xb8, 0xf0, 0x3d, 0x3b, 0x32,
  0x90, 0x54, 0x2d, 0xbe, 0x0d, 0x64, 0xd9, 0x55, 0xa1, 0x5a, 0x1c, 0x40,
  0x87, 0x84, 0xae, 0x23, 0x84, 0x57, 0xe3, 0x94, 0x75, 0x84, 0xba, 0xc9,
  0x2e, 0xc8, 0x6c, 0xae, 0x05, 0xdf, 0x60, 0x54, 0xaf, 0x06, 0xea, 0x96,
  0x0e, 0x24, 0xfd, 0x02, 0x22, 0x42, 0xa2, 0xd0, 0xe1, 0x16, 0x81, 0x6b,
  0xf1, 0xfe, 0xb7, 0x25, 0x97, 0x06, 0x12, 0x6c, 0x81, 0x78, 0x2a, 0xc5,
  0x1d, 0x56, 0xde, 0x22, 0x72, 0x98, 0xca, 0x8b, 0x8b, 0x1f, 0xce, 0x0e,
  0x5f, 0xdb, 0x9b, 0x8f, 0xed, 0x99, 0x40, 0x6e, 0x21, 0xe0, 0x22, 0x51,
  0x8c, 0xcb, 0xa0, 0x7c, 0x24, 0x11, 0x59, 0xbf, 0x34, 0x47, 0xb0, 0x74,
  0xd3, 0x8f, 0xbe, 0x3f, 0x38, 0x1a, 0x9e, 0x1d, 0x9f, 0xee, 0xbf, 0x7e,
  0xf5, 0xbd, 0x71, 0xe3, 0xcf, 0x19, 0x63, 0x46, 0x64, 0x34, 0xf7, 0x99,
  0x87, 0x04, 0xd0, 0xf7, 0x4e, 0x0e, 0xbf, 0x7b, 0x4f, 0x6a, 0xc0, 0x6b,
  0xc6, 0x02, 0xef, 0xdd, 0xc6, 0x53, 0x7d, 0x89, 0x75, 0xa9, 0x16, 0xb9,
  0x2e, 0x48, 0xe0, 0x68, 0x5b, 0x58, 0x57, 0x2b, 0xde, 0x87, 0xb7, 0x3f,
  0x58, 0x0c, 0x56, 0x50, 0x48, 0x28, 0xae, 0x64, 0x63, 0xb6, 0xd4, 0x15,
  0xcc, 0xdc, 0xcd, 0xdf, 0x2d, 0x25, 0x16, 0x8f, 0xfd, 0xcf, 0xa1, 0x5b,
  0x17, 0xe1, 0x8e, 0xfa, 0x8d, 0x0f, 0x03, 0x55, 0xd4, 0xdd, 0x9c, 0xa3,
  0x1f, 0x1c, 0x7a, 0xa1, 0x16, 0x77, 0x84, 0xc3, 0x54, 0x21, 0x0e, 0x15,
  0xbb, 0x87, 0x23, 0x2f, 0x2d, 0x08, 0xdb, 0x55, 0x0f, 0x16, 0xf1, 0xc5,
  0x8d, 0x25, 0x1e, 0x8f, 0xe9, 0x07, 0x43, 0x4b, 0x72, 0x19, 0x97, 0x33,
  0xae, 0x26, 0x3e, 0xbc, 0x60, 0x7d, 0x69, 0xff, 0xf4, 0xe4, 0xe4, 0x70,
  0xdf, 0x6c, 0xcd, 0x56, 0x0d, 0x0d, 0xa9, 0xfe, 0x55, 0xc8, 0xca, 0xb0,
  0xc2, 0x44, 0xe5, 0x44, 0x3b, 0x36, 0x57, 0xcd, 0xfd, 0x63, 0x93, 0x81,
  0x24, 0x14, 0xb2, 0x10, 0x2a, 0xc0, 0xab, 0xf1, 0xa5, 0x1d, 0xe0, 0x4c,
  0x49, 0xa3, 0x56, 0x68, 0x01, 0x55, 0x52, 0xb0, 0x3b, 0xd3, 0x74, 0xe4,
  0xad, 0xe3, 0x35, 0xdf, 0x23, 0xbb, 0xb6, 0x15, 0xe3, 0x21, 0x3c, 0x42,
  0x66, 0xf7, 0xf6, 0x09, 0xb5, 0x45, 0x66, 0x95, 0xff, 0x84, 0xf8, 0x61,
  0x97, 0x0e, 0xd3, 0x1e, 0x9d, 0x46, 0x0a, 0x35, 0xc4, 0x44, 0x34, 0xf7,
  0x69, 0x10, 0xbc, 0xa8, 0xb0, 0x41, 0x80, 0x3c, 0x55, 0x96, 0x8d, 0x3a,
  0xdb, 0x92, 0xc0, 0xc4, 0x16, 0x15, 0x12, 0x58, 0x90, 0x90, 0x8d, 0x20,
  0x13, 0x9d, 0x59, 0x43, 0xfa, 0x50, 0xb1, 0xf1, 0x8a, 0x33, 0x9f, 0x80,
  0xcd, 0x34, 0x61, 0x51, 0x0b, 0xa6, 0xb6, 0xb0, 0x33, 0xbb, 0x49, 0x79,
  0x05, 0xad, 0x96, 0xbd, 0xb8, 0x61, 0xdd, 0xe8, 0xa5, 0x92, 0x05, 0x16,
  0x1e, 0xe1, 0x75, 0x71, 0x0e, 0xec, 0xc3, 0x52, 0x01, 0xc6, 0x4d, 0xe9,
  0xd1, 0x58, 0xb9, 0x41, 0x15, 0x06, 0xc6, 0xe8, 0x52, 0x83, 0x5b, 0x1e,
  0x5d, 0x51, 0xb7, 0x9a, 0x42, 0xbe, 0x79, 0x62, 0x41, 0x2f, 0x62, 0x4f,
  0x28, 0xd8, 0xb1, 0x30, 0x1f, 0xbb, 0xcb, 0x98, 0x73, 0x55, 0x38, 0xf8,
  0x23, 0x57, 0x88, 0x9d, 0x25, 0x17, 0xf5, 0xd6, 0xe2, 0x97, 0x28, 0xdd,
  0xc8, 0xde, 0x35, 0x83, 0x5f, 0xf3, 0xd1, 0xbf, 0xb2, 0xdc, 0x01, 0x59,
  0x89, 0x1d, 0xfd, 0x41, 0x3b, 0x74, 0x79, 0xd5, 0xb6, 0x59, 0x3d, 0x49,
  0xd3, 0x89, 0x91, 0x15, 0x62, 0x06, 0xdc, 0x20, 0xbb, 0xb0, 0xd0, 0x9c,
  0x4d, 0xe7, 0x99, 0x14, 0x86, 0x87, 0x4a, 0x45, 0x3e, 0xcb, 0xa9, 0xe2,
  0x01, 0x24, 0xc9, 0x72, 0x81, 0xb2, 0x3b, 0x63, 0x05, 0x1e, 0x47, 0xb8,
  0xa7, 0x6b, 0xcf, 0xee, 0x10, 0xbf, 0x56, 0xb4, 0xa8, 0x6f, 0xdf, 0x1d,
  0x5f, 0x1c, 0x9d, 0x85, 0x5e, 0xc6, 0xe8, 0xbb, 0xa3, 0x8b, 0xaf, 0x49,
  0x5e, 0xe7, 0xb2, 0xc4, 0xc7, 0xec, 0xca, 0x79, 0xfb, 0x76, 0xef, 0x84,
  0x73, 0xd2, 0x4f, 0x10, 0x15, 0xb7, 0x07, 0x9d, 0x81, 0xb9, 0x11, 0xad,
  0x30, 0x93, 0x0e, 0x67, 0x2b, 0xf7, 0x9a, 0x2e, 0x85, 0xda, 0xe9, 0x03,
  0xc3, 0xe1, 0x23, 0x14, 0xae, 0x11, 0x6f, 0xb8, 0xea, 0x04, 0x0f, 0x6c,
  0xc0, 0xc1, 0xa9, 0x65, 0x3d, 0x8b, 0xd7, 0xb9, 0x8e, 0x38, 0x8e, 0xcc,
  0x38, 0x91, 0xcd, 0xe1, 0x40, 0x95, 0xab, 0xdb, 0xbb, 0x29, 0xb0, 0xa1,
  0x0e, 0xb6, 0x14, 0x51, 0xaa, 0x24, 0x32, 0xcd, 0x55, 0xa5, 0x91, 0xeb,
  0xb2, 0x1a, 0xa9, 0x4e, 0x3d, 0x62, 0x48, 0x70, 0x21, 0x67, 0xde, 0xf2,
  0xc7, 0xca, 0x26, 0xeb, 0xcb, 0xe7, 0xc7, 0xe1, 0x7d, 0x5a, 0x2d, 0x7d,
  0x6b, 0xa1, 0x65, 0x57, 0x59, 0xe2, 0x0f, 0x6e, 0xff, 0xd4, 0x9a, 0x31,
  0x33, 0x2f, 0x34, 0x30, 0xb9, 0x5b, 0xfa, 0xcc, 0xd6, 0xfa, 0xb4, 0x25,
  0x1b, 0xae, 0x34, 0x8d, 0x9a, 0xc9, 0x76, 0x45, 0xaa, 0xac, 0x14, 0xa0,
  0x06, 0x56, 0xec, 0xa9, 0x6b, 0x59, 0x43, 0x18, 0x10, 0xc9, 0xab, 0xc9,
  0x30, 0x3a, 0x67, 0x30, 0x4b, 0x7b, 0xac, 0x92, 0xcb, 0x5b, 0xab, 0x82,
  0x6d, 0xc9, 0x50, 0x48, 0x81, 0x64, 0xd0, 0x16, 0xef, 0x20, 0x45, 0x39,
  0xae, 0x2c, 0x1b, 0x24, 0xf7, 0x09, 0xfb, 0x32, 0xf9, 0xd7, 0xbf, 0x2d,
  0xae, 0xc2, 0x3c, 0x29, 0xcc, 0x55, 0x13, 0x82, 0xdb, 0xa1, 0x80, 0x45,
  0x2a, 0xd2, 0xa2, 0x64, 0x95, 0x11, 0x68, 0xa5, 0xb1, 0xed, 0x55, 0x1d,
  0xea, 0xf7, 0x3b, 0xcd, 0xef, 0x77, 0xc4, 0xbc, 0xc8, 0xc5, 0xd3, 0x1d,
  0x82, 0xa6, 0x64, 0xff, 0x86, 0xd2, 0x9b, 0xc9, 0x04, 0x4c, 0x61, 0x52,
  0x67, 0x1d, 0x3e, 0x14, 0x61, 0x89, 0x62, 0xe3, 0xe7, 0xe8, 0xa3, 0x65,
  0x8e, 0xac, 0x46, 0x3c, 0x02, 0x73, 0xb0, 0x84, 0x8c, 0x22, 0x40, 0x0b,
  0x6c, 0x8a, 0x6f, 0x2b, 0x6a, 0x90, 0xbe, 0x7f, 0xee, 0x42, 0xb8, 0x3d,
  0x4b, 0x43, 0x61, 0x2f, 0xcd, 0xa1, 0xe9, 0xa7, 0x8b, 0x5b, 0xab, 0x6d,
  0x49, 0xbf, 0x7e, 0xe2, 0x6a, 0xba, 0x14, 0x15, 0x5f, 0x54, 0x05, 0xaa,
  0xd6, 0x78, 0x3f, 0x06, 0x87, 0x90, 0x3a, 0x66, 0x0c, 0x0e, 0xe5, 0x75,
  0x50, 0x1b, 0x57, 0x52, 0x0d, 0xe6, 0x0d, 0xaa, 0x4c, 0xc2, 0x90, 0x3c,
  0x45, 0x3e, 0x25, 0xd8, 0x51, 0xc0, 0x5b, 0x42, 0x78, 0xf8, 0xc7, 0xcb,
  0xc9, 0xb3, 0xe9, 0xe8, 0x36, 0x4d, 0xee, 0x5c, 0x11, 0xf4, 0xef, 0xe4,
  0x9a, 0x86, 0x73, 0xe0, 0x41, 0x7c, 0x7e, 0xcc, 0x25, 0x55, 0xc3, 0x35,
  0xc1, 0xc7, 0x61, 0x11, 0x48, 0xb8, 0xb5, 0x40, 0x90, 0x2d, 0x7c, 0x7e,
  0x22, 0xce, 0x60, 0x00, 0x91, 0x8c, 0x51, 0xfd, 0x7d, 0xc9, 0x33, 0x1d,
  0xb1, 0x34, 0x00, 0x91, 0xa6, 0x70, 0xd9, 0x60, 0x57, 0xd3, 0x6c, 0x34,
  0x42, 0xc8, 0xbb, 0x4b, 0x88, 0x1c, 0x44, 0x8c, 0xc5, 0x79, 0x23, 0x24,
  0xa1, 0x1e, 0x02, 0x04, 0xa4, 0xc9, 0x41, 0xf7, 0xab, 0x23, 0x72, 0x97,
  0x06, 0xe1, 0x8e, 0x33, 0x06, 0xa3, 0x9f, 0x30, 0x53, 0xa2, 0x45, 0xca,
  0x5d, 0xa2, 0x44, 0x74, 0x99, 0x7c, 0xb6, 0xb5, 0xbb, 0xcb, 0xf5, 0x22,
  0x3e, 0xde, 0xee, 0x69, 0x2c, 0x61, 0x18, 0x20, 0xdd, 0x73, 0xb7, 0x93,
  0xb4, 0xc1, 0xda, 0x47, 0x38, 0xcf, 0xf9, 0x72, 0x96, 0xe4, 0xaa, 0x87,
  0xe0, 0x3e, 0x14, 0xc8, 0x18, 0x26, 0x46, 0x1b, 0xb2, 0x7b, 0x16, 0x15,
  0x50, 0x60, 0x7f, 0x97, 0x8c, 0x06, 0x7f, 0x79, 0xea, 0x39, 0xc7, 0x51,
  0x99, 0x4b, 0x75, 0x49, 0x7e, 0x18, 0x02, 0x39, 0x70, 0x30, 0xb2, 0x9b,
  0x50, 0x56, 0xd5, 0x2c, 0x8e, 0x1f, 0x83, 0xc1, 0xef, 0xbc, 0xd8, 0xfe,
  0x59, 0x42, 0xd7, 0x98, 0xc0, 0xfd, 0x2a, 0x68, 0x45, 0xb0, 0x89, 0xca,
  0x23, 0x92, 0xf8, 0xa5, 0x84, 0xb1, 0x9e, 0x0c, 0xae, 0x06, 0x26, 0x24,
  0xa8, 0xe1, 0xb0, 0x17, 0x06, 0x10, 0x0b, 0x66, 0xb5, 0x94, 0x13, 0x87,
  0xda, 0x65, 0xb6, 0x21, 0x33, 0xe4, 0xaa, 0x55, 0x32, 0x2c, 0xed, 0xb2,
  0x46, 0x57, 0xc6, 0xde, 0xd1, 0x31, 0x07, 0xa7, 0x1c, 0x93, 0x04, 0x36,
  0x34, 0x56, 0x86, 0x08, 0x1e, 0x04, 0xd7, 0xcc, 0x53, 0xbe, 0x4d, 0x7b,
  0x0e, 0x51, 0xde, 0x02, 0xe1, 0x21, 0x56, 0xb0, 0x91, 0x5d, 0x24, 0x73,
  0x45, 0x7e, 0x22, 0x79, 0x98, 0xf8, 0x59, 0x21, 0xe6, 0x14, 0x00, 0x2c,
  0x32, 0xf2, 0x30, 0x1c, 0x1a, 0x90, 0x78, 0x65, 0xe1, 0x51, 0xc4, 0x22,
  0x4f, 0xa6, 0xc9, 0xad, 0xda, 0x3d, 0x04, 0xae, 0xee, 0x2b, 0xf5, 0x25,
  0x48, 0x11, 0xbb, 0xd2, 0xbb, 0x44, 0x2a, 0xee, 0x0a, 0xee, 0x73, 0x53,
  0x32, 0xfd, 0x7d, 0x02, 0x37, 0x77, 0xef, 0x21, 0x96, 0xcd, 0x75, 0xc3,
  0xef, 0xf5, 0x59, 0x04, 0x2d, 0x64, 0x27, 0xde, 0x15, 0x9a, 0xa3, 0x5b,
  0x8f, 0x03, 0x14, 0x55, 0xde, 0xaa, 0x20, 0x89, 0x59, 0xac, 0x67, 0x28,
  0x98, 0x62, 0xcc, 0x63, 0xa9, 0xa5, 0xc7, 0x26, 0x14, 0xb4, 0x74, 0x49,
  0xf2, 0x12, 0xe3, 0x9d, 0xf7, 0x22, 0x5f, 0xf3, 0x3c, 0x9b, 0xd2, 0x9f,
  0x88, 0x6a, 0xe0, 0x55, 0xc7, 0xb3, 0x8c, 0xe2, 0x17, 0xc4, 0x1a, 0xd1,
  0x9f, 0x12, 0xe8, 0xaa, 0x7f, 0xa1, 0xa9, 0x7c, 0x09, 0xb0, 0xc8, 0x9e,
  0x10, 0x2b, 0x1b, 0xff, 0xb5, 0x74, 0x3d, 0x46, 0xaf, 0xbe, 0x37, 0x19,
  0xff, 0x81, 0xb9, 0x86, 0x8c, 0x4d, 0x64, 0xb9, 0xad, 0xae, 0xec, 0xc2,
  0x48, 0x8a, 0x56, 0x7d, 0xb9, 0x64, 0x2b, 0xb5, 0x2b, 0xca, 0xc0, 0xa3,
  0x98, 0x31, 0x69, 0x25, 0x52, 0x1f, 0xce, 0x35, 0xce, 0x02, 0xd7, 0x92,
  0x76, 0x57, 0x5a, 0x3f, 0xce, 0xee, 0xb8, 0xba, 0xdd, 0xe5, 0x25, 0x97,
  0xdc, 0x3e, 0x9d, 0x7b, 0x50, 0x48, 0xe6, 0xaa, 0xf2, 0xe0, 0xcc, 0x2a,
  0x6a, 0xd0, 0xdc, 0xac, 0xf6, 0xba, 0x85, 0x2a, 0x0e, 0xa2, 0x3d, 0xac,
  0x12, 0xc9, 0x42, 0x68, 0x4e, 0x7c, 0x6a, 0x10, 0x07, 0x6b, 0x91, 0x71,
  0x5a, 0x7d, 0x97, 0x6f, 0xc8, 0x19, 0xca, 0xfc, 0x71, 0x04, 0xd8, 0x2c,
  0x9b, 0x5b, 0xa0, 0xf3, 0xb2, 0x10, 0x88, 0x30, 0x2b, 0xd5, 0xbb, 0x26,
  0x36, 0xc3, 0x74, 0xaa, 0x98, 0xbc, 0x2a, 0x38, 0xe3, 0x8d, 0x70, 0x32,
  0x93, 0xfe, 0xe2, 0x7a, 0x61, 0x3b, 0x6d, 0xfc, 0x4a, 0x98, 0x99, 0x86,
  0xd6, 0xe2, 0x7a, 0x3b, 0xfb, 0xfa, 0x6c, 0x10, 0x1d, 0x72, 0x4b, 0x32,
  0x26, 0xbd, 0x87, 0xa0, 0x41, 0xd1, 0x77, 0x34, 0xd9, 0x2b, 0x66, 0xe0,
  0xa7, 0x39, 0xff, 0x85, 0xd6, 0xf4, 0x4b, 0x31, 0x9a, 0xe0, 0xdb, 0x6a,
  0xaf, 0xd4, 0x50, 0xa6, 0x45, 0xda, 0xcf, 0xf0, 0x3b, 0x1d, 0x15, 0xe2,
  0x8e, 0x6e, 0x9b, 0x7c, 0x0f, 0x59, 0x5e, 0x01, 0x54, 0x90, 0x37, 0x23,
  0x62, 0x9a, 0x60, 0x7d, 0x8b, 0x07, 0xec, 0x1f, 0x14, 0x6e, 0xa0, 0x70,
  0xe8, 0xf5, 0x20, 0x0d, 0x04, 0xa4, 0xa5, 0xe4, 0xe7, 0xa2, 0x68, 0xe4,
  0x5c, 0xe5, 0x02, 0x25, 0x90, 0x27, 0x1a, 0x73, 0x94, 0xa9, 0x03, 0x43,
  0xf4, 0x8d, 0x22, 0xa9, 0x1d, 0xd7, 0x40, 0xbc, 0xb2, 0x2f, 0x58, 0x28,
  0xe6, 0xb1, 0x10, 0x13, 0xa2, 0x2d, 0x18, 0xac, 0xfd, 0x7f, 0x57, 0x09,
  0x56, 0x4f, 0xa4, 0xe3, 0x01, 0x00,
};
#define BUF_SIZE 0x10000
/* Decompress and send to stdout a gzip-compressed buffer */
void hugehelp(void)
{
  unsigned char* buf;
  int status,headerlen;
  z_stream z;

  /* Make sure no gzip options are set */
  if (hugehelpgz[3] & 0xfe)
    return;

  headerlen = 10;
  z.avail_in = (unsigned int)(sizeof(hugehelpgz) - headerlen);
  z.next_in = (unsigned char *)hugehelpgz + headerlen;
  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = 0;

  if (inflateInit2(&z, -MAX_WBITS) != Z_OK)
    return;

  buf = malloc(BUF_SIZE);
  if (buf) {
    while(1) {
      z.avail_out = BUF_SIZE;
      z.next_out = buf;
      status = inflate(&z, Z_SYNC_FLUSH);
      if (status == Z_OK || status == Z_STREAM_END) {
	fwrite(buf, BUF_SIZE - z.avail_out, 1, stdout);
	if (status == Z_STREAM_END)
	   break;
      }
       else
	break;    /* Error */
    }
    free(buf);
  }
  inflateEnd(&z);
}
#endif /* USE_MANUAL */
#endif /* HAVE_LIBZ */
